/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class CrossReferenceAdapter
extends ECrossReferenceAdapter {
    private Map imports = new HashMap();
    private Map exports = new HashMap();
    private boolean resolve = true;
    private static Map eClassToChangeableFeatures = new HashMap();
    private static List nullList = new ArrayList(1);
    static /* synthetic */ Class class$0;

    public CrossReferenceAdapter() {
        this(true);
    }

    public CrossReferenceAdapter(boolean resolve) {
        this.resolve = resolve;
    }

    public void selfAdapt(Notification notification) {
        super.selfAdapt(notification);
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        if (notifier instanceof Resource) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.resource.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz) == 4) {
                if (!notification.getNewBooleanValue()) {
                    this.deregisterReferences((Resource)notifier);
                } else {
                    Iterator i = ((Resource)notifier).getContents().iterator();
                    while (i.hasNext()) {
                        EObject child = (EObject)i.next();
                        if (child == null) continue;
                        this.updateImportsAndExports((Resource)notifier, child, true);
                    }
                }
            }
            return;
        }
        if (!(notifier instanceof EObject) || !(feature instanceof EReference)) {
            return;
        }
        EReference reference = (EReference)feature;
        if (!this.isImportExportCapable(reference, (EObject)notifier)) {
            return;
        }
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 9: {
                EObject newValue;
                EObject oldValue = (EObject)notification.getOldValue();
                if (oldValue != null) {
                    this.deregisterReference(((EObject)notification.getNotifier()).eResource(), oldValue.eResource());
                }
                if ((newValue = (EObject)notification.getNewValue()) == null) break;
                this.registerReference(((EObject)notification.getNotifier()).eResource(), newValue.eResource());
                break;
            }
            case 3: {
                EObject newValue = (EObject)notification.getNewValue();
                if (newValue == null) break;
                this.registerReference(((EObject)notification.getNotifier()).eResource(), newValue.eResource());
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                Iterator i = newValues.iterator();
                while (i.hasNext()) {
                    EObject newValue = (EObject)i.next();
                    this.registerReference(((EObject)notification.getNotifier()).eResource(), newValue.eResource());
                }
                break;
            }
            case 4: {
                EObject oldValue = (EObject)notification.getOldValue();
                if (oldValue == null) break;
                this.deregisterReference(((EObject)notification.getNotifier()).eResource(), oldValue.eResource());
                break;
            }
            case 6: {
                Collection oldValues = (Collection)notification.getOldValue();
                Iterator i = oldValues.iterator();
                while (i.hasNext()) {
                    EObject oldValue = (EObject)i.next();
                    this.deregisterReference(((EObject)notification.getNotifier()).eResource(), oldValue.eResource());
                }
                break;
            }
        }
    }

    protected void handleContainment(Notification notification) {
        super.handleContainment(notification);
        Object notifier = notification.getNotifier();
        if (notifier instanceof ResourceSet) {
            return;
        }
        switch (notification.getEventType()) {
            case 3: {
                EObject newValue = (EObject)notification.getNewValue();
                if (newValue == null) break;
                Resource resource = notifier instanceof Resource ? (Resource)notifier : ((EObject)notification.getNotifier()).eResource();
                this.updateImportsAndExports(resource, newValue, true);
                break;
            }
            case 5: {
                Resource resource = notifier instanceof Resource ? (Resource)notifier : ((EObject)notification.getNotifier()).eResource();
                Collection newValues = (Collection)notification.getNewValue();
                Iterator iter = newValues.iterator();
                while (iter.hasNext()) {
                    EObject next = (EObject)iter.next();
                    if (next == null) continue;
                    this.updateImportsAndExports(resource, next, true);
                }
                break;
            }
            case 4: {
                EObject oldValue = (EObject)notification.getOldValue();
                if (oldValue == null) break;
                Resource resource = notifier instanceof Resource ? (Resource)notifier : ((EObject)notification.getNotifier()).eResource();
                this.updateImportsAndExports(resource, oldValue, false);
                break;
            }
            case 6: {
                Resource resource = notifier instanceof Resource ? (Resource)notifier : ((EObject)notification.getNotifier()).eResource();
                Collection oldValues = (Collection)notification.getOldValue();
                Iterator iter = oldValues.iterator();
                while (iter.hasNext()) {
                    EObject next = (EObject)iter.next();
                    if (next == null) continue;
                    this.updateImportsAndExports(resource, next, false);
                }
                break;
            }
        }
    }

    public void updateImportsAndExports(Resource resource, EObject value, boolean register) {
        CrossReferenceAdapter adapter = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)value);
        if (register) {
            if (adapter != null) {
                Iterator iter = adapter.getInverseReferences(value).iterator();
                while (iter.hasNext()) {
                    EObject owner;
                    EStructuralFeature.Setting next = (EStructuralFeature.Setting)iter.next();
                    EReference ref = (EReference)next.getEStructuralFeature();
                    if (!this.isImportExportCapable(ref, owner = next.getEObject())) continue;
                    this.registerReference(owner.eResource(), resource);
                }
            }
        } else {
            EContentsEList.FeatureIterator crossReferences = this.getOptimizedCrossReferenceIterator(value);
            while (crossReferences.hasNext()) {
                EReference eReference;
                EObject referent = (EObject)crossReferences.next();
                if (referent == null || !this.isImportExportCapable(eReference = (EReference)crossReferences.feature(), referent)) continue;
                Resource referencedResource = referent.eResource();
                this.deregisterReference(resource, referencedResource);
            }
            if (adapter != null) {
                Iterator iter = adapter.getInverseReferences(value).iterator();
                while (iter.hasNext()) {
                    EObject owner;
                    EStructuralFeature.Setting next = (EStructuralFeature.Setting)iter.next();
                    EReference ref = (EReference)next.getEStructuralFeature();
                    if (!this.isImportExportCapable(ref, owner = next.getEObject())) continue;
                    this.deregisterReference(owner.eResource(), resource);
                }
            }
        }
        if (adapter != null) {
            adapter.updateImportsAndExportsForContents(resource, value, register);
        }
    }

    public void updateImportsAndExportsForContents(Resource resource, EObject value, boolean register) {
        Iterator i = this.resolve() ? value.eContents().iterator() : ((InternalEList)value.eContents()).basicIterator();
        while (i.hasNext()) {
            this.updateImportsAndExports(resource, (EObject)i.next(), register);
        }
    }

    public void setTarget(Notifier target) {
        super.setTarget(target);
        if (target instanceof EObject) {
            EObject eObject = (EObject)target;
            Resource resource = eObject.eResource();
            EContentsEList.FeatureIterator crossReferences = this.getOptimizedCrossReferenceIterator(eObject);
            while (crossReferences.hasNext()) {
                EReference eReference;
                EObject referent = (EObject)crossReferences.next();
                if (referent == null || !this.isImportExportCapable(eReference = (EReference)crossReferences.feature(), referent)) continue;
                Resource referencedResource = referent.eResource();
                this.registerReference(resource, referencedResource);
            }
        }
    }

    public void unsetTarget(Notifier notifier) {
        super.unsetTarget(notifier);
        if (notifier instanceof Resource) {
            this.deregisterReferences((Resource)notifier);
        }
    }

    public Set getImports(Resource referencer) {
        Map importsMap = this.getImportsMap(referencer);
        if (importsMap != null) {
            return Collections.unmodifiableSet(importsMap.keySet());
        }
        return Collections.EMPTY_SET;
    }

    public Set getExports(Resource referenced) {
        Map exportsMap = this.getExportsMap(referenced);
        if (exportsMap != null) {
            return Collections.unmodifiableSet(exportsMap.keySet());
        }
        return Collections.EMPTY_SET;
    }

    private Map getImportsMap(Resource resource) {
        return (Map)this.imports.get(resource);
    }

    private Map getExportsMap(Resource resource) {
        return (Map)this.exports.get(resource);
    }

    private void registerReference(Resource referencer, Resource referenced) {
        if (referencer != null && referenced != null && referencer != referenced) {
            Counter exportsCount;
            Counter importsCount;
            HashMap<Resource, Counter> importsMap = this.getImportsMap(referencer);
            if (importsMap == null) {
                importsMap = new HashMap<Resource, Counter>();
                this.imports.put(referencer, importsMap);
            }
            if ((importsCount = (Counter)importsMap.get(referenced)) == null) {
                importsCount = new Counter();
                importsMap.put(referenced, importsCount);
                this.importAdded(referencer, referenced);
            } else {
                importsCount.inc();
            }
            HashMap<Resource, Counter> exportsMap = this.getExportsMap(referenced);
            if (exportsMap == null) {
                exportsMap = new HashMap<Resource, Counter>();
                this.exports.put(referenced, exportsMap);
            }
            if ((exportsCount = (Counter)exportsMap.get(referencer)) == null) {
                exportsCount = new Counter();
                exportsMap.put(referencer, exportsCount);
                this.exportAdded(referenced, referencer);
            } else {
                exportsCount.inc();
            }
        }
    }

    protected void importAdded(Resource referencer, Resource referenced) {
    }

    protected void importRemoved(Resource referencer, Resource referenced) {
    }

    protected void exportAdded(Resource referenced, Resource referencer) {
    }

    protected void exportRemoved(Resource referenced, Resource referencer) {
    }

    private void deregisterReference(Resource referencer, Resource referenced) {
        if (referencer != null && referenced != null && referencer != referenced) {
            Counter exportsCount;
            Map exportsMap;
            Counter importsCount;
            Map importsMap = this.getImportsMap(referencer);
            if (importsMap != null && (importsCount = (Counter)importsMap.get(referenced)) != null && importsCount.dec()) {
                importsMap.remove(referenced);
                this.importRemoved(referencer, referenced);
                if (importsMap.isEmpty()) {
                    this.imports.remove(referencer);
                }
            }
            if ((exportsMap = this.getExportsMap(referenced)) != null && (exportsCount = (Counter)exportsMap.get(referencer)) != null && exportsCount.dec()) {
                exportsMap.remove(referencer);
                this.exportRemoved(referenced, referencer);
                if (exportsMap.isEmpty()) {
                    this.exports.remove(referenced);
                }
            }
        }
    }

    private void deregisterReferences(Resource referencer) {
        Object[] resImports = this.getImports(referencer).toArray();
        int i = 0;
        while (i < resImports.length) {
            Map exportsMap;
            Resource referenced = (Resource)resImports[i];
            Map importsMap = this.getImportsMap(referencer);
            if (importsMap != null) {
                importsMap.remove(referenced);
                this.importRemoved(referencer, referenced);
                if (importsMap.isEmpty()) {
                    this.imports.remove(referencer);
                }
            }
            if ((exportsMap = this.getExportsMap(referenced)) != null) {
                exportsMap.remove(referencer);
                this.exportRemoved(referenced, referencer);
                if (exportsMap.isEmpty()) {
                    this.exports.remove(referenced);
                }
            }
            ++i;
        }
    }

    public Set getInverseReferencers(EObject referenced, EReference reference, EClass type) {
        return this.getReferencers(this.getInverseReferences(referenced), reference, type);
    }

    public Set getInverseReferencersCrossResource(EObject referenced, EReference reference, EClass type) {
        return this.getReferencers(this.getInverseReferencesCrossResource(referenced), reference, type);
    }

    public Collection getInverseReferencesCrossResource(EObject eObject) {
        return this.getInverseReferencesCrossResource(eObject, !this.resolve());
    }

    public Set getNonNavigableInverseReferencers(EObject referenced, EReference reference, EClass type) {
        return this.getReferencers(this.getNonNavigableInverseReferences(referenced), reference, type);
    }

    private Set getReferencers(Collection references, EReference reference, EClass type) {
        HashSet<EObject> set = new HashSet<EObject>();
        if (!references.isEmpty()) {
            Iterator iter = references.iterator();
            while (iter.hasNext()) {
                EObject referencer;
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)iter.next();
                if (reference != null && reference != setting.getEStructuralFeature() || (referencer = setting.getEObject()) == null || type != null && !type.isInstance((Object)referencer)) continue;
                set.add(referencer);
            }
        }
        return set;
    }

    public static CrossReferenceAdapter getExistingCrossReferenceAdapter(Notifier notifier) {
        if (notifier == null) {
            return null;
        }
        EList adapters = notifier.eAdapters();
        int i = 0;
        int size = adapters.size();
        while (i < size) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (adapter instanceof CrossReferenceAdapter) {
                return (CrossReferenceAdapter)adapter;
            }
            ++i;
        }
        return null;
    }

    public static CrossReferenceAdapter getCrossReferenceAdapter(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        CrossReferenceAdapter result = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)resourceSet);
        if (result == null) {
            result = new CrossReferenceAdapter();
            resourceSet.eAdapters().add((Object)result);
        }
        return result;
    }

    protected boolean resolve() {
        return this.resolve;
    }

    public Collection getInverseReferences(EObject eObject, boolean _resolve) {
        Collection nonNavigableInverseReferences;
        EObject eContainer;
        ArrayList<EStructuralFeature.Setting> result = new ArrayList<EStructuralFeature.Setting>();
        if (_resolve) {
            this.resolveAll(eObject);
        }
        if ((eContainer = eObject.eContainer()) != null) {
            result.add(((InternalEObject)eContainer).eSetting((EStructuralFeature)eObject.eContainmentFeature()));
        }
        if ((nonNavigableInverseReferences = (Collection)this.inverseCrossReferencer.get((Object)eObject)) != null) {
            result.addAll(nonNavigableInverseReferences);
        }
        Iterator i = eObject.eClass().getEAllReferences().iterator();
        while (i.hasNext()) {
            EReference eReference = (EReference)i.next();
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite == null || eReference.isContainer() || eReference.isContainment() || !eObject.eIsSet((EStructuralFeature)eReference)) continue;
            if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
                Object collection = eObject.eGet((EStructuralFeature)eReference);
                Iterator j = this.resolve() ? ((Collection)collection).iterator() : ((InternalEList)collection).basicIterator();
                while (j.hasNext()) {
                    InternalEObject referencingEObject = (InternalEObject)j.next();
                    result.add(referencingEObject.eSetting((EStructuralFeature)eOpposite));
                }
                continue;
            }
            InternalEObject referencingEObject = (InternalEObject)eObject.eGet((EStructuralFeature)eReference, this.resolve());
            if (referencingEObject == null) continue;
            result.add(referencingEObject.eSetting((EStructuralFeature)eOpposite));
        }
        return result;
    }

    private static List getCrossReferencesChangeableFeatures(EClass eCls) {
        ArrayList<EStructuralFeature> features = (ArrayList<EStructuralFeature>)eClassToChangeableFeatures.get(eCls);
        if (features == null) {
            features = nullList;
            EStructuralFeature[] crossReferenceFeatures = ((EClassImpl.FeatureSubsetSupplier)eCls.getEAllStructuralFeatures()).crossReferences();
            if (crossReferenceFeatures != null) {
                features = new ArrayList<EStructuralFeature>(crossReferenceFeatures.length);
                int i = 0;
                while (i < crossReferenceFeatures.length) {
                    EStructuralFeature feature = crossReferenceFeatures[i];
                    if (feature.isChangeable()) {
                        features.add(feature);
                    }
                    ++i;
                }
            }
            eClassToChangeableFeatures.put(eCls, features);
        }
        return features != nullList ? features : null;
    }

    private EContentsEList.FeatureIterator getOptimizedCrossReferenceIterator(EObject eObj) {
        List features = CrossReferenceAdapter.getCrossReferencesChangeableFeatures(eObj.eClass());
        if (features != null) {
            ECrossReferenceEList list = null;
            list = features.size() > 0 ? new ECrossReferenceEList(eObj, features.toArray(new EStructuralFeature[features.size()])){} : ECrossReferenceEList.EMPTY_CROSS_REFERENCE_ELIST;
            return (EContentsEList.FeatureIterator)(this.resolve() ? list.iterator() : list.basicIterator());
        }
        return (EContentsEList.FeatureIterator)ECrossReferenceEList.EMPTY_CROSS_REFERENCE_ELIST.iterator();
    }

    public Collection getInverseReferencesCrossResource(EObject eObject, boolean resolve) {
        Collection nonNavigableInverseReferences;
        EObject eContainer;
        ArrayList<EStructuralFeature.Setting> result = new ArrayList<EStructuralFeature.Setting>();
        if (resolve) {
            this.resolveAll(eObject);
        }
        if ((eContainer = eObject.eContainer()) != null) {
            result.add(((InternalEObject)eContainer).eSetting((EStructuralFeature)eObject.eContainmentFeature()));
        }
        if ((nonNavigableInverseReferences = (Collection)this.inverseCrossReferencer.get((Object)eObject)) != null) {
            result.addAll(nonNavigableInverseReferences);
        }
        Iterator i = eObject.eClass().getEAllReferences().iterator();
        while (i.hasNext()) {
            EReference eReference = (EReference)i.next();
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite == null || !this.isImportExportCapable(eReference, eObject) || !eObject.eIsSet((EStructuralFeature)eReference)) continue;
            if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
                Object collection = eObject.eGet((EStructuralFeature)eReference);
                Iterator j = this.resolve() ? ((Collection)collection).iterator() : ((InternalEList)collection).basicIterator();
                while (j.hasNext()) {
                    InternalEObject referencingEObject = (InternalEObject)j.next();
                    result.add(referencingEObject.eSetting((EStructuralFeature)eOpposite));
                }
                continue;
            }
            InternalEObject referencingEObject = (InternalEObject)eObject.eGet((EStructuralFeature)eReference, this.resolve());
            if (referencingEObject == null) continue;
            result.add(referencingEObject.eSetting((EStructuralFeature)eOpposite));
        }
        return result;
    }

    protected boolean isImportExportCapable(EReference reference, EObject owner) {
        return !reference.isContainer() && !reference.isContainment() && reference.isResolveProxies() && reference.isChangeable();
    }

    private static final class Counter {
        private int value = 1;

        Counter() {
        }

        int getValue() {
            return this.value;
        }

        void inc() {
            ++this.value;
        }

        boolean dec() {
            return --this.value <= 0;
        }
    }
}

