/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.requests;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.EditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;
import org.eclipse.gmf.runtime.emf.type.core.internal.requests.RequestCacheEntries;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;

public class DestroyDependentsRequest
extends DestroyRequest {
    private EObject elementToDestroy;
    private EObject ctorElementToDestroy;
    private Set dependentElementsToDestroy;
    private Set immutableViewOfDependents;

    public DestroyDependentsRequest(TransactionalEditingDomain editingDomain, EObject elementToDestroy, boolean confirmationRequired) {
        super(editingDomain, confirmationRequired);
        this.elementToDestroy = elementToDestroy;
        this.ctorElementToDestroy = elementToDestroy;
    }

    public final EObject getElementToDestroy() {
        return this.elementToDestroy;
    }

    public final void setElementToDestroy(EObject elementToDestroy) {
        this.elementToDestroy = elementToDestroy;
        if (elementToDestroy != null) {
            this.internalGetDependentElementsToDestroy().add(elementToDestroy);
        }
    }

    public EObject getContainer() {
        if (this.getElementToDestroy() != null) {
            return this.getElementToDestroy().eContainer();
        }
        return null;
    }

    public List getElementsToEdit() {
        if (this.getElementToDestroy() != null) {
            return Collections.singletonList(this.getElementToDestroy());
        }
        return super.getElementsToEdit();
    }

    protected String getDefaultLabel() {
        return EMFTypeCoreMessages.Request_Label_DestroyDependents;
    }

    public Object getEditHelperContext() {
        IClientContext context = this.getClientContext();
        if (context == null) {
            return this.getElementToDestroy();
        }
        return new EditHelperContext(this.getElementToDestroy(), context);
    }

    public TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain result = super.getEditingDomain();
        if (result == null && (result = TransactionUtil.getEditingDomain((EObject)this.getElementToDestroy())) != null) {
            this.setEditingDomain(result);
        }
        return result;
    }

    protected final Set internalGetDependentElementsToDestroy() {
        if (this.dependentElementsToDestroy == null) {
            Map cacheMaps = (Map)this.getParameter("Cache_Maps");
            this.dependentElementsToDestroy = cacheMaps != null ? (Set)cacheMaps.get("Dependent_Elements") : new HashSet();
            this.immutableViewOfDependents = Collections.unmodifiableSet(this.dependentElementsToDestroy);
            if (this.ctorElementToDestroy != null) {
                this.dependentElementsToDestroy.add(this.ctorElementToDestroy);
                this.populateCacheMap(null, this.ctorElementToDestroy);
            }
            if (this.elementToDestroy != null && this.elementToDestroy != this.ctorElementToDestroy) {
                this.dependentElementsToDestroy.add(this.elementToDestroy);
                this.populateCacheMap(null, this.ctorElementToDestroy);
            }
            this.ctorElementToDestroy = null;
        }
        return this.dependentElementsToDestroy;
    }

    public final Set getDependentElementsToDestroy() {
        if (this.immutableViewOfDependents == null) {
            this.internalGetDependentElementsToDestroy();
        }
        return this.immutableViewOfDependents;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICommand getDestroyDependentCommand(EObject dependent) {
        ICommand result = null;
        if (!this.addDependentElementToDestroy(dependent)) return result;
        EObject elementBeingDestroyed = this.getElementToDestroy();
        try {
            DestroyElementRequest destroy = new DestroyElementRequest(this.getEditingDomain(), dependent, this.isConfirmationRequired());
            destroy.addParameters(this.getParameters());
            destroy.setParameter("DestroyElementRequest.destroyDependentsRequest", this);
            this.setElementToDestroy(dependent);
            Object eHelperContext = destroy.getEditHelperContext();
            IElementType context = this.populateCacheMap(eHelperContext, dependent);
            if (context == null) {
                context = ElementTypeRegistry.getInstance().getElementType(eHelperContext);
            }
            if (context != null) {
                result = context.getEditCommand(destroy);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setElementToDestroy(elementBeingDestroyed);
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.setElementToDestroy(elementBeingDestroyed);
            return result;
        }
    }

    private IElementType populateCacheMap(Object eHelperContext, EObject dependent) {
        IElementType context = null;
        Map cacheMaps = (Map)this.getParameter("Cache_Maps");
        if (cacheMaps != null) {
            Set dependents = this.internalGetDependentElementsToDestroy();
            if (cacheMaps.get(dependent) == null) {
                HashMap parentMap = new HashMap();
                cacheMaps.put(dependent, parentMap);
                RequestCacheEntries.initializeEObjCache(dependent, parentMap);
            }
            TreeIterator it = dependent.eAllContents();
            while (it.hasNext()) {
                EObject eObj = (EObject)it.next();
                dependents.add(eObj);
                if (cacheMaps.get(eObj) != null) continue;
                HashMap map = new HashMap();
                cacheMaps.put(eObj, map);
                RequestCacheEntries.initializeEObjCache(eObj, map);
            }
            if (eHelperContext != null) {
                HashMap eHelperMap = (HashMap)cacheMaps.get(eHelperContext);
                if (eHelperMap == null && eHelperContext instanceof EObject) {
                    eHelperMap = new HashMap();
                    cacheMaps.put(eHelperContext, eHelperMap);
                    RequestCacheEntries.initializeEObjCache((EObject)eHelperContext, eHelperMap);
                }
                if (eHelperMap != null) {
                    context = (IElementType)eHelperMap.get("Element_Type");
                }
            }
        }
        return context;
    }

    public ICommand getDestroyDependentsCommand(Collection dependents) {
        ICommand result = null;
        Iterator i = dependents.iterator();
        while (i.hasNext()) {
            result = CompositeCommand.compose(result, (ICommand)this.getDestroyDependentCommand((EObject)i.next()));
        }
        return result;
    }

    protected boolean addDependentElementToDestroy(EObject dependent) {
        if (dependent == null) {
            throw new NullPointerException("dependent is null");
        }
        if (dependent == this.getElementToDestroy()) {
            throw new IllegalArgumentException("dependent is the element being destroyed");
        }
        if (!this.isElementToBeDestroyed(dependent)) {
            return this.internalGetDependentElementsToDestroy().add(dependent);
        }
        return false;
    }

    protected boolean isElementToBeDestroyed(EObject eObject) {
        boolean result = false;
        EObject eObj = this.getElementToDestroy();
        Set set = this.internalGetDependentElementsToDestroy();
        while (!result && eObject != null) {
            result = eObject == eObj || set.contains(eObject);
            eObject = eObject.eContainer();
        }
        return result;
    }
}

