/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.parts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.swt.events.KeyEvent;

public class DiagramGraphicalViewerKeyHandler
extends GraphicalViewerKeyHandler {
    public DiagramGraphicalViewerKeyHandler(GraphicalViewer viewer) {
        super(viewer);
    }

    public boolean keyPressed(KeyEvent event) {
        switch (event.keyCode) {
            case 0x1000007: {
                if (!((event.stateMask & 0x10000) != 0 ? this.navigateEndSibling(event, 8) : this.navigateEndSibling(event, 1))) break;
                return true;
            }
            case 0x1000008: {
                if (!((event.stateMask & 0x10000) != 0 ? this.navigateEndSibling(event, 16) : this.navigateEndSibling(event, 4))) break;
                return true;
            }
            case 0x1000005: {
                if (!((event.stateMask & 0x10000) != 0 ? this.navigatePageSibling(event, 8) : this.navigatePageSibling(event, 1))) break;
                return true;
            }
            case 0x1000006: {
                if (!((event.stateMask & 0x10000) != 0 ? this.navigatePageSibling(event, 16) : this.navigatePageSibling(event, 4))) break;
                return true;
            }
        }
        return super.keyPressed(event);
    }

    protected GraphicalEditPart getFocusPart() {
        return (GraphicalEditPart)this.getViewer().getFocusEditPart();
    }

    protected void navigateToPart(EditPart part, KeyEvent event) {
        if (part == null) {
            return;
        }
        if (!part.isSelectable()) {
            this.getViewer().deselectAll();
            this.getViewer().setFocus(part);
        } else if ((event.stateMask & 0x20000) != 0) {
            this.getViewer().appendSelection(part);
            this.getViewer().setFocus(part);
        } else if ((event.stateMask & 0x40000) != 0) {
            this.getViewer().setFocus(part);
        } else {
            this.getViewer().select(part);
        }
        this.getViewer().reveal(part);
    }

    protected List getPartNavigationSiblings() {
        EditPart epParent = this.findParent((EditPart)this.getFocusPart());
        if (epParent != null) {
            return epParent.getChildren();
        }
        return null;
    }

    protected Point getFigureInterestingPoint(IFigure figure) {
        return figure.getBounds().getCenter();
    }

    protected Viewport findViewport(GraphicalEditPart part) {
        if (part == null) {
            return null;
        }
        IFigure figure = null;
        Viewport port = null;
        do {
            if (!((figure = figure == null ? part.getContentPane() : figure.getParent()) instanceof Viewport)) continue;
            port = (Viewport)figure;
            break;
        } while (figure != null);
        return port;
    }

    protected boolean navigatePageSibling(KeyEvent event, int direction) {
        GraphicalEditPart epStart = this.getFocusPart();
        IFigure figure = epStart.getFigure();
        Point pStart = this.getFigureInterestingPoint(figure);
        figure.translateToAbsolute((Translatable)pStart);
        GraphicalEditPart epParent = (GraphicalEditPart)this.findParent((EditPart)epStart);
        Viewport viewport = this.findViewport(epParent);
        Rectangle bounds = viewport != null ? new Rectangle(viewport.getBounds()) : epParent.getFigure().getClientArea();
        figure.translateToAbsolute((Translatable)bounds);
        int pageDistance = 0;
        switch (direction) {
            case 1: 
            case 4: {
                pageDistance = bounds.height;
                break;
            }
            case 8: 
            case 16: {
                pageDistance = bounds.width;
            }
        }
        List editParts = this.findPageSibling(this.getPartNavigationSiblings(), pStart, pageDistance, direction, (EditPart)epStart);
        if (editParts.isEmpty()) {
            return false;
        }
        if ((event.stateMask & 0x20000) != 0) {
            Iterator parts = editParts.iterator();
            while (parts.hasNext()) {
                this.navigateToPart((EditPart)parts.next(), event);
            }
        } else {
            EditPart part = (EditPart)editParts.get(editParts.size() - 1);
            this.navigateToPart(part, event);
        }
        return true;
    }

    protected boolean navigateEndSibling(KeyEvent event, int direction) {
        GraphicalEditPart epStart = this.getFocusPart();
        IFigure figure = epStart.getFigure();
        Point pStart = this.getFigureInterestingPoint(figure);
        figure.translateToAbsolute((Translatable)pStart);
        List editParts = this.findEndSibling(this.getPartNavigationSiblings(), pStart, direction, (EditPart)epStart);
        if (editParts.isEmpty()) {
            return false;
        }
        if ((event.stateMask & 0x20000) != 0) {
            Iterator parts = editParts.iterator();
            while (parts.hasNext()) {
                this.navigateToPart((EditPart)parts.next(), event);
            }
        } else {
            EditPart part = (EditPart)editParts.get(editParts.size() - 1);
            this.navigateToPart(part, event);
        }
        return true;
    }

    private List findPageSibling(List siblings, Point pStart, int pageDistance, int direction, EditPart exclude) {
        GraphicalEditPart epFinal = null;
        ArrayList<GraphicalEditPart> selection = new ArrayList<GraphicalEditPart>();
        int distance = 0;
        Iterator iter = siblings.iterator();
        while (iter.hasNext()) {
            GraphicalEditPart epCurrent = (GraphicalEditPart)iter.next();
            if (epCurrent == exclude || !epCurrent.getFigure().isVisible() || epCurrent.getFigure().getBounds().isEmpty()) continue;
            IFigure figure = epCurrent.getFigure();
            Point pCurrent = this.getFigureInterestingPoint(figure);
            figure.translateToAbsolute((Translatable)pCurrent);
            if (pStart.getPosition(pCurrent) != direction) continue;
            int d = pCurrent.getDistanceOrthogonal(pStart);
            if (d <= pageDistance) {
                selection.add(epCurrent);
                if (d > distance) {
                    distance = d;
                    epFinal = epCurrent;
                }
            }
            if (epFinal == null) continue;
            selection.remove(epFinal);
            selection.add(epFinal);
        }
        return selection;
    }

    private List findEndSibling(List siblings, Point pStart, int direction, EditPart exclude) {
        GraphicalEditPart epFinal = null;
        ArrayList<GraphicalEditPart> selection = new ArrayList<GraphicalEditPart>();
        int distance = 0;
        Iterator iter = siblings.iterator();
        while (iter.hasNext()) {
            GraphicalEditPart epCurrent = (GraphicalEditPart)iter.next();
            if (epCurrent == exclude || !epCurrent.getFigure().isVisible() || epCurrent.getFigure().getBounds().isEmpty()) continue;
            IFigure figure = epCurrent.getFigure();
            Point pCurrent = this.getFigureInterestingPoint(figure);
            figure.translateToAbsolute((Translatable)pCurrent);
            if (pStart.getPosition(pCurrent) != direction) continue;
            selection.add(epCurrent);
            int d = pCurrent.getDistanceOrthogonal(pStart);
            if (d <= distance) continue;
            distance = d;
            epFinal = epCurrent;
        }
        if (epFinal != null) {
            selection.remove(epFinal);
            selection.add(epFinal);
        }
        return selection;
    }

    private EditPart findParent(EditPart child) {
        if (child instanceof RootEditPart) {
            return child;
        }
        return child.getParent();
    }
}

