/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGAltGlyphHandler;
import org.apache.batik.bridge.SVGFontFamily;
import org.apache.batik.bridge.SVGFontUtilities;
import org.apache.batik.bridge.SVGTextPathElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGTextContent;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SVGTextElementBridge
extends AbstractGraphicsNodeBridge
implements SVGTextContent {
    protected static final Integer ZERO = new Integer(0);
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    public static final AttributedCharacterIterator.Attribute ALT_GLYPH_HANDLER = GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER;
    protected AttributedString laidoutText;
    protected WeakHashMap elemTPI = new WeakHashMap();
    protected boolean usingComplexSVGFont = false;
    protected DOMChildNodeRemovedEventListener childNodeRemovedEventListener = new DOMChildNodeRemovedEventListener();
    protected DOMSubtreeModifiedEventListener subtreeModifiedEventListener = new DOMSubtreeModifiedEventListener();
    private boolean hasNewACI;
    private Element cssProceedElement;
    protected int endLimit;

    public String getLocalName() {
        return "text";
    }

    public Bridge getInstance() {
        return new SVGTextElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        TextNode textNode = (TextNode)super.createGraphicsNode(bridgeContext, element);
        if (textNode == null) {
            return null;
        }
        if (bridgeContext.getTextPainter() != null) {
            textNode.setTextPainter(bridgeContext.getTextPainter());
        }
        RenderingHints renderingHints = null;
        renderingHints = CSSUtilities.convertColorRendering(element, renderingHints);
        if ((renderingHints = CSSUtilities.convertTextRendering(element, renderingHints)) != null) {
            textNode.setRenderingHints(renderingHints);
        }
        textNode.setLocation(this.getLocation(bridgeContext, element));
        return textNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new TextNode();
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(stringTokenizer.nextToken(), "x", context);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(stringTokenizer.nextToken(), "y", context);
        }
        return new Point2D.Float(f, f2);
    }

    protected boolean isTextElement(Element element) {
        if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            return false;
        }
        String string = element.getLocalName();
        return string.equals("text") || string.equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref");
    }

    protected boolean isTextChild(Element element) {
        if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            return false;
        }
        String string = element.getLocalName();
        return string.equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref");
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        element.normalize();
        this.computeLaidoutText(bridgeContext, element, graphicsNode);
        graphicsNode.setComposite(CSSUtilities.convertOpacity(element));
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        graphicsNode.setPointerEventType(CSSUtilities.convertPointerEvents(element));
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        if (!bridgeContext.isDynamic()) {
            return;
        }
        EventTarget eventTarget = (EventTarget)((Object)element);
        eventTarget.addEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        bridgeContext.storeEventListener(eventTarget, "DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        eventTarget.addEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        bridgeContext.storeEventListener(eventTarget, "DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.addContextToChild(bridgeContext, (Element)node);
            }
            node = node.getNextSibling();
        }
    }

    protected void addContextToChild(BridgeContext bridgeContext, Element element) {
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            if (element.getLocalName().equals("tspan")) {
                ((SVGOMElement)element).setSVGContext((SVGContext)new TspanBridge(bridgeContext, this, element));
            } else if (element.getLocalName().equals("textPath")) {
                ((SVGOMElement)element).setSVGContext((SVGContext)new TextPathBridge(bridgeContext, this, element));
            } else if (element.getLocalName().equals("tref")) {
                ((SVGOMElement)element).setSVGContext((SVGContext)new TRefBridge(bridgeContext, this, element));
            }
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.addContextToChild(bridgeContext, (Element)node);
            }
            node = node.getNextSibling();
        }
    }

    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                this.laidoutText = null;
                break;
            }
            case 1: {
                Element element = (Element)node;
                if (!this.isTextChild(element)) break;
                this.addContextToChild(this.ctx, element);
                this.laidoutText = null;
                break;
            }
        }
        if (this.laidoutText == null) {
            this.computeLaidoutText(this.ctx, this.e, this.node);
        }
    }

    public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        EventTarget eventTarget = mutationEvent.getTarget();
        eventTarget.removeEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        eventTarget.removeEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        super.handleDOMNodeRemovedEvent(mutationEvent);
    }

    public void handleDOMChildNodeRemovedEvent(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                if (!this.isParentDisplayed(node)) break;
                this.laidoutText = null;
                break;
            }
            case 1: {
                if (!this.isTextChild((Element)node)) break;
                this.laidoutText = null;
                break;
            }
        }
    }

    public void handleDOMSubtreeModifiedEvent(MutationEvent mutationEvent) {
        if (this.laidoutText == null) {
            this.computeLaidoutText(this.ctx, this.e, this.node);
        }
    }

    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        if (this.isParentDisplayed(node)) {
            this.laidoutText = null;
        }
    }

    protected boolean isParentDisplayed(Node node) {
        Node node2 = node.getParentNode();
        return this.isTextElement((Element)node2);
    }

    protected void computeLaidoutText(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        AttributedString attributedString = this.buildAttributedString(bridgeContext, element);
        this.addGlyphPositionAttributes(attributedString, element, bridgeContext);
        if (bridgeContext.isDynamic()) {
            this.laidoutText = new AttributedString(attributedString.getIterator());
        }
        TextNode textNode = (TextNode)graphicsNode;
        this.elemTPI.clear();
        this.addNullPaintAttributes(attributedString, element, bridgeContext);
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
        TextPaintInfo textPaintInfo = new TextPaintInfo();
        this.setBaseTextPaintInfo(textPaintInfo, element, graphicsNode, bridgeContext);
        this.setDecorationTextPaintInfo(textPaintInfo, element);
        this.addPaintAttributes(attributedString, element, textNode, textPaintInfo, bridgeContext);
        if (this.usingComplexSVGFont) {
            textNode.setAttributedCharacterIterator(attributedString.getIterator());
        }
    }

    protected void addNullPaintAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n = this.getElementStartIndex(attributedCharacterIterator, element);
        if (n == -1) {
            return;
        }
        int n2 = this.getElementEndIndex(attributedCharacterIterator, element);
        TextPaintInfo textPaintInfo = new TextPaintInfo();
        textPaintInfo.visible = true;
        textPaintInfo.fillPaint = Color.black;
        attributedString.addAttribute(PAINT_INFO, textPaintInfo, n, n2 + 1);
        this.elemTPI.put(element, textPaintInfo);
        this.addChildNullPaintAttributes(attributedString, element, bridgeContext);
    }

    protected void addChildNullPaintAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node.getNodeType() == 1 && this.isTextChild(element2 = (Element)node)) {
                this.addNullPaintAttributes(attributedString, element2, bridgeContext);
            }
            node = node.getNextSibling();
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate")) {
            if (string.equals("x") || string.equals("y")) {
                ((TextNode)this.node).setLocation(this.getLocation(this.ctx, this.e));
            }
            this.computeLaidoutText(this.ctx, this.e, this.node);
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }

    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
        this.hasNewACI = false;
        int[] nArray = cSSEngineEvent.getProperties();
        int n = 0;
        while (n < nArray.length) {
            switch (nArray[n]) {
                case 1: 
                case 11: 
                case 12: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 32: 
                case 53: 
                case 56: 
                case 58: 
                case 59: {
                    if (this.hasNewACI) break;
                    this.hasNewACI = true;
                    this.computeLaidoutText(this.ctx, this.e, this.node);
                }
            }
            ++n;
        }
        this.cssProceedElement = cSSEngineEvent.getElement();
        super.handleCSSEngineEvent(cSSEngineEvent);
        this.cssProceedElement = null;
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 15: 
            case 16: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                this.rebuildACI();
                break;
            }
            case 57: {
                this.rebuildACI();
                super.handleCSSPropertyChanged(n);
                break;
            }
            case 55: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertTextRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            case 9: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertColorRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }

    protected void rebuildACI() {
        TextPaintInfo textPaintInfo;
        TextPaintInfo textPaintInfo2;
        if (this.hasNewACI) {
            return;
        }
        TextNode textNode = (TextNode)this.node;
        if (this.cssProceedElement == this.e) {
            textPaintInfo2 = new TextPaintInfo();
            this.setBaseTextPaintInfo(textPaintInfo2, this.e, this.node, this.ctx);
            this.setDecorationTextPaintInfo(textPaintInfo2, this.e);
            textPaintInfo = (TextPaintInfo)this.elemTPI.get(this.e);
        } else {
            TextPaintInfo textPaintInfo3 = this.getParentTextPaintInfo(textNode.getAttributedCharacterIterator(), this.cssProceedElement);
            textPaintInfo2 = this.getTextPaintInfo(this.cssProceedElement, (GraphicsNode)textNode, textPaintInfo3, this.ctx);
            textPaintInfo = (TextPaintInfo)this.elemTPI.get(this.cssProceedElement);
        }
        if (textPaintInfo == null) {
            return;
        }
        textNode.swapTextPaintInfo(textPaintInfo2, textPaintInfo);
        if (this.usingComplexSVGFont) {
            textNode.setAttributedCharacterIterator(textNode.getAttributedCharacterIterator());
        }
    }

    int getElementStartIndex(AttributedCharacterIterator attributedCharacterIterator, Element element) {
        int n = 0;
        while (n < attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator.setIndex(n);
            Element element2 = (Element)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (element2 == element || this.nodeAncestorOf(element, element2)) {
                return n;
            }
            n = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_DELIMITER);
        }
        return -1;
    }

    int getElementEndIndex(AttributedCharacterIterator attributedCharacterIterator, Element element) {
        int n = attributedCharacterIterator.getEndIndex() - 1;
        while (n >= 0) {
            attributedCharacterIterator.setIndex(n);
            Element element2 = (Element)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (element2 == element || this.nodeAncestorOf(element, element2)) {
                return n;
            }
            n = attributedCharacterIterator.getRunStart(TEXT_COMPOUND_DELIMITER) - 1;
        }
        return -1;
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        AttributedStringBuffer attributedStringBuffer = new AttributedStringBuffer();
        this.fillAttributedStringBuffer(bridgeContext, element, true, null, null, attributedStringBuffer);
        return attributedStringBuffer.toAttributedString();
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl, TextPath textPath, Integer n, AttributedStringBuffer attributedStringBuffer) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        String string = XMLSupport.getXMLSpace((Element)element);
        boolean bl2 = string.equals("preserve");
        Element element2 = element;
        if (bl) {
            this.endLimit = 0;
        }
        if (bl2) {
            this.endLimit = attributedStringBuffer.length();
        }
        Map map = this.getAttributeMap(bridgeContext, element, textPath, n);
        Object v = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer n2 = n;
        if (v != null) {
            n2 = (Integer)v;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            boolean bl3 = bl2 ? false : (attributedStringBuffer.length() == 0 ? true : attributedStringBuffer.getLastChar() == 32);
            switch (node.getNodeType()) {
                case 1: {
                    Object object;
                    Object object2;
                    Object object3;
                    if (!"http://www.w3.org/2000/svg".equals(node.getNamespaceURI())) break;
                    element2 = (Element)node;
                    String string2 = node.getLocalName();
                    if (string2.equals("tspan") || string2.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, textPath, n2, attributedStringBuffer);
                        break;
                    }
                    if (string2.equals("textPath")) {
                        object3 = (SVGTextPathElementBridge)bridgeContext.getBridge(element2);
                        object2 = ((SVGTextPathElementBridge)object3).createTextPath(bridgeContext, element2);
                        if (object2 == null) break;
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, (TextPath)object2, n2, attributedStringBuffer);
                        break;
                    }
                    if (string2.equals("tref")) {
                        object3 = XLinkSupport.getXLinkHref((Element)((Element)node));
                        object2 = bridgeContext.getReferencedElement((Element)node, (String)object3);
                        string = TextUtilities.getElementContent((Element)object2);
                        if ((string = this.normalizeString(string, bl2, bl3)) == null) break;
                        object = this.getAttributeMap(bridgeContext, element2, textPath, n);
                        attributedStringBuffer.append(string, (Map)object);
                        break;
                    }
                    if (!string2.equals("a")) break;
                    object3 = (EventTarget)((Object)element2);
                    object2 = bridgeContext.getUserAgent();
                    object = new SVGAElementBridge.AnchorListener((UserAgent)object2);
                    object3.addEventListener("click", (EventListener)object, false);
                    bridgeContext.storeEventListener((EventTarget)object3, "click", (EventListener)object, false);
                    this.fillAttributedStringBuffer(bridgeContext, element2, false, textPath, n2, attributedStringBuffer);
                    break;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl2, bl3);
                    attributedStringBuffer.append(string, map);
                    if (!bl2) break;
                    this.endLimit = attributedStringBuffer.length();
                }
            }
            node = node.getNextSibling();
        }
        if (bl) {
            while (this.endLimit < attributedStringBuffer.length() && attributedStringBuffer.getLastChar() == 32) {
                attributedStringBuffer.stripLast();
            }
        }
    }

    protected String normalizeString(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (bl) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        stringBuffer.append(' ');
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        int n = 0;
        if (bl2) {
            block11: while (n < string.length()) {
                switch (string.charAt(n)) {
                    default: {
                        break block11;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++n;
                    }
                }
            }
        }
        boolean bl3 = false;
        int n2 = n;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            switch (c) {
                case '\n': 
                case '\r': {
                    break;
                }
                case '\t': 
                case ' ': {
                    if (bl3) break;
                    stringBuffer.append(' ');
                    bl3 = true;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    bl3 = false;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected boolean nodeAncestorOf(Node node, Node node2) {
        if (node2 == null || node == null) {
            return false;
        }
        Node node3 = node2.getParentNode();
        while (node3 != null && node3 != node) {
            node3 = node3.getParentNode();
        }
        return node3 == node;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        int n;
        int n2;
        ArrayList arrayList;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        if (element.getLocalName().equals("textPath")) {
            this.addChildGlyphPositionAttributes(attributedString, element, bridgeContext);
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n3 = this.getElementStartIndex(attributedCharacterIterator, element);
        if (n3 == -1) {
            return;
        }
        int n4 = this.getElementEndIndex(attributedCharacterIterator, element);
        String string = element.getAttributeNS(null, "x");
        String string2 = element.getAttributeNS(null, "y");
        String string3 = element.getAttributeNS(null, "dx");
        String string4 = element.getAttributeNS(null, "dy");
        String string5 = element.getAttributeNS(null, "rotate");
        if (string.length() != 0) {
            arrayList = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "x", string, bridgeContext);
            n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n4) {
                    attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.X, arrayList.get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string2.length() != 0) {
            arrayList = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "y", string2, bridgeContext);
            n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n4) {
                    attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.Y, arrayList.get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string3.length() != 0) {
            arrayList = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "dx", string3, bridgeContext);
            n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n4) {
                    attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.DX, arrayList.get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string4.length() != 0) {
            arrayList = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "dy", string4, bridgeContext);
            n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                if (n3 + n <= n4) {
                    attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.DY, arrayList.get(n), n3 + n, n3 + n + 1);
                }
                ++n;
            }
        }
        if (string5.length() != 0) {
            arrayList = TextUtilities.svgRotateArrayToFloats(element, "rotate", string5, bridgeContext);
            n2 = arrayList.size();
            if (n2 == 1) {
                attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ROTATION, arrayList.get(0), n3, n4 + 1);
            } else {
                n = 0;
                while (n < n2) {
                    if (n3 + n <= n4) {
                        attributedString.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ROTATION, arrayList.get(n), n3 + n, n3 + n + 1);
                    }
                    ++n;
                }
            }
        }
        this.addChildGlyphPositionAttributes(attributedString, element, bridgeContext);
    }

    protected void addChildGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node.getNodeType() == 1 && this.isTextChild(element2 = (Element)node)) {
                this.addGlyphPositionAttributes(attributedString, element2, bridgeContext);
            }
            node = node.getNextSibling();
        }
    }

    protected void addPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        Object v = this.elemTPI.get(element);
        if (v == null) {
            return;
        }
        textNode.swapTextPaintInfo(textPaintInfo, (TextPaintInfo)v);
        this.addChildPaintAttributes(attributedString, element, textNode, textPaintInfo, bridgeContext);
    }

    protected void addChildPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node.getNodeType() == 1 && this.isTextChild(element2 = (Element)node)) {
                TextPaintInfo textPaintInfo2 = this.getTextPaintInfo(element2, (GraphicsNode)textNode, textPaintInfo, bridgeContext);
                this.addPaintAttributes(attributedString, element2, textNode, textPaintInfo2, bridgeContext);
            }
            node = node.getNextSibling();
        }
    }

    protected Map getFontProperties(BridgeContext bridgeContext, Element element, Map hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap<AttributedCharacterIterator.Attribute, Element>(4);
        }
        hashMap.put(TEXT_COMPOUND_DELIMITER, element);
        hashMap.put(TextAttribute.SIZE, (Element)((Object)TextUtilities.convertFontSize(element)));
        hashMap.put(TextAttribute.WIDTH, (Element)((Object)TextUtilities.convertFontStretch(element)));
        hashMap.put(TextAttribute.WEIGHT, (Element)((Object)TextUtilities.convertFontWeight(element)));
        hashMap.put(TextAttribute.POSTURE, (Element)((Object)TextUtilities.convertFontStyle(element)));
        return hashMap;
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, TextPath textPath, Integer n) {
        Object object;
        Value value;
        String string;
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI()) && element.getLocalName().equals("altGlyph")) {
            hashMap.put(ALT_GLYPH_HANDLER, new SVGAltGlyphHandler(bridgeContext, element));
        }
        if (textPath != null) {
            hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.TEXTPATH, textPath);
        }
        TextNode.Anchor anchor = TextUtilities.convertTextAnchor(element);
        hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE, anchor);
        this.getFontProperties(bridgeContext, element, hashMap);
        List list = this.getFontFamilyList(element, bridgeContext);
        hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES, list);
        Object object2 = TextUtilities.convertBaselineShift(element);
        if (object2 != null) {
            hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, object2);
        }
        if ((string = (value = CSSUtilities.getComputedStyle(element, 56)).getStringValue()).charAt(0) == 'n') {
            if (n != null) {
                hashMap.put(TextAttribute.BIDI_EMBEDDING, n);
            }
        } else {
            value = CSSUtilities.getComputedStyle(element, 11);
            object = value.getStringValue();
            int n2 = 0;
            if (n != null) {
                n2 = n;
            }
            if (n2 < 0) {
                n2 = -n2;
            }
            switch (((String)object).charAt(0)) {
                case 'l': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    if ((n2 & 1) == 1) {
                        ++n2;
                        break;
                    }
                    n2 += 2;
                    break;
                }
                case 'r': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    if ((n2 & 1) == 1) {
                        n2 += 2;
                        break;
                    }
                    ++n2;
                }
            }
            switch (string.charAt(0)) {
                case 'b': {
                    n2 = -n2;
                }
            }
            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(n2));
        }
        value = CSSUtilities.getComputedStyle(element, 59);
        string = value.getStringValue();
        switch (string.charAt(0)) {
            case 'l': {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR);
                break;
            }
            case 'r': {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL);
                break;
            }
            case 't': {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB);
            }
        }
        value = CSSUtilities.getComputedStyle(element, 29);
        switch (value.getPrimitiveType()) {
            case 21: {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO);
                break;
            }
            case 11: {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(value.getFloatValue()));
                break;
            }
            case 12: {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float((double)(value.getFloatValue() * 180.0f) / Math.PI));
                break;
            }
            case 13: {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(value.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        value = CSSUtilities.getComputedStyle(element, 28);
        switch (value.getPrimitiveType()) {
            case 11: {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float(value.getFloatValue()));
                break;
            }
            case 12: {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float((double)(value.getFloatValue() * 180.0f) / Math.PI));
                break;
            }
            case 13: {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float(value.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        object = TextUtilities.convertLetterSpacing(element);
        if (object != null) {
            hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING, object);
            hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((object = TextUtilities.convertWordSpacing(element)) != null) {
            hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING, object);
            hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((object = TextUtilities.convertKerning(element)) != null) {
            hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.KERNING, object);
            hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((string = element.getAttributeNS(null, "textLength")).length() != 0) {
            float f = UnitProcessor.svgOtherLengthToUserSpace(string, "textLength", context);
            hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH, new Float(f));
            string = element.getAttributeNS(null, "lengthAdjust");
            if (string.length() < 10) {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING);
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
            } else {
                hashMap.put((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL);
            }
        }
        return hashMap;
    }

    protected List getFontFamilyList(Element element, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 27);
        String string = value.getCssText();
        String string2 = CSSUtilities.getComputedStyle(element, 25).getStringValue();
        Value value2 = CSSUtilities.getComputedStyle(element, 21);
        ArrayList<GVTFontFamily> arrayList = new ArrayList<GVTFontFamily>();
        int n = value2.getLength();
        int n2 = 0;
        while (n2 < n) {
            SVGFontFamily sVGFontFamily;
            Value value3 = value2.item(n2);
            String string3 = value3.getStringValue();
            GVTFontFamily gVTFontFamily = SVGFontUtilities.getFontFamily(element, bridgeContext, string3, string, string2);
            if (gVTFontFamily instanceof SVGFontFamily && (sVGFontFamily = (SVGFontFamily)gVTFontFamily).isComplex()) {
                this.usingComplexSVGFont = true;
            }
            arrayList.add(gVTFontFamily);
            ++n2;
        }
        return arrayList;
    }

    protected TextPaintInfo getParentTextPaintInfo(AttributedCharacterIterator attributedCharacterIterator, Element element) {
        Element element2 = null;
        int n = -1;
        int n2 = 0;
        while (n2 < attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator.setIndex(n2);
            Element element3 = (Element)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (this.nodeAncestorOf(element3, element) && (element2 == null || this.nodeAncestorOf(element2, element3))) {
                element2 = element3;
                n = n2;
            }
            if (element3 == element || this.nodeAncestorOf(element, element3)) break;
            n2 = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_DELIMITER);
        }
        if (element2 == null) {
            return new TextPaintInfo();
        }
        attributedCharacterIterator.setIndex(n);
        return (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
    }

    protected TextPaintInfo getTextPaintInfo(Element element, GraphicsNode graphicsNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 54);
        TextPaintInfo textPaintInfo2 = new TextPaintInfo(textPaintInfo);
        StyleMap styleMap = ((CSSStylableElement)element).getComputedStyleMap(null);
        if (styleMap.isNullCascaded(54) && styleMap.isNullCascaded(15) && styleMap.isNullCascaded(45) && styleMap.isNullCascaded(52) && styleMap.isNullCascaded(38)) {
            return textPaintInfo2;
        }
        this.setBaseTextPaintInfo(textPaintInfo2, element, graphicsNode, bridgeContext);
        if (!styleMap.isNullCascaded(54)) {
            this.setDecorationTextPaintInfo(textPaintInfo2, element);
        }
        return textPaintInfo2;
    }

    public void setBaseTextPaintInfo(TextPaintInfo textPaintInfo, Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        textPaintInfo.composite = !element.getLocalName().equals("text") ? CSSUtilities.convertOpacity(element) : AlphaComposite.SrcOver;
        textPaintInfo.visible = CSSUtilities.convertVisibility(element);
        textPaintInfo.fillPaint = PaintServer.convertFillPaint(element, graphicsNode, bridgeContext);
        textPaintInfo.strokePaint = PaintServer.convertStrokePaint(element, graphicsNode, bridgeContext);
        textPaintInfo.strokeStroke = PaintServer.convertStroke(element);
    }

    public void setDecorationTextPaintInfo(TextPaintInfo textPaintInfo, Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 54);
        switch (value.getCssValueType()) {
            case 2: {
                ListValue listValue = (ListValue)value;
                int n = listValue.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Value value2 = listValue.item(n2);
                    String string = value2.getStringValue();
                    switch (string.charAt(0)) {
                        case 'u': {
                            if (textPaintInfo.fillPaint != null) {
                                textPaintInfo.underlinePaint = textPaintInfo.fillPaint;
                            }
                            if (textPaintInfo.strokePaint != null) {
                                textPaintInfo.underlineStrokePaint = textPaintInfo.strokePaint;
                            }
                            if (textPaintInfo.strokeStroke == null) break;
                            textPaintInfo.underlineStroke = textPaintInfo.strokeStroke;
                            break;
                        }
                        case 'o': {
                            if (textPaintInfo.fillPaint != null) {
                                textPaintInfo.overlinePaint = textPaintInfo.fillPaint;
                            }
                            if (textPaintInfo.strokePaint != null) {
                                textPaintInfo.overlineStrokePaint = textPaintInfo.strokePaint;
                            }
                            if (textPaintInfo.strokeStroke == null) break;
                            textPaintInfo.overlineStroke = textPaintInfo.strokeStroke;
                            break;
                        }
                        case 'l': {
                            if (textPaintInfo.fillPaint != null) {
                                textPaintInfo.strikethroughPaint = textPaintInfo.fillPaint;
                            }
                            if (textPaintInfo.strokePaint != null) {
                                textPaintInfo.strikethroughStrokePaint = textPaintInfo.strokePaint;
                            }
                            if (textPaintInfo.strokeStroke == null) break;
                            textPaintInfo.strikethroughStroke = textPaintInfo.strokeStroke;
                        }
                    }
                    ++n2;
                }
                break;
            }
            default: {
                textPaintInfo.underlinePaint = null;
                textPaintInfo.underlineStrokePaint = null;
                textPaintInfo.underlineStroke = null;
                textPaintInfo.overlinePaint = null;
                textPaintInfo.overlineStrokePaint = null;
                textPaintInfo.overlineStroke = null;
                textPaintInfo.strikethroughPaint = null;
                textPaintInfo.strikethroughStrokePaint = null;
                textPaintInfo.strikethroughStroke = null;
            }
        }
    }

    public int getNumberOfChars() {
        return this.getNumberOfChars(this.e);
    }

    public Rectangle2D getExtentOfChar(int n) {
        return this.getExtentOfChar(this.e, n);
    }

    public Point2D getStartPositionOfChar(int n) {
        return this.getStartPositionOfChar(this.e, n);
    }

    public Point2D getEndPositionOfChar(int n) {
        return this.getEndPositionOfChar(this.e, n);
    }

    public void selectSubString(int n, int n2) {
        this.selectSubString(this.e, n, n2);
    }

    public float getRotationOfChar(int n) {
        return this.getRotationOfChar(this.e, n);
    }

    public float getComputedTextLength() {
        return this.getComputedTextLength(this.e);
    }

    public float getSubStringLength(int n, int n2) {
        return this.getSubStringLength(this.e, n, n2);
    }

    public int getCharNumAtPosition(float f, float f2) {
        return this.getCharNumAtPosition(this.e, f, f2);
    }

    protected int getNumberOfChars(Element element) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n = this.getElementStartIndex(attributedCharacterIterator, element);
        if (n == -1) {
            return 0;
        }
        int n2 = this.getElementEndIndex(attributedCharacterIterator, element);
        return n2 - n + 1;
    }

    protected Rectangle2D getExtentOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n2 = this.getElementStartIndex(attributedCharacterIterator, element);
        if (n2 == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        if (characterInformation == null) {
            return null;
        }
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        Shape shape = null;
        if (characterInformation.glyphIndexStart == characterInformation.glyphIndexEnd) {
            if (gVTGlyphVector.isGlyphVisible(characterInformation.glyphIndexStart)) {
                shape = gVTGlyphVector.getGlyphOutline(characterInformation.glyphIndexStart);
            }
        } else {
            Path2D path2D = null;
            int n3 = characterInformation.glyphIndexStart;
            while (n3 <= characterInformation.glyphIndexEnd) {
                if (gVTGlyphVector.isGlyphVisible(n3)) {
                    if (path2D == null) {
                        path2D = new GeneralPath(gVTGlyphVector.getGlyphOutline(n3));
                    } else {
                        path2D.append(gVTGlyphVector.getGlyphOutline(n3), false);
                    }
                }
                ++n3;
            }
            shape = path2D;
        }
        if (shape == null) {
            return null;
        }
        return shape.getBounds2D();
    }

    protected Point2D getStartPositionOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n2 = this.getElementStartIndex(attributedCharacterIterator, element);
        if (n2 == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        if (characterInformation == null) {
            return null;
        }
        return this.getStartPoint(characterInformation);
    }

    protected Point2D getStartPoint(CharacterInformation characterInformation) {
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        if (!gVTGlyphVector.isGlyphVisible(characterInformation.glyphIndexStart)) {
            return null;
        }
        Point2D point2D = gVTGlyphVector.getGlyphPosition(characterInformation.glyphIndexStart);
        AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(characterInformation.glyphIndexStart);
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        if (affineTransform != null) {
            affineTransform.transform(float_, float_);
        }
        float_.x = (float)((double)float_.x + point2D.getX());
        float_.y = (float)((double)float_.y + point2D.getY());
        return float_;
    }

    protected Point2D getEndPositionOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n2 = this.getElementStartIndex(attributedCharacterIterator, element);
        if (n2 == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        if (characterInformation == null) {
            return null;
        }
        return this.getEndPoint(characterInformation);
    }

    protected Point2D getEndPoint(CharacterInformation characterInformation) {
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        if (!gVTGlyphVector.isGlyphVisible(characterInformation.glyphIndexEnd)) {
            return null;
        }
        Point2D point2D = gVTGlyphVector.getGlyphPosition(characterInformation.glyphIndexEnd);
        AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(characterInformation.glyphIndexEnd);
        GVTGlyphMetrics gVTGlyphMetrics = gVTGlyphVector.getGlyphMetrics(characterInformation.glyphIndexEnd);
        Point2D.Float float_ = new Point2D.Float(gVTGlyphMetrics.getHorizontalAdvance(), 0.0f);
        if (affineTransform != null) {
            affineTransform.transform(float_, float_);
        }
        float_.x = (float)((double)float_.x + point2D.getX());
        float_.y = (float)((double)float_.y + point2D.getY());
        return float_;
    }

    protected float getRotationOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n2 = this.getElementStartIndex(attributedCharacterIterator, element);
        if (n2 == -1) {
            return 0.0f;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        double d = 0.0;
        int n3 = 0;
        if (characterInformation != null) {
            GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
            int n4 = characterInformation.glyphIndexStart;
            while (n4 <= characterInformation.glyphIndexEnd) {
                if (gVTGlyphVector.isGlyphVisible(n4)) {
                    ++n3;
                    AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(n4);
                    if (affineTransform != null) {
                        double d2 = 0.0;
                        double d3 = affineTransform.getScaleX();
                        double d4 = affineTransform.getShearX();
                        if (d3 == 0.0) {
                            d2 = d4 > 0.0 ? Math.PI : -Math.PI;
                        } else {
                            d2 = Math.atan(d4 / d3);
                            if (d3 < 0.0) {
                                d2 += Math.PI;
                            }
                        }
                        d2 = Math.toDegrees(-d2) % 360.0;
                        d += d2 - characterInformation.getComputedOrientationAngle();
                    }
                }
                ++n4;
            }
        }
        if (n3 == 0) {
            return 0.0f;
        }
        return (float)(d / (double)n3);
    }

    protected float getComputedTextLength(Element element) {
        return this.getSubStringLength(element, 0, this.getNumberOfChars(element));
    }

    protected float getSubStringLength(Element element, int n, int n2) {
        int n3;
        if (n2 == 0) {
            return 0.0f;
        }
        float f = 0.0f;
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int n4 = this.getElementStartIndex(attributedCharacterIterator, element);
        if (n4 == -1) {
            return -1.0f;
        }
        List list = this.getTextRuns(textNode);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n4, n, attributedCharacterIterator);
        CharacterInformation characterInformation2 = null;
        int n5 = characterInformation.characterIndex + 1;
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        float[] fArray = characterInformation.layout.getGlyphAdvances();
        boolean[] blArray = new boolean[fArray.length];
        int n6 = n + 1;
        while (n6 < n + n2) {
            if (characterInformation.layout.isOnATextPath()) {
                n3 = characterInformation.glyphIndexStart;
                while (n3 <= characterInformation.glyphIndexEnd) {
                    if (gVTGlyphVector.isGlyphVisible(n3) && !blArray[n3]) {
                        f += fArray[n3 + 1] - fArray[n3];
                    }
                    blArray[n3] = true;
                    ++n3;
                }
                CharacterInformation characterInformation3 = this.getCharacterInformation(list, n4, n6, attributedCharacterIterator);
                if (characterInformation3.layout != characterInformation.layout) {
                    gVTGlyphVector = characterInformation3.layout.getGlyphVector();
                    fArray = characterInformation3.layout.getGlyphAdvances();
                    blArray = new boolean[fArray.length];
                    n5 = characterInformation.characterIndex + 1;
                }
                characterInformation = characterInformation3;
            } else if (characterInformation.layout.hasCharacterIndex(n5)) {
                ++n5;
            } else {
                characterInformation2 = this.getCharacterInformation(list, n4, n6 - 1, attributedCharacterIterator);
                f += this.distanceFirstLastCharacterInRun(characterInformation, characterInformation2);
                characterInformation = this.getCharacterInformation(list, n4, n6, attributedCharacterIterator);
                n5 = characterInformation.characterIndex + 1;
                gVTGlyphVector = characterInformation.layout.getGlyphVector();
                fArray = characterInformation.layout.getGlyphAdvances();
                blArray = new boolean[fArray.length];
                characterInformation2 = null;
            }
            ++n6;
        }
        if (characterInformation.layout.isOnATextPath()) {
            n3 = characterInformation.glyphIndexStart;
            while (n3 <= characterInformation.glyphIndexEnd) {
                if (gVTGlyphVector.isGlyphVisible(n3) && !blArray[n3]) {
                    f += fArray[n3 + 1] - fArray[n3];
                }
                blArray[n3] = true;
                ++n3;
            }
        } else {
            if (characterInformation2 == null) {
                characterInformation2 = this.getCharacterInformation(list, n4, n + n2 - 1, attributedCharacterIterator);
            }
            f += this.distanceFirstLastCharacterInRun(characterInformation, characterInformation2);
        }
        return f;
    }

    protected float distanceFirstLastCharacterInRun(CharacterInformation characterInformation, CharacterInformation characterInformation2) {
        float[] fArray = characterInformation.layout.getGlyphAdvances();
        int n = characterInformation.glyphIndexStart;
        int n2 = characterInformation.glyphIndexEnd;
        int n3 = characterInformation2.glyphIndexStart;
        int n4 = characterInformation2.glyphIndexEnd;
        int n5 = n < n3 ? n : n3;
        int n6 = n2 < n4 ? n4 : n2;
        return fArray[n6 + 1] - fArray[n5];
    }

    protected float distanceBetweenRun(CharacterInformation characterInformation, CharacterInformation characterInformation2) {
        CharacterInformation characterInformation3 = new CharacterInformation();
        characterInformation3.layout = characterInformation.layout;
        characterInformation3.glyphIndexEnd = characterInformation.layout.getGlyphCount() - 1;
        Point2D point2D = this.getEndPoint(characterInformation3);
        characterInformation3.layout = characterInformation2.layout;
        characterInformation3.glyphIndexStart = 0;
        Point2D point2D2 = this.getStartPoint(characterInformation3);
        float f = characterInformation2.isVertical() ? (float)(point2D2.getY() - point2D.getY()) : (float)(point2D2.getX() - point2D.getX());
        return f;
    }

    protected void selectSubString(Element element, int n, int n2) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int n3 = this.getElementStartIndex(attributedCharacterIterator, element);
        if (n3 == -1) {
            return;
        }
        List list = this.getTextRuns(textNode);
        int n4 = this.getElementEndIndex(attributedCharacterIterator, element);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n3, n, attributedCharacterIterator);
        CharacterInformation characterInformation2 = this.getCharacterInformation(list, n3, n + n2 - 1, attributedCharacterIterator);
        Mark mark = textNode.getMarkerForChar(characterInformation.characterIndex, true);
        Mark mark2 = characterInformation2 != null && characterInformation2.characterIndex <= n4 ? textNode.getMarkerForChar(characterInformation2.characterIndex, false) : textNode.getMarkerForChar(n4, false);
        this.ctx.getUserAgent().setTextSelection(mark, mark2);
    }

    protected int getCharNumAtPosition(Element element, float f, float f2) {
        TextNode textNode = (TextNode)this.node;
        List list = this.getTextRuns(textNode);
        TextHit textHit = null;
        int n = list.size() - 1;
        while (n >= 0 && textHit == null) {
            textHit = ((StrokingTextPainter.TextRun)list.get(n)).getLayout().hitTestChar(f, f2);
            --n;
        }
        if (textHit == null) {
            return -1;
        }
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n2 = this.getElementStartIndex(attributedCharacterIterator, element);
        int n3 = this.getElementEndIndex(attributedCharacterIterator, element);
        int n4 = textHit.getCharIndex();
        if (n4 >= n2 && n4 <= n3) {
            return n4 - n2;
        }
        return -1;
    }

    protected List getTextRuns(TextNode textNode) {
        if (textNode.getTextRuns() == null) {
            textNode.getPrimitiveBounds();
        }
        return textNode.getTextRuns();
    }

    protected CharacterInformation getCharacterInformation(List list, int n, int n2, AttributedCharacterIterator attributedCharacterIterator) {
        CharacterInformation characterInformation = new CharacterInformation();
        characterInformation.characterIndex = n + n2;
        int n3 = 0;
        while (n3 < list.size()) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(n3);
            if (textRun.getLayout().hasCharacterIndex(characterInformation.characterIndex)) {
                characterInformation.layout = textRun.getLayout();
                attributedCharacterIterator.setIndex(characterInformation.characterIndex);
                if (attributedCharacterIterator.getAttribute(ALT_GLYPH_HANDLER) != null) {
                    characterInformation.glyphIndexStart = 0;
                    characterInformation.glyphIndexEnd = characterInformation.layout.getGlyphCount() - 1;
                } else {
                    characterInformation.glyphIndexStart = characterInformation.layout.getGlyphIndex(characterInformation.characterIndex);
                    if (characterInformation.glyphIndexStart == -1) {
                        characterInformation.glyphIndexStart = 0;
                        characterInformation.glyphIndexEnd = characterInformation.layout.getGlyphCount() - 1;
                    } else {
                        characterInformation.glyphIndexEnd = characterInformation.glyphIndexStart;
                    }
                }
                return characterInformation;
            }
            ++n3;
        }
        return null;
    }

    public Set getTextIntersectionSet(AffineTransform affineTransform, Rectangle2D rectangle2D) {
        TextNode textNode = (TextNode)this.node;
        List list = textNode.getTextRuns();
        HashSet<Element> hashSet = new HashSet<Element>();
        int n = 0;
        while (n < list.size()) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(n);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Element element = (Element)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (element != null && !hashSet.contains(element) && SVGTextElementBridge.isTextSensitive(element)) {
                Rectangle2D rectangle2D2 = textSpanLayout.getBounds2D();
                if (rectangle2D2 != null) {
                    rectangle2D2 = affineTransform.createTransformedShape(rectangle2D2).getBounds2D();
                }
                if (rectangle2D.intersects(rectangle2D2)) {
                    GVTGlyphVector gVTGlyphVector = textSpanLayout.getGlyphVector();
                    int n2 = 0;
                    while (n2 < gVTGlyphVector.getNumGlyphs()) {
                        Shape shape = gVTGlyphVector.getGlyphLogicalBounds(n2);
                        if (shape != null) {
                            shape = affineTransform.createTransformedShape(shape).getBounds2D();
                        }
                        if (shape.intersects(rectangle2D)) {
                            hashSet.add(element);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return hashSet;
    }

    public Set getTextEnclosureSet(AffineTransform affineTransform, Rectangle2D rectangle2D) {
        TextNode textNode = (TextNode)this.node;
        HashSet<Element> hashSet = new HashSet<Element>();
        HashSet<Element> hashSet2 = new HashSet<Element>();
        List list = textNode.getTextRuns();
        int n = 0;
        while (n < list.size()) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(n);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Element element = (Element)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (element != null && !hashSet2.contains(element)) {
                if (!SVGTextElementBridge.isTextSensitive(element)) {
                    hashSet2.add(element);
                } else {
                    Rectangle2D rectangle2D2 = textSpanLayout.getBounds2D();
                    if (rectangle2D2 != null) {
                        rectangle2D2 = affineTransform.createTransformedShape(rectangle2D2).getBounds2D();
                    }
                    if (rectangle2D.contains(rectangle2D2)) {
                        hashSet.add(element);
                    } else {
                        hashSet2.add(element);
                        hashSet.remove(element);
                    }
                }
            }
            ++n;
        }
        return hashSet;
    }

    public static boolean getTextIntersection(BridgeContext bridgeContext, Element element, AffineTransform affineTransform, Rectangle2D rectangle2D, boolean bl) {
        AbstractTextChildSVGContext abstractTextChildSVGContext;
        SVGContext sVGContext = null;
        if (element instanceof SVGOMElement) {
            sVGContext = ((SVGOMElement)element).getSVGContext();
        }
        if (sVGContext == null) {
            return false;
        }
        SVGTextElementBridge sVGTextElementBridge = null;
        if (sVGContext instanceof SVGTextElementBridge) {
            sVGTextElementBridge = (SVGTextElementBridge)sVGContext;
        } else if (sVGContext instanceof AbstractTextChildSVGContext) {
            abstractTextChildSVGContext = (AbstractTextChildSVGContext)sVGContext;
            sVGTextElementBridge = abstractTextChildSVGContext.getTextBridge();
        }
        if (sVGTextElementBridge == null) {
            return false;
        }
        abstractTextChildSVGContext = (TextNode)sVGTextElementBridge.node;
        Element element2 = sVGTextElementBridge.e;
        AffineTransform affineTransform2 = abstractTextChildSVGContext.getGlobalTransform();
        affineTransform2.preConcatenate(affineTransform);
        Rectangle2D rectangle2D2 = abstractTextChildSVGContext.getBounds();
        rectangle2D2 = affineTransform2.createTransformedShape(rectangle2D2).getBounds2D();
        if (!rectangle2D.intersects(rectangle2D2)) {
            return false;
        }
        List list = abstractTextChildSVGContext.getTextRuns();
        int n = 0;
        while (n < list.size()) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(n);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Element element3 = (Element)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (element3 != null && (!bl || SVGTextElementBridge.isTextSensitive(element3))) {
                Rectangle2D rectangle2D3;
                Element element4 = element3;
                while (element4 != null && element4 != element2 && element4 != element) {
                    element4 = (Element)element4.getParentNode();
                }
                if (element4 == element && (rectangle2D3 = textSpanLayout.getBounds2D()) != null && rectangle2D.intersects(rectangle2D3 = affineTransform2.createTransformedShape(rectangle2D3).getBounds2D())) {
                    GVTGlyphVector gVTGlyphVector = textSpanLayout.getGlyphVector();
                    int n2 = 0;
                    while (n2 < gVTGlyphVector.getNumGlyphs()) {
                        Shape shape = gVTGlyphVector.getGlyphLogicalBounds(n2);
                        if (shape != null) {
                            shape = affineTransform2.createTransformedShape(shape).getBounds2D();
                        }
                        if (shape.intersects(rectangle2D)) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return false;
    }

    public static Rectangle2D getTextBounds(BridgeContext bridgeContext, Element element, boolean bl) {
        AbstractTextChildSVGContext abstractTextChildSVGContext;
        SVGContext sVGContext = null;
        if (element instanceof SVGOMElement) {
            sVGContext = ((SVGOMElement)element).getSVGContext();
        }
        if (sVGContext == null) {
            return null;
        }
        SVGTextElementBridge sVGTextElementBridge = null;
        if (sVGContext instanceof SVGTextElementBridge) {
            sVGTextElementBridge = (SVGTextElementBridge)sVGContext;
        } else if (sVGContext instanceof AbstractTextChildSVGContext) {
            abstractTextChildSVGContext = (AbstractTextChildSVGContext)sVGContext;
            sVGTextElementBridge = abstractTextChildSVGContext.getTextBridge();
        }
        if (sVGTextElementBridge == null) {
            return null;
        }
        abstractTextChildSVGContext = (TextNode)sVGTextElementBridge.node;
        Element element2 = sVGTextElementBridge.e;
        Rectangle2D rectangle2D = null;
        List list = abstractTextChildSVGContext.getTextRuns();
        if (list == null) {
            return null;
        }
        int n = 0;
        while (n < list.size()) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(n);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Element element3 = (Element)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (element3 != null && (!bl || SVGTextElementBridge.isTextSensitive(element3))) {
                Rectangle2D rectangle2D2;
                Element element4 = element3;
                while (element4 != null && element4 != element2 && element4 != element) {
                    element4 = (Element)element4.getParentNode();
                }
                if (element4 == element && (rectangle2D2 = textSpanLayout.getBounds2D()) != null) {
                    if (rectangle2D == null) {
                        rectangle2D = (Rectangle2D)rectangle2D2.clone();
                    } else {
                        rectangle2D.add(rectangle2D2);
                    }
                }
            }
            ++n;
        }
        return rectangle2D;
    }

    public static boolean isTextSensitive(Element element) {
        int n = CSSUtilities.convertPointerEvents(element);
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return CSSUtilities.convertVisibility(element);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    protected static class CharacterInformation {
        TextSpanLayout layout;
        int glyphIndexStart;
        int glyphIndexEnd;
        int characterIndex;

        protected CharacterInformation() {
        }

        public boolean isVertical() {
            return this.layout.isVertical();
        }

        public double getComputedOrientationAngle() {
            return this.layout.getComputedOrientationAngle(this.characterIndex);
        }
    }

    protected class TspanBridge
    extends AbstractTextChildTextContent {
        public TspanBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
            String string = mutationEvent.getAttrName();
            if (string.equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate")) {
                this.textBridge.computeLaidoutText(this.ctx, this.textBridge.e, this.textBridge.node);
            }
        }
    }

    protected class TextPathBridge
    extends AbstractTextChildTextContent {
        public TextPathBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }
    }

    protected class TRefBridge
    extends AbstractTextChildTextContent {
        public TRefBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
            String string = mutationEvent.getAttrName();
            if (string.equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate")) {
                this.textBridge.computeLaidoutText(this.ctx, this.textBridge.e, this.textBridge.node);
            }
        }
    }

    protected class AbstractTextChildTextContent
    extends AbstractTextChildBridgeUpdateHandler
    implements SVGTextContent {
        public AbstractTextChildTextContent(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public int getNumberOfChars() {
            return this.textBridge.getNumberOfChars(this.e);
        }

        public Rectangle2D getExtentOfChar(int n) {
            return this.textBridge.getExtentOfChar(this.e, n);
        }

        public Point2D getStartPositionOfChar(int n) {
            return this.textBridge.getStartPositionOfChar(this.e, n);
        }

        public Point2D getEndPositionOfChar(int n) {
            return this.textBridge.getEndPositionOfChar(this.e, n);
        }

        public void selectSubString(int n, int n2) {
            this.textBridge.selectSubString(this.e, n, n2);
        }

        public float getRotationOfChar(int n) {
            return this.textBridge.getRotationOfChar(this.e, n);
        }

        public float getComputedTextLength() {
            return this.textBridge.getComputedTextLength(this.e);
        }

        public float getSubStringLength(int n, int n2) {
            return this.textBridge.getSubStringLength(this.e, n, n2);
        }

        public int getCharNumAtPosition(float f, float f2) {
            return this.textBridge.getCharNumAtPosition(this.e, f, f2);
        }
    }

    protected abstract class AbstractTextChildBridgeUpdateHandler
    extends AbstractTextChildSVGContext
    implements BridgeUpdateHandler {
        public AbstractTextChildBridgeUpdateHandler(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        }

        public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
            this.textBridge.handleDOMNodeInsertedEvent(mutationEvent);
        }

        public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
            this.dispose();
        }

        public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
            this.textBridge.handleDOMCharacterDataModified(mutationEvent);
        }

        public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
            this.textBridge.handleCSSEngineEvent(cSSEngineEvent);
        }

        public void dispose() {
            ((SVGOMElement)this.e).setSVGContext(null);
            SVGTextElementBridge.this.elemTPI.remove(this.e);
        }
    }

    public abstract class AbstractTextChildSVGContext
    implements SVGContext {
        protected BridgeContext ctx;
        protected SVGTextElementBridge textBridge;
        protected Element e;

        public AbstractTextChildSVGContext(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            this.ctx = bridgeContext;
            this.textBridge = sVGTextElementBridge2;
            this.e = element;
        }

        public SVGTextElementBridge getTextBridge() {
            return this.textBridge;
        }

        public float getPixelUnitToMillimeter() {
            return this.ctx.getUserAgent().getPixelUnitToMillimeter();
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public Rectangle2D getBBox() {
            return null;
        }

        public AffineTransform getCTM() {
            return null;
        }

        public AffineTransform getGlobalTransform() {
            return null;
        }

        public AffineTransform getScreenTransform() {
            return null;
        }

        public void setScreenTransform(AffineTransform affineTransform) {
        }

        public float getViewportWidth() {
            return this.ctx.getBlockWidth(this.e);
        }

        public float getViewportHeight() {
            return this.ctx.getBlockHeight(this.e);
        }

        public float getFontSize() {
            return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
        }
    }

    protected static class AttributedStringBuffer {
        protected List strings = new ArrayList();
        protected List attributes = new ArrayList();
        protected int count = 0;
        protected int length = 0;

        public boolean isEmpty() {
            return this.count == 0;
        }

        public int length() {
            return this.length;
        }

        public void append(String string, Map map) {
            if (string.length() == 0) {
                return;
            }
            this.strings.add(string);
            this.attributes.add(map);
            ++this.count;
            this.length += string.length();
        }

        public int getLastChar() {
            if (this.count == 0) {
                return -1;
            }
            String string = (String)this.strings.get(this.count - 1);
            return string.charAt(string.length() - 1);
        }

        public void stripFirst() {
            String string = (String)this.strings.get(0);
            if (string.charAt(string.length() - 1) != ' ') {
                return;
            }
            --this.length;
            if (string.length() == 1) {
                this.attributes.remove(0);
                this.strings.remove(0);
                --this.count;
                return;
            }
            this.strings.set(0, string.substring(1));
        }

        public void stripLast() {
            String string = (String)this.strings.get(this.count - 1);
            if (string.charAt(string.length() - 1) != ' ') {
                return;
            }
            --this.length;
            if (string.length() == 1) {
                this.attributes.remove(--this.count);
                this.strings.remove(this.count);
                return;
            }
            this.strings.set(this.count - 1, string.substring(0, string.length() - 1));
        }

        public AttributedString toAttributedString() {
            switch (this.count) {
                case 0: {
                    return new AttributedString(" ");
                }
                case 1: {
                    return new AttributedString((String)this.strings.get(0), (Map)this.attributes.get(0));
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.strings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            AttributedString attributedString = new AttributedString(stringBuffer.toString());
            Iterator iterator2 = this.strings.iterator();
            Iterator iterator3 = this.attributes.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                int n2 = n + string.length();
                Map map = (Map)iterator3.next();
                Iterator iterator4 = map.keySet().iterator();
                Iterator iterator5 = map.values().iterator();
                while (iterator4.hasNext()) {
                    AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)iterator4.next();
                    Object v = iterator5.next();
                    attributedString.addAttribute(attribute, v, n, n2);
                }
                n = n2;
            }
            return attributedString;
        }

        public String toString() {
            switch (this.count) {
                case 0: {
                    return "";
                }
                case 1: {
                    return (String)this.strings.get(0);
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.strings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            return stringBuffer.toString();
        }
    }

    protected class DOMSubtreeModifiedEventListener
    implements EventListener {
        protected DOMSubtreeModifiedEventListener() {
        }

        public void handleEvent(Event event) {
            SVGTextElementBridge.this.handleDOMSubtreeModifiedEvent((MutationEvent)event);
        }
    }

    protected class DOMChildNodeRemovedEventListener
    implements EventListener {
        protected DOMChildNodeRemovedEventListener() {
        }

        public void handleEvent(Event event) {
            SVGTextElementBridge.this.handleDOMChildNodeRemovedEvent((MutationEvent)event);
        }
    }
}

