/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core.commands;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.type.core.commands.DeferredSetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Employee;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.EmployeePackage;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Office;

public class DeferredSetValueCommandTest
extends AbstractEMFTypeTest {
    private Department department;
    private Employee manager;
    private Office managerOffice;
    static /* synthetic */ Class class$0;

    public DeferredSetValueCommandTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.commands.DeferredSetValueCommandTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void doModelSetup(Resource resource) {
        this.department = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department.setName("Department");
        resource.getContents().add((Object)this.department);
        this.manager = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.managerOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
    }

    public void test_isExecutable() {
        SetRequest request = new SetRequest(this.getEditingDomain(), null, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Manager(), (Object)this.manager);
        TestDeferredSetValueCommand command = new TestDeferredSetValueCommand(request);
        DeferredSetValueCommandTest.assertTrue((boolean)command.canExecute());
        command.setOwner(this.managerOffice);
        DeferredSetValueCommandTest.assertFalse((boolean)command.canExecute());
        command.setOwner(this.department);
        DeferredSetValueCommandTest.assertTrue((boolean)command.canExecute());
        try {
            DeferredSetValueCommandTest.assertNull((Object)this.department.getManager());
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            DeferredSetValueCommandTest.assertSame((Object)this.manager, (Object)this.department.getManager());
        }
        catch (ExecutionException executionException) {
            DeferredSetValueCommandTest.fail((String)"unexpected execution exception");
        }
    }

    private class TestDeferredSetValueCommand
    extends DeferredSetValueCommand {
        private EObject owner;

        public TestDeferredSetValueCommand(SetRequest request) {
            super(request);
        }

        protected EObject getElementToEdit() {
            return this.owner;
        }

        public void setOwner(EObject owner) {
            this.owner = owner;
        }
    }
}

