/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.ui.services.action.contributionitem;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.ContributionItemService;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.services.IServiceLocator;

public class ContributionItemServiceTests
extends TestCase {
    private static final String MY_ACTIVITY_ID = "MyActivityID";
    static /* synthetic */ Class class$0;

    public ContributionItemServiceTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ContributionItemServiceTests.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.common.ui.services.action.contributionitem.ContributionItemServiceTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testActivityFiltering() throws Exception {
        String EDITOR1 = "editor1";
        String EDITOR2 = "editor2";
        MyWorkbenchPartDescriptor editor1Descriptor = new MyWorkbenchPartDescriptor(EDITOR1);
        MyWorkbenchPartDescriptor editor2Descriptor = new MyWorkbenchPartDescriptor(EDITOR2);
        MyActionBars editor1ActionBars = new MyActionBars();
        MyActionBars editor2ActionBars = new MyActionBars();
        this.toggleActivity(false);
        ContributionItemService.getInstance().contributeToActionBars((IActionBars)editor1ActionBars, (IWorkbenchPartDescriptor)editor1Descriptor);
        this.validateActionBars(editor1ActionBars, false, false);
        ContributionItemService.getInstance().contributeToActionBars((IActionBars)editor2ActionBars, (IWorkbenchPartDescriptor)editor2Descriptor);
        this.validateActionBars(editor2ActionBars, false, false);
        this.toggleActivity(true);
        ContributionItemService.getInstance().updateActionBars((IActionBars)editor1ActionBars, (IWorkbenchPartDescriptor)editor1Descriptor);
        this.validateActionBars(editor1ActionBars, true, true);
        this.validateActionBars(editor2ActionBars, false, true);
        ContributionItemService.getInstance().updateActionBars((IActionBars)editor2ActionBars, (IWorkbenchPartDescriptor)editor2Descriptor);
        this.validateActionBars(editor1ActionBars, true, true);
        this.validateActionBars(editor2ActionBars, true, true);
        int expectedLength = editor2ActionBars.getToolBarManager().getItems().length;
        IContributionItem expectedItem0 = editor2ActionBars.getToolBarManager().getItems()[0];
        IContributionItem expectedItem2 = editor2ActionBars.getToolBarManager().getItems()[2];
        ContributionItemService.getInstance().updateActionBars((IActionBars)editor2ActionBars, (IWorkbenchPartDescriptor)editor2Descriptor);
        ContributionItemServiceTests.assertEquals((int)expectedLength, (int)editor2ActionBars.getToolBarManager().getItems().length);
        ContributionItemServiceTests.assertEquals((Object)expectedItem0, (Object)editor2ActionBars.getToolBarManager().getItems()[0]);
        ContributionItemServiceTests.assertEquals((Object)expectedItem2, (Object)editor2ActionBars.getToolBarManager().getItems()[2]);
        this.validateActionBars(editor1ActionBars, true, true);
        this.validateActionBars(editor2ActionBars, true, true);
        this.toggleActivity(false);
        this.validateActionBars(editor1ActionBars, true, false);
        this.validateActionBars(editor2ActionBars, true, false);
        this.toggleActivity(true);
        this.validateActionBars(editor1ActionBars, true, true);
        this.validateActionBars(editor2ActionBars, true, true);
    }

    private void toggleActivity(boolean enabled) {
        boolean changeMade;
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet<String> enabledActivityIds = new HashSet<String>(workbenchActivitySupport.getActivityManager().getEnabledActivityIds());
        boolean bl = changeMade = enabled ? enabledActivityIds.add(MY_ACTIVITY_ID) : enabledActivityIds.remove(MY_ACTIVITY_ID);
        if (changeMade) {
            workbenchActivitySupport.setEnabledActivityIds(enabledActivityIds);
        }
    }

    private void validateActionBars(IActionBars actionBars, boolean provider2Contributed, boolean provider2Visible) {
        ContributionItemServiceTests.assertNotNull((Object)actionBars.getToolBarManager().find("action1"));
        if (provider2Contributed) {
            ContributionItemServiceTests.assertNotNull((Object)actionBars.getToolBarManager().find("action2"));
            ContributionItemServiceTests.assertNotNull((Object)((IMenuManager)actionBars.getToolBarManager().find("menu1")).find("menu2"));
        } else {
            ContributionItemServiceTests.assertNull((Object)actionBars.getToolBarManager().find("action2"));
            ContributionItemServiceTests.assertNull((Object)((IMenuManager)actionBars.getToolBarManager().find("menu1")).find("menu2"));
        }
        if (provider2Contributed) {
            this.validateVisibility(actionBars.getMenuManager().getItems(), provider2Visible);
            this.validateVisibility(actionBars.getToolBarManager().getItems(), provider2Visible);
        }
    }

    private void validateVisibility(IContributionItem[] items, boolean visibility) {
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (item.getId().equals("action2")) {
                ContributionItemServiceTests.assertEquals((boolean)visibility, (boolean)item.isVisible());
            }
            if (item instanceof IMenuManager) {
                this.validateVisibility(((IMenuManager)item).getItems(), visibility);
            }
            ++i;
        }
    }

    class MyActionBars
    implements IActionBars {
        IToolBarManager myToolBarManager = new ToolBarManager();
        IMenuManager myMenuManager = new MenuManager();

        MyActionBars() {
        }

        public void clearGlobalActionHandlers() {
        }

        public IAction getGlobalActionHandler(String actionId) {
            return null;
        }

        public IMenuManager getMenuManager() {
            return this.myMenuManager;
        }

        public IStatusLineManager getStatusLineManager() {
            return null;
        }

        public IToolBarManager getToolBarManager() {
            return this.myToolBarManager;
        }

        public void setGlobalActionHandler(String actionId, IAction handler) {
        }

        public void updateActionBars() {
        }

        public IServiceLocator getServiceLocator() {
            return null;
        }
    }

    class MyWorkbenchPartDescriptor
    implements IWorkbenchPartDescriptor {
        String partId;
        static /* synthetic */ Class class$0;

        public MyWorkbenchPartDescriptor(String id) {
            this.partId = id;
        }

        public String getPartId() {
            return this.partId;
        }

        public Class getPartClass() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.common.ui.services.action.contributionitem.MyWorkbenchPart");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public IWorkbenchPage getPartPage() {
            return null;
        }
    }
}

