/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.parts;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandleLocator;

public class ConnectionHandleLocatorTest
extends TestCase {
    private RectangleFigure rectangle;
    static /* synthetic */ Class class$0;

    public ConnectionHandleLocatorTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ConnectionHandleLocatorTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.diagram.ui.parts.ConnectionHandleLocatorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() throws Exception {
        this.rectangle = new RectangleFigure();
        this.rectangle.setLocation(new Point(0, 0));
        this.rectangle.setSize(100, 200);
    }

    protected void tearDown() throws Exception {
        this.rectangle = null;
    }

    public void testConnectionHandleLocator() throws Exception {
        ConnectionHandleLocator locator;
        Object[][] data = new Object[][]{{new Point(30, 0), new Integer(1)}, {new Point(30, 100), new Integer(8)}, {new Point(80, 70), new Integer(16)}, {new Point(40, 190), new Integer(4)}};
        int i = 0;
        while (i < data.length) {
            locator = new ConnectionHandleLocator((IFigure)this.rectangle, (Point)data[i][0]);
            FakeConnectionHandle handle = new FakeConnectionHandle();
            locator.addHandle((ConnectionHandle)handle);
            locator.relocate((IFigure)handle);
            ConnectionHandleLocatorTest.assertTrue((this.rectangle.getBounds().getPosition(handle.getLocation()) == ((Integer)data[i][1]).intValue() ? 1 : 0) != 0);
            ConnectionHandleLocatorTest.assertTrue((locator.getBorderSide() == ((Integer)data[i][1]).intValue() ? 1 : 0) != 0);
            ConnectionHandleLocatorTest.assertTrue((!locator.isEastWestSouth() ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < data.length) {
            locator = new ConnectionHandleLocator((IFigure)this.rectangle, (Point)data[i][0]);
            FakeConnectionHandle handle1 = new FakeConnectionHandle();
            FakeConnectionHandle handle2 = new FakeConnectionHandle();
            locator.addHandle((ConnectionHandle)handle1);
            locator.addHandle((ConnectionHandle)handle2);
            locator.relocate((IFigure)handle1);
            locator.relocate((IFigure)handle2);
            int expectedSide = (Integer)data[i][1];
            if (expectedSide != 1) {
                ConnectionHandleLocatorTest.assertTrue((this.rectangle.getBounds().getPosition(handle1.getLocation()) == expectedSide ? 1 : 0) != 0);
                ConnectionHandleLocatorTest.assertTrue((this.rectangle.getBounds().getPosition(handle2.getLocation()) == expectedSide ? 1 : 0) != 0);
            }
            ConnectionHandleLocatorTest.assertTrue((locator.getBorderSide() == expectedSide ? 1 : 0) != 0);
            if (expectedSide == 1 || expectedSide == 4) {
                ConnectionHandleLocatorTest.assertTrue((handle1.getLocation().y == handle2.getLocation().y ? 1 : 0) != 0);
                ConnectionHandleLocatorTest.assertTrue((handle1.getLocation().x != handle2.getLocation().x ? 1 : 0) != 0);
            } else {
                ConnectionHandleLocatorTest.assertTrue((handle1.getLocation().y != handle2.getLocation().y ? 1 : 0) != 0);
                ConnectionHandleLocatorTest.assertTrue((handle1.getLocation().x == handle2.getLocation().x ? 1 : 0) != 0);
            }
            ++i;
        }
        Object[][] data2 = new Object[][]{{new Point(30, 0), new Integer(8)}, {new Point(80, 10), new Integer(16)}, {new Point(30, 100), new Integer(8)}, {new Point(80, 70), new Integer(16)}, {new Point(40, 190), new Integer(4)}};
        int i2 = 0;
        while (i2 < data.length) {
            ConnectionHandleLocator locator2 = new ConnectionHandleLocator((IFigure)this.rectangle, (Point)data2[i2][0]);
            locator2.setEastWestSouth(true);
            FakeConnectionHandle handle = new FakeConnectionHandle();
            locator2.addHandle((ConnectionHandle)handle);
            locator2.relocate((IFigure)handle);
            ConnectionHandleLocatorTest.assertTrue((this.rectangle.getBounds().getPosition(handle.getLocation()) == ((Integer)data2[i2][1]).intValue() ? 1 : 0) != 0);
            ConnectionHandleLocatorTest.assertTrue((locator2.getBorderSide() == ((Integer)data2[i2][1]).intValue() ? 1 : 0) != 0);
            ConnectionHandleLocatorTest.assertTrue((boolean)locator2.isEastWestSouth());
            ++i2;
        }
    }

    public void testConnectionHandleLocatorForMemoryLeaks() throws Exception {
        ConnectionHandleLocator objTested = new ConnectionHandleLocator((IFigure)this.rectangle, new Point(10, 10));
        FakeConnectionHandle handle = new FakeConnectionHandle();
        objTested.addHandle((ConnectionHandle)handle);
        objTested.relocate((IFigure)handle);
        ReferenceQueue spy = new ReferenceQueue();
        PhantomReference<ConnectionHandleLocator> refObjTested = new PhantomReference<ConnectionHandleLocator>(objTested, spy);
        objTested = null;
        System.gc();
        if (!refObjTested.isEnqueued()) {
            System.runFinalization();
        }
        ConnectionHandleLocatorTest.assertTrue((boolean)refObjTested.isEnqueued());
        Reference removedRef = spy.remove();
        if (removedRef != null) {
            removedRef.clear();
        }
    }

    private class FakeConnectionHandle
    extends ConnectionHandle {
        public FakeConnectionHandle() {
            super(null, null, null);
            this.setSize(1, 1);
        }
    }
}

