/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.internal.commands;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.core.internal.DiagramPlugin;
import org.eclipse.gmf.runtime.diagram.core.internal.l10n.DiagramCoreMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class PersistViewsCommand
extends AbstractTransactionalCommand {
    private List views;

    public PersistViewsCommand(TransactionalEditingDomain editingDomain, List views) {
        super(editingDomain, DiagramCoreMessages.AddCommand_Label, null);
        this.views = views;
    }

    public PersistViewsCommand(TransactionalEditingDomain editingDomain, List views, Map options) {
        super(editingDomain, DiagramCoreMessages.AddCommand_Label, options, null);
        this.views = views;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        try {
            Iterator it = this.views.iterator();
            while (it.hasNext()) {
                View view = (View)it.next();
                EObject container = view.eContainer();
                if (view instanceof Edge) {
                    Diagram diagram = (Diagram)container;
                    diagram.persistEdges();
                    continue;
                }
                if (!(container instanceof View)) continue;
                ((View)container).persistChildren();
            }
            return CommandResult.newOKCommandResult((Object)this.views);
        }
        catch (Exception e) {
            Log.error((Plugin)DiagramPlugin.getInstance(), (int)4, (String)e.getMessage(), (Throwable)e);
            return CommandResult.newErrorCommandResult((String)e.getMessage());
        }
    }
}

