/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.emf.type.core.EditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;

public class DuplicateElementsRequest
extends AbstractEditCommandRequest {
    private EObject commonContainer;
    private List elementsToDuplicate;
    private Map allDuplicatedElementsMap = new HashMap();
    private EObject duplicate;

    public DuplicateElementsRequest(TransactionalEditingDomain editingDomain) {
        this(editingDomain, null);
    }

    public DuplicateElementsRequest(TransactionalEditingDomain editingDomain, List elementsToDuplicate) {
        super(editingDomain);
        this.elementsToDuplicate = elementsToDuplicate;
    }

    public DuplicateElementsRequest() {
        this(null, null);
    }

    public DuplicateElementsRequest(List elementsToDuplicate) {
        this(null, elementsToDuplicate);
    }

    public Map getAllDuplicatedElementsMap() {
        return this.allDuplicatedElementsMap;
    }

    public List getElementsToBeDuplicated() {
        return this.elementsToDuplicate;
    }

    public EObject getDuplicate() {
        return this.duplicate;
    }

    public void setAllDuplicatedElementsMap(Map duplicatedElementsMap) {
        this.allDuplicatedElementsMap = duplicatedElementsMap;
    }

    public void setElementsToBeDuplicated(List elements) {
        this.elementsToDuplicate = elements;
    }

    public List getElementsToEdit() {
        return this.elementsToDuplicate;
    }

    protected String getDefaultLabel() {
        return EMFTypeCoreMessages.Request_Label_Duplicate;
    }

    public Object getEditHelperContext() {
        IClientContext context;
        if (this.commonContainer == null) {
            this.commonContainer = DuplicateElementsRequest.getLeastCommonContainer(this.getElementsToBeDuplicated());
        }
        if ((context = this.getClientContext()) == null) {
            return this.commonContainer;
        }
        return new EditHelperContext(this.commonContainer, context);
    }

    private static EObject getLeastCommonContainer(Collection objects) {
        EObject commonContainer = null;
        ArrayList prevContainers = new ArrayList();
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            EObject nextElement = (EObject)i.next();
            boolean found = false;
            ArrayList<EObject> containers = new ArrayList<EObject>();
            EObject container = nextElement;
            while (container != null) {
                containers.add(container);
                if (!found) {
                    if (prevContainers.isEmpty() || commonContainer == null) {
                        commonContainer = container;
                        found = true;
                    } else if (prevContainers.contains(container) && DuplicateElementsRequest.contains(container, commonContainer)) {
                        commonContainer = container;
                        found = true;
                    }
                }
                container = container.eContainer();
            }
            if (!found) {
                return null;
            }
            prevContainers = containers;
        }
        return commonContainer;
    }

    private static boolean contains(EObject container, EObject eObject) {
        if (container == eObject) {
            return true;
        }
        if (container == null || eObject == null) {
            return false;
        }
        return DuplicateElementsRequest.contains(container, eObject.eContainer());
    }

    public TransactionalEditingDomain getEditingDomain() {
        EObject eObject;
        TransactionalEditingDomain result = super.getEditingDomain();
        if (result == null && (eObject = (EObject)(this.getElementsToBeDuplicated().size() > 0 ? this.getElementsToBeDuplicated().get(0) : null)) != null) {
            result = TransactionUtil.getEditingDomain((EObject)eObject);
        }
        return result;
    }
}

