/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.codeassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.codeassist.LazyVar;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ExpressionFacade;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalComputer;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalFactory;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ReverseScanner;
import org.eclipse.gmf.internal.xpand.expression.codeassist.TypeProposalComputer;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionProposalComputer
implements ProposalComputer {
    private static final Set<Integer> operators = new HashSet<Integer>();
    private static final Set<Integer> stopper;
    private static final Set<Integer> methodNames;
    private static final Set<Integer> operands;
    private static final Map<Integer, Integer> blockTokens;
    private ExecutionContext executionContext;
    private ProposalFactory proposalFactory;
    private static final Pattern COL_OP;
    private static final Pattern LET;

    static {
        operators.add(37);
        operators.add(48);
        operators.add(29);
        operators.add(40);
        operators.add(42);
        operators.add(44);
        operators.add(43);
        operators.add(45);
        operators.add(23);
        operators.add(47);
        operators.add(41);
        operators.add(14);
        operators.add(38);
        operators.add(46);
        stopper = new HashSet<Integer>();
        stopper.add(2);
        stopper.add(27);
        stopper.add(33);
        stopper.add(50);
        stopper.add(13);
        stopper.add(49);
        methodNames = new HashSet<Integer>();
        methodNames.add(1);
        methodNames.add(7);
        methodNames.add(10);
        methodNames.add(11);
        methodNames.add(12);
        methodNames.add(9);
        methodNames.add(8);
        methodNames.add(6);
        operands = new HashSet<Integer>();
        operands.add(1);
        operands.add(7);
        operands.add(10);
        operands.add(11);
        operands.add(19);
        operands.add(12);
        operands.add(21);
        operands.add(9);
        operands.add(8);
        operands.add(20);
        operands.add(6);
        operands.add(16);
        operands.add(17);
        operands.add(15);
        blockTokens = new HashMap<Integer, Integer>();
        blockTokens.put(2, 22);
        blockTokens.put(13, 28);
        COL_OP = Pattern.compile("((select|collect|exists|notExists|reject|forEach)\\s*\\(\\s*(\\w+)\\s*\\|)|(\\()|(\\))");
        LET = Pattern.compile(".*let\\s*(\\w+)\\s*=\\s*([^:]+):([^:]*)");
    }

    @Override
    public List<ICompletionProposal> computeProposals(String txt, ExecutionContext context, ProposalFactory factory) {
        this.proposalFactory = factory;
        try {
            HashSet issues;
            String[] s = ExpressionProposalComputer.computePrefixAndTargetExpression(txt);
            String prefix = s[0];
            String expressionString = s[1];
            this.executionContext = ExpressionProposalComputer.computeExecutionContext(txt, context);
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            if (prefix.length() > 0 && expressionString == null) {
                proposals.addAll(new TypeProposalComputer().computeProposals(txt, this.executionContext, factory));
            }
            EClassifier targetType = null;
            if (expressionString != null && (targetType = new ExpressionFacade(this.executionContext).analyze(expressionString, issues = new HashSet())) == null) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            if (targetType == null) {
                Variable v2;
                for (Variable v2 : this.executionContext.getVisibleVariables()) {
                    String varName = v2.getName();
                    if (!varName.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                    Object o = this.executionContext.getVariable(varName).getValue();
                    proposals.add(factory.createVariableProposal(varName, (EClassifier)o, prefix));
                }
                v2 = this.executionContext.getVariable("this");
                if (v2 != null) {
                    targetType = (EClassifier)v2.getValue();
                    proposals.addAll(this.getAllMemberProposals(targetType, prefix));
                }
                Set exts = this.executionContext.getAllExtensions();
                for (Extension extension : exts) {
                    if (!extension.getName().toLowerCase().startsWith(prefix.toLowerCase())) continue;
                    proposals.add(factory.createExtensionProposal(extension, prefix));
                }
            } else {
                proposals.addAll(this.getAllMemberProposals(targetType, prefix));
            }
            ArrayList<ICompletionProposal> arrayList = proposals;
            return arrayList;
        }
        finally {
            this.proposalFactory = null;
            this.executionContext = null;
        }
    }

    protected static final ExecutionContext computeExecutionContext(String txt, ExecutionContext ctx) {
        Stack<LazyVar> vars = new Stack<LazyVar>();
        Matcher m = LET.matcher(txt);
        while (m.find()) {
            LazyVar v = new LazyVar();
            v.name = m.group(1);
            v.forEach = false;
            v.expression = m.group(2).trim();
            vars.push(v);
        }
        m = COL_OP.matcher(txt);
        while (m.find()) {
            if (m.group(1) != null) {
                String[] s = ExpressionProposalComputer.computePrefixAndTargetExpression(txt.substring(0, m.start()));
                String expressionString = s[1];
                LazyVar v = new LazyVar();
                v.name = m.group(3);
                v.forEach = true;
                v.expression = expressionString;
                vars.push(v);
                continue;
            }
            if (m.group(4) != null) {
                vars.push(null);
                continue;
            }
            if (m.group(5) != null) {
                vars.pop();
                continue;
            }
            throw new IllegalStateException("Match:" + m.group());
        }
        for (LazyVar v : vars) {
            if (v == null) continue;
            Object targetType = null;
            String expressionString = v.expression;
            if (expressionString == null) {
                EClassifier value;
                Variable var = ctx.getVariable("this");
                if (var != null && var.getValue() instanceof EClassifier && BuiltinMetaModel.isParameterizedType((EClassifier)(value = (EClassifier)var.getValue()))) {
                    targetType = BuiltinMetaModel.getInnerType((EClassifier)value);
                }
            } else {
                targetType = new ExpressionFacade(ctx).analyze(expressionString, new HashSet());
                if (v.forEach) {
                    targetType = BuiltinMetaModel.isParameterizedType((EClassifier)targetType) ? BuiltinMetaModel.getInnerType((EClassifier)targetType) : null;
                }
            }
            if (targetType == null) continue;
            ctx = ctx.cloneWithVariable(new Variable[]{new Variable(v.name, targetType)});
        }
        return ctx;
    }

    private List<ICompletionProposal> getAllMemberProposals(EClassifier targetType, String prefix) {
        if (targetType == null) {
            return Collections.emptyList();
        }
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.addAll(this.internalGetAllMemberProposals(targetType, prefix, false));
        if (BuiltinMetaModel.isParameterizedType((EClassifier)targetType)) {
            result.addAll(ExpressionProposalComputer.getAllCollectionOperations(prefix, this.proposalFactory));
            targetType = BuiltinMetaModel.getInnerType((EClassifier)targetType);
            result.addAll(this.internalGetAllMemberProposals(targetType, prefix, true));
        }
        return result;
    }

    private List<ICompletionProposal> internalGetAllMemberProposals(EClassifier targetType, String prefix, boolean onCollection) {
        LinkedList<ICompletionProposal> result = new LinkedList<ICompletionProposal>();
        String prefixLowerCase = prefix.toLowerCase();
        for (EStructuralFeature f : BuiltinMetaModel.getAllFeatures((EClassifier)targetType)) {
            if (!f.getName().toLowerCase().startsWith(prefixLowerCase)) continue;
            result.add(this.proposalFactory.createPropertyProposal(f, prefix, onCollection));
        }
        for (EOperation op : BuiltinMetaModel.getAllOperation((EClassifier)targetType)) {
            if (!op.getName().toLowerCase().startsWith(prefixLowerCase) || !Character.isJavaIdentifierStart(op.getName().charAt(0))) continue;
            result.add(this.proposalFactory.createOperationProposal(op, prefix, onCollection));
        }
        for (Extension e : this.executionContext.getAllExtensions()) {
            if (!e.getName().toLowerCase().startsWith(prefixLowerCase) || e.getParameterTypes().size() < 1 || !BuiltinMetaModel.isAssignableFrom((EClassifier)((EClassifier)e.getParameterTypes().get(0)), (EClassifier)targetType)) continue;
            result.add(this.proposalFactory.createExtensionOnMemberPositionProposal(e, prefix, onCollection));
        }
        return result;
    }

    private static List<ICompletionProposal> getAllCollectionOperations(String prefix, ProposalFactory f) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        String s = "select(e|expression-with-e)";
        if (s.startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "reject(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "collect(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "exists(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "notExists(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "forAll(e|expression-with-e)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("expression-with-e"), "expression-with-e".length()));
        }
        if ((s = "typeSelect(EClassifier)").startsWith(prefix)) {
            result.add(f.createCollectionSpecificOperationProposal(s, s, prefix, s.indexOf("EClassifier"), "EClassifier".length()));
        }
        return result;
    }

    protected static final String[] computePrefixAndTargetExpression(String str) {
        ReverseScanner scanner = new ReverseScanner(str);
        String prefix = "";
        Object expr = null;
        IToken t = scanner.previousToken();
        if (t != null) {
            if (!Character.isWhitespace(str.charAt(str.length() - 1)) && Character.isJavaIdentifierStart(t.toString().charAt(0))) {
                prefix = t.toString();
                t = scanner.previousToken();
            }
            int exprEnd = scanner.getOffset();
            if (t != null && t.getKind() == 29) {
                boolean lastWasOperator = true;
                boolean stop = false;
                while (!stop && (t = scanner.previousToken()) != null) {
                    if (ExpressionProposalComputer.isOperand(t)) {
                        if (lastWasOperator) {
                            lastWasOperator = false;
                            continue;
                        }
                        scanner.nextToken();
                        stop = true;
                        continue;
                    }
                    if (t.getKind() == 29) {
                        if (!lastWasOperator) {
                            lastWasOperator = true;
                            continue;
                        }
                        return new String[]{prefix, expr};
                    }
                    if (ExpressionProposalComputer.isBlockCloser(t) && lastWasOperator) {
                        IToken temp;
                        lastWasOperator = false;
                        Stack<IToken> s = new Stack<IToken>();
                        s.push(t);
                        while (!s.isEmpty()) {
                            temp = scanner.previousToken();
                            if (temp == null) {
                                return new String[]{prefix, expr};
                            }
                            if (temp.getKind() == t.getKind()) {
                                s.push(temp);
                                continue;
                            }
                            if (!ExpressionProposalComputer.isOpposite(temp, t)) continue;
                            s.pop();
                        }
                        if (t.getKind() != 22 || ExpressionProposalComputer.isMethodName(temp = scanner.previousToken())) continue;
                        scanner.nextToken();
                        continue;
                    }
                    scanner.nextToken();
                    stop = true;
                }
                return new String[]{prefix, str.substring(scanner.getOffset(), exprEnd).trim()};
            }
        }
        return new String[]{prefix, expr};
    }

    private static final boolean isMethodName(IToken temp) {
        return methodNames.contains(temp.getKind());
    }

    private static final boolean isOpposite(IToken left, IToken right) {
        Integer temp = blockTokens.get(left.getKind());
        return temp != null && right.getKind() == temp.intValue();
    }

    private static final boolean isBlockCloser(IToken t) {
        return blockTokens.values().contains(t.getKind());
    }

    private static final boolean isOperand(IToken t) {
        return operands.contains(t.getKind());
    }
}

