/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ClipboardCommand;
import org.eclipse.gmf.runtime.diagram.ui.util.MeasurementUnitHelper;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.util.Assert;

public final class PasteCommand
extends ClipboardCommand {
    private final ICustomData[] data;
    private int offset = 0;
    private IMapMode mm;

    public PasteCommand(TransactionalEditingDomain editingDomain, String label, View viewContext, ICustomData[] data, IMapMode mm) {
        super(editingDomain, label, viewContext);
        Assert.isNotNull((Object)data);
        this.data = data;
        this.offset = mm.DPtoLP(10);
        this.mm = mm;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.data != null && this.data.length > 0) {
            ArrayList allViews = new ArrayList();
            int j = 0;
            while (j < this.data.length) {
                String xml = new String(this.data[j].getData());
                List views = this.pasteFromString(this.getViewContext(), xml);
                allViews.addAll(views);
                ++j;
            }
            return CommandResult.newOKCommandResult(allViews);
        }
        return CommandResult.newOKCommandResult();
    }

    private List pasteFromString(View view, String clipboard) {
        ArrayList retval = new ArrayList();
        Iterator pastedElements = ClipboardUtil.pasteElementsFromString((String)clipboard, (EObject)view, null, null).iterator();
        MeasurementUnit mu = MeasurementUnit.HIMETRIC_LITERAL;
        while (pastedElements.hasNext()) {
            Object element = pastedElements.next();
            if (element instanceof View) {
                retval.add(element);
                continue;
            }
            if (!(element instanceof EAnnotation)) continue;
            EAnnotation measureUnitAnnotation = (EAnnotation)element;
            String unitName = measureUnitAnnotation.getSource();
            mu = MeasurementUnit.get((String)unitName);
            view.getEAnnotations().remove(element);
        }
        Set edges = this.convertNodesConstraint(retval, mu, new Point(this.offset, this.offset));
        this.convertEdgeBendpoints(mu, edges);
        return retval;
    }

    private void convertEdgeBendpoints(MeasurementUnit mu, Set edges) {
        for (Edge nextEdge : edges) {
            Bendpoints bendpoints = nextEdge.getBendpoints();
            if (!(bendpoints instanceof RelativeBendpoints)) continue;
            RelativeBendpoints relBendpoints = (RelativeBendpoints)bendpoints;
            List points = relBendpoints.getPoints();
            ArrayList<RelativeBendpoint> newpoints = new ArrayList<RelativeBendpoint>(points.size());
            ListIterator li = points.listIterator();
            IMapMode viewMapMode = MeasurementUnitHelper.getMapMode(mu);
            while (li.hasNext()) {
                RelativeBendpoint rb = (RelativeBendpoint)li.next();
                Dimension source = new Dimension(rb.getSourceX(), rb.getSourceY());
                Dimension target = new Dimension(rb.getTargetX(), rb.getTargetY());
                if (!viewMapMode.equals(this.mm)) {
                    source = (Dimension)viewMapMode.LPtoDP((Translatable)source);
                    source = (Dimension)this.mm.DPtoLP((Translatable)source);
                    target = (Dimension)viewMapMode.LPtoDP((Translatable)target);
                    target = (Dimension)this.mm.DPtoLP((Translatable)target);
                }
                newpoints.add(new RelativeBendpoint(source.width, source.height, target.width, target.height));
            }
            relBendpoints.setPoints(newpoints);
        }
    }

    private Set convertNodesConstraint(List retval, MeasurementUnit mu, Point ptOffset) {
        HashSet edges = new HashSet();
        for (View nextView : retval) {
            IMapMode viewMapMode;
            if (!(nextView instanceof Node)) continue;
            Node node = (Node)nextView;
            Point loc = new Point(0, 0);
            LayoutConstraint lc = node.getLayoutConstraint();
            if (lc instanceof Location) {
                Location locC = (Location)lc;
                loc = new Point(locC.getX(), locC.getY());
            }
            Dimension size = new Dimension(0, 0);
            if (lc instanceof Size) {
                Size sizeC = (Size)lc;
                size = new Dimension(sizeC.getWidth(), sizeC.getHeight());
            }
            if (!(viewMapMode = MeasurementUnitHelper.getMapMode(mu)).equals(this.mm)) {
                loc = (Point)viewMapMode.LPtoDP((Translatable)loc);
                loc = (Point)this.mm.DPtoLP((Translatable)loc);
                Dimension origSize = new Dimension(size);
                size = (Dimension)viewMapMode.LPtoDP((Translatable)size);
                size = (Dimension)this.mm.DPtoLP((Translatable)size);
                if (origSize.width == -1) {
                    size.width = -1;
                }
                if (origSize.height == -1) {
                    size.height = -1;
                }
            }
            Rectangle constraintRect = new Rectangle(loc, size);
            constraintRect = constraintRect.getTranslated(ptOffset.x, ptOffset.y);
            ViewUtil.setStructuralFeatureValue((View)nextView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)new Integer(constraintRect.x));
            ViewUtil.setStructuralFeatureValue((View)nextView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)new Integer(constraintRect.y));
            ViewUtil.setStructuralFeatureValue((View)nextView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)new Integer(constraintRect.width));
            ViewUtil.setStructuralFeatureValue((View)nextView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)new Integer(constraintRect.height));
            edges.addAll(((Node)nextView).getTargetEdges());
            edges.addAll(((Node)nextView).getSourceEdges());
            edges.addAll(this.convertNodesConstraint((List)node.getPersistedChildren(), mu, new Point(0, 0)));
        }
        return edges;
    }
}

