/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.migrate;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.internal.common.migrate.MigrationDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationDelegateImpl
implements MigrationDelegate {
    private final EStructuralFeature myDeletedAttribute = EcoreFactory.eINSTANCE.createEAttribute();
    private boolean isMigrationApplied;
    private Map<EClassifier, Collection<String>> myDeletedAttributes = new HashMap<EClassifier, Collection<String>>();
    private Map<String, EClass> myNarrowedTypes = new HashMap<String, EClass>();
    private Map<EClass, Map<String, EStructuralFeature>> myRenamedAttributes = new HashMap<EClass, Map<String, EStructuralFeature>>();
    private Map<String, EClassifier> myRenamedTypes = new HashMap<String, EClassifier>();
    private Map<EClass, Map<String, EStructuralFeature>> myTracedHierarchyFeatures = new HashMap<EClass, Map<String, EStructuralFeature>>();
    private Map<EClass, Map<String, EStructuralFeature>> myTracedHierarchyAttributes = new HashMap<EClass, Map<String, EStructuralFeature>>();
    private Resource myResource;

    public MigrationDelegateImpl() {
        this.myDeletedAttribute.setName("attributeIsDeleted");
        this.myDeletedAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        this.isMigrationApplied = false;
    }

    public void registerDeletedAttributes(EClassifier classifier, String ... deletedAttrNames) {
        assert (!this.myDeletedAttributes.containsKey(classifier));
        this.myDeletedAttributes.put(classifier, (Collection<String>)Arrays.asList(deletedAttrNames));
    }

    public void registerRenamedAttributes(EClass eClass, Map<String, EStructuralFeature> renamedAttributes) {
        this.myRenamedAttributes.put(eClass, renamedAttributes);
    }

    public void registerTracedElementForHierarchy(EClass eClass, Map<String, EStructuralFeature> tracedFeature) {
        this.myTracedHierarchyFeatures.put(eClass, tracedFeature);
    }

    public void registerTracedAttributeForHierarchy(EClass eClass, Map<String, EStructuralFeature> tracedFeature) {
        this.myTracedHierarchyAttributes.put(eClass, tracedFeature);
    }

    public void registerNarrowedAbstractType(String abstractTypeName, EClass narrowedType) {
        this.myNarrowedTypes.put(abstractTypeName, narrowedType);
    }

    public void registerRenamedType(String oldTypeName, EClassifier newType) {
        this.myRenamedTypes.put(oldTypeName, newType);
    }

    public void registerRenamedAttribute(EClass eClass, String oldName, EStructuralFeature newStructuralFeature) {
        Map<String, EStructuralFeature> renamedAttributes = this.myRenamedAttributes.get(eClass);
        if (renamedAttributes == null) {
            renamedAttributes = new HashMap<String, EStructuralFeature>();
        }
        renamedAttributes.put(oldName, newStructuralFeature);
        this.registerRenamedAttributes(eClass, renamedAttributes);
    }

    public void registerTracedFeatureForHierarchy(EClass eClass, String xmlName, EStructuralFeature tracerFeature) {
        this.registerTracedElementForHierarchy(eClass, xmlName, tracerFeature);
        this.registerTracedAttributeForHierarchy(eClass, xmlName, tracerFeature);
    }

    public void registerTracedAttributeForHierarchy(EClass eClass, String xmlName, EStructuralFeature tracerFeature) {
        Map<String, EStructuralFeature> tracedFeatures = this.myTracedHierarchyAttributes.get(eClass);
        if (tracedFeatures == null) {
            tracedFeatures = new HashMap<String, EStructuralFeature>();
        }
        tracedFeatures.put(xmlName, tracerFeature);
        this.registerTracedAttributeForHierarchy(eClass, tracedFeatures);
    }

    public void registerTracedElementForHierarchy(EClass eClass, String xmlName, EStructuralFeature tracerFeature) {
        Map<String, EStructuralFeature> tracedFeatures = this.myTracedHierarchyFeatures.get(eClass);
        if (tracedFeatures == null) {
            tracedFeatures = new HashMap<String, EStructuralFeature>();
        }
        tracedFeatures.put(xmlName, tracerFeature);
        this.registerTracedElementForHierarchy(eClass, tracedFeatures);
    }

    public boolean isAttributeDeleted(EClass clazz, String name) {
        Collection<String> deletedAttributes = this.myDeletedAttributes.get(clazz);
        boolean result = deletedAttributes != null && deletedAttributes.contains(name);
        Iterator it = clazz.getEAllSuperTypes().iterator();
        while (!result && it.hasNext()) {
            EClass nextParent = (EClass)it.next();
            result = this.isAttributeDeleted(nextParent, name);
        }
        return result;
    }

    public EClass getNarrowReferenceType(String abstractTypeName) {
        return this.myNarrowedTypes.get(abstractTypeName);
    }

    public EStructuralFeature getRenamedFeatureFor(EClass clazz, String name) {
        Map<String, EStructuralFeature> renamings = this.myRenamedAttributes.get(clazz);
        return renamings != null ? renamings.get(name) : null;
    }

    public EStructuralFeature getTracedParentFeatureFor(EClass clazz, String name) {
        Map<String, EStructuralFeature> tracings = this.myTracedHierarchyFeatures.get(clazz);
        EStructuralFeature result = tracings != null ? tracings.get(name) : null;
        Iterator it = clazz.getEAllSuperTypes().iterator();
        while (result == null && it.hasNext()) {
            EClass nextParent = (EClass)it.next();
            result = this.getTracedParentFeatureFor(nextParent, name);
        }
        return result;
    }

    public EStructuralFeature getTracedParentAttributeFor(EClass clazz, String name) {
        Map<String, EStructuralFeature> tracings = this.myTracedHierarchyAttributes.get(clazz);
        EStructuralFeature result = tracings != null ? tracings.get(name) : null;
        Iterator it = clazz.getEAllSuperTypes().iterator();
        while (result == null && it.hasNext()) {
            EClass nextParent = (EClass)it.next();
            result = this.getTracedParentAttributeFor(nextParent, name);
        }
        return result;
    }

    public EClassifier getRenamedType(String typeName) {
        return this.myRenamedTypes.get(typeName);
    }

    @Override
    public boolean setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        return this.myDeletedAttribute.equals(feature);
    }

    @Override
    public EStructuralFeature getFeature(EClass eClass, String namespaceURI, String name, boolean isElement) {
        EStructuralFeature result = null;
        EStructuralFeature rename = null;
        rename = this.getRenamedFeatureFor(eClass, name);
        if (rename != null) {
            result = rename;
            this.fireMigrationApplied(true);
        } else if (this.isAttributeDeleted(eClass, name)) {
            result = this.myDeletedAttribute;
            this.fireMigrationApplied(true);
        } else if (isElement && (rename = this.getTracedParentFeatureFor(eClass, name)) != null) {
            result = rename;
        } else if (!isElement && (rename = this.getTracedParentAttributeFor(eClass, name)) != null) {
            result = rename;
        }
        return result;
    }

    @Override
    public EClassifier getType(EFactory factory, String typeName) {
        EClassifier renamedType = this.getRenamedType(typeName);
        if (renamedType != null) {
            this.fireMigrationApplied(true);
            return renamedType;
        }
        EClass narrowedType = this.getNarrowReferenceType(typeName);
        if (narrowedType != null) {
            this.fireMigrationApplied(true);
            return narrowedType;
        }
        return null;
    }

    @Override
    public EObject createObject(EFactory factory, EClassifier type) {
        return null;
    }

    @Override
    public void preResolve() {
    }

    @Override
    public void processObject(EObject result) {
    }

    @Override
    public boolean setManyReference(EObject object, EStructuralFeature feature, Object[] values) {
        return false;
    }

    @Override
    public boolean isMigrationApplied() {
        return this.isMigrationApplied;
    }

    protected void fireMigrationApplied(boolean applied) {
        this.isMigrationApplied = applied;
    }

    protected static EReference createNewReference(String name, EClass eType, boolean isContainment) {
        return MigrationDelegateImpl.createNewReference(name, eType, isContainment, 0, -1);
    }

    protected static EReference createNewReference(String name, EClass eType, boolean isContainment, int lowerBound, int upperBound) {
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName(name);
        ref.setEType((EClassifier)eType);
        ref.setContainment(isContainment);
        ref.setLowerBound(lowerBound);
        ref.setUpperBound(upperBound);
        return ref;
    }

    protected static EAttribute createNewAttribute(String name, EDataType eType, boolean isMany) {
        return MigrationDelegateImpl.createNewAttribute(name, eType, isMany, false);
    }

    protected static EAttribute createNewAttribute(String name, EDataType eType, boolean isMany, boolean isObligatory) {
        EAttribute attr = EcoreFactory.eINSTANCE.createEAttribute();
        attr.setName(name);
        attr.setEType((EClassifier)eType);
        attr.setLowerBound(isObligatory ? 1 : 0);
        attr.setUpperBound(isMany ? -1 : 1);
        return attr;
    }

    @Override
    public void setResource(Resource resource) {
        this.myResource = resource;
    }

    protected Resource getResource() {
        return this.myResource;
    }

    @Override
    public void postLoad() {
    }
}

