/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.lite;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.GIFEmitter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.codegen.templates.expressions.AbstractExpressionGenerator;
import org.eclipse.gmf.codegen.templates.expressions.OCLExpressionFactoryGenerator;
import org.eclipse.gmf.codegen.templates.expressions.RegexpExpressionFactoryGenerator;
import org.eclipse.gmf.codegen.templates.lite.providers.MetricProviderGenerator;
import org.eclipse.gmf.codegen.templates.lite.providers.ValidationProviderGenerator;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.codegen.dispatch.CachingEmitterFactory;
import org.eclipse.gmf.internal.codegen.dispatch.EmitterFactory;
import org.eclipse.gmf.internal.codegen.dispatch.EmitterFactoryImpl;
import org.eclipse.gmf.internal.codegen.dispatch.NoSuchTemplateException;
import org.eclipse.gmf.internal.codegen.dispatch.StaticTemplateRegistry;
import org.eclipse.gmf.internal.codegen.dispatch.TemplateRegistry;
import org.eclipse.gmf.internal.codegen.lite.Activator;
import org.eclipse.gmf.internal.common.codegen.BinaryEmitter;
import org.eclipse.gmf.internal.common.codegen.DefaultTextMerger;
import org.eclipse.gmf.internal.common.codegen.JETEmitterAdapter;
import org.eclipse.gmf.internal.common.codegen.JETGIFEmitterAdapter;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.common.codegen.TextMerger;
import org.eclipse.gmf.internal.common.codegen.XpandTextEmitter;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.util.BundleResourceManager;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodegenEmitters {
    private static final String CODEGEN_PLUGIN_ID = "org.eclipse.gmf.codegen";
    private final EmitterFactory myFactory;
    private final String[] myTemplatePath;
    private static StaticTemplateRegistry myRegistry;
    private ResourceManager myResourceManager;
    private HashMap<String, TextEmitter> myCachedXpandEmitters = new HashMap();

    public CodegenEmitters(boolean usePrecompiled, String templateDirectory) {
        myRegistry = CodegenEmitters.initRegistry();
        String[] variables = new String[]{"org.eclipse.emf.codegen", "org.eclipse.emf.codegen.ecore", "org.eclipse.emf.common", "org.eclipse.emf.ecore", "org.eclipse.gmf.common", CODEGEN_PLUGIN_ID};
        URL liteTemplatesPath = CodegenEmitters.getTemplatesBundle().getEntry("/templates/");
        URL runtimeTemplatesPath = Platform.getBundle((String)CODEGEN_PLUGIN_ID).getEntry("/templates/");
        this.myTemplatePath = new String[]{usePrecompiled ? null : (templateDirectory != null && templateDirectory.indexOf(":") == -1 ? URI.createPlatformResourceURI((String)templateDirectory, (boolean)true).toString() : templateDirectory), liteTemplatesPath.toString(), runtimeTemplatesPath.toString()};
        this.myFactory = new CachingEmitterFactory((EmitterFactory)new EmitterFactoryImpl(this.getTemplatePath(), (TemplateRegistry)myRegistry, usePrecompiled, variables));
        this.myResourceManager = new BundleResourceManager(new URL[]{liteTemplatesPath, runtimeTemplatesPath});
    }

    public TextMerger createMergeService() {
        URL controlFile = this.getJMergeControlFile();
        if (controlFile != null) {
            JControlModel controlModel = new JControlModel();
            controlModel.initialize(CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS), controlFile.toString());
            if (!controlModel.canMerge()) {
                throw new IllegalStateException("Can not initialize JControlModel");
            }
            return new DefaultTextMerger(controlModel);
        }
        return null;
    }

    private static StaticTemplateRegistry initRegistry() {
        StaticTemplateRegistry tr = new StaticTemplateRegistry(CodegenEmitters.class.getClassLoader());
        CodegenEmitters.put(tr, "/providers/ValidationProvider.javajet", ValidationProviderGenerator.class);
        CodegenEmitters.put(tr, "/providers/MetricProvider.javajet", MetricProviderGenerator.class);
        CodegenEmitters.put(tr, "/expressions/AbstractExpression.javajet", AbstractExpressionGenerator.class);
        CodegenEmitters.put(tr, "/expressions/OCLExpressionFactory.javajet", OCLExpressionFactoryGenerator.class);
        CodegenEmitters.put(tr, "/expressions/RegexpExpressionFactory.javajet", RegexpExpressionFactoryGenerator.class);
        return tr;
    }

    public TextEmitter getCreateNodeCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateNodeCommand::CreateNodeCommand");
    }

    public TextEmitter getAddNodeCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::AddNodeCommand::AddNodeCommand");
    }

    public TextEmitter getCloneNodeCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CloneNodeCommand::CloneNodeCommand");
    }

    public TextEmitter getCreateLinkStartCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateLinkStartCommand::CreateLinkStartCommand");
    }

    public TextEmitter getCreateLinkCompleteCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::CreateLinkCompleteCommand::CreateLinkCompleteCommand");
    }

    public TextEmitter getReconnectLinkSourceCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::ReconnectLinkSourceCommand::ReconnectLinkSourceCommand");
    }

    public TextEmitter getReconnectLinkTargetCommandEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::commands::ReconnectLinkTargetCommand::ReconnectLinkTargetCommand");
    }

    public TextEmitter getViewFactoryGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::viewfactories::ViewFactory::ViewFactory");
    }

    public TextEmitter getComponentEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::ComponentEditPolicy::ComponentEditPolicy");
    }

    public TextEmitter getLayoutEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::LayoutEditPolicy::LayoutEditPolicy");
    }

    public TextEmitter getGraphicalEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::GraphicalNodeEditPolicy::GraphicalNodeEditPolicy");
    }

    public TextEmitter getValidationProviderGenerator() throws UnexpectedBehaviourException {
        return this.retrieve(ValidationProviderGenerator.class);
    }

    public TextEmitter getMetricProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieve(MetricProviderGenerator.class);
    }

    public TextEmitter getDomainElementInitializerGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::DomainElementInitializer::DomainElementInitializer");
    }

    public TextEmitter getDomainElementInitializerQualifiedNameGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::DomainElementInitializer::qualifiedClassName");
    }

    public TextEmitter getCompartmentEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::CompartmentEditPart::CompartmentEditPart");
    }

    public TextEmitter getDiagramEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::DiagramEditPart::DiagramEditPart");
    }

    public TextEmitter getEditPartFactoryGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::EditPartFactory::EditPartFactory");
    }

    public TextEmitter getLinkEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::LinkEditPart::LinkEditPart");
    }

    public TextEmitter getLinkLabelEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::LinkLabelEditPart::LinkLabelEditPart");
    }

    public TextEmitter getChildNodeEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::ChildNodeEditPart::ChildNodeEditPart");
    }

    public TextEmitter getNodeEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::NodeEditPart::NodeEditPart");
    }

    public TextEmitter getNodeLabelEditPartGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::parts::NodeLabelEditPart::NodeLabelEditPart");
    }

    public TextEmitter getPluginGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::Plugin::Plugin");
    }

    public TextEmitter getActionBarContributorGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::ActionBarContributor::ActionBarContributor");
    }

    public TextEmitter getOpenDiagramInViewActionGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::OpenDiagramInViewAction::OpenDiagramInViewAction");
    }

    public TextEmitter getEditorGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::Editor::Editor");
    }

    public TextEmitter getMatchingStrategyEmitter() {
        return this.retrieveXpand("xpt::editor::MatchingStrategy::MatchingStrategy");
    }

    public TextEmitter getCreationWizardGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::CreationWizard::CreationWizard");
    }

    public TextEmitter getCreationWizardPageGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::CreationWizardPage::CreationWizardPage");
    }

    public TextEmitter getDiagramEditorUtilGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::DiagramEditorUtil::DiagramEditorUtil");
    }

    public TextEmitter getPaletteFactoryGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::palette::PaletteFactory::Factory");
    }

    public TextEmitter getVisualIDRegistryGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::VisualIDRegistry::VisualIDRegistry");
    }

    public TextEmitter getManifestGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::manifest::manifest");
    }

    public TextEmitter getBuildPropertiesGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::buildProperties::buildProperties");
    }

    public TextEmitter getPluginXML() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::plugin::plugin");
    }

    public TextEmitter getInitDiagramFileActionGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::InitDiagramFileAction::InitDiagramFileAction");
    }

    public TextEmitter getNewDiagramFileWizardGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::NewDiagramFileWizard::NewDiagramFileWizard");
    }

    public TextEmitter getLoadResourceActionGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::LoadResourceAction::LoadResourceAction");
    }

    public TextEmitter getElementTypesGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::ElementTypes::ElementTypes");
    }

    public TextEmitter getPluginPropertiesGenerator() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::properties::properties");
    }

    public TextEmitter getAbstractExpressionEmitter() throws UnexpectedBehaviourException {
        return this.retrieve(AbstractExpressionGenerator.class);
    }

    public TextEmitter getOCLExpressionFactoryEmitter() throws UnexpectedBehaviourException {
        return this.retrieve(OCLExpressionFactoryGenerator.class);
    }

    public TextEmitter getRegexpExpressionFactoryEmitter() throws UnexpectedBehaviourException {
        return this.retrieve(RegexpExpressionFactoryGenerator.class);
    }

    public TextEmitter getOpenDiagramEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::diagram::policies::OpenDiagramEditPolicy::OpenDiagramEditPolicy");
    }

    public BinaryEmitter getDiagramIconEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitterAdapter("/xpt/editor/diagram.gif");
    }

    public BinaryEmitter getWizardBannerImageEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitterAdapter("/xpt/editor/wizban.gif");
    }

    public TextEmitter getWizardBannerStemEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::CreationWizard::wizardBannerStem");
    }

    public TextEmitter getWizardBannerLocationEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::editor::CreationWizard::wizardBannerLocation");
    }

    private static void put(StaticTemplateRegistry tr, String path, Class<?> precompiledTemplate) {
        tr.put(precompiledTemplate, path, precompiledTemplate);
    }

    private TextEmitter retrieve(Class<?> key) throws UnexpectedBehaviourException {
        try {
            return new JETEmitterAdapter(this.myFactory.acquireEmitter(key));
        }
        catch (NoSuchTemplateException ex) {
            throw new UnexpectedBehaviourException(ex.getMessage(), (Throwable)ex);
        }
    }

    private BinaryEmitter newGIFEmitter(String relativePath) throws UnexpectedBehaviourException {
        return new org.eclipse.gmf.internal.common.codegen.GIFEmitter(this.checkTemplateLocation(relativePath));
    }

    private BinaryEmitter newGIFEmitterAdapter(String relativePath) throws UnexpectedBehaviourException {
        return new JETGIFEmitterAdapter(new GIFEmitter(this.checkTemplateLocation(relativePath)));
    }

    private String checkTemplateLocation(String relativePath) throws UnexpectedBehaviourException {
        String templateLocation = JETCompiler.find((String[])this.getTemplatePath(), (String)relativePath);
        if (templateLocation == null) {
            throw new UnexpectedBehaviourException("Template " + relativePath + " not found");
        }
        return templateLocation;
    }

    private String[] getTemplatePath() {
        return this.myTemplatePath;
    }

    private static Bundle getTemplatesBundle() {
        return Activator.getDefault();
    }

    public URL getJMergeControlFile() {
        return CodegenEmitters.getTemplatesBundle().getEntry("/templates/emf-merge.xml");
    }

    public BinaryEmitter getShortcutImageEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitter("/xpt/editor/shortcut.gif");
    }

    public TextEmitter getNavigatorContentProviderEmitter() {
        return this.retrieveXpand("xpt::navigator::NavigatorContentProvider::NavigatorContentProvider");
    }

    public TextEmitter getDomainNavigatorContentProviderEmitter() {
        return this.retrieveXpand("xpt::navigator::DomainNavigatorContentProvider::DomainNavigatorContentProvider");
    }

    public TextEmitter getDomainNavigatorLabelProviderEmitter() {
        return this.retrieveXpand("xpt::navigator::DomainNavigatorLabelProvider::DomainNavigatorLabelProvider");
    }

    public TextEmitter getDomainNavigatorItemEmitter() {
        return this.retrieveXpand("xpt::navigator::DomainNavigatorItem::DomainNavigatorItem");
    }

    public TextEmitter getDomainModelElementTesterEmitter() {
        return this.retrieveXpand("xpt::editor::DomainModelElementTester::DomainModelElementTester");
    }

    public TextEmitter getURIEditorInputTesterEmitter() {
        return this.retrieveXpand("xpt::editor::UriEditorInputTester::UriEditorInputTester");
    }

    public TextEmitter getNavigatorLabelProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::navigator::NavigatorLabelProvider::NavigatorLabelProvider");
    }

    public TextEmitter getNavigatorLinkHelperEmitter() {
        return this.retrieveXpand("xpt::navigator::NavigatorLinkHelper::NavigatorLinkHelper");
    }

    public TextEmitter getNavigatorSorterEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::navigator::NavigatorSorter::NavigatorSorter");
    }

    public TextEmitter getNavigatorActionProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::navigator::NavigatorActionProvider::NavigatorActionProvider");
    }

    public TextEmitter getAbstractNavigatorItemEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::navigator::AbstractNavigatorItem::AbstractNavigatorItem");
    }

    public TextEmitter getNavigatorGroupEmitter() {
        return this.retrieveXpand("xpt::navigator::NavigatorGroup::NavigatorGroup");
    }

    public TextEmitter getNavigatorItemEmitter() {
        return this.retrieveXpand("xpt::navigator::NavigatorItem::NavigatorItem");
    }

    public BinaryEmitter getGroupIconEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitter("/xpt/navigator/navigatorGroup.gif");
    }

    public TextEmitter getPropertySheetLabelProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::propsheet::SheetLabelProvider::SheetLabelProvider");
    }

    public TextEmitter getPropertySectionEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::propsheet::PropertySection::PropertySection");
    }

    public TextEmitter getApplicationEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::application::Application::Application");
    }

    public TextEmitter getActionBarAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::application::ActionBarAdvisor::ActionBarAdvisor");
    }

    public TextEmitter getPerspectiveEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::application::Perspective::Perspective");
    }

    public TextEmitter getWorkbenchAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::application::WorkbenchAdvisor::WorkbenchAdvisor");
    }

    public TextEmitter getWorkbenchWindowAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::application::WorkbenchWindowAdvisor::WorkbenchWindowAdvisor");
    }

    public TextEmitter getMarkerNavigationProviderEmitter() throws UnexpectedBehaviourException {
        return this.retrieveXpand("xpt::providers::MarkerNavigationProvider::MarkerNavigationProvider");
    }

    public TextEmitter getExternalizeEmitter() {
        return this.retrieveXpand("xpt::Externalizer::Access");
    }

    public TextEmitter getMessagesEmitter() {
        return this.retrieveXpand("xpt::Externalizer::Values");
    }

    private TextEmitter retrieveXpand(String templateFQN) {
        TextEmitter result = this.myCachedXpandEmitters.get(templateFQN);
        if (result == null) {
            result = new XpandTextEmitter(this.myResourceManager, templateFQN, this.getClass().getClassLoader());
            this.myCachedXpandEmitters.put(templateFQN, result);
        }
        return result;
    }
}

