/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.gmf.internal.bridge.naming.ClassNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.DefaultNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.DesignNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.NamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediatorImpl;
import org.eclipse.gmf.internal.common.IncrementalNamesDispenser;
import org.eclipse.gmf.tests.tr.AbstractMappingTransformerTest;
import org.eclipse.jdt.core.JavaConventions;

public class NamingStrategyTest
extends AbstractMappingTransformerTest {
    private static final boolean STRICT_CHECK = true;

    public NamingStrategyTest(String name) {
        super(name);
    }

    public void testUniqueValueDispenser() {
        IncrementalNamesDispenser d = new IncrementalNamesDispenser();
        String semanticPart = "Rocket";
        String suffixPart = "Node";
        String name1 = d.get(semanticPart, suffixPart);
        String name2 = d.get(semanticPart, suffixPart);
        NamingStrategyTest.assertFalse((String)"Names are not unique", (boolean)name1.equals(name2));
    }

    public void testDefaultEPNamingStrategy() {
        this.doTest(new GenModelNamingMediatorImpl().getEditPart());
    }

    public void testPrefixNameStrategy() {
        DefaultNamingStrategy pns = new DefaultNamingStrategy(null, null, null, null);
        pns = new DesignNamingStrategy(null, null, (NamingStrategy)pns, null);
        pns = new ClassNamingStrategy(null, null, (NamingStrategy)pns, null);
        this.doTest((NamingStrategy)pns);
    }

    private void doTest(NamingStrategy strategy) {
        String diagramEPName = strategy.get(this.getCanvasMapping());
        String nodeEPName = strategy.get(this.getNodeMapping());
        String linkEPName = strategy.get(this.getLinkMapping());
        this.assertStatus("Invalid Java class name '" + diagramEPName + " for diagram", JavaConventions.validateJavaTypeName((String)diagramEPName, (String)"1.4", (String)"1.4"));
        this.assertStatus("Invalid Java class name '" + nodeEPName + " for node", JavaConventions.validateJavaTypeName((String)nodeEPName, (String)"1.4", (String)"1.4"));
        this.assertStatus("Invalid Java class name '" + linkEPName + " for link", JavaConventions.validateJavaTypeName((String)linkEPName, (String)"1.4", (String)"1.4"));
    }

    private void assertStatus(String message, IStatus status) {
        NamingStrategyTest.assertTrue((String)message, (boolean)status.isOK());
    }
}

