/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Employee;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.EmployeeType;

public class CreateElementRequestTest
extends AbstractEMFTypeTest {
    private CreateElementRequest fixture;
    private Department department;
    private Department department2;
    private Employee employee;

    public CreateElementRequestTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)CreateElementRequestTest.suite());
    }

    public static Test suite() {
        return new TestSuite(CreateElementRequestTest.class);
    }

    protected void doModelSetup(Resource resource) {
        this.department = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department.setName("Department");
        resource.getContents().add((Object)this.department);
        this.department2 = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department2.setName("Department2");
        resource.getContents().add((Object)this.department2);
        this.employee = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        resource.getContents().add((Object)this.employee);
    }

    protected CreateElementRequest getFixture() {
        return this.fixture;
    }

    protected void setFixture(CreateElementRequest fixture) {
        this.fixture = fixture;
    }

    public void test_getEditHelperContext_eObject() {
        this.setFixture(new CreateElementRequest(this.getEditingDomain(), (EObject)this.department, (IElementType)EmployeeType.EMPLOYEE));
        Object editHelperContext = this.getFixture().getEditHelperContext();
        CreateElementRequestTest.assertEquals((Object)this.department, (Object)editHelperContext);
    }

    public void test_getEditHelperContext_elementType() {
        this.setFixture(new CreateElementRequest(this.getEditingDomain(), (EObject)this.department, (IElementType)EmployeeType.TOP_SECRET));
        Object editHelperContext = this.getFixture().getEditHelperContext();
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(editHelperContext);
        CreateElementRequestTest.assertEquals((Object)EmployeeType.SECRET_DEPARTMENT, (Object)elementType);
        ICommand command = elementType.getEditCommand((IEditCommandRequest)this.getFixture());
        CreateElementRequestTest.assertNotNull((Object)command);
        CreateElementRequestTest.assertTrue((boolean)command.canExecute());
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            CreateElementRequestTest.fail((String)e.getLocalizedMessage());
        }
        CommandResult result = command.getCommandResult();
        CreateElementRequestTest.assertEquals((int)0, (int)result.getStatus().getCode());
        Employee topSecretEmployee = null;
        topSecretEmployee = (Employee)result.getReturnValue();
        CreateElementRequestTest.assertNotNull((Object)topSecretEmployee);
        CreateElementRequestTest.assertTrue((boolean)topSecretEmployee.isSecurityClearance());
    }

    public void test_invalidateEditHelperContext() {
        CreateElementRequest request = new CreateElementRequest(this.getEditingDomain(), (EObject)this.department, (IElementType)EmployeeType.EMPLOYEE);
        this.setFixture(request);
        Object departmentContext = this.getFixture().getEditHelperContext();
        CreateElementRequestTest.assertEquals((Object)this.department, (Object)departmentContext);
        request.setContainer((EObject)this.employee);
        Object employeeContext = this.getFixture().getEditHelperContext();
        CreateElementRequestTest.assertNotSame((Object)departmentContext, (Object)employeeContext);
    }

    public void test_getEditingDomain_noContainer_131766() {
        CreateElementRequest request = new CreateElementRequest((IElementType)EmployeeType.DEPARTMENT);
        TransactionalEditingDomain domain = request.getEditingDomain();
        CreateElementRequestTest.assertNull((Object)domain);
    }

    public void test_noNewRequestWhenSetContainer_132253() {
        final GetEditContextRequest[] contextRequestArray = new GetEditContextRequest[1];
        ElementTypeRegistry.getInstance().register((ISpecializationType)new SpecializationType("132253", null, "132253", new IElementType[]{EmployeeType.MANAGER}, null, null, (IEditHelperAdvice)new AbstractEditHelperAdvice(){

            protected ICommand getBeforeEditContextCommand(GetEditContextRequest request) {
                contextRequestArray[0] = request;
                return null;
            }
        }));
        CreateElementRequest request = new CreateElementRequest((EObject)this.department, (IElementType)EmployeeType.MANAGER);
        request.getEditHelperContext();
        GetEditContextRequest contextRequest1 = contextRequestArray[0];
        contextRequestArray[0] = null;
        request.setContainer((EObject)this.department2);
        request.getEditHelperContext();
        GetEditContextRequest contextRequest2 = contextRequestArray[0];
        contextRequestArray[0] = null;
        CreateElementRequestTest.assertSame((Object)contextRequest1, (Object)contextRequest2);
    }

    public void test_singleGetEditContextRequest_129582() {
        final GetEditContextRequest[] contextRequestArray = new GetEditContextRequest[1];
        ElementTypeRegistry.getInstance().register((ISpecializationType)new SpecializationType("132253", null, "132253", new IElementType[]{EmployeeType.MANAGER}, null, null, (IEditHelperAdvice)new AbstractEditHelperAdvice(){

            protected ICommand getBeforeEditContextCommand(GetEditContextRequest request) {
                contextRequestArray[0] = request;
                CreateElementRequest createRequest = (CreateElementRequest)request.getEditCommandRequest();
                createRequest.setContainmentFeature(CreateElementRequestTest.this.getEmployeePackage().getDepartment_Manager());
                return null;
            }
        }));
        CreateElementRequest request = new CreateElementRequest((EObject)this.department, (IElementType)EmployeeType.MANAGER);
        request.getEditHelperContext();
        GetEditContextRequest contextRequest1 = contextRequestArray[0];
        contextRequestArray[0] = null;
        request.setContainer((EObject)this.department2);
        request.getEditHelperContext();
        GetEditContextRequest contextRequest2 = contextRequestArray[0];
        contextRequestArray[0] = null;
        CreateElementRequestTest.assertSame((Object)contextRequest1, (Object)contextRequest2);
    }
}

