/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Employee;

public class MoveRequestTest
extends AbstractEMFTypeTest {
    private MoveRequest fixture;
    private Department department1;
    private Department department2;
    private Employee employee1;
    private Employee employee2;
    private Employee manager;

    public MoveRequestTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MoveRequestTest.suite());
    }

    public static Test suite() {
        return new TestSuite(MoveRequestTest.class);
    }

    protected void doModelSetup(Resource resource) {
        this.department1 = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department1.setName("Department1");
        resource.getContents().add((Object)this.department1);
        this.department2 = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department2.setName("Department2");
        resource.getContents().add((Object)this.department2);
        this.employee1 = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.department1.getMembers().add((Object)this.employee1);
        this.employee2 = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.department1.getMembers().add((Object)this.employee2);
        this.manager = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.department1.setManager(this.manager);
    }

    protected MoveRequest getFixture() {
        return this.fixture;
    }

    protected void setFixture(MoveRequest fixture) {
        this.fixture = fixture;
    }

    public void test_move_singleElement_noFeature() {
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee1.eContainmentFeature());
        this.setFixture(new MoveRequest(this.getEditingDomain(), (EObject)this.department2, (EObject)this.employee1));
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(this.getFixture().getEditHelperContext());
        ICommand command = elementType.getEditCommand((IEditCommandRequest)this.getFixture());
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            MoveRequestTest.fail((String)e.getLocalizedMessage());
        }
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee1.eContainmentFeature());
    }

    public void test_move_singleElement_differentFeatureInSameContainer() {
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee1.eContainmentFeature());
        this.setFixture(new MoveRequest(this.getEditingDomain(), (EObject)this.department1, this.getEmployeePackage().getDepartment_Manager(), (EObject)this.employee1));
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(this.getFixture().getEditHelperContext());
        ICommand command = elementType.getEditCommand((IEditCommandRequest)this.getFixture());
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            MoveRequestTest.fail((String)e.getLocalizedMessage());
        }
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Manager(), (Object)this.employee1.eContainmentFeature());
    }

    public void test_move_singleElement_featureInNewContainer() {
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee1.eContainmentFeature());
        this.setFixture(new MoveRequest(this.getEditingDomain(), (EObject)this.department2, this.getEmployeePackage().getDepartment_Manager(), (EObject)this.employee1));
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(this.getFixture().getEditHelperContext());
        ICommand command = elementType.getEditCommand((IEditCommandRequest)this.getFixture());
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            MoveRequestTest.fail((String)e.getLocalizedMessage());
        }
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Manager(), (Object)this.employee1.eContainmentFeature());
    }

    public void test_move_manyElements_noFeatures() {
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.employee2.eContainer());
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.manager.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee1.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee2.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Manager(), (Object)this.manager.eContainmentFeature());
        ArrayList<Employee> elementsToMove = new ArrayList<Employee>();
        elementsToMove.add(this.employee1);
        elementsToMove.add(this.employee2);
        elementsToMove.add(this.manager);
        this.setFixture(new MoveRequest(this.getEditingDomain(), (EObject)this.department2, elementsToMove));
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(this.getFixture().getEditHelperContext());
        ICommand command = elementType.getEditCommand((IEditCommandRequest)this.getFixture());
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            MoveRequestTest.fail((String)e.getLocalizedMessage());
        }
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.employee2.eContainer());
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.manager.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee1.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee2.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Manager(), (Object)this.manager.eContainmentFeature());
    }

    public void test_move_manyElements_someFeatures() {
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.employee2.eContainer());
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.manager.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee1.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee2.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Manager(), (Object)this.manager.eContainmentFeature());
        HashMap<Employee, EReference> elementsToMove = new HashMap<Employee, EReference>();
        elementsToMove.put(this.employee1, this.getEmployeePackage().getDepartment_Manager());
        elementsToMove.put(this.employee2, null);
        elementsToMove.put(this.manager, this.getEmployeePackage().getDepartment_Members());
        this.setFixture(new MoveRequest(this.getEditingDomain(), (EObject)this.department2, elementsToMove));
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(this.getFixture().getEditHelperContext());
        ICommand command = elementType.getEditCommand((IEditCommandRequest)this.getFixture());
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            MoveRequestTest.fail((String)e.getLocalizedMessage());
        }
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.employee2.eContainer());
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.manager.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Manager(), (Object)this.employee1.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee2.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.manager.eContainmentFeature());
    }

    public void test_move_manyElements_featuresInNewContainer() {
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.employee2.eContainer());
        MoveRequestTest.assertSame((Object)this.department1, (Object)this.manager.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee1.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee2.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Manager(), (Object)this.manager.eContainmentFeature());
        HashMap<Employee, EReference> elementsToMove = new HashMap<Employee, EReference>();
        elementsToMove.put(this.employee1, this.getEmployeePackage().getDepartment_Manager());
        elementsToMove.put(this.employee2, this.getEmployeePackage().getDepartment_Members());
        elementsToMove.put(this.manager, this.getEmployeePackage().getDepartment_Members());
        this.setFixture(new MoveRequest(this.getEditingDomain(), (EObject)this.department2, elementsToMove));
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(this.getFixture().getEditHelperContext());
        ICommand command = elementType.getEditCommand((IEditCommandRequest)this.getFixture());
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            MoveRequestTest.fail((String)e.getLocalizedMessage());
        }
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.employee1.eContainer());
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.employee2.eContainer());
        MoveRequestTest.assertSame((Object)this.department2, (Object)this.manager.eContainer());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Manager(), (Object)this.employee1.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.employee2.eContainmentFeature());
        MoveRequestTest.assertSame((Object)this.getEmployeePackage().getDepartment_Members(), (Object)this.manager.eContainmentFeature());
    }
}

