/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.type.core.ClientContext;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.MultiClientContext;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Employee;

public class MultiClientContextTest
extends AbstractEMFTypeTest {
    private MultiClientContext multiContext;
    private IClientContext childContext1;
    private IClientContext childContext2;
    private IClientContext clientContext1;
    private IClientContext clientContext2;
    private IClientContext unboundClientContext;
    private Department department;
    private Employee employee_101;
    private Employee employee_102;

    public MultiClientContextTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MultiClientContextTest.suite());
    }

    public static Test suite() {
        return new TestSuite(MultiClientContextTest.class, "MultiClientContext Test Suit");
    }

    protected void doModelSetupWithContext(Resource resource) {
        this.department = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department.setName("MultiClientContextDepartment");
        resource.getContents().add((Object)this.department);
        this.employee_101 = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.employee_101.setNumber(101);
        this.department.getMembers().add((Object)this.employee_101);
        this.employee_102 = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.employee_102.setNumber(102);
        this.department.getMembers().add((Object)this.employee_102);
        this.childContext1 = new ClientContext("childContext1", new IElementMatcher(){

            public boolean matches(EObject eObject) {
                EObject container = eObject.eContainer();
                return container instanceof Department && ((Department)container).getName().equals("MultiClientContextDepartment");
            }
        });
        this.childContext2 = new ClientContext("childContext2", new IElementMatcher(){

            public boolean matches(EObject eObject) {
                return eObject instanceof Employee && ((Employee)eObject).getNumber() == 101;
            }
        });
        this.multiContext = new MultiClientContext((Collection)Collections.singletonList(this.childContext1));
    }

    protected IClientContext getClientContext1() {
        if (this.clientContext1 == null) {
            this.clientContext1 = ClientContextManager.getInstance().getClientContext("org.eclipse.gmf.tests.runtime.emf.type.core.ClientContext1");
        }
        return this.clientContext1;
    }

    protected IClientContext getClientContext2() {
        if (this.clientContext2 == null) {
            this.clientContext2 = ClientContextManager.getInstance().getClientContext("org.eclipse.gmf.tests.runtime.emf.type.core.ClientContext2");
        }
        return this.clientContext2;
    }

    protected IClientContext getUnboundClientContext() {
        if (this.unboundClientContext == null) {
            this.unboundClientContext = ClientContextManager.getInstance().getClientContext("org.eclipse.gmf.tests.runtime.emf.type.core.UnboundClientContext");
        }
        return this.unboundClientContext;
    }

    public void test_bindId() {
        String typeID = "org.eclipse.gmf.tests.runtime.emf.type.example1.employee";
        IElementType type = ElementTypeRegistry.getInstance().getType(typeID);
        MultiClientContextTest.assertFalse((boolean)this.multiContext.includes(type));
        this.multiContext.bindId(typeID);
        MultiClientContextTest.assertTrue((boolean)this.multiContext.includes(type));
    }

    public void test_bindPattern() {
        String typeID = "org.eclipse.gmf.tests.runtime.emf.type.example2.employee";
        IElementType type = ElementTypeRegistry.getInstance().getType(typeID);
        MultiClientContextTest.assertFalse((boolean)this.multiContext.includes(type));
        Pattern pattern = Pattern.compile("org.eclipse.gmf.tests.runtime.emf.type.example2.*");
        this.multiContext.bindPattern(pattern);
        MultiClientContextTest.assertTrue((boolean)this.multiContext.includes(type));
    }

    public void test_getMatcher() {
        MultiClientContextTest.assertTrue((boolean)this.multiContext.getMatcher().matches((EObject)this.employee_101));
        MultiClientContextTest.assertTrue((boolean)this.multiContext.getMatcher().matches((EObject)this.employee_102));
        Collection children = this.multiContext.getChildren();
        MultiClientContextTest.assertEquals((int)1, (int)children.size());
        this.multiContext.add(this.childContext2);
        children = this.multiContext.getChildren();
        MultiClientContextTest.assertEquals((int)2, (int)children.size());
        MultiClientContextTest.assertTrue((boolean)children.contains(this.childContext1));
        MultiClientContextTest.assertTrue((boolean)children.contains(this.childContext2));
        MultiClientContextTest.assertTrue((boolean)this.multiContext.getMatcher().matches((EObject)this.employee_101));
        MultiClientContextTest.assertFalse((boolean)this.multiContext.getMatcher().matches((EObject)this.employee_102));
    }
}

