/*******************************************************************************
* Copyright (c) 2006 Eclipse.org
* 
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/
package org.eclipse.gmf.internal.xpand.parser;

public class XpandParserprs implements lpg.lpgjavaruntime.ParseTable, XpandParsersym {

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static short baseCheck[] = {0,
            1,6,1,4,1,1,3,1,5,10,
            1,0,5,1,3,1,3,1,3,1,
            3,1,1,1,1,1,1,1,3,1,
            1,1,3,1,1,1,2,2,2,3,
            1,2,1,1,1,1,1,1,1,1,
            3,4,3,1,1,3,2,2,1,1,
            1,1,1,4,6,4,1,1,1,1,
            1,1,0,1,2,4,1,3,1,1,
            4,1,1,1,3,1,1,3,1,0,
            3,5,4,4,0,1,0,1,0,2,
            0,2,4,0,2,4,6,9,11,9,
            2,2,0,1,2,6,9,2,0,3,
            1,1,1,1,1,1,3,0,3,0,
            1,1,1,1,2,3,5,6,0,3,
            1,1,5,0,1,8,0,2,0,2,
            6,0,4,0,2,6,10,0,1,-52,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-66,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-2,0,0,0,
            0,0,0,0,0,-8,0,0,0,-93,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-67,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-4,0,0,0,
            0,0,0,0,0,-17,0,0,0,-73,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-153,0,0,-103,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-13,0,0,-152,0,-130,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-50,
            0,0,0,0,-135,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-72,0,0,0,0,-68,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-82,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-83,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-84,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-85,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-86,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-98,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-101,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-110,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-118,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-145,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-148,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-149,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-154,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-156,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-171,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-174,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-133,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-160,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-111,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-94,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-144,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-95,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-170,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -179,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-180,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-109,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-96,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-97,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-108,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-107,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-125,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-106,0,
            0,0,0,0,0,0,0,-33,0,0,
            0,0,0,-36,0,0,0,0,0,-59,
            0,0,0,0,0,-34,0,0,0,0,
            0,-37,0,0,0,0,0,-56,0,0,
            0,0,0,0,-31,-1,-65,-32,-75,0,
            -29,0,-30,0,-6,0,-58,0,0,0,
            0,0,-89,0,0,0,0,0,-102,0,
            0,0,0,0,-122,0,0,0,0,0,
            -11,0,0,0,0,0,0,-9,-14,0,
            -43,-15,0,-45,-81,0,0,-90,0,-16,
            -92,0,-76,-116,-18,-12,-120,0,-74,-136,
            0,0,-143,0,-19,-155,-7,0,0,0,
            0,0,0,0,0,0,-165,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-166,0,
            0,-172,0,-25,-181,-26,0,0,0,0,
            -113,0,0,-35,-88,0,-61,-3,-5,-141,
            -114,-10,-21,-22,-23,-28,-131,-138,0,0,
            0,0,0,0,0,0,0,-161,0,-159,
            0,-162,-173,0,0,0,0,0,0,0,
            0,0,-178,0,0,0,0,0,0,-183,
            -20,-24,-27,-38,-39,-40,-41,-42,0,-44,
            0,-46,-47,-48,-49,0,-51,-53,0,-54,
            0,-55,-57,-60,-62,-63,-64,-69,0,0,
            -70,-71,-77,-78,-79,-80,-87,0,-91,-99,
            0,0,-100,0,-104,-105,-112,-115,-117,-119,
            -121,-123,-124,-126,-127,-128,-129,-132,-134,-137,
            -139,-140,-142,-146,0,-147,-150,-151,-157,-158,
            -163,-164,-167,-168,-169,-175,-176,-177,-182,-184,
            0
        };
    };
    public final static short baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            62,28,29,29,27,27,25,25,26,26,
            24,24,41,41,23,23,21,21,22,22,
            20,20,63,63,63,63,63,63,19,19,
            64,64,17,17,65,65,18,18,18,42,
            42,9,9,10,10,10,10,10,10,10,
            10,10,6,6,6,6,15,15,16,11,
            11,14,12,13,7,7,7,8,8,8,
            8,8,8,74,74,36,36,34,34,3,
            3,4,5,5,5,2,2,1,1,62,
            66,66,62,37,37,45,45,75,75,33,
            33,43,43,46,44,44,47,39,39,39,
            39,35,35,40,40,40,38,38,32,48,
            48,49,49,49,49,49,49,31,56,56,
            30,30,50,50,50,57,58,58,58,68,
            68,67,59,51,69,69,52,70,70,60,
            60,53,61,61,71,71,54,55,72,72,
            1,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,142,1,
            263,86,80,54,79,1498,50,55,1518,38,
            1389,44,45,46,47,48,49,33,118,1447,
            121,122,123,124,125,126,343,132,133,134,
            1,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,142,1,
            263,86,80,54,79,1498,50,55,1518,37,
            1389,44,45,46,47,48,49,159,120,1447,
            121,122,123,124,125,126,31,132,133,134,
            34,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1536,1,
            1335,1492,470,1397,1535,77,86,80,54,79,
            1498,50,55,1518,36,1389,44,45,46,47,
            48,49,1327,1329,1383,1517,1516,1523,11,1515,
            5,1525,3,1536,1,29,86,1395,471,1547,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1536,1,
            29,86,1514,1562,78,105,86,80,54,79,
            1498,50,55,1518,36,1389,44,45,46,47,
            48,49,1327,1329,1383,1517,1516,1523,11,1515,
            5,1525,3,1536,1,29,86,58,1472,1557,
            105,86,80,1533,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1530,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,135,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1451,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1538,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1384,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1539,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1530,1,
            133,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1544,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1548,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1552,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1560,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1468,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,137,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1429,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1564,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,150,1,
            105,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,3,1483,1,
            187,86,80,54,79,1498,50,55,1518,36,
            1389,44,45,46,47,48,49,1327,1329,1383,
            1517,1516,1523,11,1515,5,1525,1556,187,86,
            80,54,79,1498,50,55,1518,36,1389,44,
            45,46,47,48,49,1327,1329,1383,1517,1516,
            1523,11,1515,5,1525,2,161,86,80,54,
            79,1498,50,55,1518,36,1389,44,45,46,
            47,48,49,1327,1329,1383,1517,1516,1523,11,
            1515,7,1525,161,86,80,54,79,1498,50,
            55,1518,36,1389,44,45,46,47,48,49,
            1327,1329,1383,1517,1516,1523,11,1543,161,86,
            80,54,79,1498,50,55,1518,36,1389,44,
            45,46,47,48,49,1327,1329,1383,1517,1516,
            1523,11,9,213,86,80,54,79,1498,50,
            55,1518,36,1389,44,45,46,47,48,49,
            1327,1329,1383,1517,1516,1523,15,213,86,80,
            54,79,1498,50,55,1518,36,1389,44,45,
            46,47,48,49,1327,1329,1383,1517,1516,1523,
            1567,213,86,80,54,79,1498,50,55,1518,
            36,1389,44,45,46,47,48,49,1327,1329,
            1383,1517,1516,1523,1569,213,86,80,54,79,
            1498,50,55,1518,36,1389,44,45,46,47,
            48,49,1327,1329,1383,1517,1516,1523,1490,213,
            86,80,54,79,1498,50,55,1518,36,1389,
            44,45,46,47,48,49,1327,1329,1383,1517,
            17,1523,213,86,80,54,79,1498,50,55,
            1518,36,1389,44,45,46,47,48,49,1327,
            1329,1383,19,213,86,80,54,79,1498,50,
            55,1518,36,1389,44,45,46,47,48,49,
            1327,1329,29,213,86,80,54,79,1498,50,
            55,1518,36,1389,44,45,46,47,48,49,
            1327,1329,21,213,86,80,54,79,1498,50,
            55,1518,36,1389,44,45,46,47,48,49,
            33,1329,263,86,80,54,79,1498,50,55,
            1518,4,1389,44,45,46,47,48,49,288,
            86,80,54,79,1498,1457,55,1518,313,86,
            80,1497,79,1498,319,86,80,1497,79,1498,
            319,86,80,1497,79,1498,319,86,80,1371,
            79,1498,319,86,80,1374,79,1498,319,86,
            80,1378,79,1498,1496,315,281,290,315,330,
            1500,369,88,369,85,62,76,319,86,80,
            1381,79,1498,319,86,80,1387,79,1498,319,
            86,80,1546,79,1498,319,86,80,1393,79,
            1498,270,96,1380,1372,96,1380,1372,139,349,
            94,382,360,93,382,29,86,141,382,1361,
            365,382,1386,256,382,71,62,382,207,398,
            382,1203,89,382,1243,368,382,159,92,1380,
            1372,1508,160,1507,1508,160,1512,382,1508,160,
            1541,1508,160,1542,1508,160,1458,1508,160,1553,
            1508,160,1558,1508,160,1559,1508,160,1563,382,
            105,42,382,1386,328,382,328,1508,160,155,
            102,423,1441,1397,328,348,1223,382,340,346,
            354,426,346,346,346,346,346,443,455,1508,
            160,1473,1508,160,1568,1508,160,1570,476,114,
            475,114,476,455,112,1540,111,1508,220,114,
            1540,267,1368,488,115,100,103,1325,1328,106,
            475,103,269,337,345,374,338,375,7,40,
            379,127,167,377,381,387,129,390,391,1549,
            392,1565,393,394,19,395,396,397,294,312,
            1390,399,67,402,403,404,410,341,138,408,
            413,13,1432,416,153,412,414,415,424,428,
            431,429,433,437,435,325,436,440,448,205,
            452,456,458,459,461,1435,463,468,469,472,
            473,480,482,483,484,485,486,487,489,490,
            491,1573,1573
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,4,5,0,7,8,9,
            10,11,12,13,14,15,16,17,0,19,
            20,21,22,23,24,25,0,27,0,1,
            0,1,0,0,1,2,3,4,5,39,
            7,8,9,10,11,12,13,14,15,16,
            17,45,19,20,21,22,23,24,25,29,
            27,0,62,63,46,32,0,67,2,69,
            0,1,40,73,8,75,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,28,19,20,21,22,23,
            24,25,0,27,0,1,2,3,4,5,
            8,7,8,9,10,11,12,13,14,15,
            16,17,61,19,20,21,22,23,24,25,
            28,27,0,1,2,3,4,5,0,7,
            8,9,10,11,12,13,14,15,16,17,
            0,19,20,21,22,23,24,25,0,27,
            0,1,2,3,4,5,0,7,8,9,
            10,11,12,13,14,15,16,17,40,19,
            20,21,22,23,24,25,0,1,2,3,
            4,5,26,7,8,9,10,11,12,13,
            14,15,16,17,0,19,20,21,22,23,
            24,25,0,1,2,3,4,5,60,7,
            8,9,10,11,12,13,14,15,16,17,
            26,19,20,21,22,23,24,0,1,2,
            3,4,5,39,7,8,9,10,11,12,
            13,14,15,16,17,0,19,20,21,22,
            23,24,0,1,2,3,4,5,0,0,
            2,9,10,11,12,13,14,15,16,17,
            0,19,20,21,22,23,24,0,1,0,
            3,4,5,0,26,2,7,10,11,12,
            13,14,15,16,35,36,51,52,53,54,
            55,56,0,1,0,3,4,5,0,1,
            0,3,4,5,0,0,2,0,1,0,
            0,1,8,3,4,5,0,0,2,0,
            0,29,0,6,0,0,57,0,0,35,
            36,9,28,0,7,28,29,18,29,0,
            7,81,26,18,0,18,18,0,0,1,
            33,18,28,0,0,1,0,18,0,6,
            0,0,18,59,6,18,0,58,7,0,
            0,0,0,0,0,0,0,0,0,6,
            2,0,0,0,2,29,26,0,18,0,
            1,0,0,0,0,0,76,26,6,33,
            31,6,0,0,2,0,1,0,0,37,
            0,34,0,26,0,0,0,41,44,0,
            6,6,0,32,49,6,33,0,18,48,
            47,0,1,6,0,0,1,0,0,31,
            0,38,0,31,50,38,30,0,0,0,
            0,0,0,6,0,0,34,17,6,0,
            1,0,0,0,0,0,0,0,0,0,
            0,0,30,0,0,37,0,0,0,0,
            0,0,31,0,0,0,0,0,0,18,
            0,0,0,0,0,30,30,43,0,0,
            0,32,0,0,70,0,42,0,0,0,
            0,0,0,0,77,65,68,0,0,64,
            71,0,0,0,0,0,0,0,0,0,
            0,0,0,72,66,0,74,0,0,0,
            0,78,0,0,0,0,79,0,0,0,
            80,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            119,1522,420,1655,1656,1657,1573,190,250,1616,
            1521,1640,1641,1642,1643,1644,1645,280,1573,1635,
            1636,415,1632,1633,1634,1524,1573,1526,1573,1491,
            1573,1434,1573,1573,1522,420,1655,1656,1657,510,
            190,250,1616,1521,1640,1641,1642,1643,1644,1645,
            280,380,1635,1636,415,1632,1633,1634,1524,1436,
            1526,104,450,1375,1654,1630,87,480,315,540,
            1573,1493,1572,570,1333,1527,1573,1522,420,1655,
            1656,1657,1626,190,250,1616,1521,1640,1641,1642,
            1643,1644,1645,280,1331,1635,1636,415,1632,1633,
            1634,1524,87,1526,1573,1522,420,1655,1656,1657,
            1333,190,250,1616,1521,1640,1641,1642,1643,1644,
            1645,280,345,1635,1636,415,1632,1633,1634,1524,
            1331,1526,1573,1545,420,1655,1656,1657,100,190,
            250,1616,1521,1640,1641,1642,1643,1644,1645,280,
            1573,1635,1636,415,1632,1633,1634,1524,101,1526,
            1573,1522,600,1655,1656,1657,1573,190,250,1616,
            1521,1640,1641,1642,1643,1644,1645,280,91,1635,
            1636,415,1632,1633,1634,1524,1573,1522,420,1655,
            1656,1657,1318,190,250,1616,1521,1640,1641,1642,
            1643,1644,1645,280,136,1635,1636,415,1632,1633,
            1634,1524,1573,1522,600,1655,1656,1657,216,190,
            250,1616,1521,1640,1641,1642,1643,1644,1645,280,
            780,1635,1636,415,1632,1633,1634,28,1604,1604,
            1604,1604,1604,750,1604,1604,1604,1604,1604,1604,
            1604,1604,1604,1604,1604,20,1604,1604,1604,1604,
            1604,1604,1573,1522,600,1655,1656,1657,1573,1573,
            1288,1616,1521,1640,1641,1642,1643,1644,1645,280,
            90,1635,1636,415,1632,1633,1634,1573,1522,28,
            1655,1656,1657,1573,1306,630,1970,1521,1640,1641,
            1642,1643,1644,1645,276,1385,1595,1596,1597,1598,
            1599,1600,1573,1491,95,1655,1656,1657,1573,1491,
            1573,1655,1656,1657,87,1573,315,113,1434,32,
            75,1300,1333,1300,1300,1300,1573,1573,1294,99,
            1573,1495,1573,1504,87,99,1603,128,1573,276,
            1385,1369,1331,128,2224,1444,1436,1449,1607,1573,
            2224,1448,1312,1452,1573,130,1453,1573,1573,1494,
            1503,130,1331,1573,1573,1505,1573,1454,1573,1502,
            1573,130,1455,720,1510,1456,75,1608,1704,1573,
            1573,1573,1573,1573,8,14,18,41,1573,1529,
            1349,16,1573,6,660,1513,1337,1573,1445,1573,
            1537,1573,1573,77,1573,54,690,1343,1624,2063,
            1680,1262,139,1573,385,144,1718,1573,1573,1689,
            1573,1279,1573,1355,1573,1573,1573,1182,1013,1573,
            1639,1637,39,1629,1063,1625,350,1573,1450,1159,
            986,1573,348,1554,152,1573,1396,1573,1573,1683,
            1573,1550,1573,1681,930,1551,1038,1573,1573,154,
            147,1573,1573,1713,12,149,1279,1470,1638,1573,
            1721,1573,1573,1573,1573,1573,1573,158,1573,1573,
            1573,128,958,1573,1573,1690,1573,1573,1573,1573,
            1573,1573,1682,1573,1573,1573,1573,1573,1573,1704,
            1573,1573,1573,1573,1573,1111,1135,1087,1573,1573,
            1573,1583,1573,1573,810,1573,1566,1573,1573,1573,
            1573,1573,1573,1573,840,1561,1716,1573,1573,870,
            1407,1573,1573,1573,1573,1573,1573,1573,1573,1573,
            1573,1573,1573,1724,1719,1573,1729,1573,1573,1573,
            1573,900,1573,1573,1573,1573,1732,1573,1573,1573,
            1730
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            66,143,123,131,129,132,131,1,130,129,
            133,132,121,186,186,186,63,121,186,152,
            123,140,140,72,69,69,72,124,121,121,
            141,141,60,118,69,118,118,153,233,232,
            121,188,185,233,185,79,227,79,232,121,
            190,82,186,79,192,118,233,118,118,194,
            185,173,170,168,161,102,102,98,261,261,
            196,121,3,158,159,162,169,261,174,121,
            121,98,98,98,98,98,229,81,118,185,
            79,185,82,99,100,100,100,98,233,211,
            98,118,29,27,231,111,100,100,100,98,
            99,235,75,136,237,185,237,98,186,185,
            190,118,190,239,102,233,241,233,233,98,
            158,233,99,76,98,185,121,145,121,263,
            81,192,185,99,98,53,239,98,98,233,
            265,55,146,98,185,98,190,233,149,99,
            56,56,121,147,185,185,267,269,150,100,
            98,185,145,98,239,239,271,184,100,100,
            185,27,149,273
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static byte asr[] = {0,
            9,0,2,8,7,9,1,3,4,5,
            10,11,12,13,14,15,16,21,17,24,
            20,19,22,23,25,27,32,0,2,8,
            7,9,1,3,4,5,10,11,12,13,
            14,15,16,21,24,20,19,22,23,25,
            27,6,17,0,65,7,18,64,0,3,
            4,5,29,1,0,40,81,0,29,1,
            28,26,2,0,2,7,18,39,26,0,
            18,31,37,66,68,70,71,72,74,80,
            75,73,69,39,67,62,63,27,25,8,
            7,9,2,21,17,24,20,19,22,23,
            10,11,12,13,14,15,16,3,4,5,
            1,0,60,61,35,36,18,0,18,40,
            60,61,36,35,0,7,18,1,0,18,
            36,35,40,0,70,71,72,0,43,42,
            0,8,2,46,26,39,28,34,29,58,
            57,51,52,53,54,55,56,41,48,42,
            43,49,44,1,30,6,32,33,64,38,
            77,78,47,79,7,18,0,45,0,31,
            0,37,0,46,0,1,42,43,30,32,
            33,64,38,77,78,79,18,2,8,28,
            41,44,47,48,49,51,52,53,54,55,
            56,57,7,58,34,6,29,0,76,0,
            32,33,6,0,50,0,38,0,30,0,
            41,44,6,47,48,49,51,52,53,54,
            55,56,57,7,29,58,34,59,8,28,
            2,0,77,0,68,0,74,0,78,0,
            66,0,80,0
        };
    };
    public final static byte asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static byte nasb[] = {0,
            32,5,62,6,62,40,6,5,5,62,
            42,40,12,5,5,5,8,5,5,5,
            62,62,62,5,55,55,5,62,38,38,
            28,28,24,17,55,24,17,5,5,5,
            5,5,46,5,46,5,5,5,5,12,
            5,1,5,5,5,17,5,17,24,5,
            46,5,5,5,34,2,2,16,5,5,
            5,12,2,53,36,51,5,5,5,5,
            49,2,2,2,2,2,5,59,17,46,
            5,46,1,2,2,2,2,2,5,5,
            2,17,2,5,5,20,2,2,2,2,
            2,5,57,64,5,46,5,2,5,46,
            5,17,5,5,2,5,5,5,5,2,
            53,5,2,5,2,46,5,66,5,5,
            59,5,46,2,2,5,5,2,2,5,
            5,14,10,2,46,2,5,5,70,2,
            68,68,5,5,46,46,5,5,5,2,
            2,46,66,2,5,5,5,72,2,2,
            46,5,70,5
        };
    };
    public final static byte nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            48,5,8,10,0,46,0,35,0,71,
            0,2,0,70,0,8,5,3,0,5,
            8,6,0,5,3,36,0,38,39,45,
            0,62,0,64,0,65,0,1,0,47,
            0,38,39,37,0,30,31,0,67,0,
            63,0,42,0,40,0,68,0,30,56,
            0,33,0,69,0,61,0,60,0,41,
            0,72,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static byte terminalIndex[] = {0,
            30,4,43,44,45,5,22,11,31,46,
            47,48,49,50,51,52,6,82,32,33,
            37,38,39,40,35,61,34,2,23,3,
            56,7,26,25,55,57,58,63,65,81,
            36,41,42,1,8,9,10,12,13,14,
            15,16,17,18,19,20,21,24,27,53,
            54,59,60,62,64,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            28,83
        };
    };
    public final static byte terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static byte nonterminalIndex[] = {0,
            109,105,86,0,108,102,0,106,87,103,
            0,0,0,0,0,0,97,99,95,94,
            92,93,91,90,88,89,85,84,0,0,
            117,116,0,104,115,107,110,111,112,0,
            0,101,0,0,0,113,114,0,118,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,96,98,100,0,119,0,0,0,
            0,0,0,0,0
        };
    };
    public final static byte nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            1,87,29,97,13,21,57,39,128,51,
            68,121,109,63,72,75,80,46
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            11,66,37,104,19,27,55,44,133,55,
            55,125,113,66,55,78,83,48
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            55,24,52,24,54,53,7,51,29,7,
            6,26,24,15,10,42,41,48
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static byte scopeLa[] = {
            80,32,66,42,74,72,6,68,30,6,
            6,30,6,32,6,34,30,7
        };
    };
    public final static byte scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static byte scopeStateSet[] = {
            46,20,46,20,46,46,7,46,25,7,
            7,22,20,8,8,4,1,46
        };
    };
    public final static byte scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            114,154,110,78,110,77,110,76,75,0,
            80,0,114,1,38,110,73,0,74,0,
            153,143,114,110,69,0,72,0,114,142,
            152,1,38,110,39,0,66,0,114,151,
            110,67,0,68,0,131,0,117,0,0,
            110,2,90,0,5,0,110,59,1,2,
            90,0,116,17,0,7,0,116,2,1,
            0,110,2,0,88,34,0,101,0,105,
            43,0,3,91,0,0,105,30,42,123,
            17,6,110,2,25,0,123,17,6,110,
            2,25,0,41,3,91,7,0,110,2,
            25,0,5,6,0,41,3,91,7,0,
            106,44,106,0,3,90,0,109,50,1,
            27,0,3,85,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            1490,1470,0,1457,1389,0,1279,1135,1111,1087,
            1262,1159,1223,1243,1203,1182,1063,250,190,1038,
            1013,958,930,986,900,870,840,810,780,750,
            720,385,350,690,660,315,630,600,570,540,
            510,480,450,280,420,220,160,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,144,81,115,18,125,128,60,115,18,
            126,129,61,9,121,120,35,36,84,1,
            18,18,18,117,1,29,1,18,28,8,
            115,115,2,26,28,2,26,1,29,118,
            85,87,85,118,85,6,33,6,1,45,
            114,113,112,6,114,26,29,26,33,84,
            131,106,103,102,99,7,8,2,90,10,
            1,21,17,92,100,101,104,25,108,27,
            63,62,67,39,69,73,75,18,26,85,
            6,85,113,44,49,41,146,2,110,85,
            2,2,2,116,110,34,147,145,48,2,
            47,1,149,110,110,110,110,76,112,85,
            114,26,114,106,6,110,1,85,116,33,
            88,110,50,150,2,151,38,114,38,110,
            18,114,85,30,59,6,109,39,26,116,
            114,1,143,70,1,77,114,110,17,30,
            110,152,65,153,71,110,114,110,123,43,
            64,142,114,78,42,105,114,110,30,30,
            154,105,105,114
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "",
            "?",
            "::",
            ":",
            "(",
            ")",
            "{",
            "}",
            "[",
            "]",
            "->",
            "!",
            "&&",
            "||",
            "=",
            "==",
            "!=",
            ">=",
            "<=",
            ">",
            "<",
            "+",
            "-",
            "*",
            "/",
            ".",
            ",",
            "|",
            "\\u00AB",
            "$empty",
            "IDENT",
            "STRING",
            "INT_CONST",
            "REAL_CONST",
            "let",
            "switch",
            "implies",
            "new",
            "false",
            "true",
            "null",
            "default",
            "case",
            "Collection",
            "List",
            "Set",
            "typeSelect",
            "collect",
            "select",
            "reject",
            "exists",
            "notExists",
            "forAll",
            "IMPORT",
            "EXTENSION",
            "AROUND",
            "ENDAROUND",
            "DEFINE",
            "ENDDEFINE",
            "ERROR",
            "EXPAND",
            "FOR",
            "SEPARATOR",
            "AS",
            "ITERATOR",
            "FOREACH",
            "ENDFOREACH",
            "FILE",
            "ENDFILE",
            "IF",
            "ELSEIF",
            "ELSE",
            "ENDIF",
            "LET",
            "ENDLET",
            "PROTECT",
            "CSTART",
            "CEND",
            "ID",
            "DISABLE",
            "ENDPROTECT",
            "EOF_TOKEN",
            "TEXT",
            "ERROR_TOKEN",
            "expression",
            "castedExpression",
            "type",
            "infixExpression",
            "chainExpression",
            "ifExpression",
            "switchExpression",
            "orExpression",
            "andExpression",
            "impliesExpression",
            "relationalExpression",
            "additiveExpression",
            "relationalOperator",
            "multiplicativeExpression",
            "additiveOperator",
            "unaryExpression",
            "multiplicativeOperator",
            "infixExpressionSuffix",
            "featureCall",
            "primaryExpression",
            "parameterList",
            "simpleType",
            "collectionExpressionName",
            "declaredParameterList",
            "collectionTypeName",
            "qualifiedType",
            "defineOrAroundSeq",
            "define",
            "around",
            "anImport",
            "anExtensionImport",
            "pointcut",
            "sequence",
            "text",
            "statement",
            "definitionName"
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final static int
           ERROR_SYMBOL      = 82,
           SCOPE_UBOUND      = 17,
           SCOPE_SIZE        = 18,
           MAX_NAME_LENGTH   = 24;

    public final int getErrorSymbol() { return ERROR_SYMBOL; }
    public final int getScopeUbound() { return SCOPE_UBOUND; }
    public final int getScopeSize() { return SCOPE_SIZE; }
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int
           NUM_STATES        = 184,
           NT_OFFSET         = 82,
           LA_STATE_OFFSET   = 1732,
           MAX_LA            = 2,
           NUM_RULES         = 159,
           NUM_NONTERMINALS  = 75,
           NUM_SYMBOLS       = 157,
           SEGMENT_SIZE      = 8192,
           START_STATE       = 1326,
           IDENTIFIER_SYMBOL = 0,
           EOFT_SYMBOL       = 40,
           EOLT_SYMBOL       = 40,
           ACCEPT_ACTION     = 1572,
           ERROR_ACTION      = 1573;

    public final static boolean BACKTRACK = false;

    public final int getNumStates() { return NUM_STATES; }
    public final int getNtOffset() { return NT_OFFSET; }
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }
    public final int getMaxLa() { return MAX_LA; }
    public final int getNumRules() { return NUM_RULES; }
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }
    public final int getNumSymbols() { return NUM_SYMBOLS; }
    public final int getSegmentSize() { return SEGMENT_SIZE; }
    public final int getStartState() { return START_STATE; }
    public final int getStartSymbol() { return lhs[0]; }
    public final int getIdentifierSymbol() { return IDENTIFIER_SYMBOL; }
    public final int getEoftSymbol() { return EOFT_SYMBOL; }
    public final int getEoltSymbol() { return EOLT_SYMBOL; }
    public final int getAcceptAction() { return ACCEPT_ACTION; }
    public final int getErrorAction() { return ERROR_ACTION; }
    public final boolean isValidForParser() { return isValidForParser; }
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
