/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.services;

import java.lang.reflect.Constructor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class TreeDirectEditManager {
    private EditPartListener editPartListener;
    private ControlListener controlListener;
    private ICellEditorListener cellEditorListener;
    private boolean showingFeedback;
    private boolean dirty;
    private DirectEditRequest request;
    private CellEditorLocator locator;
    private EditPart source;
    private CellEditor ce;
    private Class editorType;
    private boolean committing = false;
    private Object feature;
    private Listener scrollListener;

    public TreeDirectEditManager(EditPart source, Class editorType, CellEditorLocator locator) {
        this.source = source;
        this.locator = locator;
        this.editorType = editorType;
    }

    public TreeDirectEditManager(EditPart source, Class editorType, CellEditorLocator locator, Object feature) {
        this(source, editorType, locator);
        this.feature = feature;
    }

    protected void bringDown() {
        this.eraseFeedback();
        this.unhookListeners();
        if (this.getCellEditor() != null) {
            this.getCellEditor().deactivate();
            this.getCellEditor().dispose();
            this.setCellEditor(null);
        }
        this.request = null;
        this.dirty = false;
    }

    protected void commit() {
        if (this.committing) {
            return;
        }
        this.committing = true;
        try {
            this.eraseFeedback();
            if (this.isDirty()) {
                CommandStack stack = this.getEditPart().getViewer().getEditDomain().getCommandStack();
                stack.execute(this.getEditPart().getCommand((Request)this.getDirectEditRequest()));
            }
        }
        finally {
            this.bringDown();
            this.committing = false;
        }
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        try {
            Constructor constructor = this.editorType.getConstructor(Composite.class);
            return (CellEditor)constructor.newInstance(composite);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected DirectEditRequest createDirectEditRequest() {
        DirectEditRequest req = new DirectEditRequest();
        req.setCellEditor(this.getCellEditor());
        req.setDirectEditFeature(this.getDirectEditFeature());
        return req;
    }

    protected void eraseFeedback() {
        if (this.showingFeedback) {
            this.getEditPart().eraseSourceFeedback((Request)this.getDirectEditRequest());
            this.showingFeedback = false;
        }
    }

    protected CellEditor getCellEditor() {
        return this.ce;
    }

    private Control getControl() {
        return this.ce.getControl();
    }

    protected Object getDirectEditFeature() {
        return this.feature;
    }

    protected DirectEditRequest getDirectEditRequest() {
        if (this.request == null) {
            this.request = this.createDirectEditRequest();
        }
        return this.request;
    }

    protected EditPart getEditPart() {
        return this.source;
    }

    private CellEditorLocator getLocator() {
        return this.locator;
    }

    private void handleValueChanged() {
        this.setDirty(true);
        this.showFeedback();
        this.placeCellEditor();
    }

    private void hookListeners() {
        Composite control = (Composite)this.getEditPart().getViewer().getControl();
        this.controlListener = new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        TreeDirectEditManager.this.placeCellEditor();
                    }
                });
            }

            public void controlResized(ControlEvent e) {
                TreeDirectEditManager.this.placeCellEditor();
            }
        };
        control.addControlListener(this.controlListener);
        this.scrollListener = new Listener(){

            public void handleEvent(Event e) {
                TreeDirectEditManager.this.placeCellEditor();
            }
        };
        if (control.getHorizontalBar() != null) {
            control.getHorizontalBar().addListener(13, this.scrollListener);
        }
        if (control.getVerticalBar() != null) {
            control.getVerticalBar().addListener(13, this.scrollListener);
        }
        this.cellEditorListener = new ICellEditorListener(){

            public void applyEditorValue() {
                TreeDirectEditManager.this.commit();
            }

            public void cancelEditor() {
                TreeDirectEditManager.this.bringDown();
            }

            public void editorValueChanged(boolean old, boolean newState) {
                TreeDirectEditManager.this.handleValueChanged();
            }
        };
        this.getCellEditor().addListener(this.cellEditorListener);
        this.editPartListener = new EditPartListener.Stub(){

            public void partDeactivated(EditPart editpart) {
                TreeDirectEditManager.this.bringDown();
            }
        };
        this.getEditPart().addEditPartListener(this.editPartListener);
    }

    protected abstract void initCellEditor();

    protected boolean isDirty() {
        return this.dirty;
    }

    private void placeCellEditor() {
        this.getLocator().relocate(this.getCellEditor());
    }

    protected void setCellEditor(CellEditor editor) {
        this.ce = editor;
        if (this.ce == null) {
            return;
        }
        this.hookListeners();
    }

    protected void setDirty(boolean value) {
        this.dirty = value;
    }

    protected void setEditPart(EditPart source) {
        this.source = source;
    }

    public void setLocator(CellEditorLocator locator) {
        this.locator = locator;
    }

    public void show() {
        if (this.getCellEditor() != null) {
            return;
        }
        Composite composite = (Composite)this.source.getViewer().getControl();
        this.setCellEditor(this.createCellEditorOn(composite));
        if (this.getCellEditor() == null) {
            return;
        }
        this.initCellEditor();
        this.getCellEditor().activate();
        this.placeCellEditor();
        this.getControl().setVisible(true);
        this.getCellEditor().setFocus();
        this.showFeedback();
    }

    public void showFeedback() {
        this.showingFeedback = true;
        this.getEditPart().showSourceFeedback((Request)this.getDirectEditRequest());
    }

    protected void unhookListeners() {
        this.getEditPart().removeEditPartListener(this.editPartListener);
        this.editPartListener = null;
        if (this.getCellEditor() == null) {
            return;
        }
        this.getCellEditor().removeListener(this.cellEditorListener);
        this.cellEditorListener = null;
        Composite control = (Composite)this.getEditPart().getViewer().getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.removeControlListener(this.controlListener);
        this.controlListener = null;
        if (control.getHorizontalBar() != null) {
            control.getHorizontalBar().removeListener(13, this.scrollListener);
        }
        if (control.getVerticalBar() != null) {
            control.getVerticalBar().removeListener(13, this.scrollListener);
        }
    }
}

