/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;

public class CreateElementCommand
extends EditElementCommand {
    private EObject newElement;
    private final IElementType elementType;
    private EReference containmentFeature;

    public CreateElementCommand(CreateElementRequest request) {
        super(request.getLabel(), null, request);
        this.elementType = request.getElementType();
        this.containmentFeature = request.getContainmentFeature();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.newElement = this.doDefaultElementCreation();
        ConfigureRequest configureRequest = this.createConfigureRequest();
        ICommand configureCommand = this.elementType.getEditCommand(configureRequest);
        IStatus configureStatus = null;
        if (configureCommand != null && configureCommand.canExecute()) {
            configureStatus = configureCommand.execute(monitor, info);
        }
        this.getCreateRequest().setNewElement(this.newElement);
        return configureStatus == null ? CommandResult.newOKCommandResult((Object)this.newElement) : new CommandResult(configureStatus, (Object)this.newElement);
    }

    protected ConfigureRequest createConfigureRequest() {
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), this.newElement, this.getElementType());
        configureRequest.setClientContext(this.getCreateRequest().getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        return configureRequest;
    }

    protected EObject doDefaultElementCreation() {
        EObject element;
        EReference containment = this.getContainmentFeature();
        EClass eClass = this.getElementType().getEClass();
        if (containment != null && (element = this.getElementToEdit()) != null) {
            return EMFCoreUtil.create((EObject)element, (EReference)containment, (EClass)eClass);
        }
        return null;
    }

    protected EObject getElementToEdit() {
        if (super.getElementToEdit() == null) {
            CreateElementRequest request = (CreateElementRequest)this.getRequest();
            this.setElementToEdit(request.createContainer());
        }
        return super.getElementToEdit();
    }

    protected EClass getEClassToEdit() {
        CreateElementRequest request = (CreateElementRequest)this.getRequest();
        Object context = request.getEditHelperContext();
        if (context instanceof EObject) {
            return ((EObject)context).eClass();
        }
        IElementType type = ElementTypeRegistry.getInstance().getElementType(context);
        if (type != null) {
            return type.getEClass();
        }
        return null;
    }

    protected EReference getContainmentFeature() {
        IElementType type;
        EClass classToEdit;
        if (this.containmentFeature == null && (classToEdit = this.getEClassToEdit()) != null && (type = this.getElementType()) != null && type.getEClass() != null) {
            this.containmentFeature = PackageUtil.findFeature((EClass)classToEdit, (EClass)type.getEClass());
        }
        return this.containmentFeature;
    }

    protected void setContainmentFeature(EReference containmentFeature) {
        this.containmentFeature = containmentFeature;
    }

    protected IElementType getElementType() {
        return this.elementType;
    }

    public CreateElementRequest getCreateRequest() {
        return (CreateElementRequest)this.getRequest();
    }

    public boolean canExecute() {
        if (this.getEClassToEdit() == null) {
            return false;
        }
        if (this.getContainmentFeature() != null) {
            EClassifier eClassifier = this.getContainmentFeature().getEType();
            boolean result = true;
            if (eClassifier instanceof EClass) {
                result = ((EClass)eClassifier).isSuperTypeOf(this.getElementType().getEClass());
            }
            boolean bl = result = result && PackageUtil.canContain((EClass)this.getEClassToEdit(), (EReference)this.getContainmentFeature(), (EClass)this.getElementType().getEClass(), (boolean)false);
            return result && super.canExecute();
        }
        return false;
    }

    public EObject getNewElement() {
        return this.newElement;
    }
}

