/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.edithelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyReferenceCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;

public abstract class AbstractEditHelper
implements IEditHelper {
    private Map defaultContainmentFeatures = new HashMap();

    public boolean canEdit(IEditCommandRequest req) {
        IEditHelperAdvice[] advice = this.getEditHelperAdvice(req);
        this.configureRequest(req, advice);
        boolean approved = this.approveRequest(req, advice);
        if (!approved) {
            return false;
        }
        ICommand command = this.getEditCommand(req, advice);
        return command != null && command.canExecute();
    }

    public ICommand getEditCommand(IEditCommandRequest req) {
        IEditHelperAdvice[] advice = this.getEditHelperAdvice(req);
        this.configureRequest(req, advice);
        boolean approved = this.approveRequest(req, advice);
        if (!approved) {
            return null;
        }
        ICommand result = this.getEditCommand(req, advice);
        if (result != null) {
            return result.reduce();
        }
        return result;
    }

    private ICommand getEditCommand(IEditCommandRequest req, IEditHelperAdvice[] advice) {
        ICommand insteadCommand;
        Object replaceParam;
        ICompositeCommand command = this.createCommand(req);
        if (advice != null) {
            int i = 0;
            while (i < advice.length) {
                IEditHelperAdvice nextAdvice = advice[i];
                ICommand beforeAdvice = nextAdvice.getBeforeEditCommand(req);
                if (beforeAdvice != null) {
                    if (!beforeAdvice.canExecute()) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    command.compose((IUndoableOperation)beforeAdvice);
                }
                ++i;
            }
        }
        if ((replaceParam = req.getParameter("IEditCommandRequest.replaceDefaultCommand")) != Boolean.TRUE && (insteadCommand = this.getInsteadCommand(req)) != null) {
            if (!insteadCommand.canExecute()) {
                return UnexecutableCommand.INSTANCE;
            }
            command.compose((IUndoableOperation)insteadCommand);
        }
        if (advice != null) {
            int i = 0;
            while (i < advice.length) {
                IEditHelperAdvice nextAdvice = advice[i];
                ICommand afterAdvice = nextAdvice.getAfterEditCommand(req);
                if (afterAdvice != null) {
                    if (!afterAdvice.canExecute()) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    command.compose((IUndoableOperation)afterAdvice);
                }
                ++i;
            }
        }
        return command.isEmpty() ? null : command;
    }

    private void configureRequest(IEditCommandRequest req, IEditHelperAdvice[] advice) {
        if (advice != null) {
            int i = 0;
            while (i < advice.length) {
                IEditHelperAdvice nextAdvice = advice[i];
                nextAdvice.configureRequest(req);
                ++i;
            }
        }
        this.configureRequest(req);
    }

    private boolean approveRequest(IEditCommandRequest req, IEditHelperAdvice[] advice) {
        if (advice != null) {
            int i = 0;
            while (i < advice.length) {
                IEditHelperAdvice nextAdvice = advice[i];
                boolean approved = nextAdvice.approveRequest(req);
                if (!approved) {
                    return false;
                }
                ++i;
            }
        }
        return this.approveRequest(req);
    }

    protected void configureRequest(IEditCommandRequest request) {
    }

    protected boolean approveRequest(IEditCommandRequest request) {
        return true;
    }

    protected IEditHelperAdvice[] getEditHelperAdvice(IEditCommandRequest req) {
        Map contextMap;
        IEditHelperAdvice[] advices = null;
        Object editHelperContext = req.getEditHelperContext();
        Map cacheMaps = (Map)req.getParameter("Cache_Maps");
        if (cacheMaps != null && (contextMap = (Map)cacheMaps.get(editHelperContext)) != null) {
            advices = (IEditHelperAdvice[])contextMap.get("EditHelper_Advice");
        }
        if (advices == null) {
            advices = ElementTypeRegistry.getInstance().getEditHelperAdvice(editHelperContext);
        }
        return advices;
    }

    protected ICompositeCommand createCommand(IEditCommandRequest req) {
        CompositeTransactionalCommand result = new CompositeTransactionalCommand(req.getEditingDomain(), req.getLabel()){

            public CommandResult getCommandResult() {
                IStatus status;
                CommandResult _result = super.getCommandResult();
                IStatus iStatus = status = _result == null ? null : _result.getStatus();
                if (status != null && status.getSeverity() == 0) {
                    Object returnObject = null;
                    Object returnValue = _result.getReturnValue();
                    if (returnValue instanceof Collection) {
                        Collection collection = (Collection)returnValue;
                        if (!collection.isEmpty()) {
                            returnObject = collection.iterator().next();
                        }
                    } else {
                        returnObject = returnValue;
                    }
                    _result = new CommandResult(status, returnObject);
                }
                return _result;
            }
        };
        result.setTransactionNestingEnabled(false);
        return result;
    }

    protected ICommand getInsteadCommand(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            this.initializeDefaultFeature((CreateElementRequest)req);
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            this.initializeDefaultFeature((CreateElementRequest)req);
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyDependentsRequest) {
            return this.getDestroyDependentsCommand((DestroyDependentsRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    public List getContainedValues(EObject eContainer, EReference feature) {
        return Arrays.asList(ElementTypeRegistry.getInstance().getContainedTypes(eContainer, feature));
    }

    protected ICommand getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        boolean noSourceAndTarget;
        EObject source = req.getSource();
        EObject target = req.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (noSourceOrTarget && !noSourceAndTarget) {
            return IdentityCommand.INSTANCE;
        }
        return new CreateRelationshipCommand(req);
    }

    protected ICommand getCreateCommand(CreateElementRequest req) {
        return new CreateElementCommand(req);
    }

    public void initializeDefaultFeature(CreateElementRequest req) {
        if (req.getContainmentFeature() == null) {
            EClass eClass;
            EReference[] features;
            IContainerDescriptor containerDescriptor;
            ISpecializationType specializationType = (ISpecializationType)req.getElementType().getAdapter(ISpecializationType.class);
            if (specializationType != null && (containerDescriptor = specializationType.getEContainerDescriptor()) != null && (features = containerDescriptor.getContainmentFeatures()) != null) {
                int i = 0;
                while (i < features.length) {
                    Object editHelperContext = req.getEditHelperContext();
                    EClass eClass2 = null;
                    if (editHelperContext instanceof EClass) {
                        eClass2 = (EClass)editHelperContext;
                    } else if (editHelperContext instanceof EObject) {
                        eClass2 = ((EObject)editHelperContext).eClass();
                    } else if (editHelperContext instanceof IElementType) {
                        eClass2 = ((IElementType)editHelperContext).getEClass();
                    }
                    if (eClass2 != null && eClass2.getEAllReferences().contains((Object)features[i])) {
                        req.initializeContainmentFeature(features[i]);
                        return;
                    }
                    ++i;
                }
            }
            if ((eClass = req.getElementType().getEClass()) != null) {
                req.initializeContainmentFeature(this.getDefaultContainmentFeature(eClass));
            }
        }
    }

    protected EReference getDefaultContainmentFeature(EClass eClass) {
        EReference result = (EReference)this.getDefaultContainmentFeatures().get(eClass);
        if (result == null) {
            ArrayList superTypes = new ArrayList(eClass.getEAllSuperTypes());
            Collections.reverse(superTypes);
            Iterator i = superTypes.iterator();
            while (i.hasNext() && result == null) {
                EClass nextSuperType = (EClass)i.next();
                result = (EReference)this.getDefaultContainmentFeatures().get(nextSuperType);
            }
        }
        return result;
    }

    protected Map getDefaultContainmentFeatures() {
        return this.defaultContainmentFeatures;
    }

    protected ICommand getSetCommand(SetRequest req) {
        return new SetValueCommand(req);
    }

    protected ICommand getEditContextCommand(GetEditContextRequest req) {
        return new GetEditContextCommand(req);
    }

    protected ICommand getBasicDestroyElementCommand(DestroyElementRequest req) {
        DestroyElementCommand result = req.getBasicDestroyCommand();
        if (result == null) {
            result = new DestroyElementCommand(req);
        } else {
            req.setBasicDestroyCommand(null);
        }
        return result;
    }

    protected ICommand getDestroyElementWithDependentsCommand(DestroyElementRequest req) {
        ICommand command;
        Map map;
        DestroyDependentsRequest ddr;
        ICommand result = this.getBasicDestroyElementCommand(req);
        EObject initial = (EObject)req.getParameter("DestroyElementRequest.initialElementToDestroy");
        if (initial == null) {
            req.setParameter("DestroyElementRequest.initialElementToDestroy", req.getElementToDestroy());
        }
        if ((ddr = (DestroyDependentsRequest)req.getParameter("DestroyElementRequest.destroyDependentsRequest")) == null) {
            ddr = new DestroyDependentsRequest(req.getEditingDomain(), req.getElementToDestroy(), req.isConfirmationRequired());
            ddr.addParameters(req.getParameters());
            ddr.setClientContext(req.getClientContext());
            req.setParameter("DestroyElementRequest.destroyDependentsRequest", ddr);
        } else {
            ddr.setElementToDestroy(req.getElementToDestroy());
        }
        IElementType typeToDestroy = null;
        Map cacheMaps = (Map)req.getParameter("Cache_Maps");
        if (cacheMaps != null && (map = (Map)cacheMaps.get(req.getElementToDestroy())) != null) {
            typeToDestroy = (IElementType)map.get("Element_Type");
        }
        if (typeToDestroy == null) {
            typeToDestroy = ElementTypeRegistry.getInstance().getElementType(req.getElementToDestroy());
        }
        if (typeToDestroy != null && (command = typeToDestroy.getEditCommand(ddr)) != null) {
            result = result.compose((IUndoableOperation)command);
        }
        return result;
    }

    protected ICommand getDestroyElementCommand(DestroyElementRequest req) {
        ICommand result = null;
        EObject parent = req.getElementToDestroy();
        if (req.getParameter("DestroyElementRequest.initialElementToDestroy") == null) {
            req.setParameter("DestroyElementRequest.initialElementToDestroy", parent);
        }
        IElementType parentType = null;
        Map cacheMaps = (Map)req.getParameter("Cache_Maps");
        Set checkedElement = null;
        if (cacheMaps != null) {
            checkedElement = (Set)cacheMaps.get("Checked_Elements");
            checkedElement.add(parent);
            Map parentMap = (Map)cacheMaps.get(parent);
            parentType = parentMap != null ? (IElementType)parentMap.get("Element_Type") : ElementTypeRegistry.getInstance().getElementType(parent);
        } else {
            parentType = ElementTypeRegistry.getInstance().getElementType(parent);
        }
        if (parentType != null) {
            for (EObject next : parent.eContents()) {
                DestroyDependentsRequest ddr = (DestroyDependentsRequest)req.getParameter("DestroyElementRequest.destroyDependentsRequest");
                if (ddr != null && (checkedElement == null || !checkedElement.add(next)) && ddr.getDependentElementsToDestroy().contains(next)) continue;
                req.setElementToDestroy(next);
                ICommand command = parentType.getEditCommand(req);
                if (command == null) continue;
                result = result == null ? command : result.compose((IUndoableOperation)command);
            }
        }
        req.setElementToDestroy(parent);
        ICommand destroyParent = this.getDestroyElementWithDependentsCommand(req);
        result = result == null ? destroyParent : result.compose((IUndoableOperation)destroyParent);
        return result;
    }

    protected ICommand getDestroyDependentsCommand(DestroyDependentsRequest req) {
        return null;
    }

    protected ICommand getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return new DestroyReferenceCommand(req);
    }

    protected ICommand getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected ICommand getMoveCommand(MoveRequest req) {
        return new MoveElementsCommand(req);
    }

    protected ICommand getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return null;
    }

    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return null;
    }
}

