/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderToPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.ITraceMe;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class MoveTo
implements IEmf2SvgConverter,
IWmf2SvgConverter,
IRenderToPath,
ITraceMe {
    private static final int EMF_X_OFFSET = 0;
    private static final int EMF_Y_OFFSET = 4;
    private static final int WMF_X_OFFSET = 2;
    private static final int WMF_Y_OFFSET = 0;
    private int m_xPos = 0;
    private int m_yPos = 0;
    private int m_xPosConv = -1;
    private int m_yPosConv = -1;

    public void readWMFRecord(Record emr) throws IOException {
        this.m_xPos = emr.getShortAt(2);
        this.m_yPos = emr.getShortAt(0);
    }

    public void readEMFRecord(Record emr) throws IOException {
        this.m_xPos = emr.getIntAt(0);
        this.m_yPos = emr.getIntAt(4);
    }

    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        context.setCurPosX(this.m_xPos);
        context.setCurPosY(this.m_yPos);
        this.m_xPosConv = this.m_xPos;
        this.m_yPosConv = this.m_yPos;
    }

    public void render(DeviceContext context) throws TranscoderException {
        GeneralPath p = context.getGdiPath().getCurrentFigure();
        this.m_xPosConv = context.convertXToSVGLogicalUnits(this.m_xPos);
        this.m_yPosConv = context.convertYToSVGLogicalUnits(this.m_yPos);
        p.moveTo(this.m_xPosConv, this.m_yPosConv);
        context.setCurPosX(this.m_xPos);
        context.setCurPosY(this.m_yPos);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.m_xPosConv);
        sb.append(',');
        sb.append(this.m_yPosConv);
        sb.append(')');
        return sb.toString();
    }
}

