/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.draw2d.ui;

import junit.framework.TestCase;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;

public class LineSegTest
extends TestCase {
    private LineSeg lineSeg;
    private LineSeg verticalLine;
    private LineSeg horizontalLine;
    private Point origin;
    private Point terminus;

    protected void setUp() throws Exception {
        super.setUp();
        this.origin = new Point(5, 5);
        this.terminus = new Point(10, 10);
        this.lineSeg = new LineSeg(this.origin, this.terminus);
        this.verticalLine = new LineSeg(new Point(0, 5), new Point(0, 105));
        this.horizontalLine = new LineSeg(new Point(0, 5), new Point(100, 5));
    }

    public void testEqualsObject() {
        LineSeg seg1 = new LineSeg(new Point(0, 0), new Point(10, 10));
        LineSeg seg2 = new LineSeg(new Point(1, 1), new Point(9, 9));
        LineSeg seg3 = new LineSeg(new Point(0, 0), new Point(5, 5));
        LineSeg seg4 = new LineSeg(new Point(0, 0), new Point(10, 10));
        LineSegTest.assertFalse((boolean)seg1.equals((Object)seg2));
        LineSegTest.assertFalse((boolean)seg1.equals((Object)seg3));
        LineSegTest.assertTrue((boolean)seg1.equals((Object)seg4));
    }

    public void testGetOrigin() {
        LineSegTest.assertEquals((Object)this.origin, (Object)this.lineSeg.getOrigin());
    }

    public void testGetTerminus() {
        LineSegTest.assertEquals((Object)this.terminus, (Object)this.lineSeg.getTerminus());
    }

    public void testSetOrigin() {
        Point p1 = new Point(-5, -5);
        this.lineSeg.setOrigin(p1);
        LineSegTest.assertEquals((Object)p1, (Object)this.lineSeg.getOrigin());
    }

    public void testSetTerminus() {
        Point p1 = new Point(-5, -5);
        this.lineSeg.setTerminus(p1);
        LineSegTest.assertEquals((Object)p1, (Object)this.lineSeg.getTerminus());
    }

    public void testGetSupremum() {
        LineSegTest.assertEquals((int)this.terminus.x, (int)this.lineSeg.getSupremum().x);
        LineSegTest.assertEquals((int)this.terminus.y, (int)this.lineSeg.getSupremum().y);
    }

    public void testGetInfimum() {
        LineSegTest.assertEquals((int)this.origin.x, (int)this.lineSeg.getInfimum().x);
        LineSegTest.assertEquals((int)this.origin.y, (int)this.lineSeg.getInfimum().y);
    }

    public void testIsHorizontal() {
        LineSegTest.assertFalse((String)"verticalLine shouldn't be horizontal", (boolean)this.verticalLine.isHorizontal());
        LineSegTest.assertTrue((String)"horizontalLine should be horizontal", (boolean)this.horizontalLine.isHorizontal());
    }

    public void testIsVertical() {
        LineSegTest.assertTrue((String)"verticalLine should be vertical", (boolean)this.verticalLine.isVertical());
        LineSegTest.assertFalse((String)"horizontalLine shouldn't be vertical", (boolean)this.horizontalLine.isVertical());
    }

    public void testSlope() {
        LineSegTest.assertTrue((String)"The line should be vertical", (9999.0f == this.verticalLine.slope() ? 1 : 0) != 0);
        LineSegTest.assertTrue((String)"The line should be horizontal", (0.0 == (double)this.horizontalLine.slope() ? 1 : 0) != 0);
    }

    public void testPerpSlope() {
        LineSegTest.assertEquals((String)"Perp Slope of a vertical line should be horizontal", (int)0, (int)((int)this.verticalLine.perpSlope()));
        LineSegTest.assertEquals((String)"Perp slope of a horizontal line should be vertical", (int)9999, (int)((int)this.horizontalLine.perpSlope()));
    }

    public void testLength() {
        LineSegTest.assertEquals((String)"Vertical line seg length is not correct", (int)100, (int)((int)this.verticalLine.length()));
        LineSegTest.assertEquals((String)"Horizontal line seg length is not correct", (int)100, (int)((int)this.horizontalLine.length()));
    }

    public void testContainsPoint() {
        Point isContained = new Point(6, 6);
        Point notContained = new Point(3, 3);
        LineSegTest.assertTrue((boolean)this.lineSeg.containsPoint(isContained, 0));
        LineSegTest.assertFalse((boolean)this.lineSeg.containsPoint(notContained, 0));
    }

    public void testDistanceAlong() {
        LineSegTest.assertEquals((String)"The distance has been incorrectly computed", (int)0, (int)((int)this.lineSeg.distanceAlong(new Point(5, 5))));
        Point p2 = new Point(10, 10);
        LineSeg seg2 = new LineSeg(p2, p2);
        LineSegTest.assertEquals((int)-1, (int)((int)seg2.distanceAlong(new Point(2, 2))));
    }

    public void testLineEquation() {
        Point p1 = new Point(1, 0);
        Point p2 = new Point(2, 1);
        LineSeg line = new LineSeg(p1, p2);
        double[] equation = line.getEquation();
        LineSegTest.assertTrue((String)"Equation is incomplete", (equation.length == 3 ? 1 : 0) != 0);
        LineSegTest.assertTrue((String)"Coefficient 'a' is not correct", (equation[0] == -1.0 ? 1 : 0) != 0);
        LineSegTest.assertTrue((String)"Coefficient 'b' is not correct", (equation[1] == 1.0 ? 1 : 0) != 0);
        LineSegTest.assertTrue((String)"Coefficient 'c' is not correct", (equation[2] == -1.0 ? 1 : 0) != 0);
    }

    public void testFindLineIntersections() {
        PointList points = new PointList();
        points.addPoint(new Point(0, 10));
        points.addPoint(new Point(10, 0));
        points.addPoint(new Point(0, -10));
        points.addPoint(new Point(-10, 0));
        points.addPoint(new Point(0, 10));
        Point p1 = new Point(-20, 20);
        Point p2 = new Point(30, -30);
        LineSeg line = new LineSeg(p1, p2);
        PointList intersections = line.getLineIntersectionsWithLineSegs(points);
        LineSegTest.assertTrue((String)("Line passing through " + p1 + " and " + p2 + "must have exactly 2 intersections with the figure"), (intersections.size() == 2 ? 1 : 0) != 0);
        Point first = PointListUtilities.pickClosestPoint((PointList)intersections, (Point)p2);
        LineSegTest.assertTrue((String)("This is not the closest intersection to " + p2), (first.x == 5 && first.y == -5 ? 1 : 0) != 0);
        Point second = PointListUtilities.pickFarestPoint((PointList)intersections, (Point)p2);
        LineSegTest.assertTrue((String)("This is not the farest intersection to " + p2), (second.x == -5 && second.y == 5 ? 1 : 0) != 0);
        p1 = new Point(10, 10);
        p2 = new Point(10, -10);
        line = new LineSeg(p1, p2);
        intersections = line.getLineIntersectionsWithLineSegs(points);
        LineSegTest.assertTrue((String)("Line passing through " + p1 + " and " + p2 + "must have exactly 1 intersections with the figure"), (intersections.size() == 2 ? 1 : 0) != 0);
        first = PointListUtilities.pickClosestPoint((PointList)intersections, (Point)p2);
        second = PointListUtilities.pickFarestPoint((PointList)intersections, (Point)p2);
        LineSegTest.assertTrue((second.x == first.x && second.y == first.y ? 1 : 0) != 0);
        LineSegTest.assertTrue((String)"Incorrect value for intersection point", (first.x == 10 && first.y == 0 ? 1 : 0) != 0);
        p1 = new Point(20, 20);
        p2 = new Point(-10, 10);
        line = new LineSeg(p1, p2);
        intersections = line.getLineIntersectionsWithLineSegs(points);
        LineSegTest.assertTrue((String)("Line passing through " + p1 + " and " + p2 + "must have no intersections with the figure"), (intersections.size() == 0 ? 1 : 0) != 0);
        p1 = new Point(20, -10);
        p2 = new Point(-10, 20);
        line = new LineSeg(p1, p2);
        intersections = line.getLineIntersectionsWithLineSegs(points);
        LineSegTest.assertTrue((String)("Line passing through " + p1 + " and " + p2 + "must have exactly 2 intersections with the figure"), (intersections.size() == 4 ? 1 : 0) != 0);
        first = PointListUtilities.pickClosestPoint((PointList)intersections, (Point)p2);
        LineSegTest.assertTrue((String)("This is not the closest intersection to " + p2), (first.x == 0 && first.y == 10 ? 1 : 0) != 0);
        second = PointListUtilities.pickFarestPoint((PointList)intersections, (Point)p2);
        LineSegTest.assertTrue((String)("This is not the farest intersection to " + p2), (second.x == 10 && second.y == 0 ? 1 : 0) != 0);
    }

    public void testAllLineIntersectionsWithEllipse() {
        Rectangle oval = new Rectangle(Rectangle.SINGLETON);
        oval.setLocation(-2, -1);
        oval.setSize(4, 2);
        Point p1 = new Point(0, 0);
        Point p2 = new Point(3, 0);
        LineSeg line = new LineSeg(p1, p2);
        PointList intersections = line.getLineIntersectionsWithEllipse(oval);
        LineSegTest.assertTrue((String)("Must have 2 intersections with line passing through points " + p1 + " and " + p2), (intersections.size() == 2 ? 1 : 0) != 0);
        Point first = PointListUtilities.pickClosestPoint((PointList)intersections, (Point)p2);
        LineSegTest.assertTrue((String)("This is not the closes intersection to " + p2), (first.x == 2 && first.y == 0 ? 1 : 0) != 0);
        Point second = PointListUtilities.pickFarestPoint((PointList)intersections, (Point)p2);
        LineSegTest.assertTrue((String)("This is not the farest intersection to " + p2), (second.x == -2 && second.y == 0 ? 1 : 0) != 0);
        p1 = new Point(2, -2);
        p2 = new Point(2, 2);
        line = new LineSeg(p1, p2);
        intersections = line.getLineIntersectionsWithEllipse(oval);
        LineSegTest.assertTrue((String)("Line passing through " + p1 + " and " + p2 + "must have exactly 1 intersections with the figure"), (intersections.size() == 2 ? 1 : 0) != 0);
        first = PointListUtilities.pickClosestPoint((PointList)intersections, (Point)p2);
        second = PointListUtilities.pickFarestPoint((PointList)intersections, (Point)p2);
        LineSegTest.assertTrue((second.x == first.x && second.y == first.y ? 1 : 0) != 0);
        LineSegTest.assertTrue((String)"Incorrect value for intersection point", (first.x == 2 && first.y == 0 ? 1 : 0) != 0);
        p1 = new Point(3, 0);
        p2 = new Point(0, 3);
        line = new LineSeg(p1, p2);
        intersections = line.getLineIntersectionsWithEllipse(oval);
        LineSegTest.assertTrue((String)("Line passing through " + p1 + " and " + p2 + "must have no intersections with the figure"), (intersections.size() == 0 ? 1 : 0) != 0);
    }
}

