/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Band;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Employee;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.EmployeeType;

public class AbstractEditHelperAdviceTest
extends AbstractEMFTypeTest {
    private Department department;
    private Employee financeEmployee;

    public AbstractEditHelperAdviceTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AbstractEditHelperAdviceTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AbstractEditHelperAdviceTest.class, "AbstractEditHelperAdvice Test Suite");
    }

    protected void doModelSetup(Resource resource) {
        this.department = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department.setName("Finance");
        resource.getContents().add((Object)this.department);
        this.financeEmployee = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.department.getMembers().add((Object)this.financeEmployee);
    }

    public void test_approveRequest_133160() {
        SetRequest setRequest = new SetRequest((EObject)this.financeEmployee, (EStructuralFeature)this.getEmployeePackage().getEmployee_Band(), (Object)Band.SENIOR_LITERAL);
        boolean canEdit = EmployeeType.EMPLOYEE.getEditHelper().canEdit((IEditCommandRequest)setRequest);
        AbstractEditHelperAdviceTest.assertTrue((boolean)canEdit);
        Object parameter = setRequest.getParameter("approved");
        AbstractEditHelperAdviceTest.assertSame((Object)Boolean.TRUE, (Object)parameter);
        setRequest.setParameter("approved", null);
        ICommand command = EmployeeType.EMPLOYEE.getEditHelper().getEditCommand((IEditCommandRequest)setRequest);
        AbstractEditHelperAdviceTest.assertNotNull((Object)command);
        AbstractEditHelperAdviceTest.assertTrue((boolean)command.canExecute());
        parameter = setRequest.getParameter("approved");
        AbstractEditHelperAdviceTest.assertSame((Object)Boolean.TRUE, (Object)parameter);
        setRequest = new SetRequest((EObject)this.financeEmployee, (EStructuralFeature)this.getEmployeePackage().getEmployee_Band(), (Object)Band.DIRECTOR_LITERAL);
        canEdit = EmployeeType.EMPLOYEE.getEditHelper().canEdit((IEditCommandRequest)setRequest);
        AbstractEditHelperAdviceTest.assertFalse((boolean)canEdit);
        parameter = setRequest.getParameter("approved");
        AbstractEditHelperAdviceTest.assertSame((Object)Boolean.FALSE, (Object)parameter);
        setRequest.setParameter("approved", null);
        command = EmployeeType.EMPLOYEE.getEditHelper().getEditCommand((IEditCommandRequest)setRequest);
        AbstractEditHelperAdviceTest.assertNull((Object)command);
        parameter = setRequest.getParameter("approved");
        AbstractEditHelperAdviceTest.assertSame((Object)Boolean.FALSE, (Object)parameter);
    }
}

