/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.EmployeeType;

public class AbstractEditHelperTest
extends AbstractEMFTypeTest {
    private Department department;

    public AbstractEditHelperTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AbstractEditHelperTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AbstractEditHelperTest.class);
    }

    protected void doModelSetup(Resource resource) {
        this.department = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department.setName("Department");
        resource.getContents().add((Object)this.department);
    }

    public void test_defaultContainmentFeature() {
        CreateElementRequest request = new CreateElementRequest(this.getEditingDomain(), (EObject)this.department, (IElementType)EmployeeType.MANAGER);
        EmployeeType.DEPARTMENT.getEditCommand((IEditCommandRequest)request);
        AbstractEditHelperTest.assertSame((Object)this.getEmployeePackage().getDepartment_Manager(), (Object)request.getContainmentFeature());
    }

    public void test_replaceDefaultEditCommand() {
        CreateElementRequest request = new CreateElementRequest(this.getEditingDomain(), (EObject)this.department, (IElementType)EmployeeType.MANAGER);
        ICommand command = EmployeeType.DEPARTMENT.getEditCommand((IEditCommandRequest)request);
        AbstractEditHelperTest.assertNotNull((Object)command);
        request.setParameter("IEditCommandRequest.replaceDefaultCommand", (Object)Boolean.TRUE);
        command = EmployeeType.DEPARTMENT.getEditCommand((IEditCommandRequest)request);
        AbstractEditHelperTest.assertNull((Object)command);
    }

    public void test_incompleteCreateRelationshipRequest_117922() {
        CreateRelationshipRequest request = new CreateRelationshipRequest(this.getEditingDomain(), (EObject)this.department, (EObject)this.department, null, (IElementType)EmployeeType.MANAGER);
        ICommand command = EmployeeType.DEPARTMENT.getEditCommand((IEditCommandRequest)request);
        AbstractEditHelperTest.assertNotNull((Object)command);
        AbstractEditHelperTest.assertTrue((boolean)command.canExecute());
        request = new CreateRelationshipRequest(this.getEditingDomain(), (EObject)this.department, null, null, (IElementType)EmployeeType.MANAGER);
        command = EmployeeType.DEPARTMENT.getEditCommand((IEditCommandRequest)request);
        AbstractEditHelperTest.assertTrue((command == null || !command.canExecute() ? 1 : 0) != 0);
    }

    public void test_canEdit_122771() {
        CreateElementRequest request = new CreateElementRequest(this.getEditingDomain(), (EObject)this.department, (IElementType)EmployeeType.MANAGER);
        boolean canEdit = EmployeeType.DEPARTMENT.getEditHelper().canEdit((IEditCommandRequest)request);
        AbstractEditHelperTest.assertTrue((boolean)canEdit);
        canEdit = EmployeeType.DEPARTMENT.canEdit((IEditCommandRequest)request);
        AbstractEditHelperTest.assertTrue((boolean)canEdit);
        request = new CreateElementRequest(this.getEditingDomain(), (EObject)this.department, (IElementType)EmployeeType.OFFICE);
        canEdit = EmployeeType.DEPARTMENT.getEditHelper().canEdit((IEditCommandRequest)request);
        AbstractEditHelperTest.assertFalse((boolean)canEdit);
        canEdit = EmployeeType.DEPARTMENT.canEdit((IEditCommandRequest)request);
        AbstractEditHelperTest.assertFalse((boolean)canEdit);
    }

    public void test_approveRequest_133160() {
        SetRequest setRequest = new SetRequest((EObject)this.department, (EStructuralFeature)this.getEmployeePackage().getDepartment_Number(), (Object)new Integer(123456));
        boolean canEdit = EmployeeType.DEPARTMENT.getEditHelper().canEdit((IEditCommandRequest)setRequest);
        AbstractEditHelperTest.assertTrue((boolean)canEdit);
        Object parameter = setRequest.getParameter("approved");
        AbstractEditHelperTest.assertSame((Object)Boolean.TRUE, (Object)parameter);
        setRequest.setParameter("approved", null);
        ICommand command = EmployeeType.DEPARTMENT.getEditHelper().getEditCommand((IEditCommandRequest)setRequest);
        AbstractEditHelperTest.assertNotNull((Object)command);
        AbstractEditHelperTest.assertTrue((boolean)command.canExecute());
        parameter = setRequest.getParameter("approved");
        AbstractEditHelperTest.assertSame((Object)Boolean.TRUE, (Object)parameter);
        setRequest = new SetRequest((EObject)this.department, (EStructuralFeature)this.getEmployeePackage().getDepartment_Number(), (Object)new Integer(0));
        canEdit = EmployeeType.DEPARTMENT.getEditHelper().canEdit((IEditCommandRequest)setRequest);
        AbstractEditHelperTest.assertFalse((boolean)canEdit);
        parameter = setRequest.getParameter("approved");
        AbstractEditHelperTest.assertSame((Object)Boolean.FALSE, (Object)parameter);
        setRequest.setParameter("approved", null);
        command = EmployeeType.DEPARTMENT.getEditHelper().getEditCommand((IEditCommandRequest)setRequest);
        AbstractEditHelperTest.assertNull((Object)command);
        parameter = setRequest.getParameter("approved");
        AbstractEditHelperTest.assertSame((Object)Boolean.FALSE, (Object)parameter);
    }
}

