/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Employee;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.EmployeeFactory;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.EmployeePackage;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Office;

public class SetValueCommandTest
extends AbstractEMFTypeTest {
    private Department department;
    private Employee manager;
    private Office managerOffice;

    public SetValueCommandTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(SetValueCommandTest.class);
    }

    protected void doModelSetup(Resource resource) {
        this.department = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department.setName("Department");
        resource.getContents().add((Object)this.department);
        this.manager = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.managerOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
    }

    public void test_isExecutable() {
        SetRequest request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Manager(), (Object)this.manager);
        SetValueCommand command = new SetValueCommand(request);
        SetValueCommandTest.assertTrue((boolean)command.canExecute());
        request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Manager(), null);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertTrue((boolean)command.canExecute());
        request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Manager(), (Object)this.managerOffice);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertFalse((boolean)command.canExecute());
        request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)EmployeePackage.eINSTANCE.getEmployee_Office(), (Object)this.manager);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertFalse((boolean)command.canExecute());
        request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Members(), null);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertFalse((boolean)command.canExecute());
        request = new SetRequest(this.getEditingDomain(), (EObject)this.manager, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Manager(), null);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertFalse((boolean)command.canExecute());
        EReference managerFeature = EmployeePackage.eINSTANCE.getDepartment_Manager();
        managerFeature.setChangeable(false);
        request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)managerFeature, (Object)this.manager);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertFalse((boolean)command.canExecute());
    }

    public void testSetValueCommandForManyFeatureUsingList() {
        EReference members = EmployeePackage.eINSTANCE.getDepartment_Members();
        Employee e1 = EmployeeFactory.eINSTANCE.createEmployee();
        Employee e2 = EmployeeFactory.eINSTANCE.createEmployee();
        LinkedList list = new LinkedList(Arrays.asList(e1, e2));
        SetRequest usingNewListInstance = new SetRequest((EObject)this.department, (EStructuralFeature)members, list);
        SetValueCommand cmd = new SetValueCommand(usingNewListInstance);
        this.verifyExecution(cmd, list);
    }

    public void testSetValueCommandForManyFeatureUsingEmptyList() {
        EReference members = EmployeePackage.eINSTANCE.getDepartment_Members();
        Employee e1 = EmployeeFactory.eINSTANCE.createEmployee();
        Employee e2 = EmployeeFactory.eINSTANCE.createEmployee();
        LinkedList list = new LinkedList(Arrays.asList(e1, e2));
        SetRequest usingNewListInstance = new SetRequest((EObject)this.department, (EStructuralFeature)members, list);
        SetValueCommand cmd = new SetValueCommand(usingNewListInstance);
        this.verifyExecution(cmd, list);
        ArrayList list2 = new ArrayList();
        SetRequest usingNewEmptyListInstance = new SetRequest((EObject)this.department, (EStructuralFeature)members, list2);
        SetValueCommand cmd2 = new SetValueCommand(usingNewEmptyListInstance);
        this.verifyExecution(cmd2, list2);
    }

    public void testSetValueCommandForManyFeatureUsingList_VerifyOldValuesRemoved() {
        EReference members = EmployeePackage.eINSTANCE.getDepartment_Members();
        Employee e1 = EmployeeFactory.eINSTANCE.createEmployee();
        Employee e2 = EmployeeFactory.eINSTANCE.createEmployee();
        LinkedList list = new LinkedList(Arrays.asList(e1, e2));
        SetRequest usingNewListInstance = new SetRequest((EObject)this.department, (EStructuralFeature)members, list);
        SetValueCommand cmd = new SetValueCommand(usingNewListInstance);
        this.verifyExecution(cmd, list);
        Employee e3 = EmployeeFactory.eINSTANCE.createEmployee();
        Employee e4 = EmployeeFactory.eINSTANCE.createEmployee();
        LinkedList list2 = new LinkedList(Arrays.asList(e3, e4));
        SetRequest usingNewEmptyListInstance = new SetRequest((EObject)this.department, (EStructuralFeature)members, list2);
        SetValueCommand cmd2 = new SetValueCommand(usingNewEmptyListInstance);
        this.verifyExecution(cmd2, list2);
    }

    public void testSetValueCommandForManyFeatureUsingSingleValue() {
        EReference members = EmployeePackage.eINSTANCE.getDepartment_Members();
        Employee e1 = EmployeeFactory.eINSTANCE.createEmployee();
        Employee e2 = EmployeeFactory.eINSTANCE.createEmployee();
        SetRequest usingSingleValue1 = new SetRequest((EObject)this.department, (EStructuralFeature)members, (Object)e1);
        SetValueCommand cmd1 = new SetValueCommand(usingSingleValue1);
        this.verifyExecution(cmd1, e1, 1);
        SetRequest usingSingleValue2 = new SetRequest((EObject)this.department, (EStructuralFeature)members, (Object)e2);
        SetValueCommand cmd2 = new SetValueCommand(usingSingleValue2);
        this.verifyExecution(cmd2, e2, 2);
    }

    private void verifyExecution(SetValueCommand cmd, List list) {
        try {
            SetValueCommandTest.assertTrue((String)"Cannot Execute command", (boolean)cmd.canExecute());
            cmd.execute((IProgressMonitor)new NullProgressMonitor(), null);
            EList list2 = this.department.getMembers();
            SetValueCommandTest.assertTrue((String)"UnexpectedSize", (list2.size() == list.size() ? 1 : 0) != 0);
            for (Object element : list) {
                SetValueCommandTest.assertTrue((String)"Element not added", (boolean)list2.contains(element));
            }
        }
        catch (ExecutionException e) {
            SetValueCommandTest.assertTrue((String)"failed to exectue the command", (boolean)false);
            e.printStackTrace();
        }
    }

    private void verifyExecution(SetValueCommand cmd, Object object, int size) {
        try {
            SetValueCommandTest.assertTrue((String)"Cannot Execute command", (boolean)cmd.canExecute());
            cmd.execute((IProgressMonitor)new NullProgressMonitor(), null);
            EList list2 = this.department.getMembers();
            SetValueCommandTest.assertTrue((String)"UnexpectedSize", (list2.size() == size ? 1 : 0) != 0);
            SetValueCommandTest.assertTrue((String)"Element not added", (boolean)list2.contains(object));
        }
        catch (ExecutionException e) {
            SetValueCommandTest.assertTrue((String)"failed to exectue the command", (boolean)false);
            e.printStackTrace();
        }
    }
}

