/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import junit.framework.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.Attributes;
import org.eclipse.gmf.codegen.gmfgen.DefaultSizeAttributes;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.internal.codegen.util.GMFGenConfig;
import org.eclipse.gmf.internal.common.reconcile.Decision;
import org.eclipse.gmf.internal.common.reconcile.DefaultDecision;
import org.eclipse.gmf.internal.common.reconcile.Reconciler;
import org.eclipse.gmf.internal.common.reconcile.ReconcilerConfig;
import org.eclipse.gmf.internal.common.reconcile.ReconcilerConfigBase;
import org.eclipse.gmf.tests.ConfiguredTestCase;
import org.eclipse.gmf.tests.setup.DiaGenSource;

public class CodegenReconcileTest
extends ConfiguredTestCase {
    public CodegenReconcileTest(String name) {
        super(name);
    }

    protected final GenEditorGenerator getOriginal() {
        return this.getSetup().getGenModel().getGenDiagram().getEditorGen();
    }

    protected final GenEditorGenerator createCopy() {
        return (GenEditorGenerator)EcoreUtil.copy((EObject)this.getOriginal());
    }

    public void testLoadGMFGen() throws Exception {
        GenEditorGenerator original = this.getOriginal();
        CodegenReconcileTest.assertNotNull((Object)original);
        GenEditorGenerator copy = this.createCopy();
        CodegenReconcileTest.assertNotNull((Object)copy);
        CodegenReconcileTest.assertFalse((original == copy ? 1 : 0) != 0);
        CodegenReconcileTest.assertFalse((boolean)original.equals(copy));
        CodegenReconcileTest.assertEquals((String)original.getCopyrightText(), (String)copy.getCopyrightText());
        CodegenReconcileTest.assertEquals((boolean)original.isSameFileForDiagramAndModel(), (boolean)copy.isSameFileForDiagramAndModel());
        CodegenReconcileTest.assertEquals((String)original.getPackageNamePrefix(), (String)copy.getPackageNamePrefix());
        copy.setCopyrightText("New Value");
        CodegenReconcileTest.assertEquals((String)copy.getCopyrightText(), (String)"New Value");
        CodegenReconcileTest.assertFalse((boolean)copy.getCopyrightText().equals(original.getCopyrightText()));
    }

    public void testReconcileDeepElementWithAlwaysMatcher() throws Exception {
        class GenPluginChange
        extends Assert
        implements UserChange {
            private final String NEW_PROVIDER = "NewProviderValue";
            private final String NEW_VERSION = "NewVersionValue";
            private final String NEW_ID = "NewPluginID";
            private final String NEW_ACTIVATOR = "NewActivator";
            private final String NEW_NAME = "NewName With Space";
            private boolean myExpectedPrintingEnabled;

            GenPluginChange() {
            }

            public void applyChanges(GenEditorGenerator old) {
                GenPlugin genPlugin = old.getPlugin();
                GenPluginChange.assertNotNull((Object)genPlugin.getProvider());
                GenPluginChange.assertNotNull((Object)genPlugin.getVersion());
                GenPluginChange.assertNotNull((Object)genPlugin.getID());
                GenPluginChange.assertNotNull((Object)genPlugin.getActivatorClassName());
                GenPluginChange.assertNotNull((Object)genPlugin.getName());
                GenPluginChange.assertFalse((boolean)genPlugin.isPrintingEnabled());
                this.myExpectedPrintingEnabled = !genPlugin.isPrintingEnabled();
                genPlugin.setProvider("NewProviderValue");
                genPlugin.setVersion("NewVersionValue");
                genPlugin.setID("NewPluginID");
                genPlugin.setActivatorClassName("NewActivator");
                genPlugin.setPrintingEnabled(this.myExpectedPrintingEnabled);
                genPlugin.setName("NewName With Space");
            }

            public void assertChangesPreserved(GenEditorGenerator current) {
                GenPlugin genPlugin = current.getPlugin();
                GenPluginChange.assertEquals((String)"NewProviderValue", (String)genPlugin.getProvider());
                GenPluginChange.assertEquals((String)"NewVersionValue", (String)genPlugin.getVersion());
                GenPluginChange.assertEquals((String)"NewPluginID", (String)genPlugin.getID());
                GenPluginChange.assertEquals((String)"NewActivator", (String)genPlugin.getActivatorClassName());
                GenPluginChange.assertEquals((boolean)this.myExpectedPrintingEnabled, (boolean)genPlugin.isPrintingEnabled());
                GenPluginChange.assertEquals((String)"NewName With Space", (String)genPlugin.getName());
            }

            public ReconcilerConfigBase getReconcilerConfig() {
                return new GMFGenConfig();
            }
        }
        this.checkUserChange(new GenPluginChange());
    }

    public void testReconcileCompartmentIsListLayout() {
        DiaGenSource diaGenSource = this.getSetup().getGenModel();
        CodegenReconcileTest.assertFalse((boolean)diaGenSource.getNodeA().getCompartments().isEmpty());
        CodegenReconcileTest.assertFalse((boolean)diaGenSource.getNodeB().getCompartments().isEmpty());
        GMFGenPackage GMFGEN = GMFGenPackage.eINSTANCE;
        class CompartmentChange
        extends Assert
        implements UserChange {
            private int myCompartmentsTotalCount;
            private final EStructuralFeature myGenCompartmentFeature;
            private final Boolean myExpectedValue;

            public CompartmentChange(EStructuralFeature genCompartmentFeature, boolean expectedValue) {
                CompartmentChange.assertEquals((Object)EcorePackage.eINSTANCE.getEBoolean(), (Object)genCompartmentFeature.getEType());
                this.myGenCompartmentFeature = genCompartmentFeature;
                this.myExpectedValue = expectedValue;
            }

            public final void applyChanges(GenEditorGenerator old) {
                GenDiagram diagram = old.getDiagram();
                CompartmentChange.assertFalse((String)"Precondition, we need some nodes", (boolean)diagram.getChildNodes().isEmpty());
                CompartmentChange.assertFalse((String)"Precondition, we need some nodes", (boolean)diagram.getTopLevelNodes().isEmpty());
                this.myCompartmentsTotalCount = 0;
                for (GenNode next : diagram.getAllNodes()) {
                    for (GenCompartment nextCompartment : next.getCompartments()) {
                        ++this.myCompartmentsTotalCount;
                        nextCompartment.eSet(this.myGenCompartmentFeature, (Object)this.myExpectedValue);
                    }
                }
                CompartmentChange.assertTrue((this.myCompartmentsTotalCount > 0 ? 1 : 0) != 0);
            }

            public final void assertChangesPreserved(GenEditorGenerator current) {
                GenDiagram diagram = current.getDiagram();
                CompartmentChange.assertFalse((boolean)diagram.getChildNodes().isEmpty());
                CompartmentChange.assertFalse((boolean)diagram.getTopLevelNodes().isEmpty());
                int actualCompartmentsTotalCount = 0;
                for (GenNode next : diagram.getAllNodes()) {
                    for (GenCompartment nextCompartment : next.getCompartments()) {
                        ++actualCompartmentsTotalCount;
                        Boolean actualValue = (Boolean)nextCompartment.eGet(this.myGenCompartmentFeature);
                        CompartmentChange.assertEquals((String)this.getChangeDescription(), (Object)this.myExpectedValue, (Object)actualValue);
                    }
                }
                CompartmentChange.assertEquals((int)this.myCompartmentsTotalCount, (int)actualCompartmentsTotalCount);
            }

            public ReconcilerConfigBase getReconcilerConfig() {
                return new GMFGenConfig();
            }

            private String getChangeDescription() {
                return "CompartmentChange: " + this.myGenCompartmentFeature.getName() + ":" + this.myExpectedValue;
            }
        }
        this.checkUserChange(new CompartmentChange((EStructuralFeature)GMFGEN.getGenCompartment_HideIfEmpty(), true));
        this.checkUserChange(new CompartmentChange((EStructuralFeature)GMFGEN.getGenCompartment_HideIfEmpty(), false));
        this.checkUserChange(new CompartmentChange((EStructuralFeature)GMFGEN.getGenCompartment_ListLayout(), false));
    }

    public void testReconcileGenNodes() throws Exception {
        class ListLayoutChange
        extends Assert
        implements UserChange {
            private final String NEW_CANONICAL_EP = "MyCanonicalPolicy";
            private final String NEW_GRAPHICAL_EP = "MyGraphicalPolicy";
            private final String BAD_CANONICAL_EP = "MyCanonicalEditPolicy";
            private final String BAD_GRAPHICAL_EP = "MyGraphicalNodeEditPolicy";

            ListLayoutChange() {
            }

            public void applyChanges(GenEditorGenerator old) {
                EList oldNodes = old.getDiagram().getTopLevelNodes();
                ListLayoutChange.assertTrue((oldNodes.size() > 1 ? 1 : 0) != 0);
                GenNode nodeA = (GenNode)oldNodes.get(0);
                GenNode nodeB = (GenNode)oldNodes.get(1);
                nodeA.setCanonicalEditPolicyClassName("MyCanonicalPolicy");
                nodeA.setGraphicalNodeEditPolicyClassName("MyGraphicalPolicy");
                nodeB.setCanonicalEditPolicyClassName("MyCanonicalEditPolicy");
                nodeB.setGraphicalNodeEditPolicyClassName("MyGraphicalNodeEditPolicy");
            }

            public void assertChangesPreserved(GenEditorGenerator current) {
                EList currentNodes = current.getDiagram().getTopLevelNodes();
                ListLayoutChange.assertTrue((currentNodes.size() > 1 ? 1 : 0) != 0);
                GenNode nodeA = (GenNode)currentNodes.get(0);
                GenNode nodeB = (GenNode)currentNodes.get(1);
                ListLayoutChange.assertEquals((String)"MyCanonicalPolicy", (String)nodeA.getCanonicalEditPolicyClassName());
                ListLayoutChange.assertEquals((String)"MyGraphicalPolicy", (String)nodeA.getGraphicalNodeEditPolicyClassName());
                ListLayoutChange.assertEquals((String)"MyCanonicalEditPolicy", (String)nodeB.getCanonicalEditPolicyClassName());
                ListLayoutChange.assertEquals((String)"MyGraphicalNodeEditPolicy", (String)nodeB.getGraphicalNodeEditPolicyClassName());
            }

            public ReconcilerConfigBase getReconcilerConfig() {
                return new GMFGenConfig();
            }
        }
        this.checkUserChange(new ListLayoutChange());
    }

    public void testReconcileGenDiagram() {
        GMFGenPackage GMF = GMFGenPackage.eINSTANCE;
        final class DiagramChange
        extends SingleChange {
            public DiagramChange(EAttribute attribute, String valueToSet) {
                super(attribute, valueToSet);
            }

            public DiagramChange(EAttribute attribute, boolean valueToSet) {
                super(attribute, valueToSet);
            }

            protected EObject findChangeSubject(GenEditorGenerator root) {
                return root.getDiagram();
            }
        }
        this.checkUserChange(new DiagramChange(GMF.getGenDiagram_Synchronized(), true));
        this.checkUserChange(new DiagramChange(GMF.getGenDiagram_Synchronized(), false));
        this.checkUserChange(new DiagramChange(GMF.getEditorCandies_CreationWizardIconPath(), null));
        this.checkUserChange(new DiagramChange(GMF.getEditorCandies_CreationWizardIconPath(), ""));
        this.checkUserChange(new DiagramChange(GMF.getEditorCandies_CreationWizardIconPath(), "\\..\\a\\B\\c"));
        this.checkUserChange(new DiagramChange(GMF.getEditorCandies_CreationWizardIconPath(), "http://localhost:8080/"));
        this.checkUserChange(new DiagramChange(GMF.getEditorCandies_CreationWizardCategoryID(), null));
        this.checkUserChange(new DiagramChange(GMF.getEditorCandies_CreationWizardCategoryID(), ""));
        this.checkUserChange(new DiagramChange(GMF.getEditorCandies_CreationWizardCategoryID(), "   "));
        this.checkUserChange(new DiagramChange(GMF.getEditorCandies_CreationWizardCategoryID(), "org.eclipse.ui.Examples"));
        this.checkUserChange(new DiagramChange(GMF.getEditorCandies_CreationWizardCategoryID(), "com.myCompany.TheBestCategory"));
    }

    public void testReconcileGenDiagram_Shortcuts() {
        String[] PROVIDED_FOR = new String[]{"ModelA", "ModelB", "ModelC"};
        String[] CONTAINS_TO = new String[]{"txt", "mdm", "taipan"};
        String[] EMPTY = new String[]{};
        class ShortcutChange
        extends Assert
        implements UserChange {
            private final String[] myProvidedFor;
            private final String[] myContainsTo;

            public ShortcutChange(String[] providedFor, String[] containsTo) {
                this.myProvidedFor = providedFor;
                this.myContainsTo = containsTo;
            }

            public void applyChanges(GenEditorGenerator old) {
                GenDiagram diagram = old.getDiagram();
                ShortcutChange.assertNotNull((Object)diagram);
                diagram.getShortcutsProvidedFor().addAll((Collection)Arrays.asList(this.myProvidedFor));
                diagram.getContainsShortcutsTo().addAll((Collection)Arrays.asList(this.myContainsTo));
                ShortcutChange.assertEquals(Arrays.asList(this.myProvidedFor), (Object)diagram.getShortcutsProvidedFor());
                ShortcutChange.assertEquals(Arrays.asList(this.myContainsTo), (Object)diagram.getContainsShortcutsTo());
            }

            public void assertChangesPreserved(GenEditorGenerator current) {
                GenDiagram diagram = current.getDiagram();
                ShortcutChange.assertEquals(Arrays.asList(this.myProvidedFor), (Object)diagram.getShortcutsProvidedFor());
                ShortcutChange.assertEquals(Arrays.asList(this.myContainsTo), (Object)diagram.getContainsShortcutsTo());
            }

            public ReconcilerConfigBase getReconcilerConfig() {
                return new GMFGenConfig();
            }
        }
        ShortcutChange someChange = new ShortcutChange(PROVIDED_FOR, CONTAINS_TO);
        ShortcutChange emptyChange = new ShortcutChange(EMPTY, EMPTY);
        this.checkUserChange(someChange);
        this.checkUserChange(emptyChange);
    }

    public void testReconcileGenEditorGenerator_LimitedConfig() throws Exception {
        class UserChangeImpl
        extends Assert
        implements UserChange {
            private boolean mySameFile;
            private final boolean myExpectingCopyrightPreserved;

            public UserChangeImpl(boolean reconcileCopyright) {
                this.myExpectingCopyrightPreserved = reconcileCopyright;
            }

            public void applyChanges(GenEditorGenerator old) {
                old.setCopyrightText("AAA");
                old.setPackageNamePrefix("BBB");
                old.setDiagramFileExtension("CCC");
                this.mySameFile = !old.isSameFileForDiagramAndModel();
                old.setSameFileForDiagramAndModel(this.mySameFile);
                old.setTemplateDirectory("DDD");
                UserChangeImpl.assertEquals((String)"DDD", (String)old.getTemplateDirectory());
            }

            public void assertChangesPreserved(GenEditorGenerator current) {
                if (this.myExpectingCopyrightPreserved) {
                    UserChangeImpl.assertEquals((String)"AAA", (String)current.getCopyrightText());
                } else {
                    UserChangeImpl.assertFalse((boolean)"AAA".equals(current.getCopyrightText()));
                }
                UserChangeImpl.assertEquals((String)"BBB", (String)current.getPackageNamePrefix());
                UserChangeImpl.assertEquals((String)"CCC", (String)current.getDiagramFileExtension());
                UserChangeImpl.assertEquals((boolean)this.mySameFile, (boolean)current.isSameFileForDiagramAndModel());
                UserChangeImpl.assertFalse((boolean)"DDD".equals(current.getTemplateDirectory()));
            }

            public ReconcilerConfigBase getReconcilerConfig() {
                return new LimitedGMFGenConfig(this.myExpectingCopyrightPreserved);
            }
        }
        this.checkUserChange(new UserChangeImpl(false));
        this.checkUserChange(new UserChangeImpl(true));
    }

    public void testReconcileGenEditorGenerator() {
        class DynamicTemplatesChange
        extends GenEditorGeneratorChange {
            public DynamicTemplatesChange(boolean value) {
                class GenEditorGeneratorChange
                extends SingleChange {
                    public GenEditorGeneratorChange(EAttribute attribute, boolean expectedValue) {
                        super(attribute, expectedValue);
                    }

                    public GenEditorGeneratorChange(EAttribute attribute, Object expectedValue) {
                        super(attribute, expectedValue);
                    }

                    protected final EObject findChangeSubject(GenEditorGenerator root) {
                        return root;
                    }
                }
                super(GMFGenPackage.eINSTANCE.getGenEditorGenerator_DynamicTemplates(), value);
            }
        }
        this.checkUserChange(new DynamicTemplatesChange(true));
        this.checkUserChange(new DynamicTemplatesChange(false));
        class TemplateDirectoryChange
        extends GenEditorGeneratorChange {
            public TemplateDirectoryChange(String value) {
                super(GMFGenPackage.eINSTANCE.getGenEditorGenerator_TemplateDirectory(), value);
            }
        }
        this.checkUserChange(new TemplateDirectoryChange(null));
        this.checkUserChange(new TemplateDirectoryChange(""));
        this.checkUserChange(new TemplateDirectoryChange("\\a\\b\\c"));
        this.checkUserChange(new TemplateDirectoryChange("c:/my-folder/my templates with space/"));
        class ModelIdChange
        extends GenEditorGeneratorChange {
            public ModelIdChange(String value) {
                super(GMFGenPackage.eINSTANCE.getGenEditorGenerator_ModelID(), value);
            }
        }
        this.checkUserChange(new ModelIdChange("ABC"));
        this.checkUserChange(new ModelIdChange("ABC   "));
        this.checkUserChange(new ModelIdChange(""));
        this.checkUserChange(new ModelIdChange(" "));
        this.checkUserChange(new ModelIdChange(null));
        this.checkUserChange(new GenEditorGeneratorChange(GMFGenPackage.eINSTANCE.getGenEditorGenerator_DomainFileExtension(), "xxx"));
        this.checkUserChange(new UserChange(){

            public void applyChanges(GenEditorGenerator old) {
                CodegenReconcileTest.assertNotNull((Object)old.getNavigator());
                old.setNavigator(null);
            }

            public void assertChangesPreserved(GenEditorGenerator current) {
                CodegenReconcileTest.assertNull((Object)current.getNavigator());
            }

            public ReconcilerConfigBase getReconcilerConfig() {
                return new GMFGenConfig();
            }
        });
    }

    public void testReconcileGenEditorView() {
        GMFGenPackage GMF = GMFGenPackage.eINSTANCE;
        final class EditorChange
        extends SingleChange {
            public EditorChange(EAttribute attribute, String valueToSet) {
                super(attribute, valueToSet);
            }

            protected EObject findChangeSubject(GenEditorGenerator root) {
                return root.getEditor();
            }
        }
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_IconPath(), null));
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_IconPath(), ""));
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_IconPath(), "//a//b//c"));
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_IconPath(), "c:\\myIconsFolder"));
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_ClassName(), null));
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_ClassName(), ""));
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_ClassName(), "MyClass"));
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_ClassName(), "org.eclipse.MyClass"));
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_ID(), null));
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_ID(), ""));
        this.checkUserChange(new EditorChange(GMF.getGenEditorView_ID(), "my.editor.id"));
    }

    public void testReconcileViewmapAttributes() {
        class DefaultSizeChange
        extends 1AbstractAttributesChange {
            private static final int HEIGHT = 23;
            private static final int WIDTH = 32;

            DefaultSizeChange() {
                abstract class AbstractAttributesChange
                implements UserChange {
                    private int myAffectedViewmapsCount;

                    AbstractAttributesChange() {
                    }

                    protected abstract Attributes findAttributes(Viewmap var1);

                    protected abstract Attributes createUserAttributes();

                    protected abstract void assertChanges(Attributes var1);

                    public final void applyChanges(GenEditorGenerator old) {
                        this.myAffectedViewmapsCount = 0;
                        for (GenNode next : old.getDiagram().getAllNodes()) {
                            Viewmap nextViewmap = next.getViewmap();
                            if (nextViewmap == null) continue;
                            Attributes attributes = this.findAttributes(nextViewmap);
                            CodegenReconcileTest.assertNull((String)"Reconciler is intended to work with attributes that are created only by user", (Object)attributes);
                            attributes = this.createUserAttributes();
                            nextViewmap.getAttributes().add((Object)attributes);
                            ++this.myAffectedViewmapsCount;
                        }
                        CodegenReconcileTest.assertTrue((this.myAffectedViewmapsCount > 0 ? 1 : 0) != 0);
                    }

                    public final void assertChangesPreserved(GenEditorGenerator current) {
                        int checkedViewmapsCount = 0;
                        for (GenNode next : current.getDiagram().getAllNodes()) {
                            Viewmap nextViewmap = next.getViewmap();
                            if (nextViewmap == null) continue;
                            Attributes attributes = this.findAttributes(nextViewmap);
                            CodegenReconcileTest.assertNotNull((Object)attributes);
                            this.assertChanges(attributes);
                            ++checkedViewmapsCount;
                        }
                        CodegenReconcileTest.assertEquals((int)this.myAffectedViewmapsCount, (int)checkedViewmapsCount);
                    }

                    public final ReconcilerConfigBase getReconcilerConfig() {
                        return new GMFGenConfig();
                    }
                }
            }

            protected void assertChanges(Attributes attributes) {
                DefaultSizeAttributes defaultSize = (DefaultSizeAttributes)attributes;
                CodegenReconcileTest.assertEquals((int)23, (int)defaultSize.getHeight());
                CodegenReconcileTest.assertEquals((int)32, (int)defaultSize.getWidth());
            }

            protected Attributes createUserAttributes() {
                DefaultSizeAttributes defaultSize = GMFGenFactory.eINSTANCE.createDefaultSizeAttributes();
                defaultSize.setHeight(23);
                defaultSize.setWidth(32);
                return defaultSize;
            }

            protected Attributes findAttributes(Viewmap viewmap) {
                return viewmap.find(DefaultSizeAttributes.class);
            }
        }
        this.checkUserChange(new DefaultSizeChange());
    }

    public void testReconcileMetamodelType() {
        class DisplayNameChange
        extends 1ElementTypeChange {
            private final String myValue;

            public DisplayNameChange(String value) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                abstract class ElementTypeChange
                implements UserChange {
                    ElementTypeChange() {
                    }

                    protected abstract void applyChange(ElementType var1);

                    protected abstract void assertChange(ElementType var1);

                    protected Collection<GenContainerBase> collectSubjects(GenEditorGenerator editorGenerator) {
                        LinkedList<GenContainerBase> allWithType = new LinkedList<GenContainerBase>();
                        GenDiagram diagram = editorGenerator.getDiagram();
                        allWithType.add((GenContainerBase)diagram);
                        allWithType.addAll((Collection<GenContainerBase>)diagram.getAllChildContainers());
                        return allWithType;
                    }

                    @Override
                    public final void applyChanges(GenEditorGenerator old) {
                        for (GenCommonBase genCommonBase : this.collectSubjects(old)) {
                            ElementType nextElementType = genCommonBase.getElementType();
                            if (nextElementType == null) continue;
                            this.applyChange(nextElementType);
                        }
                    }

                    @Override
                    public final void assertChangesPreserved(GenEditorGenerator current) {
                        for (GenCommonBase genCommonBase : this.collectSubjects(current)) {
                            ElementType nextElementType = genCommonBase.getElementType();
                            if (nextElementType == null) continue;
                            this.assertChange(nextElementType);
                        }
                    }

                    @Override
                    public final ReconcilerConfigBase getReconcilerConfig() {
                        return new GMFGenConfig();
                    }

                    protected String toString(ElementType elementType) {
                        return String.valueOf(elementType);
                    }
                }
                this.myValue = value;
            }

            protected void applyChange(ElementType elementType) {
                elementType.setDisplayName(this.myValue);
            }

            protected void assertChange(ElementType elementType) {
                CodegenReconcileTest.assertEquals((String)this.toString(elementType), (String)this.myValue, (String)elementType.getDisplayName());
            }
        }
        this.checkUserChange(new DisplayNameChange("ABCD"));
        class DefinedExternallyChange
        extends 1ElementTypeChange {
            private boolean myValue;

            public DefinedExternallyChange(boolean value) {
                this.myValue = value;
            }

            protected void applyChange(ElementType elementType) {
                elementType.setDefinedExternally(this.myValue);
            }

            protected void assertChange(ElementType elementType) {
                CodegenReconcileTest.assertEquals((String)this.toString(elementType), (boolean)this.myValue, (boolean)elementType.isDefinedExternally());
            }
        }
        this.checkUserChange(new DefinedExternallyChange(true));
        this.checkUserChange(new DefinedExternallyChange(false));
    }

    public void testGenNavigator() {
        class DomainNavigatorRemovingChange
        implements UserChange {
            DomainNavigatorRemovingChange() {
            }

            public void applyChanges(GenEditorGenerator old) {
                CodegenReconcileTest.assertNotNull((Object)old.getNavigator());
                old.getNavigator().setGenerateDomainModelNavigator(false);
            }

            public void assertChangesPreserved(GenEditorGenerator current) {
                CodegenReconcileTest.assertFalse((boolean)current.getNavigator().isGenerateDomainModelNavigator());
            }

            public ReconcilerConfigBase getReconcilerConfig() {
                return new GMFGenConfig();
            }
        }
        this.checkUserChange(new DomainNavigatorRemovingChange());
        GMFGenPackage gmfGenPackage = GMFGenPackage.eINSTANCE;
        class NavigatorChange
        extends SingleChange {
            public NavigatorChange(EAttribute attribute, String valueToSet) {
                super(attribute, valueToSet);
            }

            protected EObject findChangeSubject(GenEditorGenerator root) {
                CodegenReconcileTest.assertNotNull((Object)root.getNavigator());
                return root.getNavigator();
            }
        }
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenDomainModelNavigator_DomainContentExtensionID(), "customId"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenDomainModelNavigator_DomainContentExtensionName(), "customName"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenDomainModelNavigator_DomainContentExtensionPriority(), "customPriorityName"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenDomainModelNavigator_DomainContentProviderClassName(), "CustomContentProvider"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenDomainModelNavigator_DomainLabelProviderClassName(), "CustomLabelProvider"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenDomainModelNavigator_DomainModelElementTesterClassName(), "CustomModelElementTester"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenDomainModelNavigator_DomainNavigatorItemClassName(), "CustomNavigatorItem"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_ContentExtensionID(), "customID"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_ContentExtensionName(), "customName"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_ContentExtensionPriority(), "customPriority"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_LinkHelperExtensionID(), "customID"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_SorterExtensionID(), "customID"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_ActionProviderID(), "customID"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_ContentProviderClassName(), "CustomContentProvider"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_LabelProviderClassName(), "CustomLabelProvider"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_LinkHelperClassName(), "CustomLinkHelper"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_SorterClassName(), "CustomSorter"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_ActionProviderClassName(), "CustomActionProvider"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_AbstractNavigatorItemClassName(), "CustomAbstractNavigator"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_NavigatorGroupClassName(), "CustomNavigatorGroup"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_NavigatorItemClassName(), "CustomItemClass"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_UriInputTesterClassName(), "CustomURITester"));
        this.checkUserChange(new NavigatorChange(gmfGenPackage.getGenNavigator_PackageName(), "customPackage"));
    }

    private void checkUserChange(UserChange userChange) {
        GenEditorGenerator old = this.createCopy();
        GenEditorGenerator current = this.createCopy();
        userChange.applyChanges(old);
        new Reconciler((ReconcilerConfig)userChange.getReconcilerConfig()).reconcileTree((EObject)current, (EObject)old);
        userChange.assertChangesPreserved(current);
    }

    private static class LimitedGMFGenConfig
    extends ReconcilerConfigBase {
        public LimitedGMFGenConfig(boolean reconcileCopyright) {
            GMFGenPackage GMFGEN = GMFGenPackage.eINSTANCE;
            this.setMatcher(GMFGEN.getGenEditorGenerator(), ALWAYS_MATCH);
            if (reconcileCopyright) {
                this.preserveIfSet(GMFGEN.getGenEditorGenerator(), GMFGEN.getGenEditorGenerator_CopyrightText());
            }
            this.preserveIfSet(GMFGEN.getGenEditorGenerator(), GMFGEN.getGenEditorGenerator_PackageNamePrefix());
            this.preserveIfSet(GMFGEN.getGenEditorGenerator(), GMFGEN.getGenEditorGenerator_DiagramFileExtension());
            this.preserveIfSet(GMFGEN.getGenEditorGenerator(), GMFGEN.getGenEditorGenerator_SameFileForDiagramAndModel());
            this.setMatcher(GMFGEN.getGenPlugin(), ALWAYS_MATCH);
            this.preserveIfSet(GMFGEN.getGenPlugin(), GMFGEN.getGenPlugin_Provider());
            this.preserveIfSet(GMFGEN.getGenPlugin(), GMFGEN.getGenPlugin_Version());
        }

        private void preserveIfSet(EClass eClass, EAttribute feature) {
            this.addDecision(eClass, (Decision)new DefaultDecision((EStructuralFeature)feature));
        }
    }

    private static abstract class SingleChange
    implements UserChange {
        private final EAttribute myAttribute;
        private final Object myValueToSet;
        private Object myExpectedValue;

        public SingleChange(EAttribute attribute, boolean valueToSet) {
            this(attribute, (Object)valueToSet);
        }

        public SingleChange(EAttribute attribute, Object valueToSet) {
            this.myAttribute = attribute;
            this.myValueToSet = valueToSet;
        }

        protected abstract EObject findChangeSubject(GenEditorGenerator var1);

        public void applyChanges(GenEditorGenerator old) {
            EObject subject = this.findChangeSubject(old);
            CodegenReconcileTest.assertNotNull((Object)subject);
            subject.eSet((EStructuralFeature)this.myAttribute, this.myValueToSet);
            this.myExpectedValue = subject.eGet((EStructuralFeature)this.myAttribute);
        }

        public void assertChangesPreserved(GenEditorGenerator current) {
            EObject subject = this.findChangeSubject(current);
            CodegenReconcileTest.assertNotNull((Object)subject);
            CodegenReconcileTest.assertEquals((Object)this.myExpectedValue, (Object)subject.eGet((EStructuralFeature)this.myAttribute));
        }

        public ReconcilerConfigBase getReconcilerConfig() {
            return new GMFGenConfig();
        }
    }

    private static interface UserChange {
        public void applyChanges(GenEditorGenerator var1);

        public void assertChangesPreserved(GenEditorGenerator var1);

        public ReconcilerConfigBase getReconcilerConfig();
    }
}

