/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.GenProjectBaseSetup;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class GenProjectSetup
extends GenProjectBaseSetup {
    private ArrayList<Bundle> myAllInstalledBundes = new ArrayList();
    private Bundle myBundle;
    private final boolean myIsFullRuntimeRun;

    public GenProjectSetup(GeneratorConfiguration generatorFactory) {
        super(generatorFactory);
        this.myIsFullRuntimeRun = generatorFactory instanceof RuntimeBasedGeneratorConfiguration;
    }

    public GenProjectSetup init(DiaGenSource diaGenSource) throws BundleException {
        final boolean[] extensionChangeNotification = new boolean[]{true};
        IRegistryChangeListener listener = new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                extensionChangeNotification[0] = false;
            }
        };
        try {
            try {
                if (this.myIsFullRuntimeRun) {
                    RegistryFactory.getRegistry().addRegistryChangeListener(listener, "org.eclipse.gmf.runtime.emf.type.core");
                } else {
                    RegistryFactory.getRegistry().addRegistryChangeListener(listener, "org.eclipse.ui");
                }
                this.myBundle = null;
                super.generateAndCompile(diaGenSource);
                this.myBundle.start();
                this.registerExtensions(this.myBundle);
                this.registerEMFEditExtensions();
                this.monitorExtensionLoad(extensionChangeNotification, 60);
                this.disabledNoExprImplDebugOption();
            }
            catch (BundleException ex) {
                throw ex;
            }
            catch (Exception ex) {
                Assert.fail((String)(String.valueOf(ex.getClass().getSimpleName()) + ":" + ex.getMessage()));
                RegistryFactory.getRegistry().removeRegistryChangeListener(listener);
            }
        }
        finally {
            RegistryFactory.getRegistry().removeRegistryChangeListener(listener);
        }
        return this;
    }

    private void monitorExtensionLoad(boolean[] flag, int timeoutSeconds) {
        if (Display.getCurrent() != null && !Utils.dispatchDisplayMessages(flag, timeoutSeconds)) {
            Plugin.logError("Timeout while waiting for extension point registry to refresh !!!");
        }
    }

    protected void hookProjectBuild(IProject p) throws Exception {
        super.hookProjectBuild(p);
        try {
            String url = p.getLocation().toFile().toURL().toExternalForm();
            this.myBundle = Plugin.getBundleContext().installBundle(url);
            this.myAllInstalledBundes.add(this.myBundle);
        }
        catch (MalformedURLException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    private void registerExtensions(Bundle bundle) {
        IConfigurationElement[] configElements = this.getConfigurationElements(bundle.getSymbolicName(), "org.eclipse.emf.ecore.extension_parser");
        int i = 0;
        while (i < configElements.length) {
            try {
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(configElements[i].getAttribute("type"), configElements[i].createExecutableExtension("class"));
            }
            catch (InvalidRegistryObjectException e) {
                Assert.fail((String)e.getMessage());
            }
            catch (CoreException e) {
                Assert.fail((String)e.getMessage());
            }
            ++i;
        }
    }

    private void registerEMFEditExtensions() {
        for (Bundle next : this.myAllInstalledBundes) {
            IConfigurationElement[] configElements = this.getConfigurationElements(next.getSymbolicName(), "org.eclipse.emf.edit.itemProviderAdapterFactories");
            int i = 0;
            while (i < configElements.length) {
                IConfigurationElement element = configElements[i];
                if (element.getName().equals("factory")) {
                    String packageURI = element.getAttribute("uri");
                    String className = element.getAttribute("class");
                    String supportedTypes = element.getAttribute("supportedTypes");
                    if (packageURI != null && className != null && supportedTypes != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(supportedTypes);
                        while (stringTokenizer.hasMoreTokens()) {
                            String supportedType = stringTokenizer.nextToken();
                            ArrayList<String> key = new ArrayList<String>();
                            key.add(packageURI);
                            key.add(supportedType);
                            class PluginAdapterFactoryDescriptor
                            extends RegistryReader.PluginClassDescriptor
                            implements ComposedAdapterFactory.Descriptor {
                                public PluginAdapterFactoryDescriptor(IConfigurationElement element, String attributeName) {
                                    super(element, attributeName);
                                }

                                public AdapterFactory createAdapterFactory() {
                                    return (AdapterFactory)this.createInstance();
                                }
                            }
                            ((ComposedAdapterFactory.Descriptor.Registry.Impl)ComposedAdapterFactory.Descriptor.Registry.INSTANCE).put(key, (Object)new PluginAdapterFactoryDescriptor(element, "class"));
                        }
                    }
                }
                ++i;
            }
        }
    }

    private IConfigurationElement[] getConfigurationElements(String bundlID, String extensionPointID) {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointID);
        LinkedList<IConfigurationElement> ownConfigs = new LinkedList<IConfigurationElement>();
        int i = 0;
        while (i < configs.length) {
            if (bundlID.equals(configs[i].getContributor().getName())) {
                ownConfigs.add(configs[i]);
            }
            ++i;
        }
        return ownConfigs.toArray(new IConfigurationElement[ownConfigs.size()]);
    }

    public final Bundle getBundle() {
        assert (this.myBundle != null) : "GenProjectSetup was not initialized";
        return this.myBundle;
    }

    public void uninstall() throws Exception {
        for (Bundle next : this.myAllInstalledBundes) {
            next.uninstall();
        }
    }

    private void disabledNoExprImplDebugOption() {
        String disabledNoExprImplDebugOpt = Platform.getDebugOption((String)(String.valueOf(Plugin.getInstance().getBundle().getSymbolicName()) + "/disableNoExprImplExceptionLog"));
        if (disabledNoExprImplDebugOpt != null) {
            ServiceTracker debugTracker = new ServiceTracker(Plugin.getBundleContext(), DebugOptions.class.getName(), null);
            debugTracker.open();
            DebugOptions debugOptions = (DebugOptions)debugTracker.getService();
            if (debugOptions != null) {
                debugOptions.setOption(String.valueOf(this.getBundle().getSymbolicName()) + "/debug/disableNoExprImplExceptionLog", disabledNoExprImplDebugOpt);
            }
            debugTracker.close();
        }
    }
}

