/*
 * Copyright (c) 2005 Borland Software Corporation
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Karen Shaglamdjan (Borland) - initial API and implementation
 */
package org.eclipse.gmf.tests.setup;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class DomainModelFileSetup implements DomainModelSource {

	private EPackage myModelPackage;

	public DomainModelSource init(URI sourceURI) {
		ResourceSet srcResSet = new ResourceSetImpl();
		Resource srcRes = srcResSet.getResource(sourceURI, true);
		myModelPackage = (EPackage) srcRes.getContents().get(0);
		return this;
	}

	public EPackage getModel() {
		return myModelPackage;
	}

	public EClass getDiagramElement() {
		return null;
	}

	public LinkData getLinkAsClass() {
		return null;
	}

	public EReference getLinkAsRef() {
		return null;
	}

	public NodeData getNodeA() {
		return null;
	}

	public NodeData getNodeB() {
		return null;
	}
}
