/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class CollectionKind
extends AbstractEnumerator {
    public static final String copyright = "";
    public static final int COLLECTION = 1;
    public static final int SET = 2;
    public static final int ORDERED_SET = 5;
    public static final int BAG = 3;
    public static final int SEQUENCE = 4;
    public static final CollectionKind COLLECTION_LITERAL = new CollectionKind(1, "collection", "collection");
    public static final CollectionKind SET_LITERAL = new CollectionKind(2, "set", "set");
    public static final CollectionKind ORDERED_SET_LITERAL = new CollectionKind(5, "orderedSet", "orderedSet");
    public static final CollectionKind BAG_LITERAL = new CollectionKind(3, "bag", "bag");
    public static final CollectionKind SEQUENCE_LITERAL = new CollectionKind(4, "sequence", "sequence");
    private static final CollectionKind[] VALUES_ARRAY = new CollectionKind[]{COLLECTION_LITERAL, SET_LITERAL, BAG_LITERAL, SEQUENCE_LITERAL, ORDERED_SET_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static CollectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind get(int value) {
        switch (value) {
            case 1: {
                return COLLECTION_LITERAL;
            }
            case 2: {
                return SET_LITERAL;
            }
            case 5: {
                return ORDERED_SET_LITERAL;
            }
            case 3: {
                return BAG_LITERAL;
            }
            case 4: {
                return SEQUENCE_LITERAL;
            }
        }
        return null;
    }

    private CollectionKind(int value, String name, String literal) {
        super(value, name, literal);
    }
}

