/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.expressions.impl;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ocl.expressions.AssociationClassCallExp;
import org.eclipse.emf.ocl.expressions.BooleanLiteralExp;
import org.eclipse.emf.ocl.expressions.CollectionItem;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.CollectionLiteralExp;
import org.eclipse.emf.ocl.expressions.CollectionLiteralPart;
import org.eclipse.emf.ocl.expressions.CollectionRange;
import org.eclipse.emf.ocl.expressions.EnumLiteralExp;
import org.eclipse.emf.ocl.expressions.EvaluationVisitor;
import org.eclipse.emf.ocl.expressions.IfExp;
import org.eclipse.emf.ocl.expressions.IntegerLiteralExp;
import org.eclipse.emf.ocl.expressions.InvalidLiteralExp;
import org.eclipse.emf.ocl.expressions.IterateExp;
import org.eclipse.emf.ocl.expressions.IteratorExp;
import org.eclipse.emf.ocl.expressions.LetExp;
import org.eclipse.emf.ocl.expressions.MessageExp;
import org.eclipse.emf.ocl.expressions.NullLiteralExp;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.OperationCallExp;
import org.eclipse.emf.ocl.expressions.PropertyCallExp;
import org.eclipse.emf.ocl.expressions.RealLiteralExp;
import org.eclipse.emf.ocl.expressions.StateExp;
import org.eclipse.emf.ocl.expressions.StringLiteralExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralPart;
import org.eclipse.emf.ocl.expressions.TypeExp;
import org.eclipse.emf.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.expressions.VariableExp;
import org.eclipse.emf.ocl.expressions.impl.EvaluationVisitorImpl;
import org.eclipse.emf.ocl.expressions.impl.IterationTempateExists;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplate;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplateAny;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplateClosure;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplateCollect;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplateCollectNested;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplateForAll;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplateIsUnique;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplateOne;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplateReject;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplateSelect;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplateSortedBy;
import org.eclipse.emf.ocl.expressions.util.AbstractVisitor;
import org.eclipse.emf.ocl.expressions.util.EvalEnvironment;
import org.eclipse.emf.ocl.internal.OCLPlugin;
import org.eclipse.emf.ocl.internal.l10n.OCLMessages;
import org.eclipse.emf.ocl.parser.EvaluationEnvironment;
import org.eclipse.emf.ocl.types.BagType;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.OrderedSetType;
import org.eclipse.emf.ocl.types.PrimitiveType;
import org.eclipse.emf.ocl.types.SequenceType;
import org.eclipse.emf.ocl.types.SetType;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.PrimitiveTypeImpl;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.emf.ocl.uml.Constraint;
import org.eclipse.emf.ocl.utilities.PredefinedType;
import org.eclipse.emf.ocl.utilities.impl.CollectionFactory;

public class EvaluationVisitorImpl
extends AbstractVisitor
implements EvaluationVisitor {
    private EvaluationEnvironment env;
    private Map extentMap;
    private static int tempCounter = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static EvaluationVisitor getInstance(EvaluationEnvironment env, Map extentMap) {
        return new EvaluationVisitorImpl(env, extentMap);
    }

    private EvaluationVisitorImpl() {
    }

    private EvaluationVisitorImpl(EvaluationEnvironment env, Map extentMap) {
        this.env = env;
        this.extentMap = extentMap;
    }

    public EvaluationEnvironment getEvalEnvironment() {
        return this.env;
    }

    public Map getExtentMap() {
        return this.extentMap;
    }

    public void setEvalEnvironment(EvaluationEnvironment newEnv) {
        this.env = newEnv;
    }

    public void setExtentMap(Map extentMap) {
        this.extentMap = extentMap;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (evaluation environment: ");
        result.append(this.env);
        result.append(')');
        return result.toString();
    }

    static boolean isUndefined(Object value) {
        return value == null || value == Types.OCL_INVALID;
    }

    public Object visitOperationCallExp(OperationCallExp oc) {
        OCLExpression arg;
        Object evalArgs;
        Object sourceVal;
        OCLExpression source = oc.getSource();
        EClassifier sourceType = source.getType();
        EOperation oper = oc.getReferredOperation();
        int opCode = oc.getOperationCode();
        EList args = oc.getArgument();
        int numArgs = args.size();
        OCLExpression body = this.getBody((ETypedElement)oper);
        if (body != null || this.getEvalEnvironment().canEvaluate(oper, opCode)) {
            sourceVal = source.accept(this);
            evalArgs = new Object[numArgs];
            int i = 0;
            Iterator it = args.iterator();
            while (it.hasNext()) {
                OCLExpression arg2 = (OCLExpression)it.next();
                evalArgs[i] = arg2.accept(this);
                ++i;
            }
            try {
                Object result = body != null ? this.invoke(oper, body, sourceVal, (Object[])evalArgs) : this.getEvalEnvironment().evaluate(oper, opCode, sourceVal, (Object[])evalArgs);
                return result;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception e) {
                OCLPlugin.catching(this.getClass(), "visitOperationCallExp", e);
                OCLPlugin.log(4, 10, OCLMessages.bind(OCLMessages.ErrorMessage_ERROR_, "visitOperationCallExp", e.getLocalizedMessage()), e);
                return Types.OCL_INVALID;
            }
        }
        if (opCode == 60) {
            sourceVal = source.accept(this);
            arg = (OCLExpression)args.get(0);
            Object argVal = arg.accept(this);
            return AnyTypeImpl.equal(sourceVal, argVal);
        }
        if (opCode == 61) {
            Object argVal;
            sourceVal = source.accept(this);
            return !AnyTypeImpl.equal(sourceVal, argVal = (arg = (OCLExpression)args.get(0)).accept(this));
        }
        if (sourceType instanceof PrimitiveType || sourceType instanceof CollectionType || sourceType instanceof EEnum || sourceType instanceof EDataType || sourceType == Types.OCL_VOID || sourceType == Types.INVALID) {
            if (numArgs == 0) {
                sourceVal = source.accept(this);
                if (EvaluationVisitorImpl.isUndefined(sourceVal) && opCode != 65 && opCode != 66) {
                    return Types.OCL_INVALID;
                }
                switch (opCode) {
                    case 2: {
                        if (sourceVal instanceof Integer) {
                            return new Integer(-((Integer)sourceVal).intValue());
                        }
                        return new Double(-((Double)sourceVal).doubleValue());
                    }
                    case 15: {
                        if (sourceVal instanceof Integer) {
                            return new Integer(Math.abs((Integer)sourceVal));
                        }
                        return new Double(Math.abs((Double)sourceVal));
                    }
                    case 26: {
                        Double sourceDoubleVal;
                        if (sourceVal instanceof Double) {
                            sourceDoubleVal = (Double)sourceVal;
                            return new Integer((int)Math.floor(sourceDoubleVal));
                        }
                        return sourceVal;
                    }
                    case 27: {
                        Double sourceDoubleVal;
                        if (sourceVal instanceof Double) {
                            sourceDoubleVal = (Double)sourceVal;
                            return new Integer((int)Math.round(sourceDoubleVal));
                        }
                        return sourceVal;
                    }
                    case 11: {
                        return (Boolean)sourceVal != false ? Boolean.FALSE : Boolean.TRUE;
                    }
                    case 65: {
                        return EvaluationVisitorImpl.isUndefined(sourceVal) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 66: {
                        return sourceVal == Types.OCL_INVALID ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 20: {
                        if (sourceType == Types.OCL_STRING) {
                            return new Integer(((String)sourceVal).length());
                        }
                        if (sourceType instanceof CollectionType) {
                            return new Integer(((Collection)sourceVal).size());
                        }
                    }
                    case 23: {
                        return Integer.valueOf((String)sourceVal);
                    }
                    case 24: {
                        return Double.valueOf((String)sourceVal);
                    }
                    case 28: {
                        return UCharacter.toLowerCase((String)((String)sourceVal));
                    }
                    case 29: {
                        return UCharacter.toUpperCase((String)((String)sourceVal));
                    }
                    case 145: {
                        return ((Collection)sourceVal).isEmpty();
                    }
                    case 146: {
                        return !((Collection)sourceVal).isEmpty();
                    }
                    case 148: {
                        return CollectionTypeImpl.sum((Collection)sourceVal);
                    }
                    case 154: {
                        return CollectionTypeImpl.flatten((Collection)sourceVal);
                    }
                    case 152: {
                        return CollectionTypeImpl.asSet((Collection)sourceVal);
                    }
                    case 149: {
                        return CollectionTypeImpl.asBag((Collection)sourceVal);
                    }
                    case 150: {
                        return CollectionTypeImpl.asOrderedSet((Collection)sourceVal);
                    }
                    case 151: {
                        return CollectionTypeImpl.asSequence((Collection)sourceVal);
                    }
                    case 159: {
                        return CollectionTypeImpl.first((Collection)sourceVal);
                    }
                    case 162: {
                        return CollectionTypeImpl.last((Collection)sourceVal);
                    }
                }
            } else if (numArgs == 1) {
                String message;
                OCLExpression arg3 = (OCLExpression)args.get(0);
                EClassifier argType = arg3.getType();
                Object sourceVal2 = source.accept(this);
                if (opCode == 64) {
                    return this.oclIsTypeOf(sourceVal2, arg3.accept(this));
                }
                if (opCode == 63) {
                    return this.oclIsKindOf(sourceVal2, arg3.accept(this));
                }
                if (opCode == 62) {
                    if (sourceVal2 == null || argType == Types.OCL_VOID) {
                        return null;
                    }
                    if (sourceVal2 == Types.OCL_INVALID || argType == Types.INVALID) {
                        return Types.OCL_INVALID;
                    }
                    if (sourceVal2 instanceof Double && argType == Types.OCL_INTEGER) {
                        return new Integer(((Double)sourceVal2).intValue());
                    }
                    if (sourceVal2 instanceof Integer && argType == Types.OCL_REAL) {
                        return new Double(((Integer)sourceVal2).doubleValue());
                    }
                    return sourceVal2;
                }
                if (EvaluationVisitorImpl.isUndefined(sourceVal2)) {
                    return Types.OCL_INVALID;
                }
                Object argVal = null;
                if (!(sourceVal2 instanceof Boolean)) {
                    argVal = arg3.accept(this);
                }
                if (sourceVal2 instanceof Integer && argVal instanceof Integer) {
                    switch (opCode) {
                        case 1: {
                            return new Integer((Integer)sourceVal2 + (Integer)argVal);
                        }
                        case 2: {
                            return new Integer((Integer)sourceVal2 - (Integer)argVal);
                        }
                        case 3: {
                            return new Integer((Integer)sourceVal2 * (Integer)argVal);
                        }
                        case 4: {
                            double num = ((Integer)sourceVal2).doubleValue();
                            double denom = ((Integer)argVal).doubleValue();
                            return denom == 0.0 ? null : new Double(num / denom);
                        }
                        case 16: {
                            int num = (Integer)sourceVal2;
                            int denom = (Integer)argVal;
                            return denom == 0 ? null : new Integer(num / denom);
                        }
                        case 17: {
                            return new Integer((Integer)sourceVal2 % (Integer)argVal);
                        }
                        case 18: {
                            return new Integer(Math.max((Integer)sourceVal2, (Integer)argVal));
                        }
                        case 19: {
                            return new Integer(Math.min((Integer)sourceVal2, (Integer)argVal));
                        }
                        case 67: {
                            return (Integer)sourceVal2 < (Integer)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 68: {
                            return (Integer)sourceVal2 > (Integer)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 69: {
                            return (Integer)sourceVal2 <= (Integer)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 70: {
                            return (Integer)sourceVal2 >= (Integer)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                    message = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, oper.getName());
                    RuntimeException error = new RuntimeException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal2 instanceof Integer && argVal instanceof Double) {
                    switch (opCode) {
                        case 1: {
                            return new Double((double)((Integer)sourceVal2).intValue() + (Double)argVal);
                        }
                        case 2: {
                            return new Double((double)((Integer)sourceVal2).intValue() - (Double)argVal);
                        }
                        case 3: {
                            return new Double((double)((Integer)sourceVal2).intValue() * (Double)argVal);
                        }
                        case 4: {
                            return new Double((double)((Integer)sourceVal2).intValue() / (Double)argVal);
                        }
                        case 18: {
                            return new Double(Math.max((double)((Integer)sourceVal2).intValue(), (Double)argVal));
                        }
                        case 19: {
                            return new Double(Math.min((double)((Integer)sourceVal2).intValue(), (Double)argVal));
                        }
                        case 67: {
                            return (double)((Integer)sourceVal2).intValue() < (Double)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 68: {
                            return (double)((Integer)sourceVal2).intValue() > (Double)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 69: {
                            return (double)((Integer)sourceVal2).intValue() <= (Double)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 70: {
                            return (double)((Integer)sourceVal2).intValue() >= (Double)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                    message = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, oper.getName());
                    RuntimeException error = new RuntimeException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal2 instanceof Double && argVal instanceof Integer) {
                    switch (opCode) {
                        case 1: {
                            return new Double((Double)sourceVal2 + (double)((Integer)argVal).intValue());
                        }
                        case 2: {
                            return new Double((Double)sourceVal2 - (double)((Integer)argVal).intValue());
                        }
                        case 3: {
                            return new Double((Double)sourceVal2 * (double)((Integer)argVal).intValue());
                        }
                        case 4: {
                            return new Double((Double)sourceVal2 / (double)((Integer)argVal).intValue());
                        }
                        case 18: {
                            return new Double(Math.max((Double)sourceVal2, (double)((Integer)argVal).intValue()));
                        }
                        case 19: {
                            return new Double(Math.min((Double)sourceVal2, (double)((Integer)argVal).intValue()));
                        }
                        case 67: {
                            return (Double)sourceVal2 < (double)((Integer)argVal).intValue() ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 68: {
                            return (Double)sourceVal2 > (double)((Integer)argVal).intValue() ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 69: {
                            return (Double)sourceVal2 <= (double)((Integer)argVal).intValue() ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 70: {
                            return (Double)sourceVal2 >= (double)((Integer)argVal).intValue() ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                    message = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, oper.getName());
                    RuntimeException error = new RuntimeException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal2 instanceof Double && argVal instanceof Double) {
                    switch (opCode) {
                        case 1: {
                            return new Double((Double)sourceVal2 + (Double)argVal);
                        }
                        case 2: {
                            return new Double((Double)sourceVal2 - (Double)argVal);
                        }
                        case 3: {
                            return new Double((Double)sourceVal2 * (Double)argVal);
                        }
                        case 4: {
                            return new Double((Double)sourceVal2 / (Double)argVal);
                        }
                        case 18: {
                            return new Double(Math.max((Double)sourceVal2, (Double)argVal));
                        }
                        case 19: {
                            return new Double(Math.min((Double)sourceVal2, (Double)argVal));
                        }
                        case 67: {
                            return (Double)sourceVal2 < (Double)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 68: {
                            return (Double)sourceVal2 > (Double)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 69: {
                            return (Double)sourceVal2 <= (Double)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 70: {
                            return (Double)sourceVal2 >= (Double)argVal ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                    message = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, oper.getName());
                    RuntimeException error = new RuntimeException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal2 instanceof Boolean) {
                    switch (opCode) {
                        case 12: {
                            if (Boolean.TRUE.equals(sourceVal2)) {
                                return Boolean.TRUE;
                            }
                            argVal = arg3.accept(this);
                            return argVal;
                        }
                        case 25: {
                            argVal = arg3.accept(this);
                            if (sourceVal2 == null) {
                                return argVal;
                            }
                            return argVal == null ? sourceVal2 : ((Boolean)sourceVal2 ^ (Boolean)argVal ? Boolean.TRUE : Boolean.FALSE);
                        }
                        case 10: {
                            if (!Boolean.TRUE.equals(sourceVal2)) {
                                return Boolean.FALSE;
                            }
                            argVal = arg3.accept(this);
                            return argVal;
                        }
                        case 13: {
                            if (Boolean.FALSE.equals(sourceVal2)) {
                                return Boolean.TRUE;
                            }
                            argVal = arg3.accept(this);
                            return argVal;
                        }
                    }
                    message = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, oper.getName());
                    RuntimeException error = new RuntimeException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal2 instanceof String && argVal instanceof String) {
                    switch (opCode) {
                        case 21: {
                            return ((String)sourceVal2).concat((String)argVal);
                        }
                        case 67: {
                            return ((String)sourceVal2).compareTo((String)argVal) < 0;
                        }
                        case 69: {
                            return ((String)sourceVal2).compareTo((String)argVal) <= 0;
                        }
                        case 68: {
                            return ((String)sourceVal2).compareTo((String)argVal) > 0;
                        }
                        case 70: {
                            return ((String)sourceVal2).compareTo((String)argVal) >= 0;
                        }
                    }
                    message = OCLMessages.bind(OCLMessages.UnknownOperation_ERROR_, oper.getName());
                    RuntimeException error = new RuntimeException(message);
                    OCLPlugin.throwing(this.getClass(), "visitOperationCallExp", error);
                    throw error;
                }
                if (sourceVal2 instanceof Collection) {
                    Collection sourceColl = (Collection)sourceVal2;
                    switch (opCode) {
                        case 143: {
                            return CollectionTypeImpl.includes(sourceColl, argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 141: {
                            return CollectionTypeImpl.excludes(sourceColl, argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 140: {
                            return new Integer(CollectionTypeImpl.count(sourceColl, argVal));
                        }
                        case 144: {
                            return CollectionTypeImpl.includesAll(sourceColl, (Collection)argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 142: {
                            return CollectionTypeImpl.excludesAll(sourceColl, (Collection)argVal) ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case 147: {
                            return CollectionTypeImpl.product(sourceColl, (Collection)argVal, (EClass)((CollectionType)oc.getType()).getElementType());
                        }
                        case 157: {
                            Collection argColl = (Collection)argVal;
                            return CollectionTypeImpl.union(sourceColl, argColl);
                        }
                        case 156: {
                            Collection argColl = (Collection)argVal;
                            return CollectionTypeImpl.intersection(sourceColl, argColl);
                        }
                        case 2: {
                            return CollectionTypeImpl.minus((Set)sourceColl, (Set)argVal);
                        }
                        case 155: {
                            return CollectionTypeImpl.including(sourceColl, argVal);
                        }
                        case 153: {
                            return CollectionTypeImpl.excluding(sourceColl, argVal);
                        }
                        case 167: {
                            return CollectionTypeImpl.symmetricDifference((Set)sourceColl, (Set)argVal);
                        }
                        case 165: {
                            return CollectionTypeImpl.append(sourceColl, argVal);
                        }
                        case 163: {
                            return CollectionTypeImpl.prepend(sourceColl, argVal);
                        }
                        case 158: {
                            int indexVal = (Integer)argVal;
                            return CollectionTypeImpl.at(sourceColl, indexVal);
                        }
                        case 160: {
                            return CollectionTypeImpl.indexOf(sourceColl, argVal);
                        }
                    }
                } else if (sourceVal2 instanceof Comparable) {
                    Comparable comp;
                    if (opCode == 67) {
                        comp = (Comparable)sourceVal2;
                        return comp.compareTo(argVal) < 0;
                    }
                    if (opCode == 69) {
                        comp = (Comparable)sourceVal2;
                        return comp.compareTo(argVal) <= 0;
                    }
                    if (opCode == 68) {
                        comp = (Comparable)sourceVal2;
                        return comp.compareTo(argVal) > 0;
                    }
                    if (opCode == 70) {
                        comp = (Comparable)sourceVal2;
                        return comp.compareTo(argVal) >= 0;
                    }
                }
            } else {
                sourceVal = source.accept(this);
                if (EvaluationVisitorImpl.isUndefined(sourceVal)) {
                    return Types.OCL_INVALID;
                }
                Object arg1 = ((OCLExpression)args.get(0)).accept(this);
                if (EvaluationVisitorImpl.isUndefined(arg1)) {
                    return Types.OCL_INVALID;
                }
                Object arg2 = ((OCLExpression)args.get(1)).accept(this);
                if (EvaluationVisitorImpl.isUndefined(arg2)) {
                    return Types.OCL_INVALID;
                }
                if (sourceVal instanceof String) {
                    int lower = (Integer)arg1 - 1;
                    int upper = (Integer)arg2;
                    return ((String)sourceVal).substring(lower, upper);
                }
                if (sourceVal instanceof Collection) {
                    Collection sourceColl = (Collection)sourceVal;
                    if (opCode == 161) {
                        int index = (Integer)arg1;
                        return CollectionTypeImpl.insertAt(sourceColl, index, arg2);
                    }
                    if (opCode == 166) {
                        int lower = (Integer)arg1;
                        int upper = (Integer)arg2;
                        return CollectionTypeImpl.subOrderedSet(sourceColl, lower, upper);
                    }
                    if (opCode == 164) {
                        int lower = (Integer)arg1;
                        int upper = (Integer)arg2;
                        return CollectionTypeImpl.subSequence(sourceColl, lower, upper);
                    }
                }
            }
        } else {
            Comparable evalArg;
            Comparable compContext;
            Object context = source.accept(this);
            if (opCode == 40) {
                if (context instanceof EEnum) {
                    return new HashSet(((EEnum)context).getELiterals());
                }
                if (context == Types.OCL_VOID) {
                    HashSet<Object> result = new HashSet<Object>();
                    result.add(null);
                    return result;
                }
                if (context instanceof EClass) {
                    return this.extentMap.get(context);
                }
                return new HashSet();
            }
            if (opCode == 65) {
                return EvaluationVisitorImpl.isUndefined(context) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (opCode == 66) {
                return context == Types.OCL_INVALID ? Boolean.TRUE : Boolean.FALSE;
            }
            if (EvaluationVisitorImpl.isUndefined(context)) {
                return Types.OCL_INVALID;
            }
            if (opCode == 64) {
                arg = (OCLExpression)args.get(0);
                return this.oclIsTypeOf(context, arg.accept(this));
            }
            if (opCode == 63) {
                arg = (OCLExpression)args.get(0);
                return this.oclIsKindOf(context, arg.accept(this));
            }
            if (opCode == 62) {
                arg = (OCLExpression)args.get(0);
                EClassifier type = (EClassifier)arg.accept(this);
                if (this.oclIsKindOf(context, type) == Boolean.TRUE) {
                    return context;
                }
                return Types.OCL_INVALID;
            }
            if (opCode == 67 && context instanceof Comparable) {
                compContext = (Comparable)context;
                OCLExpression arg4 = (OCLExpression)args.get(0);
                evalArg = (Comparable)arg4.accept(this);
                return compContext.compareTo(evalArg) < 0;
            }
            if (opCode == 69 && context instanceof Comparable) {
                compContext = (Comparable)context;
                OCLExpression arg5 = (OCLExpression)args.get(0);
                evalArg = (Comparable)arg5.accept(this);
                return compContext.compareTo(evalArg) <= 0;
            }
            if (opCode == 68 && context instanceof Comparable) {
                compContext = (Comparable)context;
                OCLExpression arg6 = (OCLExpression)args.get(0);
                evalArg = (Comparable)arg6.accept(this);
                return compContext.compareTo(evalArg) > 0;
            }
            if (opCode == 70 && context instanceof Comparable) {
                compContext = (Comparable)context;
                OCLExpression arg7 = (OCLExpression)args.get(0);
                evalArg = (Comparable)arg7.accept(this);
                return compContext.compareTo(evalArg) >= 0;
            }
            evalArgs = new LinkedList();
            Iterator it = args.iterator();
            while (it.hasNext()) {
                OCLExpression arg8 = (OCLExpression)it.next();
                Object evalArg2 = arg8.accept(this);
                if (evalArg2 == Types.OCL_INVALID) {
                    return Types.OCL_INVALID;
                }
                evalArgs.add(evalArg2);
            }
            Class[] argTypes = new Class[args.size()];
            int i = 0;
            int n = args.size();
            while (i < n) {
                OCLExpression e = (OCLExpression)args.get(i);
                argTypes[i] = e.getType().getInstanceClass();
                ++i;
            }
            Method method = EvaluationVisitorImpl.getJavaMethodFor(oper);
            if (method == null) {
                return Types.OCL_INVALID;
            }
            try {
                Object result = method.invoke(context, evalArgs.toArray());
                return result;
            }
            catch (Exception e) {
                OCLPlugin.catching(this.getClass(), "visitOperationCallExp", e);
                OCLPlugin.log(4, 10, OCLMessages.bind(OCLMessages.ErrorMessage_ERROR_, "visitOperationCallExp", e.getLocalizedMessage()), e);
                return Types.OCL_INVALID;
            }
        }
        return null;
    }

    private Object invoke(EOperation operation, OCLExpression body, Object target, Object[] args) {
        EvalEnvironment evalEnv = new EvalEnvironment(this.getEvalEnvironment());
        evalEnv.add("self", target);
        if (args.length > 0) {
            int i = 0;
            Iterator iter = operation.getEParameters().iterator();
            while (iter.hasNext()) {
                EParameter next = (EParameter)iter.next();
                evalEnv.add(next.getName(), args[i]);
                ++i;
            }
        }
        return body.accept(EvaluationVisitorImpl.getInstance(evalEnv, this.getExtentMap()));
    }

    private OCLExpression getBody(ETypedElement feature) {
        OCLExpression result = null;
        EAnnotation ann = feature.getEAnnotation("http://www.eclipse.org/OCL/1.0.0/define");
        if (ann == null) {
            if (feature instanceof EOperation) {
                ann = feature.getEAnnotation("http://www.eclipse.org/OCL/1.0.0/body");
            } else if (feature instanceof EStructuralFeature) {
                ann = feature.getEAnnotation("http://www.eclipse.org/OCL/1.0.0/derive");
            }
        }
        if (ann != null && !ann.getContents().isEmpty()) {
            Constraint constraint = (Constraint)ann.getContents().get(0);
            result = constraint.getBody();
        }
        return result;
    }

    public static Method getJavaMethodFor(EOperation oper) {
        Method result = null;
        String operName = oper.getName();
        int opcode = PrimitiveTypeImpl.getOperationCode(operName);
        switch (opcode) {
            case 1: {
                operName = "plus";
                break;
            }
            case 2: {
                operName = "minus";
                break;
            }
            case 3: {
                operName = "times";
                break;
            }
            case 4: {
                operName = "divide";
                break;
            }
            case 67: {
                operName = "lessThan";
                break;
            }
            case 69: {
                operName = "lessThanEqual";
                break;
            }
            case 68: {
                operName = "greaterThan";
                break;
            }
            case 70: {
                operName = "greaterThanEqual";
            }
        }
        EClass container = oper.getEContainingClass();
        Class containerClass = container.getInstanceClass();
        EList parms = oper.getEParameters();
        Class[] javaParms = new Class[parms.size()];
        int i = 0;
        int n = parms.size();
        while (i < n) {
            EParameter parm = (EParameter)parms.get(i);
            if (parm.isMany()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.emf.common.util.EList");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                javaParms[i] = clazz;
            } else {
                javaParms[i] = parm.getEType().getInstanceClass();
            }
            ++i;
        }
        try {
            result = containerClass.getMethod(operName, javaParms);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return result;
    }

    public Object visitIterateExp(IterateExp ie) {
        Variable vd = ie.getResult();
        String resultName = (String)vd.accept(this);
        EList iterators = ie.getIterator();
        Object sourceValue = ie.getSource().accept(this);
        if (EvaluationVisitorImpl.isUndefined(sourceValue)) {
            return Types.OCL_INVALID;
        }
        Collection coll = (Collection)sourceValue;
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplate.getInstance(this);
        Object result = is.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        return result;
    }

    public Object visitIteratorExp(IteratorExp ie) {
        EClassifier sourceType = ie.getSource().getType();
        if (sourceType instanceof PredefinedType) {
            Object sourceValue = ie.getSource().accept(this);
            if (EvaluationVisitorImpl.isUndefined(sourceValue)) {
                return Types.OCL_INVALID;
            }
            Collection sourceCollection = (Collection)sourceValue;
            switch (((PredefinedType)sourceType).getOperationCodeFor(ie.getName())) {
                case 201: {
                    return this.evaluateExistsIterator(ie, sourceCollection);
                }
                case 202: {
                    return this.evaluateForAllIterator(ie, sourceCollection);
                }
                case 209: {
                    return this.evaluateSelectIterator(ie, sourceCollection);
                }
                case 210: {
                    return this.evaluateRejectIterator(ie, sourceCollection);
                }
                case 206: {
                    return this.evaluateCollectIterator(ie, sourceCollection);
                }
                case 207: {
                    return this.evaluateCollectNestedIterator(ie, sourceCollection);
                }
                case 204: {
                    return this.evaluateOneIterator(ie, sourceCollection);
                }
                case 205: {
                    return this.evaluateAnyIterator(ie, sourceCollection);
                }
                case 211: {
                    return this.evaluateSortedByIterator(ie, sourceCollection);
                }
                case 203: {
                    return this.evaluateIsUnique(ie, sourceCollection);
                }
                case 208: {
                    return this.evaluateClosure(ie, sourceCollection);
                }
            }
        }
        String message = OCLMessages.bind(OCLMessages.IteratorNotImpl_ERROR_, ie.getName());
        UnsupportedOperationException ex = new UnsupportedOperationException(message);
        OCLPlugin.throwing(this.getClass(), "visitIteratorExp", ex);
        throw ex;
    }

    public Object evaluateExistsIterator(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTempateExists.getInstance(this);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, Boolean.FALSE);
        Object result = is.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        return result;
    }

    public Object evaluateForAllIterator(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateForAll.getInstance(this);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, Boolean.TRUE);
        Object result = is.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        return result;
    }

    public Object evaluateCollectNestedIterator(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType || collType instanceof BagType ? CollectionTypeImpl.createNewBag() : CollectionTypeImpl.createNewSequence();
        IterationTemplate is = IterationTemplateCollectNested.getInstance(this);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, initResultVal);
        Object result = is.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        return result;
    }

    public Object evaluateCollectIterator(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType || collType instanceof BagType ? CollectionTypeImpl.createNewBag() : CollectionTypeImpl.createNewSequence();
        IterationTemplate is = IterationTemplateCollect.getInstance(this);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, initResultVal);
        Object result = is.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        return result;
    }

    public Object evaluateSelectIterator(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType ? CollectionTypeImpl.createNewSet() : (collType instanceof BagType ? CollectionTypeImpl.createNewBag() : (collType instanceof SequenceType ? CollectionTypeImpl.createNewSequence() : CollectionTypeImpl.createNewOrderedSet()));
        IterationTemplate is = IterationTemplateSelect.getInstance(this);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, initResultVal);
        Object result = is.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        return result;
    }

    public Object evaluateRejectIterator(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        CollectionType collType = (CollectionType)ie.getSource().getType();
        Collection initResultVal = null;
        initResultVal = collType instanceof SetType ? CollectionTypeImpl.createNewSet() : (collType instanceof BagType ? CollectionTypeImpl.createNewBag() : (collType instanceof SequenceType ? CollectionTypeImpl.createNewSequence() : CollectionTypeImpl.createNewOrderedSet()));
        IterationTemplate is = IterationTemplateReject.getInstance(this);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, initResultVal);
        Object result = is.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        return result;
    }

    public Object evaluateOneIterator(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateOne.getInstance(this);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, Boolean.FALSE);
        Object result = is.evaluate(coll, (List)iterators, body, resultName);
        return result;
    }

    public Object evaluateAnyIterator(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateAny.getInstance(this);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, null);
        Object result = is.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        return result;
    }

    public Object evaluateSortedByIterator(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateSortedBy.getInstance(this);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, new HashMap());
        Object evaluationResult = is.evaluate(coll, (List)iterators, body, resultName);
        if (evaluationResult == Types.OCL_INVALID) {
            return evaluationResult;
        }
        final Map bodyEvals = (Map)is.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        ArrayList result = new ArrayList(coll);
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                Comparable b1 = (Comparable)bodyEvals.get(o1);
                Comparable b2 = (Comparable)bodyEvals.get(o2);
                return b1.compareTo(b2);
            }
        });
        CollectionType collType = (CollectionType)ie.getSource().getType();
        if (collType instanceof SetType || collType instanceof OrderedSetType) {
            return CollectionTypeImpl.createNewOrderedSet(result);
        }
        return CollectionTypeImpl.createNewSequence(result);
    }

    public Object evaluateIsUnique(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        IterationTemplate is = IterationTemplateIsUnique.getInstance(this);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, new HashSet());
        is.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        return is.isDone() ? Boolean.FALSE : Boolean.TRUE;
    }

    public Object evaluateClosure(IteratorExp ie, Collection coll) {
        EList iterators = ie.getIterator();
        OCLExpression body = ie.getBody();
        Collection initResultVal = CollectionTypeImpl.createNewSet();
        IterationTemplate template = IterationTemplateClosure.getInstance(this, body);
        String resultName = EvaluationVisitorImpl.generateName();
        this.env.add(resultName, initResultVal);
        Object result = template.evaluate(coll, (List)iterators, body, resultName);
        this.env.remove(resultName);
        return result;
    }

    private static synchronized String generateName() {
        return "__result__" + tempCounter++;
    }

    public Object visitEnumLiteralExp(EnumLiteralExp el) {
        return el.getReferredEnumLiteral();
    }

    public Object visitVariableExp(VariableExp v) {
        Variable vd = v.getReferredVariable();
        String varName = vd.getName();
        EvaluationEnvironment ee = this.getEvalEnvironment();
        Object result = ee.getValueOf(varName);
        return result;
    }

    public Object visitPropertyCallExp(PropertyCallExp pc) {
        EStructuralFeature property = pc.getReferredProperty();
        OCLExpression source = pc.getSource();
        EObject context = (EObject)source.accept(this);
        if (EvaluationVisitorImpl.isUndefined(context)) {
            return Types.OCL_INVALID;
        }
        OCLExpression derivation = this.getBody((ETypedElement)property);
        if (derivation != null) {
            return this.get(property, derivation, context);
        }
        Object result = context.eGet(property);
        if (pc.getType() instanceof CollectionType && !(result instanceof Collection)) {
            CollectionKind kind = ((CollectionType)pc.getType()).getKind();
            Collection collection = CollectionFactory.getInstance().createCollection(kind.getValue());
            collection.add(result);
            result = collection;
        }
        return result;
    }

    private Object get(EStructuralFeature property, OCLExpression derivation, Object target) {
        EvalEnvironment evalEnv = new EvalEnvironment(this.getEvalEnvironment());
        evalEnv.add("self", target);
        return derivation.accept(EvaluationVisitorImpl.getInstance(evalEnv, this.getExtentMap()));
    }

    public Object visitAssociationClassCallExp(AssociationClassCallExp ae) {
        EObject context = (EObject)ae.getSource().accept(this);
        if (EvaluationVisitorImpl.isUndefined(context)) {
            return Types.OCL_INVALID;
        }
        EReference ref = this.getAssociationClassReference(context, ae.getReferredAssociationClass());
        return context.eGet((EStructuralFeature)ref);
    }

    private EReference getAssociationClassReference(EObject context, EClass associationClass) {
        EReference result = null;
        StringBuffer nameBuf = new StringBuffer(associationClass.getName());
        UTF16.setCharAt((StringBuffer)nameBuf, (int)0, (int)UCharacter.toLowerCase((int)UTF16.charAt((StringBuffer)nameBuf, (int)0)));
        String name = nameBuf.toString();
        Iterator iter = context.eClass().getEAllReferences().iterator();
        while (result == null && iter.hasNext()) {
            EReference next = (EReference)iter.next();
            if (!name.equals(next.getName()) || associationClass != next.getEReferenceType()) continue;
            result = next;
        }
        return result;
    }

    public Object visitVariable(Variable vd) {
        String varName = vd.getName();
        OCLExpression initExp = vd.getInitExpression();
        Object initVal = null;
        if (initExp != null) {
            initVal = initExp.accept(this);
        }
        this.env.add(varName, initVal);
        return varName;
    }

    public Object visitIfExp(IfExp ie) {
        OCLExpression condition = ie.getCondition();
        Boolean condVal = (Boolean)condition.accept(this);
        if (condVal == null) {
            return null;
        }
        if (condVal.booleanValue()) {
            return ie.getThenExpression().accept(this);
        }
        return ie.getElseExpression().accept(this);
    }

    public Object visitTypeExp(TypeExp t) {
        return t.getReferredType();
    }

    public Object visitStateExp(StateExp s) {
        return s.getReferredState();
    }

    public Object visitMessageExp(MessageExp m) {
        throw new UnsupportedOperationException("evaluation of MessageExp");
    }

    public Object visitUnspecifiedValueExp(UnspecifiedValueExp uv) {
        throw new UnsupportedOperationException("evaluation of UnspecifiedValueExp");
    }

    public Object visitIntegerLiteralExp(IntegerLiteralExp il) {
        return il.getIntegerSymbol();
    }

    public Object visitRealLiteralExp(RealLiteralExp rl) {
        return rl.getRealSymbol();
    }

    public Object visitStringLiteralExp(StringLiteralExp sl) {
        return sl.getStringSymbol();
    }

    public Object visitBooleanLiteralExp(BooleanLiteralExp bl) {
        return bl.getBooleanSymbol();
    }

    public Object visitInvalidLiteralExp(InvalidLiteralExp il) {
        return Types.OCL_INVALID;
    }

    public Object visitNullLiteralExp(NullLiteralExp il) {
        return null;
    }

    public Object visitLetExp(LetExp l) {
        Variable vd = l.getVariable();
        String name = (String)vd.accept(this);
        OCLExpression inExp = l.getIn();
        Object val = inExp.accept(this);
        this.env.remove(name);
        return val;
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp cl) {
        CollectionKind kind = cl.getKind();
        EList parts = cl.getPart();
        Collection result = kind == CollectionKind.SET_LITERAL ? CollectionTypeImpl.createNewSet() : (kind == CollectionKind.ORDERED_SET_LITERAL ? CollectionTypeImpl.createNewOrderedSet() : (kind == CollectionKind.SEQUENCE_LITERAL ? CollectionTypeImpl.createNewSequence() : CollectionTypeImpl.createNewBag()));
        if (kind == CollectionKind.SEQUENCE_LITERAL && cl.isSimpleRange()) {
            int lastInt;
            CollectionRange collRange = (CollectionRange)parts.get(0);
            OCLExpression first = collRange.getFirst();
            OCLExpression last = collRange.getLast();
            Integer firstVal = (Integer)first.accept(this);
            if (firstVal == null) {
                result.add(null);
                return result;
            }
            Integer lastVal = (Integer)last.accept(this);
            if (lastVal == null) {
                result.add(null);
                return result;
            }
            int firstInt = firstVal;
            if (firstInt > (lastInt = lastVal.intValue())) {
                return result;
            }
            return new IntegerRangeList(firstInt, lastInt);
        }
        Iterator it = parts.iterator();
        while (it.hasNext()) {
            CollectionLiteralPart part = (CollectionLiteralPart)it.next();
            if (part instanceof CollectionItem) {
                CollectionItem item = (CollectionItem)part;
                OCLExpression itemExp = item.getItem();
                Object itemVal = itemExp.accept(this);
                if (itemVal == null) continue;
                result.add(itemVal);
                continue;
            }
            CollectionRange range = (CollectionRange)part;
            OCLExpression first = range.getFirst();
            OCLExpression last = range.getLast();
            Integer firstVal = (Integer)first.accept(this);
            Integer lastVal = (Integer)last.accept(this);
            if (firstVal == null || lastVal == null) continue;
            int firstInt = firstVal;
            int lastInt = lastVal;
            int i = firstInt;
            while (i <= lastInt) {
                result.add(new Integer(i));
                ++i;
            }
        }
        return result;
    }

    public Object visitTupleLiteralExp(TupleLiteralExp tl) {
        EClass eclazz = (EClass)tl.getType();
        EList tp = tl.getPart();
        EFactory factory = eclazz.getEPackage().getEFactoryInstance();
        EObject result = factory.create(eclazz);
        Iterator iter = tp.iterator();
        EStructuralFeature sf = null;
        while (iter.hasNext()) {
            TupleLiteralPart part = (TupleLiteralPart)iter.next();
            sf = eclazz.getEStructuralFeature(part.getName());
            if (sf == null) {
                String message = OCLMessages.bind(OCLMessages.TupleFieldDoesntExist_ERROR_, part.getName());
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "visitTupleLiteralExp", error);
                throw error;
            }
            Object value = part.accept(this);
            result.eSet(sf, value);
        }
        return result;
    }

    public Object visitTupleLiteralPart(TupleLiteralPart tp) {
        return tp.getValue().accept(this);
    }

    protected Boolean oclIsTypeOf(Object value, Object typeArg) {
        EClassifier type = (EClassifier)typeArg;
        if (type == null) {
            return null;
        }
        if (value == null) {
            return type == Types.OCL_VOID;
        }
        if (value == Types.OCL_INVALID) {
            return type == Types.INVALID;
        }
        boolean isObject = value instanceof EObject;
        if (!isObject) {
            Class<?> valueType = value.getClass();
            return valueType == type.getInstanceClass();
        }
        if (isObject && type instanceof EClass) {
            EObject valueEObject = (EObject)value;
            EClass valueEClass = valueEObject.eClass();
            EClass argClass = (EClass)type;
            return valueEClass.equals(argClass);
        }
        return Boolean.FALSE;
    }

    protected Boolean oclIsKindOf(Object value, Object typeArg) {
        EClassifier type = (EClassifier)typeArg;
        if (type == null) {
            return null;
        }
        if (EvaluationVisitorImpl.isUndefined(value)) {
            return Boolean.TRUE;
        }
        boolean isEObject = value instanceof EObject;
        if (!isEObject) {
            Class<?> valueClass = value.getClass();
            Class typeClass = type.getInstanceClass();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (valueClass == clazz) {
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (typeClass == clazz2) {
                    return Boolean.TRUE;
                }
            }
            return typeClass.isAssignableFrom(valueClass) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (isEObject && type instanceof EClass) {
            EObject valueEObject = (EObject)value;
            EClass valueEClass = valueEObject.eClass();
            EClass argClass = (EClass)type;
            return argClass.isSuperTypeOf(valueEClass);
        }
        return Boolean.FALSE;
    }

    private static final class IntegerRangeList
    extends AbstractList {
        private int first;
        private int last;

        public IntegerRangeList() {
        }

        public IntegerRangeList(int first, int last) {
            this.first = first;
            this.last = last;
        }

        public int getFirst() {
            return this.first;
        }

        public int getLast() {
            return this.last;
        }

        public int size() {
            return this.last - this.first + 1;
        }

        public Object get(int index) {
            if (index < 0 || index >= this.size()) {
                String message = OCLMessages.bind(OCLMessages.IndexOutOfRange_ERROR_, new Object[]{Integer.toString(index), Integer.toString(this.first), Integer.toString(this.last)});
                IllegalArgumentException error = new IllegalArgumentException(message);
                OCLPlugin.throwing(this.getClass(), "get", error);
                throw error;
            }
            return new Integer(this.first + index);
        }

        public Iterator iterator() {
            class IntegerRangeIterator
            implements Iterator {
                private int curr;
                private boolean initialized;
                final /* synthetic */ IntegerRangeList this$1;

                public IntegerRangeIterator(IntegerRangeList integerRangeList) {
                    this.this$1 = integerRangeList;
                    this.curr = IntegerRangeList.access$0(integerRangeList);
                    this.initialized = false;
                }

                public Object next() {
                    if (!this.initialized) {
                        this.curr = IntegerRangeList.access$0(this.this$1) - 1;
                        this.initialized = true;
                    }
                    if (this.hasNext()) {
                        return new Integer(++this.curr);
                    }
                    throw new NoSuchElementException();
                }

                public boolean hasNext() {
                    return this.curr < IntegerRangeList.access$1(this.this$1);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new IntegerRangeIterator(this);
        }

        static /* synthetic */ int access$0(IntegerRangeList integerRangeList) {
            return integerRangeList.first;
        }

        static /* synthetic */ int access$1(IntegerRangeList integerRangeList) {
            return integerRangeList.last;
        }
    }
}

