/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.expressions.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ocl.expressions.EvaluationVisitor;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.expressions.impl.IterationTemplate;
import org.eclipse.emf.ocl.parser.EvaluationEnvironment;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.util.Types;

public class IterationTemplateClosure
extends IterationTemplate {
    private OCLExpression body;

    private IterationTemplateClosure(EvaluationVisitor v, OCLExpression body) {
        super(v);
        this.body = body;
    }

    public static IterationTemplate getInstance(EvaluationVisitor v, OCLExpression body) {
        return new IterationTemplateClosure(v, body);
    }

    protected Object evaluateResult(List iterators, String resultName, Object bodyVal) {
        EvaluationEnvironment env = this.getEvalEnvironment();
        Set currVal = (Set)env.getValueOf(resultName);
        if (bodyVal == Types.OCL_INVALID) {
            this.setDone(true);
            return Types.OCL_INVALID;
        }
        Collection newResults = CollectionTypeImpl.createNewSet();
        if (bodyVal instanceof Collection) {
            Collection bodyColl = (Collection)bodyVal;
            Iterator iter = bodyColl.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (next == null || !currVal.add(next)) continue;
                newResults.add(next);
            }
        } else if (bodyVal != null && currVal.add(bodyVal)) {
            newResults.add(bodyVal);
        }
        if (!newResults.isEmpty()) {
            Object[] iteratorValues = this.pauseIterators(iterators);
            this.evaluate(newResults, iterators, this.body, resultName);
            this.resumeIterators(iterators, iteratorValues);
        }
        return currVal;
    }

    private Object[] pauseIterators(List iterators) {
        Object[] result = new Object[iterators.size()];
        EvaluationEnvironment env = this.getEvalEnvironment();
        int i = 0;
        int n = result.length;
        while (i < n) {
            Variable iterDecl = (Variable)iterators.get(i);
            result[i] = env.remove(iterDecl.getName());
            ++i;
        }
        return result;
    }

    private void resumeIterators(List iterators, Object[] values) {
        EvaluationEnvironment env = this.getEvalEnvironment();
        int i = 0;
        int n = values.length;
        while (i < n) {
            Variable iterDecl = (Variable)iterators.get(i);
            env.add(iterDecl.getName(), values[i]);
            ++i;
        }
    }
}

