/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.expressions.impl;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ocl.expressions.AssociationClassCallExp;
import org.eclipse.emf.ocl.expressions.BooleanLiteralExp;
import org.eclipse.emf.ocl.expressions.CollectionItem;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.CollectionLiteralExp;
import org.eclipse.emf.ocl.expressions.CollectionLiteralPart;
import org.eclipse.emf.ocl.expressions.CollectionRange;
import org.eclipse.emf.ocl.expressions.EnumLiteralExp;
import org.eclipse.emf.ocl.expressions.ExpressionsPackage;
import org.eclipse.emf.ocl.expressions.FeatureCallExp;
import org.eclipse.emf.ocl.expressions.IfExp;
import org.eclipse.emf.ocl.expressions.IntegerLiteralExp;
import org.eclipse.emf.ocl.expressions.InvalidLiteralExp;
import org.eclipse.emf.ocl.expressions.IterateExp;
import org.eclipse.emf.ocl.expressions.IteratorExp;
import org.eclipse.emf.ocl.expressions.LetExp;
import org.eclipse.emf.ocl.expressions.MessageExp;
import org.eclipse.emf.ocl.expressions.NullLiteralExp;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.OperationCallExp;
import org.eclipse.emf.ocl.expressions.PropertyCallExp;
import org.eclipse.emf.ocl.expressions.RealLiteralExp;
import org.eclipse.emf.ocl.expressions.StateExp;
import org.eclipse.emf.ocl.expressions.StringLiteralExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralPart;
import org.eclipse.emf.ocl.expressions.TypeExp;
import org.eclipse.emf.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.expressions.VariableExp;
import org.eclipse.emf.ocl.expressions.Visitor;
import org.eclipse.emf.ocl.parser.EcoreEnvironment;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.emf.ocl.uml.Constraint;
import org.eclipse.emf.ocl.utilities.Visitable;

public class ToStringVisitorImpl
implements Visitor {
    private static String NULL_PLACEHOLDER = "\"<null>\"";
    private static Visitor instance = null;

    public static Visitor getInstance() {
        if (instance == null) {
            instance = new ToStringVisitorImpl();
        }
        return instance;
    }

    private ToStringVisitorImpl() {
    }

    public static String toString(Visitable v) {
        return v == null ? NULL_PLACEHOLDER : (String)v.accept(ToStringVisitorImpl.getInstance());
    }

    private static String getName(ENamedElement named) {
        return named == null ? NULL_PLACEHOLDER : (named.getName() == null ? NULL_PLACEHOLDER : named.getName());
    }

    public Object visitOperationCallExp(OperationCallExp oc) {
        OCLExpression source = oc.getSource();
        EClassifier sourceType = source != null ? source.getType() : null;
        EOperation oper = oc.getReferredOperation();
        EList args = oc.getArgument();
        int numArgs = args != null ? args.size() : 0;
        StringBuffer result = new StringBuffer();
        result.append(this.visit(source));
        result.append(sourceType instanceof CollectionType ? "->" : ".");
        result.append(ToStringVisitorImpl.getName((ENamedElement)oper));
        result.append("(");
        Iterator iter = args.iterator();
        int i = 0;
        while (i < numArgs) {
            OCLExpression arg = (OCLExpression)iter.next();
            result.append(this.visit(arg));
            if (i < numArgs - 1) {
                result.append(", ");
            }
            ++i;
        }
        result.append(")");
        return this.maybeAtPre(oc, result.toString());
    }

    public Object visitEnumLiteralExp(EnumLiteralExp el) {
        EEnumLiteral l = el.getReferredEnumLiteral();
        return ToStringVisitorImpl.getName((ENamedElement)l);
    }

    public Object visitVariableExp(VariableExp v) {
        Variable vd = v.getReferredVariable();
        return ToStringVisitorImpl.getName(vd);
    }

    public Object visitPropertyCallExp(PropertyCallExp pc) {
        EStructuralFeature property = pc.getReferredProperty();
        if (pc.eContainmentFeature() == ExpressionsPackage.Literals.NAVIGATION_CALL_EXP__QUALIFIER && pc.eContainer() instanceof AssociationClassCallExp) {
            return ToStringVisitorImpl.getName((ENamedElement)property);
        }
        StringBuffer result = new StringBuffer(this.maybeAtPre(pc, String.valueOf(this.visit(pc.getSource())) + "." + ToStringVisitorImpl.getName((ENamedElement)property)));
        if (!pc.getQualifier().isEmpty()) {
            result.append('[');
            Iterator iter = pc.getQualifier().iterator();
            while (iter.hasNext()) {
                OCLExpression next = (OCLExpression)iter.next();
                result.append(this.visit(next));
                if (!iter.hasNext()) continue;
                result.append(", ");
            }
            result.append(']');
        }
        return result.toString();
    }

    public Object visitAssociationClassCallExp(AssociationClassCallExp ac) {
        EClass ref = ac.getReferredAssociationClass();
        String name = ref == null ? NULL_PLACEHOLDER : EcoreEnvironment.initialLower((ENamedElement)ref);
        StringBuffer result = new StringBuffer(this.maybeAtPre(ac, String.valueOf(this.visit(ac.getSource())) + "." + name));
        if (ac.getNavigationSource() != null) {
            result.append('[').append(ToStringVisitorImpl.getName((ENamedElement)ac.getNavigationSource())).append(']');
        }
        return result.toString();
    }

    public Object visitVariable(Variable vd) {
        String varName = vd.getName();
        if (varName == null) {
            varName = NULL_PLACEHOLDER;
        }
        EClassifier type = vd.getType();
        OCLExpression init = vd.getInitExpression();
        String result = varName;
        if (type != null) {
            result = String.valueOf(result) + " : " + ToStringVisitorImpl.getName((ENamedElement)type);
        }
        if (init != null) {
            result = String.valueOf(result) + " = " + this.visit(init);
        }
        return result;
    }

    public Object visitIfExp(IfExp i) {
        OCLExpression cond = i.getCondition();
        OCLExpression thenexp = i.getThenExpression();
        OCLExpression elseexp = i.getElseExpression();
        return "if " + this.visit(cond) + " then " + this.visit(thenexp) + " else " + this.visit(elseexp) + " endif";
    }

    public Object visitTypeExp(TypeExp t) {
        return this.getQualifiedName(t.getReferredType());
    }

    private String getQualifiedName(EClassifier type) {
        StringBuffer result = new StringBuffer();
        this.appendQualifiedName(type, result);
        return result.toString();
    }

    private void appendQualifiedName(EClassifier type, StringBuffer buf) {
        if (type != null && type.getEPackage() != null) {
            this.appendQualifiedName(type.getEPackage(), buf);
            buf.append("::");
        }
        buf.append(ToStringVisitorImpl.getName((ENamedElement)type));
    }

    private void appendQualifiedName(EPackage pkg, StringBuffer buf) {
        if (pkg != null && pkg.getESuperPackage() != null) {
            this.appendQualifiedName(pkg.getESuperPackage(), buf);
            buf.append("::");
        }
        buf.append(ToStringVisitorImpl.getName((ENamedElement)pkg));
    }

    public Object visitStateExp(StateExp s) {
        return ToStringVisitorImpl.getName(s);
    }

    public Object visitUnspecifiedValueExp(UnspecifiedValueExp uv) {
        StringBuffer result = new StringBuffer();
        result.append("?");
        if (uv.getType() != null && uv.getType() != Types.OCL_VOID) {
            result.append(" : ");
            result.append(ToStringVisitorImpl.getName((ENamedElement)uv.getType()));
        }
        return result.toString();
    }

    public Object visitIntegerLiteralExp(IntegerLiteralExp il) {
        return il.getIntegerSymbol() == null ? NULL_PLACEHOLDER : il.getIntegerSymbol().toString();
    }

    public Object visitRealLiteralExp(RealLiteralExp rl) {
        return rl.getRealSymbol() == null ? NULL_PLACEHOLDER : rl.getRealSymbol().toString();
    }

    public Object visitStringLiteralExp(StringLiteralExp sl) {
        return "'" + (sl.getStringSymbol() == null ? NULL_PLACEHOLDER : sl.getStringSymbol()) + "'";
    }

    public Object visitBooleanLiteralExp(BooleanLiteralExp bl) {
        return bl.getBooleanSymbol() == null ? NULL_PLACEHOLDER : bl.getBooleanSymbol().toString();
    }

    public Object visitLetExp(LetExp l) {
        String result = "let " + this.visit(l.getVariable()) + " in " + this.visit(l.getIn());
        return result;
    }

    public Object visitIterateExp(IterateExp ie) {
        Variable vd = ie.getResult();
        EList iterators = ie.getIterator();
        int numIters = iterators.size();
        String result = String.valueOf(this.visit(ie.getSource())) + "->" + "iterate(";
        int i = 0;
        while (i < numIters) {
            Variable iter = (Variable)iterators.get(i);
            result = String.valueOf(result) + this.visit(iter);
            if (i < iterators.size() - 1) {
                result = String.valueOf(result) + ", ";
            }
            ++i;
        }
        result = String.valueOf(result) + "; " + this.visit(vd) + "| ";
        result = String.valueOf(result) + this.visit(ie.getBody()) + ")";
        return result;
    }

    public Object visitIteratorExp(IteratorExp ie) {
        EList iterators = ie.getIterator();
        int numIters = iterators.size();
        String result = String.valueOf(this.visit(ie.getSource())) + "->" + ie.getName() + "(";
        int i = 0;
        while (i < numIters) {
            Variable iter = (Variable)iterators.get(i);
            result = String.valueOf(result) + this.visit(iter);
            if (i < iterators.size() - 1) {
                result = String.valueOf(result) + ", ";
            }
            ++i;
        }
        result = String.valueOf(result) + " | ";
        result = String.valueOf(result) + this.visit(ie.getBody()) + ")";
        return result;
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp cl) {
        CollectionKind kind = cl.getKind();
        EList parts = cl.getPart();
        String result = kind == CollectionKind.SET_LITERAL ? "Set {" : (kind == CollectionKind.ORDERED_SET_LITERAL ? "OrderedSet {" : (kind == CollectionKind.BAG_LITERAL ? "Bag {" : "Sequence {"));
        Iterator it = parts.iterator();
        while (it.hasNext()) {
            CollectionLiteralPart item;
            CollectionLiteralPart part = (CollectionLiteralPart)it.next();
            if (part instanceof CollectionItem) {
                item = (CollectionItem)part;
                OCLExpression itemExp = item.getItem();
                result = String.valueOf(result) + (String)itemExp.accept(this);
            } else if (part instanceof CollectionRange) {
                item = (CollectionRange)part;
                result = String.valueOf(result) + this.visit(item.getFirst()) + ".." + this.visit(item.getLast());
            } else {
                result = String.valueOf(result) + NULL_PLACEHOLDER;
            }
            if (!it.hasNext()) continue;
            result = String.valueOf(result) + ", ";
        }
        return String.valueOf(result) + "}";
    }

    public Object visitTupleLiteralExp(TupleLiteralExp tl) {
        String result = "Tuple{";
        EList tuplePart = tl.getPart();
        Iterator iter = tuplePart.iterator();
        while (iter.hasNext()) {
            TupleLiteralPart tp = (TupleLiteralPart)iter.next();
            result = String.valueOf(result) + this.visit(tp);
            if (!iter.hasNext()) continue;
            result = String.valueOf(result) + ", ";
        }
        return String.valueOf(result) + "}";
    }

    public Object visitTupleLiteralPart(TupleLiteralPart tp) {
        String varName = ToStringVisitorImpl.getName(tp);
        EClassifier type = tp.getType();
        OCLExpression init = tp.getValue();
        String result = varName;
        if (type != null) {
            result = String.valueOf(result) + " : " + ToStringVisitorImpl.getName((ENamedElement)type);
        }
        if (init != null) {
            result = String.valueOf(result) + " = " + this.visit(init);
        }
        return result;
    }

    public Object visitMessageExp(MessageExp m) {
        StringBuffer result = new StringBuffer();
        result.append(this.visit(m.getTarget()));
        result.append(m.getType() == Types.OCL_BOOLEAN ? "^" : "^^");
        if (m.getCalledOperation() != null) {
            result.append(ToStringVisitorImpl.getName((ENamedElement)m.getCalledOperation().getOperation()));
        } else if (m.getSentSignal() != null) {
            result.append(ToStringVisitorImpl.getName((ENamedElement)m.getSentSignal().getSignal()));
        }
        result.append('(');
        Iterator iter = m.getArgument().iterator();
        while (iter.hasNext()) {
            result.append(this.visit((OCLExpression)iter.next()));
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        return result.toString();
    }

    public Object visitConstraint(Constraint constraint) {
        String stereo;
        StringBuffer result = new StringBuffer();
        EList constrained = constraint.getConstrainedElement();
        if (!constrained.isEmpty()) {
            EObject elem = (EObject)constrained.get(0);
            result.append("context ");
            if (elem instanceof EClassifier) {
                result.append(ToStringVisitorImpl.getName((ENamedElement)((EClassifier)elem)));
            } else if (elem instanceof EOperation) {
                this.appendOperationSignature(result, (EOperation)elem);
            } else if (elem instanceof EStructuralFeature) {
                this.appendPropertySignature(result, (EStructuralFeature)elem);
            }
            result.append(' ');
        }
        if ("precondition".equals(stereo = constraint.getStereotype())) {
            result.append("pre: ");
        } else if ("postcondition".equals(stereo)) {
            result.append("post: ");
        } else if ("body".equals(stereo)) {
            result.append("body: ");
        } else {
            result.append("inv: ");
        }
        result.append(this.visit(constraint.getBody()));
        return result.toString();
    }

    private void appendOperationSignature(StringBuffer buf, EOperation operation) {
        buf.append(ToStringVisitorImpl.getName((ENamedElement)operation)).append('(');
        boolean comma = false;
        Iterator iter = operation.getEParameters().iterator();
        while (iter.hasNext()) {
            EParameter parm = (EParameter)iter.next();
            if (comma) {
                buf.append(", ");
            } else {
                comma = true;
            }
            buf.append(ToStringVisitorImpl.getName((ENamedElement)parm)).append(" : ");
            if (parm.getEType() != null) {
                buf.append(ToStringVisitorImpl.getName((ENamedElement)parm.getEType()));
                continue;
            }
            buf.append(Types.OCL_VOID.getName());
        }
        buf.append(") :");
        if (operation.getEType() != null) {
            buf.append(' ').append(ToStringVisitorImpl.getName((ENamedElement)operation.getEType()));
        }
    }

    private void appendPropertySignature(StringBuffer buf, EStructuralFeature property) {
        buf.append(ToStringVisitorImpl.getName((ENamedElement)property));
        if (property.getEType() != null) {
            buf.append(" : ").append(ToStringVisitorImpl.getName((ENamedElement)property.getEType()));
        }
    }

    private String maybeAtPre(FeatureCallExp mpc, String base) {
        return mpc.isMarkedPre() ? String.valueOf(base) + "@pre" : base;
    }

    public Object visitInvalidLiteralExp(InvalidLiteralExp il) {
        return "OclInvalid";
    }

    public Object visitNullLiteralExp(NullLiteralExp il) {
        return "null";
    }

    private String visit(Visitable visitable) {
        return visitable == null ? NULL_PLACEHOLDER : (String)visitable.accept(this);
    }
}

