/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.expressions.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.impl.ValidationVisitorImpl;
import org.eclipse.emf.ocl.internal.OCLDebugOptions;
import org.eclipse.emf.ocl.internal.OCLPlugin;
import org.eclipse.emf.ocl.internal.parser.OCLLexer;
import org.eclipse.emf.ocl.internal.parser.OCLParser;
import org.eclipse.emf.ocl.parser.EcoreEnvironmentFactory;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.parser.ParserException;
import org.eclipse.emf.ocl.uml.Constraint;
import org.eclipse.emf.ocl.uml.UMLPackage;

public class ExpressionsUtil {
    private static final String SELF_NAME = "self";

    private ExpressionsUtil() {
    }

    public static Environment createClassifierContext(EClassifier classifier) {
        return EnvironmentFactory.ECORE_INSTANCE.createClassifierContext(classifier);
    }

    public static Environment createOperationContext(EClassifier classifier, EOperation operation) {
        return EnvironmentFactory.ECORE_INSTANCE.createOperationContext(classifier, operation);
    }

    public static Environment createOperationContext(EOperation operation) {
        return EnvironmentFactory.ECORE_INSTANCE.createOperationContext(operation.getEContainingClass(), operation);
    }

    public static Environment createPropertyContext(EClassifier classifier, EStructuralFeature property) {
        return EnvironmentFactory.ECORE_INSTANCE.createPropertyContext(classifier, property);
    }

    public static Environment createPropertyContext(EStructuralFeature property) {
        return EnvironmentFactory.ECORE_INSTANCE.createPropertyContext(property.getEContainingClass(), property);
    }

    public static OCLExpression createQuery(EClassifier context, String expression, boolean validate) throws ParserException {
        Environment env = ExpressionsUtil.createClassifierContext(context);
        return ExpressionsUtil.createQuery(env, expression, validate);
    }

    public static OCLExpression createQuery(Environment env, String expression, boolean validate) throws ParserException {
        OCLParser parser = ExpressionsUtil.createParser("inv:", expression);
        Constraint constraint = parser.parseInvOrDefCS(env);
        constraint.setInstanceVarName(SELF_NAME);
        OCLExpression result = constraint.getBody();
        constraint.setBody(null);
        if (validate) {
            result.accept(ValidationVisitorImpl.getInstance(env));
        }
        return result;
    }

    public static OCLExpression createInvariant(EClassifier context, String expression, boolean validate) throws ParserException {
        Environment env = ExpressionsUtil.createClassifierContext(context);
        return ExpressionsUtil.createInvariant(env, expression, validate);
    }

    public static OCLExpression createInvariant(Environment env, String expression, boolean validate) throws ParserException {
        OCLParser parser = ExpressionsUtil.createParser("inv:", expression);
        Constraint constraint = parser.parseInvOrDefCS(env);
        constraint.setInstanceVarName(SELF_NAME);
        OCLExpression result = constraint.getBody();
        if (validate) {
            constraint.accept(ValidationVisitorImpl.getInstance(env));
        }
        return result;
    }

    public static OCLExpression createPrecondition(EOperation context, String expression, boolean validate) throws ParserException {
        return ExpressionsUtil.createPrecondition((EClassifier)context.getEContainingClass(), context, expression, validate);
    }

    public static OCLExpression createPrecondition(EClassifier classifier, EOperation context, String expression, boolean validate) throws ParserException {
        Environment env = ExpressionsUtil.createOperationContext(classifier, context);
        return ExpressionsUtil.createPrecondition(env, expression, validate);
    }

    public static OCLExpression createPrecondition(Environment env, String expression, boolean validate) throws ParserException {
        OCLParser parser = ExpressionsUtil.createParser("pre:", expression);
        Constraint constraint = parser.parsePrePostOrBodyDeclCS(env, env.getContextOperation());
        constraint.setInstanceVarName(SELF_NAME);
        OCLExpression result = constraint.getBody();
        if (validate) {
            constraint.accept(ValidationVisitorImpl.getInstance(env));
        }
        return result;
    }

    public static OCLExpression createPostcondition(EOperation context, String expression, boolean validate) throws ParserException {
        return ExpressionsUtil.createPostcondition((EClassifier)context.getEContainingClass(), context, expression, validate);
    }

    public static OCLExpression createPostcondition(EClassifier classifier, EOperation context, String expression, boolean validate) throws ParserException {
        Environment env = ExpressionsUtil.createOperationContext(classifier, context);
        return ExpressionsUtil.createPostcondition(env, expression, validate);
    }

    public static OCLExpression createPostcondition(Environment env, String expression, boolean validate) throws ParserException {
        OCLParser parser = ExpressionsUtil.createParser("post:", expression);
        Constraint constraint = parser.parsePrePostOrBodyDeclCS(env, env.getContextOperation());
        constraint.setInstanceVarName(SELF_NAME);
        OCLExpression result = constraint.getBody();
        if (validate) {
            constraint.accept(ValidationVisitorImpl.getInstance(env));
        }
        return result;
    }

    public static OCLExpression createBodyCondition(EOperation context, String expression, boolean validate) throws ParserException {
        return ExpressionsUtil.createBodyCondition((EClassifier)context.getEContainingClass(), context, expression, validate);
    }

    public static OCLExpression createBodyCondition(EClassifier classifier, EOperation context, String expression, boolean validate) throws ParserException {
        Environment env = ExpressionsUtil.createOperationContext(classifier, context);
        return ExpressionsUtil.createBodyCondition(env, expression, validate);
    }

    public static OCLExpression createBodyCondition(Environment env, String expression, boolean validate) throws ParserException {
        OCLParser parser = ExpressionsUtil.createParser("body:", expression);
        Constraint constraint = parser.parsePrePostOrBodyDeclCS(env, env.getContextOperation());
        constraint.setInstanceVarName(SELF_NAME);
        OCLExpression result = constraint.getBody();
        if (validate) {
            constraint.accept(ValidationVisitorImpl.getInstance(env));
        }
        return result;
    }

    public static OCLExpression createInitialValueExpression(EStructuralFeature context, String expression, boolean validate) throws ParserException {
        return ExpressionsUtil.createInitialValueExpression((EClassifier)context.getEContainingClass(), context, expression, validate);
    }

    public static OCLExpression createInitialValueExpression(EClassifier classifier, EStructuralFeature context, String expression, boolean validate) throws ParserException {
        Environment env = ExpressionsUtil.createPropertyContext(classifier, context);
        return ExpressionsUtil.createInitialValueExpression(env, expression, validate);
    }

    public static OCLExpression createInitialValueExpression(Environment env, String expression, boolean validate) throws ParserException {
        OCLParser parser = ExpressionsUtil.createParser("init:", expression);
        Constraint constraint = parser.parseInitOrDerValueCS(env, env.getContextProperty());
        constraint.setInstanceVarName(SELF_NAME);
        OCLExpression result = constraint.getBody();
        if (validate) {
            constraint.accept(ValidationVisitorImpl.getInstance(env));
        }
        return result;
    }

    public static OCLExpression createDerivedValueExpression(EStructuralFeature context, String expression, boolean validate) throws ParserException {
        return ExpressionsUtil.createDerivedValueExpression((EClassifier)context.getEContainingClass(), context, expression, validate);
    }

    public static OCLExpression createDerivedValueExpression(EClassifier classifier, EStructuralFeature context, String expression, boolean validate) throws ParserException {
        Environment env = ExpressionsUtil.createPropertyContext(classifier, context);
        return ExpressionsUtil.createDerivedValueExpression(env, expression, validate);
    }

    public static OCLExpression createDerivedValueExpression(Environment env, String expression, boolean validate) throws ParserException {
        OCLParser parser = ExpressionsUtil.createParser("derive:", expression);
        Constraint constraint = parser.parseInitOrDerValueCS(env, env.getContextProperty());
        constraint.setInstanceVarName(SELF_NAME);
        OCLExpression result = constraint.getBody();
        if (validate) {
            constraint.accept(ValidationVisitorImpl.getInstance(env));
        }
        return result;
    }

    public static void define(EClassifier context, String expression) throws ParserException {
        Environment env = ExpressionsUtil.createClassifierContext(context);
        ExpressionsUtil.define(env, expression);
    }

    public static ETypedElement define(Environment env, String defExpression) throws ParserException {
        OCLParser parser = ExpressionsUtil.createParser("def:", env.getFactory(), defExpression);
        Constraint constraint = parser.parseInvOrDefCS(env);
        constraint.setInstanceVarName(SELF_NAME);
        constraint.accept(ValidationVisitorImpl.getInstance(env));
        return (ETypedElement)constraint.getConstrainedElement().get(1);
    }

    private static OCLParser createParser(String prefix, String text) {
        return ExpressionsUtil.createParser(prefix, EcoreEnvironmentFactory.ECORE_INSTANCE, text);
    }

    private static OCLParser createParser(String prefix, EnvironmentFactory environmentFactory, String text) {
        OCLLexer lexer = new OCLLexer((String.valueOf(prefix) + '\n' + text).toCharArray());
        OCLParser result = new OCLParser(lexer, environmentFactory);
        result.setErrorReportLineOffset(-1);
        result.setCharacterOffset(-(prefix.length() + 1));
        result.setTraceFlag(OCLPlugin.shouldTrace(OCLDebugOptions.DEBUG));
        return result;
    }

    public static EObject containerOfType(EClass type, EObject eObject) {
        EObject result = eObject.eContainer();
        while (result != null) {
            if (type.isInstance((Object)result)) break;
            result = result.eContainer();
        }
        return result;
    }

    public static boolean isInPostcondition(OCLExpression exp) {
        Constraint constraint = (Constraint)ExpressionsUtil.containerOfType(UMLPackage.Literals.CONSTRAINT, exp);
        return constraint != null && "postcondition".equals(constraint.getStereotype());
    }
}

