/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.helper;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ocl.expressions.BooleanLiteralExp;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.emf.ocl.expressions.util.ExpressionsUtil;
import org.eclipse.emf.ocl.helper.ConstraintType;
import org.eclipse.emf.ocl.helper.HelperUtil;
import org.eclipse.emf.ocl.helper.IOCLHelper;
import org.eclipse.emf.ocl.helper.OCLParsingException;
import org.eclipse.emf.ocl.helper.OCLSyntaxHelper;
import org.eclipse.emf.ocl.internal.OCLPlugin;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.query.Query;
import org.eclipse.emf.ocl.query.QueryFactory;
import org.eclipse.emf.ocl.types.PrimitiveBoolean;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.util.Types;

class OCLHelper
implements IOCLHelper {
    private EnvironmentFactory environmentFactory;
    private Environment environment;
    private OCLSyntaxHelper oclSyntaxHelper;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    OCLHelper(EnvironmentFactory factory) {
        if (factory == null) {
            HelperUtil.throwException(new IllegalArgumentException("OCLHelper"), this.getClass(), "OCLHelper");
        }
        this.environmentFactory = factory;
    }

    public EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String removeOCLComments(String txt) {
        try {
            return HelperUtil.getLogicalLine(txt);
        }
        catch (Exception ex) {
            HelperUtil.catchException(ex, this.getClass(), "removeOCLComments");
            return "";
        }
    }

    public void setContext(Object context) {
        this.environment = this.environmentFactory.createClassifierContext(context);
    }

    public void setContextOperation(Object context, Object operation) {
        this.environment = this.environmentFactory.createOperationContext(context, operation);
    }

    public void setContextProperty(Object context, Object property) {
        this.environment = this.environmentFactory.createPropertyContext(context, property);
    }

    public EClassifier getContextClassifier() {
        return this.environment.getContextClassifier();
    }

    public EOperation getContextOperation() {
        return this.environment.getContextOperation();
    }

    public EStructuralFeature getContextProperty() {
        return this.environment.getContextProperty();
    }

    public List getSyntaxHelp(String txt) {
        return this.getContextOperation() != null ? this.getSyntaxHelp(ConstraintType.POSTCONDITION, txt) : this.getSyntaxHelp(ConstraintType.INVARIANT, txt);
    }

    public List getSyntaxHelp(ConstraintType constraintType, String txt) {
        return this.getOCLSyntaxHelper().getSyntaxHelp(this.environment, constraintType, txt);
    }

    public OCLExpression createQuery(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createQuery(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createQuery");
            }
        }
        return this.createNullCondition((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
    }

    public OCLExpression createInvariant(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createInvariant(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createInvariant");
            }
        }
        return this.createNullCondition((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
    }

    public OCLExpression createPrecondition(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createPrecondition(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createPrecondition");
            }
        }
        return this.createNullCondition((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
    }

    public OCLExpression createPostcondition(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createPostcondition(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createPostcondition");
            }
        }
        return this.createNullCondition((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
    }

    public OCLExpression createBodyCondition(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createBodyCondition(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createBodyCondition");
            }
        }
        return this.createNullCondition(Types.OCL_VOID);
    }

    public OCLExpression createInitialValueExpression(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createInitialValueExpression(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createInitialValueExpression");
            }
        }
        return this.createNullCondition(Types.OCL_VOID);
    }

    public OCLExpression createDerivedValueExpression(String expression) throws OCLParsingException {
        if (this.removeOCLComments(expression).length() > 0) {
            try {
                return ExpressionsUtil.createDerivedValueExpression(this.environment, expression, true);
            }
            catch (Exception e) {
                this.propagate(e, "createDerivedValueExpression");
            }
        }
        return this.createNullCondition(Types.OCL_VOID);
    }

    public ETypedElement define(String defExpression) throws OCLParsingException {
        try {
            return ExpressionsUtil.define(this.environment, defExpression);
        }
        catch (Exception e) {
            this.propagate(e, "define");
            return null;
        }
    }

    public Object evaluate(Object context, OCLExpression expr) {
        Object result = null;
        Query q = QueryFactory.eINSTANCE.createQuery(expr);
        q.setExtentMap(this.environmentFactory.createExtentMap(context));
        q.setEvaluationEnvironment(this.environmentFactory.createEvaluationEnvironment());
        result = q.evaluate(context);
        return result;
    }

    public Object evaluate(Object context, String expr) throws OCLParsingException {
        OCLExpression ocl = null;
        try {
            ocl = ExpressionsUtil.createQuery(this.environment, expr, true);
        }
        catch (Exception e) {
            this.propagate(e, "evaluate");
        }
        return this.evaluate(context, ocl);
    }

    public boolean check(Object context, OCLExpression constraint) {
        if (!(constraint.getType() instanceof PrimitiveBoolean)) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        Object result = this.evaluate(context, constraint);
        return Boolean.TRUE.equals(result);
    }

    public boolean check(Object context, String constraint) throws OCLParsingException {
        OCLExpression ocl = null;
        try {
            ocl = ExpressionsUtil.createInvariant(this.environment, constraint, true);
        }
        catch (Exception e) {
            this.propagate(e, "evaluate");
        }
        return this.check(context, ocl);
    }

    private OCLExpression createNullCondition(EClassifier type) {
        OCLExpression result;
        if (OCLHelper.isBoolean(type)) {
            BooleanLiteralExp literal;
            result = literal = ExpressionsFactory.eINSTANCE.createBooleanLiteralExp();
            literal.setType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
            literal.setBooleanSymbol(Boolean.FALSE);
        } else {
            UnspecifiedValueExp unspec = ExpressionsFactory.eINSTANCE.createUnspecifiedValueExp();
            result = unspec;
            if (type == null) {
                type = Types.OCL_VOID;
            }
            unspec.setType(type);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isBoolean(EClassifier type) {
        boolean result = TypesPackage.eINSTANCE.getPrimitiveBoolean().isInstance((Object)type);
        if (result) return result;
        if (type == null) return result;
        Class javaClass = type.getInstanceClass();
        if (javaClass == Boolean.TYPE) return true;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (javaClass == clazz) return true;
        return false;
    }

    private void propagate(Exception e, String method) throws OCLParsingException {
        OCLPlugin.catching(this.getClass(), method, e);
        OCLParsingException ope = new OCLParsingException(e.getLocalizedMessage(), e);
        OCLPlugin.throwing(this.getClass(), method, ope);
        throw ope;
    }

    protected OCLSyntaxHelper getOCLSyntaxHelper() {
        if (this.oclSyntaxHelper == null) {
            this.oclSyntaxHelper = new OCLSyntaxHelper(this.getEnvironmentFactory());
        }
        return this.oclSyntaxHelper;
    }
}

