/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.helper;

import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ocl.expressions.AssociationClassCallExp;
import org.eclipse.emf.ocl.expressions.BooleanLiteralExp;
import org.eclipse.emf.ocl.expressions.CollectionLiteralExp;
import org.eclipse.emf.ocl.expressions.EnumLiteralExp;
import org.eclipse.emf.ocl.expressions.IfExp;
import org.eclipse.emf.ocl.expressions.IntegerLiteralExp;
import org.eclipse.emf.ocl.expressions.InvalidLiteralExp;
import org.eclipse.emf.ocl.expressions.IterateExp;
import org.eclipse.emf.ocl.expressions.IteratorExp;
import org.eclipse.emf.ocl.expressions.LetExp;
import org.eclipse.emf.ocl.expressions.MessageExp;
import org.eclipse.emf.ocl.expressions.NullLiteralExp;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.OperationCallExp;
import org.eclipse.emf.ocl.expressions.PropertyCallExp;
import org.eclipse.emf.ocl.expressions.RealLiteralExp;
import org.eclipse.emf.ocl.expressions.StateExp;
import org.eclipse.emf.ocl.expressions.StringLiteralExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralPart;
import org.eclipse.emf.ocl.expressions.TypeExp;
import org.eclipse.emf.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.expressions.VariableExp;
import org.eclipse.emf.ocl.expressions.Visitor;
import org.eclipse.emf.ocl.expressions.util.ExpressionsUtil;
import org.eclipse.emf.ocl.helper.Choice;
import org.eclipse.emf.ocl.helper.ChoiceType;
import org.eclipse.emf.ocl.helper.ConstraintType;
import org.eclipse.emf.ocl.internal.parser.OCLLexer;
import org.eclipse.emf.ocl.internal.parser.OCLParser;
import org.eclipse.emf.ocl.parser.EcoreEnvironment;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.parser.ParserException;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.emf.ocl.uml.Constraint;

final class OCLSyntaxHelper {
    private static final int NONE = -1;
    private static final int DOT = 0;
    private static final int ARROW = 1;
    private static final int DOUBLE_COLON = 2;
    private static final int CARET = 3;
    private static final int OCL_IS_IN_STATE = 4;
    private static final Set INFIX_OPERATORS = new HashSet();
    private static final Set ANY_TYPE_OPERATIONS;
    private int syntaxHelpStringSuffix;
    private EnvironmentFactory environmentFactory;
    private Environment environment;

    static {
        INFIX_OPERATORS.add("-");
        INFIX_OPERATORS.add("+");
        INFIX_OPERATORS.add("/");
        INFIX_OPERATORS.add("*");
        INFIX_OPERATORS.add("<");
        INFIX_OPERATORS.add("<=");
        INFIX_OPERATORS.add(">");
        INFIX_OPERATORS.add(">=");
        INFIX_OPERATORS.add("=");
        INFIX_OPERATORS.add("<>");
        ANY_TYPE_OPERATIONS = new HashSet();
        Iterator iter = Types.OCL_ANY_TYPE.getOperations().iterator();
        while (iter.hasNext()) {
            ANY_TYPE_OPERATIONS.add(((EOperation)iter.next()).getName());
        }
    }

    OCLSyntaxHelper(EnvironmentFactory factory) {
        this.environmentFactory = factory;
    }

    private List getCollectionChoices(CollectionType ct) {
        ArrayList result = new ArrayList();
        result.addAll(this.getOperationChoices((EClassifier)ct));
        return result;
    }

    private List getAnyChoices() {
        return this.getOperationChoices(Types.OCL_ANY_TYPE);
    }

    private List getOperationChoices(EClassifier owner) {
        List result = this.getOperationChoices(owner, (List)TypeUtil.getOperations(owner));
        if (owner instanceof CollectionTypeImpl) {
            result.addAll(this.getOperationChoices(owner, (List)((CollectionTypeImpl)owner).getIterators()));
        }
        return result;
    }

    private List getOperationChoices(EClassifier owner, List operations) {
        ArrayList<Choice> result = new ArrayList<Choice>(operations.size());
        Iterator iter = operations.iterator();
        while (iter.hasNext()) {
            EOperation operation = (EOperation)iter.next();
            if (this.syntaxHelpStringSuffix != 3 && !this.isQuery(operation)) continue;
            operation = TypeUtil.resolveGenericSignature(owner, operation);
            Choice choice = new Choice(operation.getName(), this.getDescription(operation), ChoiceType.BEHAVIORAL_FEATURE);
            result.add(choice);
        }
        return result;
    }

    private List getReceptionChoices(EClass owner) {
        EList signals = this.environment.getSignals((EClassifier)owner);
        ArrayList<Choice> result = new ArrayList<Choice>(signals.size());
        Iterator iter = signals.iterator();
        while (iter.hasNext()) {
            EClass signal = (EClass)iter.next();
            Choice choice = new Choice(signal.getName(), this.getSignalDescription(signal), ChoiceType.BEHAVIORAL_FEATURE);
            result.add(choice);
        }
        return result;
    }

    private boolean isQuery(EOperation operation) {
        return this.environment.isQuery(operation);
    }

    private String getDescription(EOperation operation) {
        StringBuffer result = new StringBuffer();
        result.append(operation.getName());
        result.append('(');
        Iterator iter = operation.getEParameters().iterator();
        while (iter.hasNext()) {
            EParameter next = (EParameter)iter.next();
            result.append(next.getName());
            if (next.getEType() != null) {
                result.append(": ");
                result.append(this.getDescription((ENamedElement)next));
            }
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        if (operation.getEType() == null) {
            result.append(')');
        } else {
            result.append(") : ");
            result.append(operation.getEType().getName());
        }
        return result.toString();
    }

    private String getSignalDescription(EClass signal) {
        StringBuffer result = new StringBuffer();
        result.append("<<signal>> ");
        result.append(signal.getName());
        result.append('(');
        Iterator iter = signal.getEAllStructuralFeatures().iterator();
        while (iter.hasNext()) {
            EStructuralFeature next = (EStructuralFeature)iter.next();
            result.append(next.getName());
            if (next.getEType() != null) {
                result.append(": ");
                result.append(this.getDescription((ENamedElement)next));
            }
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        return result.toString();
    }

    private List getChoicesForEClassEStructuralFeatures(EClass eClass) {
        ArrayList<Choice> list = new ArrayList<Choice>();
        HashSet features = new HashSet(TypeUtil.getProperties((EClassifier)eClass));
        features.removeAll((Collection<?>)EcorePackage.eINSTANCE.getEModelElement().getEAllStructuralFeatures());
        Iterator it = features.iterator();
        EStructuralFeature eFeature = null;
        while (it.hasNext()) {
            String name;
            Choice choice;
            EClass assocClass;
            eFeature = (EStructuralFeature)it.next();
            list.add(new Choice(eFeature.getName(), this.getDescription((ENamedElement)eFeature), eFeature.getEType() instanceof EEnum ? ChoiceType.ENUMERATION_LITERAL : ChoiceType.STRUCTURAL_FEATURE));
            if (!(eFeature instanceof EReference) || (assocClass = this.environment.getAssociationClass((EReference)eFeature)) == null || list.contains(choice = new Choice(name = EcoreEnvironment.initialLower((ENamedElement)assocClass), this.getDescription((ENamedElement)assocClass), ChoiceType.STRUCTURAL_FEATURE))) continue;
            list.add(choice);
        }
        return list;
    }

    private List getChoices(OCLExpression expression, ConstraintType constraintType) {
        return this.getChoices(expression.getType(), constraintType);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List getChoices(EClassifier type, ConstraintType constraintType) {
        List rawChoices;
        if (type instanceof CollectionType) {
            CollectionType ct = (CollectionType)type;
            if (this.syntaxHelpStringSuffix == 1) {
                rawChoices = this.getCollectionChoices(ct);
                return this.filter(rawChoices, constraintType);
            }
            if (this.syntaxHelpStringSuffix != 0) return Collections.EMPTY_LIST;
            return this.getChoices(ct.getElementType(), constraintType);
        }
        if (type instanceof EClass) {
            EClass eclass = (EClass)type;
            if (this.syntaxHelpStringSuffix == 1) {
                return this.getChoices((EClassifier)TypesFactory.eINSTANCE.createSetType((EClassifier)eclass), constraintType);
            }
            if (this.syntaxHelpStringSuffix == 0) {
                rawChoices = this.getChoicesForEClassEStructuralFeatures(eclass);
                rawChoices.addAll(this.getOperationChoices((EClassifier)eclass));
                return this.filter(rawChoices, constraintType);
            }
            if (this.syntaxHelpStringSuffix != 3) return Collections.EMPTY_LIST;
            rawChoices = this.getOperationChoices((EClassifier)eclass);
            rawChoices.addAll(this.getReceptionChoices(eclass));
            return this.filter(rawChoices, constraintType);
        }
        if (this.syntaxHelpStringSuffix == 1) {
            return this.getChoices((EClassifier)TypesFactory.eINSTANCE.createSetType(type), constraintType);
        }
        if (this.syntaxHelpStringSuffix == 0) {
            rawChoices = this.getOperationChoices(type);
            return this.filter(rawChoices, constraintType);
        }
        if (this.syntaxHelpStringSuffix != 3) return Collections.EMPTY_LIST;
        rawChoices = this.getOperationChoices(type);
        return this.filter(rawChoices, constraintType);
    }

    private List filter(List choices, ConstraintType constraintType) {
        List result = choices;
        Iterator iter = choices.iterator();
        block3: while (iter.hasNext()) {
            Choice next = (Choice)iter.next();
            switch (constraintType.getValue()) {
                case 0: 
                case 1: 
                case 2: {
                    if ("oclIsNew".equals(next.getName())) {
                        iter.remove();
                        break;
                    }
                }
                default: {
                    if (INFIX_OPERATORS.contains(next.getName())) {
                        iter.remove();
                        break;
                    }
                    if (this.syntaxHelpStringSuffix != 3 || !ANY_TYPE_OPERATIONS.contains(next.getName())) continue block3;
                    iter.remove();
                }
            }
        }
        return result;
    }

    private List getPathChoices(List path, Environment env) throws Exception {
        if (!path.isEmpty()) {
            EPackage ePackage = env.lookupPackage(path);
            if (ePackage != null) {
                return this.getPathChoices(ePackage);
            }
            EClassifier eClassifier = env.lookupPathName(path);
            if (eClassifier instanceof EEnum) {
                return this.getPathChoices((EEnum)eClassifier);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List getStateChoices(EClassifier owner, List pathPrefix, Environment env) throws Exception {
        ArrayList result;
        EList states = env.getStates(owner, pathPrefix);
        if (states.isEmpty()) {
            result = Collections.EMPTY_LIST;
        } else {
            LinkedHashSet<Choice> choices = new LinkedHashSet<Choice>();
            Iterator iter = states.iterator();
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                choices.add(new Choice(this.environment.getStateName(next), Types.STATE.getName(), ChoiceType.STRUCTURAL_FEATURE));
            }
            result = new ArrayList(choices);
        }
        return result;
    }

    private List getPathChoices(EEnum eEnum) {
        ArrayList<Choice> contents = new ArrayList<Choice>();
        Iterator it = eEnum.getELiterals().iterator();
        while (it.hasNext()) {
            EEnumLiteral eEnumLiteral = (EEnumLiteral)it.next();
            contents.add(new Choice(eEnumLiteral.getName(), this.getDescription((ENamedElement)eEnumLiteral), ChoiceType.STRUCTURAL_FEATURE));
        }
        return contents;
    }

    private List getPathChoices(EPackage ePackage) {
        LinkedHashSet<Choice> choices = new LinkedHashSet<Choice>();
        Iterator iter = ePackage.getESubpackages().iterator();
        while (iter.hasNext()) {
            EPackage next = (EPackage)iter.next();
            choices.add(new Choice(next.getName(), this.getDescription((ENamedElement)next), ChoiceType.STRUCTURAL_FEATURE));
        }
        Iterator it = ePackage.getEClassifiers().iterator();
        EClassifier eClassifier = null;
        while (it.hasNext()) {
            eClassifier = (EClassifier)it.next();
            choices.add(new Choice(eClassifier.getName(), this.getDescription((ENamedElement)eClassifier), ChoiceType.STRUCTURAL_FEATURE));
        }
        return new ArrayList(choices);
    }

    private List getVariableChoices(Environment env, String txt, ConstraintType constraintType) {
        LinkedHashSet<Choice> choices = new LinkedHashSet<Choice>();
        int oldSuffix = this.syntaxHelpStringSuffix;
        this.syntaxHelpStringSuffix = 0;
        choices.addAll(this.getChoices(env.getSelfVariable().getType(), constraintType));
        this.syntaxHelpStringSuffix = oldSuffix;
        List tokens = this.tokenize(txt);
        try {
            this.getVariables(env, txt, tokens.listIterator(tokens.size()));
        }
        catch (Exception exception) {}
        Iterator iter = env.getVariables().iterator();
        while (iter.hasNext()) {
            Variable next = (Variable)iter.next();
            choices.add(new Choice(next.getName(), this.getDescription((ENamedElement)next.getType()), ChoiceType.VARIABLE));
        }
        return this.filter(new ArrayList(choices), constraintType);
    }

    private List getPartialNameChoices(String text, Environment env, ConstraintType constraintType, int position) {
        List result = this.getSyntaxHelp(env, constraintType, text.substring(0, position));
        String partial = text.substring(position).trim();
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            Choice next = (Choice)iter.next();
            if (next.getName().startsWith(partial)) continue;
            iter.remove();
        }
        return result;
    }

    private int tokenAt(String text, int tokenIndex) {
        int result = 62;
        List tokens = this.tokenize(text);
        if (tokenIndex < 0) {
            tokenIndex = tokens.size() + tokenIndex;
        }
        if (tokenIndex >= 0 && tokenIndex < tokens.size()) {
            result = ((IToken)tokens.get(tokenIndex)).getKind();
        }
        return result;
    }

    private List tokenize(String text) {
        OCLLexer lexer = new OCLLexer(text.toCharArray());
        return this.tokenize(new OCLParser(lexer));
    }

    private List tokenize(OCLParser parser) {
        IToken token = null;
        ArrayList<IToken> result = new ArrayList<IToken>();
        try {
            while ((token = parser.getIToken(parser.getToken())).getKind() != 62) {
                result.add(token);
            }
        }
        catch (Exception exception) {
        }
        return result;
    }

    private String getDescription(ENamedElement namedElement) {
        if (this.environment != null) {
            return this.environment.getDescription(namedElement);
        }
        if (namedElement instanceof ETypedElement) {
            return this.getDescription((ENamedElement)((ETypedElement)namedElement).getEType());
        }
        if (namedElement instanceof EEnumLiteral) {
            return ((EEnumLiteral)namedElement).getEEnum().getName();
        }
        if (namedElement == null) {
            return null;
        }
        return namedElement.getName();
    }

    List getSyntaxHelp(Environment env, ConstraintType constraintType, String txt) {
        this.environment = env;
        try {
            List choices;
            List pathNames;
            txt = txt.trim();
            if (txt.endsWith(".")) {
                this.syntaxHelpStringSuffix = 0;
                int position = txt.lastIndexOf(".");
                return (List)this.getOCLExpression(position, txt, env, constraintType).accept(new ASTVisitor(txt, position, constraintType));
            }
            if (txt.endsWith("->")) {
                this.syntaxHelpStringSuffix = 1;
                int position = txt.lastIndexOf("->");
                return (List)this.getOCLExpression(position, txt, env, constraintType).accept(new ASTVisitor(txt, position, constraintType));
            }
            if (txt.endsWith("^")) {
                this.syntaxHelpStringSuffix = 3;
                int position = txt.endsWith("^^") ? txt.length() - 2 : txt.length() - 1;
                return (List)this.getOCLExpression(position, txt, env, constraintType).accept(new ASTVisitor(txt, position, constraintType));
            }
            if (txt.endsWith("::")) {
                this.syntaxHelpStringSuffix = -1;
                int position = txt.length() - 2;
                ArrayList<String> pathName = new ArrayList<String>();
                OCLLexer lexer = new OCLLexer(txt.toCharArray());
                OCLParser parser = new OCLParser(lexer);
                List tokens = this.tokenize(parser);
                ListIterator iter = tokens.listIterator(tokens.size());
                while (iter.hasPrevious() && this.syntaxHelpStringSuffix == -1) {
                    IToken prev = (IToken)iter.previous();
                    switch (prev.getKind()) {
                        case 1: {
                            if (iter.hasPrevious() && (prev = (IToken)iter.previous()).getKind() == 40) {
                                this.syntaxHelpStringSuffix = 4;
                                position = prev.getStartOffset();
                                break;
                            }
                            this.syntaxHelpStringSuffix = 2;
                            break;
                        }
                        case 3: {
                            pathName.add(0, parser.getTokenText(prev.getTokenIndex()));
                            break;
                        }
                        case 43: {
                            break;
                        }
                        default: {
                            this.syntaxHelpStringSuffix = 2;
                        }
                    }
                }
                if (this.syntaxHelpStringSuffix == 4) {
                    EClassifier sourceType = this.getOCLExpression(txt.lastIndexOf(".", position), txt, env, constraintType).getType();
                    return this.getStateChoices(sourceType, pathName, env);
                }
                return this.getPathChoices(pathName, env);
            }
            if (txt.endsWith("(") && this.tokenAt(txt, -2) == 40) {
                this.syntaxHelpStringSuffix = 4;
                EClassifier sourceType = this.getOCLExpression(txt.lastIndexOf("."), txt, env, constraintType).getType();
                return this.getStateChoices(sourceType, Collections.EMPTY_LIST, env);
            }
            OCLLexer lexer = new OCLLexer(txt.toCharArray());
            OCLParser parser = new OCLParser(lexer);
            List tokens = this.tokenize(parser);
            if (tokens.size() > 2) {
                IToken last = (IToken)tokens.get(tokens.size() - 1);
                IToken prev = (IToken)tokens.get(tokens.size() - 2);
                if (OCLParser.isIdentifierOrKeyword(last.getKind())) {
                    switch (prev.getKind()) {
                        case 43: 
                        case 70: 
                        case 72: {
                            return this.getPartialNameChoices(txt, env, constraintType, prev.getEndOffset() + 1);
                        }
                    }
                }
            }
            if (tokens.size() > 1 && !(pathNames = this.parseTokensPathNameCS(parser, tokens)).isEmpty() && !(choices = this.getPartialNameChoices(txt, env, constraintType, txt.lastIndexOf("::") + "::".length())).isEmpty()) {
                return choices;
            }
            this.syntaxHelpStringSuffix = -1;
            env = this.copyEnvironment(env);
            return this.getVariableChoices(env, txt, constraintType);
        }
        catch (Exception exception) {
            env = this.copyEnvironment(env);
            return this.getVariableChoices(env, txt, constraintType);
        }
    }

    private List parseTokensPathNameCS(OCLParser parser, List tokens) {
        ArrayList<String> path = new ArrayList<String>();
        int index = tokens.size() - 1;
        boolean doubleColon = false;
        while (index >= 0) {
            IToken token = (IToken)tokens.get(index--);
            if (!doubleColon || token.getKind() != 43) {
                if (doubleColon || token.getKind() != 3) break;
                path.add(0, parser.getTokenText(token.getTokenIndex()));
            }
            boolean bl = doubleColon = !doubleColon;
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    private OCLExpression getOCLExpression(int index, String txt, Environment env, ConstraintType constraintType) throws Exception {
        try {
            return this.getOCLExpression(env, txt.substring(0, index), constraintType);
        }
        catch (Exception ex) {
            newTxt = txt.substring(0, index);
            lexer = new OCLLexer(newTxt.toCharArray());
            parser = new OCLParser(lexer);
            tokens = this.tokenize(parser);
            it = tokens.listIterator(tokens.size());
            token = null;
            ** while (it.hasPrevious())
        }
lbl-1000:
        // 1 sources

        {
            token = (IToken)it.previous();
            if (!OCLParser.isIdentifierOrKeyword(token.getKind()) || !it.hasPrevious() || (previousToken = (IToken)it.previous()).getKind() == 70 || previousToken.getKind() == 72) continue;
            if (parser.getTokenText(token.getTokenIndex()) == null) break;
            it.next();
            beginIndex = token.getStartOffset();
            env = this.copyEnvironment(env);
            this.getVariables(env, txt.substring(0, index), it);
            if (beginIndex == -1) break;
            return this.getOCLExpression(env, txt.substring(beginIndex, index), constraintType);
        }
lbl21:
        // 3 sources

        throw ex;
    }

    private void getVariables(Environment env, String text, ListIterator tokens) throws ParserException {
        IToken token = null;
        while (tokens.hasPrevious()) {
            IToken ot;
            int beginIndex;
            token = (IToken)tokens.previous();
            if (token.getKind() == 54) {
                beginIndex = 0;
                while (tokens.hasPrevious()) {
                    ot = (IToken)tokens.previous();
                    if (ot.getKind() != 1) continue;
                    beginIndex = ot.getEndOffset() + 1;
                    break;
                }
                this.parseIterators(env, text.substring(beginIndex, token.getStartOffset()));
                continue;
            }
            if (token.getKind() != 82) continue;
            beginIndex = 0;
            while (tokens.hasPrevious()) {
                ot = (IToken)tokens.previous();
                if (ot.getKind() != 53) continue;
                beginIndex = ot.getEndOffset() + 1;
                break;
            }
            this.parseVariable(env, text.substring(beginIndex, token.getStartOffset()));
        }
    }

    private void parseIterators(Environment env, String variables) throws ParserException {
        int beginIndex = 0;
        OCLLexer mainLexer = new OCLLexer(variables.toCharArray());
        OCLParser mainParser = new OCLParser(mainLexer);
        if (!this.parseVariableDeclaration(env, mainParser)) {
            mainParser.reset();
            IToken token = mainParser.getIToken(mainParser.getToken());
            while (token.getKind() != 62) {
                String newTxt;
                OCLLexer lexer;
                OCLParser parser;
                if ((token.getKind() == 27 || token.getKind() == 71) && this.parseVariableDeclaration(env, parser = new OCLParser(lexer = new OCLLexer((newTxt = variables.substring(beginIndex, token.getStartOffset())).toCharArray()))) && this.parseVariableDeclaration(env, parser = new OCLParser(lexer = new OCLLexer((newTxt = variables.substring(beginIndex = token.getEndOffset() + 1)).toCharArray())))) break;
                token = mainParser.getIToken(mainParser.getToken());
            }
        }
    }

    private void parseVariable(Environment env, String variables) throws ParserException {
        OCLLexer lexer = new OCLLexer(variables.toCharArray());
        OCLParser parser = new OCLParser(lexer);
        this.parseVariableDeclaration(env, parser);
    }

    private boolean parseVariableDeclaration(Environment env, OCLParser p) {
        try {
            p.parseVariableDeclarationCS(env, true);
            return true;
        }
        catch (SemanticException semanticException) {
            return true;
        }
        catch (ParserException parserException) {
            return false;
        }
    }

    private Environment copyEnvironment(Environment env) {
        return this.environmentFactory.createEnvironment(env);
    }

    private OCLExpression getOCLExpression(Environment env, String text, ConstraintType constraintType) throws Exception {
        OCLExpression result = null;
        switch (constraintType.getValue()) {
            case 1: {
                result = ExpressionsUtil.createPrecondition(env, text, false);
                break;
            }
            case 2: {
                result = ExpressionsUtil.createBodyCondition(env, text, false);
                break;
            }
            case 3: {
                result = ExpressionsUtil.createPostcondition(env, text, false);
                break;
            }
            case 0: {
                result = ExpressionsUtil.createInvariant(env, text, false);
                break;
            }
            default: {
                result = ExpressionsUtil.createQuery(env, text, false);
            }
        }
        return result;
    }

    private class ASTVisitor
    implements Visitor {
        private final int completionPosition;
        private final String text;
        private final ConstraintType constraintType;

        ASTVisitor(String text, int position, ConstraintType constraintType) {
            this.text = text;
            this.completionPosition = position;
            this.constraintType = constraintType;
        }

        public Object visitOperationCallExp(OperationCallExp exp) {
            OCLExpression last;
            EList args;
            if (exp.getEndPosition() == this.completionPosition && !(args = exp.getArgument()).isEmpty() && (last = (OCLExpression)args.get(args.size() - 1)).getEndPosition() == this.completionPosition) {
                return last.accept(this);
            }
            return OCLSyntaxHelper.this.getChoices(exp, this.constraintType);
        }

        public Object visitVariableExp(VariableExp variableexp) {
            return OCLSyntaxHelper.this.getChoices(variableexp, this.constraintType);
        }

        public Object visitPropertyCallExp(PropertyCallExp propertycallexp) {
            return OCLSyntaxHelper.this.getChoices(propertycallexp, this.constraintType);
        }

        public Object visitAssociationClassCallExp(AssociationClassCallExp exp) {
            return OCLSyntaxHelper.this.getChoices(exp, this.constraintType);
        }

        public Object visitVariable(Variable variabledeclaration) {
            return Collections.EMPTY_LIST;
        }

        public Object visitIfExp(IfExp exp) {
            int lastCharPos = UTF16.moveCodePointOffset((String)this.text, (int)exp.getEndPosition(), (int)-1);
            if (this.text.charAt(lastCharPos) == ')') {
                return OCLSyntaxHelper.this.getChoices(exp, this.constraintType);
            }
            return Collections.EMPTY_LIST;
        }

        public Object visitTypeExp(TypeExp typeExp) {
            return OCLSyntaxHelper.this.getOperationChoices(typeExp.getType());
        }

        public Object visitMessageExp(MessageExp m) {
            return OCLSyntaxHelper.this.getChoices(m, this.constraintType);
        }

        public Object visitUnspecifiedValueExp(UnspecifiedValueExp unspecifiedvalueexp) {
            return OCLSyntaxHelper.this.getChoices(unspecifiedvalueexp, this.constraintType);
        }

        public Object visitIntegerLiteralExp(IntegerLiteralExp exp) {
            return OCLSyntaxHelper.this.getChoices(exp, this.constraintType);
        }

        public Object visitRealLiteralExp(RealLiteralExp exp) {
            return OCLSyntaxHelper.this.getChoices(exp, this.constraintType);
        }

        public Object visitStringLiteralExp(StringLiteralExp exp) {
            return OCLSyntaxHelper.this.getChoices(exp, this.constraintType);
        }

        public Object visitBooleanLiteralExp(BooleanLiteralExp exp) {
            return OCLSyntaxHelper.this.getChoices(exp, this.constraintType);
        }

        public Object visitNullLiteralExp(NullLiteralExp il) {
            return OCLSyntaxHelper.this.getAnyChoices();
        }

        public Object visitInvalidLiteralExp(InvalidLiteralExp il) {
            return OCLSyntaxHelper.this.getAnyChoices();
        }

        public Object visitTupleLiteralExp(TupleLiteralExp tupleliteralexp) {
            return OCLSyntaxHelper.this.getChoices(tupleliteralexp, this.constraintType);
        }

        public Object visitTupleLiteralPart(TupleLiteralPart tp) {
            return Collections.EMPTY_LIST;
        }

        public Object visitLetExp(LetExp letexp) {
            return OCLSyntaxHelper.this.getChoices(letexp.getType(), this.constraintType);
        }

        public Object visitEnumLiteralExp(EnumLiteralExp enumliteralexp) {
            return OCLSyntaxHelper.this.getChoices(enumliteralexp, this.constraintType);
        }

        public Object visitStateExp(StateExp s) {
            return OCLSyntaxHelper.this.getChoices(s, this.constraintType);
        }

        public Object visitCollectionLiteralExp(CollectionLiteralExp exp) {
            return OCLSyntaxHelper.this.getChoices(exp, this.constraintType);
        }

        public Object visitIteratorExp(IteratorExp exp) {
            if (exp.getEndPosition() == this.completionPosition) {
                return OCLSyntaxHelper.this.getChoices(exp.getType(), this.constraintType);
            }
            return exp.getBody().accept(this);
        }

        public Object visitIterateExp(IterateExp exp) {
            if (exp.getEndPosition() == this.completionPosition) {
                return OCLSyntaxHelper.this.getChoices(exp.getType(), this.constraintType);
            }
            return exp.getBody().accept(this);
        }

        public Object visitConstraint(Constraint constraint) {
            return Collections.EMPTY_LIST;
        }
    }
}

