/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.internal.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class LazyExtentMap
implements Map {
    private final Map delegate = new HashMap();
    private Collection roots;

    public LazyExtentMap(EObject context) {
        context = EcoreUtil.getRootContainer((EObject)context);
        this.roots = context.eResource() != null ? context.eResource().getContents() : Collections.singleton(context);
    }

    public Object get(Object key) {
        Object result = this.delegate.get(key);
        if (result == null && key instanceof EClass) {
            EClass eclass = (EClass)key;
            HashSet extent = new HashSet();
            this.delegate.put(eclass, extent);
            result = extent;
            TreeIterator iter = EcoreUtil.getAllContents((Collection)this.roots);
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!eclass.isInstance(next)) continue;
                extent.add(next);
            }
        }
        return result;
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public Object put(Object key, Object value) {
        return this.delegate.put(key, value);
    }

    public void putAll(Map t) {
        this.delegate.putAll(t);
    }

    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    public int size() {
        return this.delegate.size();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public Collection values() {
        return this.delegate.values();
    }
}

