/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.internal.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import lpg.lpgjavaruntime.LexStream;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ocl.expressions.AssociationClassCallExp;
import org.eclipse.emf.ocl.expressions.BooleanLiteralExp;
import org.eclipse.emf.ocl.expressions.CallExp;
import org.eclipse.emf.ocl.expressions.CollectionItem;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.CollectionLiteralExp;
import org.eclipse.emf.ocl.expressions.CollectionLiteralPart;
import org.eclipse.emf.ocl.expressions.CollectionRange;
import org.eclipse.emf.ocl.expressions.EnumLiteralExp;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.ExpressionsPackage;
import org.eclipse.emf.ocl.expressions.FeatureCallExp;
import org.eclipse.emf.ocl.expressions.IfExp;
import org.eclipse.emf.ocl.expressions.IntegerLiteralExp;
import org.eclipse.emf.ocl.expressions.InvalidLiteralExp;
import org.eclipse.emf.ocl.expressions.IterateExp;
import org.eclipse.emf.ocl.expressions.IteratorExp;
import org.eclipse.emf.ocl.expressions.LetExp;
import org.eclipse.emf.ocl.expressions.LiteralExp;
import org.eclipse.emf.ocl.expressions.LoopExp;
import org.eclipse.emf.ocl.expressions.MessageExp;
import org.eclipse.emf.ocl.expressions.NavigationCallExp;
import org.eclipse.emf.ocl.expressions.NullLiteralExp;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.OperationCallExp;
import org.eclipse.emf.ocl.expressions.PrimitiveLiteralExp;
import org.eclipse.emf.ocl.expressions.PropertyCallExp;
import org.eclipse.emf.ocl.expressions.RealLiteralExp;
import org.eclipse.emf.ocl.expressions.StateExp;
import org.eclipse.emf.ocl.expressions.StringLiteralExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralExp;
import org.eclipse.emf.ocl.expressions.TupleLiteralPart;
import org.eclipse.emf.ocl.expressions.TypeExp;
import org.eclipse.emf.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.expressions.VariableExp;
import org.eclipse.emf.ocl.internal.cst.BooleanLiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.CSTNode;
import org.eclipse.emf.ocl.internal.cst.CallExpCS;
import org.eclipse.emf.ocl.internal.cst.ClassifierContextDeclCS;
import org.eclipse.emf.ocl.internal.cst.CollectionLiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.CollectionLiteralPartCS;
import org.eclipse.emf.ocl.internal.cst.CollectionRangeCS;
import org.eclipse.emf.ocl.internal.cst.CollectionTypeCS;
import org.eclipse.emf.ocl.internal.cst.CollectionTypeIdentifierEnum;
import org.eclipse.emf.ocl.internal.cst.ContextDeclCS;
import org.eclipse.emf.ocl.internal.cst.DefCS;
import org.eclipse.emf.ocl.internal.cst.DefExpressionCS;
import org.eclipse.emf.ocl.internal.cst.EnumLiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.FeatureCallExpCS;
import org.eclipse.emf.ocl.internal.cst.IfExpCS;
import org.eclipse.emf.ocl.internal.cst.InitOrDerValueCS;
import org.eclipse.emf.ocl.internal.cst.IntegerLiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.InvCS;
import org.eclipse.emf.ocl.internal.cst.InvOrDefCS;
import org.eclipse.emf.ocl.internal.cst.InvalidLiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.IterateExpCS;
import org.eclipse.emf.ocl.internal.cst.IteratorExpCS;
import org.eclipse.emf.ocl.internal.cst.LetExpCS;
import org.eclipse.emf.ocl.internal.cst.LiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.LoopExpCS;
import org.eclipse.emf.ocl.internal.cst.MessageExpCS;
import org.eclipse.emf.ocl.internal.cst.MessageExpKind;
import org.eclipse.emf.ocl.internal.cst.NullLiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.OCLExpressionCS;
import org.eclipse.emf.ocl.internal.cst.OCLMessageArgCS;
import org.eclipse.emf.ocl.internal.cst.OperationCS;
import org.eclipse.emf.ocl.internal.cst.OperationCallExpCS;
import org.eclipse.emf.ocl.internal.cst.OperationContextDeclCS;
import org.eclipse.emf.ocl.internal.cst.PackageDeclarationCS;
import org.eclipse.emf.ocl.internal.cst.PathNameCS;
import org.eclipse.emf.ocl.internal.cst.PrePostOrBodyDeclCS;
import org.eclipse.emf.ocl.internal.cst.PrimitiveLiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.PrimitiveTypeCS;
import org.eclipse.emf.ocl.internal.cst.PropertyContextCS;
import org.eclipse.emf.ocl.internal.cst.RealLiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.SimpleNameCS;
import org.eclipse.emf.ocl.internal.cst.SimpleTypeEnum;
import org.eclipse.emf.ocl.internal.cst.StateExpCS;
import org.eclipse.emf.ocl.internal.cst.StringLiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.TupleLiteralExpCS;
import org.eclipse.emf.ocl.internal.cst.TupleTypeCS;
import org.eclipse.emf.ocl.internal.cst.TypeCS;
import org.eclipse.emf.ocl.internal.cst.VariableCS;
import org.eclipse.emf.ocl.internal.cst.VariableExpCS;
import org.eclipse.emf.ocl.internal.l10n.OCLMessages;
import org.eclipse.emf.ocl.internal.parser.OCLLPGParser;
import org.eclipse.emf.ocl.internal.parser.OCLLexer;
import org.eclipse.emf.ocl.parser.EcoreEnvironmentFactory;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.parser.ParserException;
import org.eclipse.emf.ocl.parser.PersistentEnvironment;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.BagType;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.MessageType;
import org.eclipse.emf.ocl.types.OrderedSetType;
import org.eclipse.emf.ocl.types.SequenceType;
import org.eclipse.emf.ocl.types.TupleType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.emf.ocl.uml.CallOperationAction;
import org.eclipse.emf.ocl.uml.Constraint;
import org.eclipse.emf.ocl.uml.SendSignalAction;
import org.eclipse.emf.ocl.uml.TypedElement;
import org.eclipse.emf.ocl.uml.UMLFactory;
import org.eclipse.emf.ocl.uml.UMLPackage;
import org.eclipse.emf.ocl.utilities.ASTNode;
import org.eclipse.emf.ocl.utilities.CallingASTNode;
import org.eclipse.emf.ocl.utilities.PredefinedType;
import org.eclipse.emf.ocl.utilities.TypedASTNode;

public class OCLParser
extends OCLLPGParser {
    public static final String[] errorMessages = new String[]{OCLMessages.OCLParseErrorCodes_LEX_ERROR, OCLMessages.OCLParseErrorCodes_ERROR, OCLMessages.OCLParseErrorCodes_BEFORE, OCLMessages.OCLParseErrorCodes_INSERTION, OCLMessages.OCLParseErrorCodes_INVALID, OCLMessages.OCLParseErrorCodes_SUBSTITUTION_SECONDARY, OCLMessages.OCLParseErrorCodes_DELETION, OCLMessages.OCLParseErrorCodes_MERGE, OCLMessages.OCLParseErrorCodes_MISPLACED, OCLMessages.OCLParseErrorCodes_SCOPE, OCLMessages.OCLParseErrorCodes_EOF, OCLMessages.OCLParseErrorCodes_INVALID_TOKEN};
    TypesPackage typesPackage = TypesPackage.eINSTANCE;
    TypesFactory typesFactory = this.typesPackage.getTypesFactory();
    ExpressionsPackage expressionsPackage = ExpressionsPackage.eINSTANCE;
    ExpressionsFactory expressionsFactory = this.expressionsPackage.getExpressionsFactory();
    UMLPackage umlPackage = UMLPackage.eINSTANCE;
    UMLFactory umlFactory = this.umlPackage.getUMLFactory();
    private EnvironmentFactory environmentFactory;
    private boolean traceflag = false;
    private String errorString = "";
    private int charOffset = 0;
    private int errorReportLineOffset = 0;

    public OCLParser(OCLLexer lexStream) {
        this(lexStream, EcoreEnvironmentFactory.ECORE_INSTANCE);
    }

    public OCLParser(OCLLexer lexStream, EnvironmentFactory environmentFactory) {
        super((LexStream)lexStream);
        lexStream.lexer(this);
        this.environmentFactory = environmentFactory;
    }

    public void setTraceFlag(boolean flag) {
        this.traceflag = flag;
    }

    public boolean getTraceFlag() {
        return this.traceflag;
    }

    private void TRACE(String rule, String message) {
        if (this.traceflag) {
            System.out.println(String.valueOf(rule) + ": " + message);
        }
    }

    private void TRACE(String rule, String message, EList namelist) {
        this.TRACE(rule, String.valueOf(message) + this.makeString(namelist));
    }

    public void setCharacterOffset(int offset) {
        this.charOffset = offset;
    }

    public void setErrorReportLineOffset(int offset) {
        this.errorReportLineOffset = offset;
    }

    public static boolean isIdentifierOrKeyword(int tokenKind) {
        switch (tokenKind) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    private void initStartEndPositions(ASTNode astNode, CSTNode cstNode) {
        astNode.setStartPosition(cstNode.getStartOffset() + this.charOffset);
        astNode.setEndPosition(cstNode.getEndOffset() + this.charOffset + 1);
    }

    private void initPropertyPositions(CallingASTNode callingASTNode, CSTNode cstNode) {
        callingASTNode.setPropertyStartPosition(cstNode.getStartOffset() + this.charOffset);
        callingASTNode.setPropertyEndPosition(cstNode.getEndOffset() + this.charOffset + 1);
    }

    private void initTypePositions(TypedASTNode typedASTNode, CSTNode cstNode) {
        typedASTNode.setTypeStartPosition(cstNode.getStartOffset() + this.charOffset);
        typedASTNode.setTypeEndPosition(cstNode.getEndOffset() + this.charOffset + 1);
    }

    private String makeString(EList namelist) {
        String msg = "";
        int i = 0;
        while (i < namelist.size()) {
            msg = String.valueOf(msg) + " " + (String)namelist.get(i);
            ++i;
        }
        return msg;
    }

    private String makeName(EList namelist) {
        StringBuffer msg = new StringBuffer();
        int i = 0;
        while (i < namelist.size()) {
            if (i > 0) {
                msg.append("::");
            }
            msg.append((String)namelist.get(i));
            ++i;
        }
        return msg.toString();
    }

    private String operationString(String operName, EList args) {
        StringBuffer result = new StringBuffer();
        result.append(operName);
        result.append('(');
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            OCLExpression arg = (OCLExpression)iter.next();
            EClassifier type = arg.getType();
            result.append(type == null ? null : type.getName());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        return result.toString();
    }

    private String unquote(String quoted) {
        String result = quoted;
        if (result != null && result.length() > 1) {
            int max = result.length() - 1;
            if (result.charAt(0) == '\"' && quoted.charAt(max) == '\"') {
                result = result.substring(1, max);
            }
            result = result.replaceAll("\\\\\"", "\"");
        }
        return result;
    }

    private void setQualifiers(Environment env, String rule, NavigationCallExp nc, EList qualifiers) throws SemanticException {
        if (nc instanceof PropertyCallExp) {
            EStructuralFeature source = ((PropertyCallExp)nc).getReferredProperty();
            EList expectedQualifiers = env.getQualifiers(source);
            if (expectedQualifiers.size() != qualifiers.size()) {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.MismatchedQualifiers_ERROR_, nc.toString()));
            } else if (!qualifiers.isEmpty()) {
                EClassifier ncType;
                Iterator eiter = expectedQualifiers.iterator();
                Iterator qiter = qualifiers.iterator();
                while (eiter.hasNext()) {
                    OCLExpression qualifier;
                    EClassifier qualifierType;
                    EClassifier expectedType = TypeUtil.getOCLType((ETypedElement)eiter.next());
                    if (TypeUtil.typeCompare(expectedType, qualifierType = (qualifier = (OCLExpression)qiter.next()).getType()) >= 0) continue;
                    this.ERROR(rule, OCLMessages.bind(OCLMessages.MismatchedQualifiers_ERROR_, nc.toString()));
                }
                if (TypeUtil.isMany((ETypedElement)source) && (ncType = nc.getType()) instanceof CollectionType) {
                    nc.setType(((CollectionType)ncType).getElementType());
                }
            }
        } else if (nc instanceof AssociationClassCallExp) {
            EReference ref;
            EClass refAssocClass;
            Object qualifier;
            if (qualifiers.size() != 1) {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierCount_ERROR_, nc.toString()));
            }
            if (!((qualifier = qualifiers.get(0)) instanceof PropertyCallExp)) {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, nc.toString()));
            }
            AssociationClassCallExp acc = (AssociationClassCallExp)nc;
            EClass assocClass = acc.getReferredAssociationClass();
            EClass sourceType = (EClass)nc.getSource().getType();
            EStructuralFeature property = ((PropertyCallExp)qualifier).getReferredProperty();
            if (!(property instanceof EReference)) {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, nc.toString()));
            }
            if ((refAssocClass = env.getAssociationClass(ref = (EReference)property)) != null && sourceType.getEAllReferences().contains((Object)ref) && refAssocClass == assocClass) {
                acc.setNavigationSource((EStructuralFeature)ref);
            } else {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, nc.toString()));
            }
        }
        nc.getQualifier().addAll((Collection)qualifiers);
    }

    private void checkNotReflexive(Environment env, String rule, AssociationClassCallExp acc) throws SemanticException {
        EClass assocClass = acc.getReferredAssociationClass();
        EList ends = env.isAssociationClass(assocClass) ? env.getMemberEnds(assocClass) : ECollections.EMPTY_ELIST;
        if (ends.size() == 2) {
            EReference end1 = (EReference)ends.get(0);
            EReference end2 = (EReference)ends.get(1);
            if (end1.getEReferenceType() == end2.getEReferenceType()) {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.AssociationClassAmbiguous_ERROR_, acc.toString()));
            }
        }
    }

    public static void ERR(String message) throws SemanticException {
        throw new SemanticException(message);
    }

    private void ERROR(String rule, String errorMessage) throws SemanticException {
        String error = OCLMessages.bind(OCLMessages.ErrorMessage_ERROR_, rule, errorMessage);
        this.errorString = String.valueOf(this.errorString) + error;
        OCLParser.ERR(error);
    }

    private Variable genVariableDeclaration(String rule, Environment env, String name, EClassifier type, OCLExpression initExp, boolean explicitFlag, boolean addToEnvironment, boolean isSelf) throws SemanticException {
        Variable vdcl = this.expressionsFactory.createVariable();
        vdcl.setName(name);
        vdcl.setType(TypeUtil.resolveType(env, type));
        vdcl.setInitExpression(initExp);
        if (addToEnvironment) {
            boolean result = env.addElement(name, vdcl, explicitFlag);
            if (!result) {
                if (name != null) {
                    String message = OCLMessages.bind(OCLMessages.VariableUsed_ERROR_, name);
                    this.ERROR(rule, message);
                } else {
                    this.ERROR(rule, OCLMessages.VariableDeclaration_ERROR_);
                }
            }
            if (isSelf) {
                env.setSelfVariable(vdcl);
            }
        }
        if (addToEnvironment) {
            this.TRACE(rule, "adding variable declaration for " + vdcl.getName());
        }
        return vdcl;
    }

    private OperationCallExp genOperationCallExp(Environment env, String rule, String operName, OCLExpression source, EClassifier ownerType, EList args) throws SemanticException {
        OperationCallExp result = this.expressionsFactory.createOperationCallExp();
        result.setSource(source);
        EOperation oper = env.lookupOperation(ownerType, operName, args);
        if (oper == null) {
            String message = OCLMessages.bind(OCLMessages.OperationNotFound_ERROR_, this.operationString(operName, args), ownerType == null ? null : ownerType.getName());
            this.ERROR(rule, message);
            result.setType(Types.OCL_VOID);
        } else {
            this.TRACE(rule, oper.getName());
            result.setReferredOperation(oper);
        }
        EList callargs = result.getArgument();
        if (args != null) {
            int i = 0;
            while (i < args.size()) {
                OCLExpression arg = (OCLExpression)args.get(i);
                if (arg == null) {
                    this.ERROR(rule, OCLMessages.BadArg_ERROR_);
                } else {
                    callargs.add(args.get(i));
                }
                ++i;
            }
        }
        if (oper != null) {
            EClassifier resultType = null;
            if (ownerType instanceof PredefinedType) {
                PredefinedType predef = (PredefinedType)ownerType;
                int opcode = predef.getOperationCodeFor(operName);
                result.setOperationCode(opcode);
                resultType = predef.getResultTypeFor(ownerType, opcode, args);
            } else {
                int opcode = AnyTypeImpl.getOperationCode(operName);
                result.setOperationCode(opcode);
                resultType = AnyTypeImpl.getResultType(ownerType, opcode, args);
            }
            if (resultType == null) {
                resultType = TypeUtil.getOCLType((ETypedElement)oper);
            }
            resultType = TypeUtil.resolveType(env, resultType);
            result.setType(resultType);
        }
        return result;
    }

    private EObject runParser() throws ParserException {
        EObject cstNode = this.parser();
        if (this.errorString.length() > 0) {
            String error = this.errorString;
            this.errorString = "";
            throw new ParserException(error);
        }
        return cstNode;
    }

    public final EList parsePackageDeclarationCS(EList constraints) throws ParserException {
        EObject cstNode = this.runParser();
        if (cstNode != null) {
            if (cstNode instanceof PackageDeclarationCS) {
                this.packageDeclarationCS((PackageDeclarationCS)cstNode, constraints);
                return constraints;
            }
            this.ERROR("parsePackageDeclarationCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "PackageDeclarationCS", cstNode.eClass().getName()));
        }
        return constraints;
    }

    public final Constraint parseInvOrDefCS(Environment env) throws ParserException {
        EObject cstNode = this.runParser();
        if (cstNode != null) {
            if (cstNode instanceof InvOrDefCS) {
                return this.invOrDefCS((InvOrDefCS)cstNode, env);
            }
            this.ERROR("parseInvOrDefCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "InvOrDefCS", cstNode.eClass().getName()));
        }
        return null;
    }

    public final Constraint parsePrePostOrBodyDeclCS(Environment env, EOperation operation) throws ParserException {
        EObject cstNode = this.runParser();
        if (cstNode != null && cstNode instanceof PrePostOrBodyDeclCS) {
            return this.prePostOrBodyDeclCS((PrePostOrBodyDeclCS)cstNode, env, operation);
        }
        this.ERROR("parsePrePostOrBodyDeclCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "PrePostOrBodyDeclCS", cstNode.eClass().getName()));
        return null;
    }

    public final Constraint parseInitOrDerValueCS(Environment env, EStructuralFeature property) throws ParserException {
        EObject cstNode = this.runParser();
        if (cstNode != null && cstNode instanceof InitOrDerValueCS) {
            return this.initOrDerValueCS((InitOrDerValueCS)cstNode, env, property);
        }
        this.ERROR("parseInitOrDerValueCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "InitOrDerValueCS", cstNode.eClass().getName()));
        return null;
    }

    public final Variable parseVariableDeclarationCS(Environment env, boolean addToEnvironment) throws ParserException {
        EObject cstNode = this.runParser();
        if (cstNode != null) {
            if (cstNode instanceof VariableCS) {
                return this.variableDeclarationCS((VariableCS)cstNode, env, true);
            }
            this.ERROR("parseVariableDeclarationCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "VariableDeclarationCS", cstNode.eClass().getName()));
        }
        return null;
    }

    public void reportError(int left_char, int right_char) {
    }

    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        int leftTokenLoc = leftToken > rightToken ? rightToken : leftToken;
        int rightTokenLoc = rightToken;
        if (this.getLine(leftTokenLoc) + this.errorReportLineOffset <= 0) {
            this.errorString = OCLMessages.InvalidOCL_ERROR_;
        } else {
            String locInfo = OCLMessages.bind(OCLMessages.ErrorReport_RowColumn, new Object[]{new Integer(this.getLine(leftTokenLoc) + this.errorReportLineOffset), new Integer(this.getColumn(leftTokenLoc)), new Integer(this.getEndLine(rightTokenLoc) + this.errorReportLineOffset), new Integer(this.getEndColumn(rightTokenLoc))});
            switch (errorCode) {
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    this.errorString = String.valueOf(OCLMessages.bind(errorMessages[errorCode], locInfo, String.valueOf('\"') + this.computeInputString(this.getIToken(leftToken).getStartOffset(), this.getIToken(rightToken).getEndOffset()))) + '\"';
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    this.errorString = OCLMessages.bind(errorMessages[errorCode], new Object[]{locInfo, tokenText, String.valueOf('\"') + this.computeInputString(this.getIToken(leftToken).getStartOffset(), this.getIToken(rightToken).getEndOffset()) + '\"'});
                    break;
                }
                default: {
                    this.errorString = OCLMessages.bind(errorMessages[errorCode], locInfo, tokenText);
                }
            }
        }
    }

    private String computeInputString(int left, int right) {
        StringBuffer result = new StringBuffer(right - left + 1);
        char[] chars = this.getInputChars();
        int i = left;
        while (i <= right) {
            if (chars[i] == '\t') {
                result.append(' ');
            } else if (chars[i] == '\n' || chars[i] == '\r' || chars[i] == '\f') {
                if (i > 0 && !Character.isWhitespace(chars[i - 1])) {
                    result.append(' ');
                }
            } else {
                result.append(chars[i]);
            }
            ++i;
        }
        return result.toString();
    }

    private String computeInputString(CSTNode node) {
        return this.computeInputString(node.getStartOffset(), node.getEndOffset());
    }

    public void reportError(int errorCode, String locationInfo, String tokenText) {
    }

    public void reportError(int i, String code) {
        this.errorString = String.valueOf(code) + " (" + this.getKind(i) + ") : " + this.getStartOffset(i) + ":" + this.getLineNumberOfTokenAt(i) + ":" + this.getColumnOfTokenAt(i) + ":" + this.getTokenLength(i) + " " + this.getTokenText(i);
    }

    protected final void packageDeclarationCS(PackageDeclarationCS packageDeclarationCS, EList constraints) throws SemanticException {
        EList contextDecls = packageDeclarationCS.getContextDecls();
        EList pathname = packageDeclarationCS.getPathNameCS().getSequenceOfNames();
        Environment env = this.environmentFactory.createPackageContext((List)pathname);
        if (env == null) {
            this.ERROR("packageDeclarationCS", OCLMessages.bind(OCLMessages.PackageNotFound_ERROR_, this.makeString(pathname)));
        }
        this.TRACE("packageDeclarationCS", "Package ", pathname);
        Iterator i = contextDecls.iterator();
        while (i.hasNext()) {
            this.contextDeclCS((ContextDeclCS)i.next(), env, constraints);
        }
    }

    protected final void contextDeclCS(ContextDeclCS contextDeclCS, Environment env, EList constraints) throws SemanticException {
        if (contextDeclCS instanceof OperationContextDeclCS) {
            this.operationContextDeclCS((OperationContextDeclCS)contextDeclCS, env, constraints);
        } else if (contextDeclCS instanceof PropertyContextCS) {
            this.propertyContextCS((PropertyContextCS)contextDeclCS, env, constraints);
        } else if (contextDeclCS instanceof ClassifierContextDeclCS) {
            this.classifierContextDeclCS((ClassifierContextDeclCS)contextDeclCS, env, constraints);
        }
    }

    protected final void operationContextDeclCS(OperationContextDeclCS operationContextDeclCS, Environment env, EList constraints) throws SemanticException {
        Environment operationEnv = this.environmentFactory.createEnvironment(env);
        EOperation operation = this.operationCS(operationContextDeclCS.getOperationCS(), env);
        Iterator i = operationContextDeclCS.getPrePostOrBodyDecls().iterator();
        while (i.hasNext()) {
            Constraint astNode = this.prePostOrBodyDeclCS((PrePostOrBodyDeclCS)i.next(), operationEnv, operation);
            constraints.add((Object)astNode);
        }
    }

    protected final EOperation operationCS(OperationCS operationCS, Environment env) throws SemanticException {
        int lastName;
        Vector className;
        EOperation operation = null;
        EClassifier classifier = null;
        BasicEList operationName = new BasicEList();
        operationName.addAll((Collection)operationCS.getPathNameCS().getSequenceOfNames());
        operationName.add((Object)operationCS.getSimpleNameCS().getValue());
        if (operationName.size() > 1 && (classifier = env.lookupPathName(className = new Vector(operationName.subList(0, lastName = operationName.size() - 1)))) != null) {
            EList params = this.parametersCS(operationCS.getParameters(), env);
            operation = env.lookupOperation(classifier, (String)operationName.get(lastName), params);
        }
        if (operation == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList)operationName));
            this.ERROR("operationContextDeclCS", message);
        }
        this.genVariableDeclaration("\noperationCS", env, "self", classifier, null, true, true, true);
        this.TRACE("operationCS", "context", (EList)operationName);
        return operation;
    }

    protected final EList parametersCS(EList parameters, Environment env) throws SemanticException {
        return this.variableDeclarationListCS(parameters, env, true);
    }

    protected final Constraint prePostOrBodyDeclCS(PrePostOrBodyDeclCS prePostOrBodyDeclCS, Environment env, EOperation operation) throws SemanticException {
        EClassifier operationType = TypeUtil.getOCLType((ETypedElement)operation);
        String stereotype = null;
        switch (prePostOrBodyDeclCS.getKind().getValue()) {
            case 1: {
                stereotype = "precondition";
                break;
            }
            case 2: {
                stereotype = "postcondition";
                if (operationType == null || env.lookup("result") != null) break;
                this.genVariableDeclaration("prePostOrBodyDeclCS0", env, "result", operationType, null, true, true, false);
                break;
            }
            case 3: {
                stereotype = "body";
                if (operationType == null || env.lookup("result") != null) break;
                this.genVariableDeclaration("prePostOrBodyDeclCS", env, "result", operationType, null, true, true, false);
            }
        }
        OCLExpression oclExpression = this.oclExpressionCS(prePostOrBodyDeclCS.getExpressionCS(), env);
        Constraint astNode = this.umlFactory.createConstraint();
        SimpleNameCS simpleNameCS = prePostOrBodyDeclCS.getSimpleNameCS();
        if (simpleNameCS != null) {
            astNode.setName(this.unquote(simpleNameCS.getValue()));
        }
        EList constrainedElement = astNode.getConstrainedElement();
        constrainedElement.add((Object)operation);
        astNode.setBody(oclExpression);
        astNode.setStereotype(stereotype);
        return astNode;
    }

    protected final void propertyContextCS(PropertyContextCS propertyContextCS, Environment env, EList constraints) throws SemanticException {
        Environment propertyEnv = this.environmentFactory.createEnvironment(env);
        EList pathName = propertyContextCS.getPathNameCS().getSequenceOfNames();
        EClassifier owner = env.lookupPathName((List)pathName);
        if (owner == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString(pathName));
            this.ERROR("propertyContextCS", message);
        }
        owner = TypeUtil.getOCLType(owner);
        String simpleName = propertyContextCS.getSimpleNameCS().getValue();
        EStructuralFeature property = env.lookupProperty(owner, simpleName);
        BasicEList propertyName = new BasicEList();
        propertyName.addAll((Collection)pathName);
        propertyName.add((Object)simpleName);
        if (property == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList)propertyName));
            this.ERROR("propertyContextCS", message);
        }
        EClassifier type = this.typeCS(propertyContextCS.getTypeCS(), env);
        EClassifier propertyType = TypeUtil.getOCLType((ETypedElement)property);
        if (type == null || TypeUtil.typeCompare(propertyType, type) != 0) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList)propertyName));
            this.ERROR("propertyContextCS", message);
        }
        this.genVariableDeclaration("\npropertyContextCS", env, "self", owner, null, true, true, true);
        this.TRACE("propertyContextCS", "context", (EList)propertyName);
        InitOrDerValueCS initOrDerValueCS = propertyContextCS.getInitOrDerValueCS();
        Constraint astNode = this.initOrDerValueCS(initOrDerValueCS, propertyEnv, property);
        constraints.add((Object)astNode);
        InitOrDerValueCS other = initOrDerValueCS.getInitOrDerValueCS();
        if (other != null) {
            if (initOrDerValueCS.eClass() == other.eClass() || other.getInitOrDerValueCS() != null) {
                String message = OCLMessages.bind(OCLMessages.PropertyConstraints_ERROR_, this.makeString((EList)propertyName));
                this.ERROR("propertyContextCS", message);
            }
            astNode = this.initOrDerValueCS(other, propertyEnv, property);
            constraints.add((Object)astNode);
        }
    }

    protected final Constraint initOrDerValueCS(InitOrDerValueCS initOrDerValueCS, Environment env, EStructuralFeature property) throws SemanticException {
        String stereotype = null;
        String annotation = null;
        switch (initOrDerValueCS.eClass().getClassifierID()) {
            case 10: {
                stereotype = "initial";
                annotation = "http://www.eclipse.org/OCL/1.0.0/init";
                break;
            }
            case 9: {
                stereotype = "derivation";
                annotation = "http://www.eclipse.org/OCL/1.0.0/derive";
            }
        }
        OCLExpression oclExpression = this.oclExpressionCS(initOrDerValueCS.getExpressionCS(), env);
        Constraint astNode = this.umlFactory.createConstraint();
        EList constrainedElement = astNode.getConstrainedElement();
        constrainedElement.add((Object)property);
        astNode.setBody(oclExpression);
        astNode.setStereotype(stereotype);
        EAnnotation ann = property.getEAnnotation(annotation);
        if (ann == null) {
            ann = EcoreFactory.eINSTANCE.createEAnnotation();
            ann.setSource(annotation);
            property.getEAnnotations().add((Object)ann);
        }
        if (ann.getContents().isEmpty()) {
            ann.getContents().add((Object)astNode);
        } else {
            ann.getContents().set(0, (Object)astNode);
        }
        return astNode;
    }

    protected final void classifierContextDeclCS(ClassifierContextDeclCS classifierContextDeclCS, Environment env, EList constraints) throws SemanticException {
        EList pathName = classifierContextDeclCS.getPathNameCS().getSequenceOfNames();
        EClassifier type = env.lookupPathName((List)pathName);
        if (type == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString(pathName));
            this.ERROR("classifierContextDeclCS", message);
        }
        type = TypeUtil.getOCLType(type);
        this.genVariableDeclaration("\nclassifierContextDeclCS", env, "self", type, null, true, true, true);
        this.TRACE("classifierContextDeclCS", "context", pathName);
        Constraint astNode = this.invOrDefCS(classifierContextDeclCS.getInvOrDefCS(), env);
        astNode.setInstanceVarName("self");
        constraints.add((Object)astNode);
    }

    protected final Constraint invOrDefCS(InvOrDefCS invOrDefCS, Environment env) throws SemanticException {
        Constraint astNode = null;
        if (invOrDefCS instanceof InvCS) {
            astNode = this.invCS((InvCS)invOrDefCS, env);
        } else if (invOrDefCS instanceof DefCS) {
            astNode = this.defCS((DefCS)invOrDefCS, env);
        }
        return astNode;
    }

    protected final Constraint invCS(InvCS invCS, Environment env) throws SemanticException {
        OCLExpression oclExpression = this.oclExpressionCS(invCS.getExpressionCS(), env);
        Constraint astNode = this.umlFactory.createConstraint();
        SimpleNameCS simpleNameCS = invCS.getSimpleNameCS();
        if (simpleNameCS != null) {
            astNode.setName(this.unquote(simpleNameCS.getValue()));
        }
        EClassifier type = env.getSelfVariable().getType();
        EList constrainedElement = astNode.getConstrainedElement();
        constrainedElement.add((Object)type);
        astNode.setBody(oclExpression);
        astNode.setStereotype("invariant");
        return astNode;
    }

    protected final Constraint defCS(DefCS defCS, Environment env) throws SemanticException {
        EClassifier type;
        DefExpressionCS defExpr = defCS.getDefExpressionCS();
        EStructuralFeature feature = null;
        OCLExpression expression = null;
        if (defExpr.getVariableCS() != null) {
            Environment contextEnv = env;
            Variable variable = this.variableDeclarationCS(defExpr.getVariableCS(), contextEnv, false);
            feature = env.lookupProperty(contextEnv.getContextClassifier(), variable.getName());
            if (feature != null) {
                this.ERROR("defCS", OCLMessages.bind(OCLMessages.DuplicateProperty_ERROR_, variable.getName(), contextEnv.getContextClassifier().getName()));
            }
            expression = this.oclExpressionCS(defExpr.getExpressionCS(), contextEnv);
            feature = TypeUtil.defineProperty(contextEnv.getContextClassifier(), variable);
        } else if (defExpr.getOperationCS() != null) {
            Environment contextEnv = this.environmentFactory.createEnvironment(env);
            OperationCS operCS = defExpr.getOperationCS();
            EList params = this.variableDeclarationListCS(operCS.getParameters(), contextEnv, true);
            type = this.typeCS(operCS.getTypeCS(), contextEnv);
            String operName = operCS.getSimpleNameCS().getValue();
            BasicEList args = new BasicEList(params.size());
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                UnspecifiedValueExp arg = this.expressionsFactory.createUnspecifiedValueExp();
                arg.setType(((Variable)iter.next()).getType());
                args.add((Object)arg);
            }
            feature = env.lookupOperation(contextEnv.getContextClassifier(), operName, (EList)args);
            if (feature != null) {
                this.ERROR("defCS", OCLMessages.bind(OCLMessages.DuplicateOperation_ERROR_, this.operationString(operName, (EList)args), contextEnv.getContextClassifier().getName()));
            }
            expression = this.oclExpressionCS(defExpr.getExpressionCS(), contextEnv);
            feature = TypeUtil.defineOperation(contextEnv.getContextClassifier(), this.unquote(operCS.getSimpleNameCS().getValue()), params, type);
        }
        Constraint astNode = this.umlFactory.createConstraint();
        SimpleNameCS simpleNameCS = defCS.getSimpleNameCS();
        if (simpleNameCS != null) {
            astNode.setName(this.unquote(simpleNameCS.getValue()));
        }
        type = env.getSelfVariable().getType();
        EList constrainedElement = astNode.getConstrainedElement();
        constrainedElement.add((Object)type);
        constrainedElement.add((Object)feature);
        astNode.setBody(expression);
        astNode.setStereotype("definition");
        EAnnotation ann = feature.getEAnnotation("http://www.eclipse.org/OCL/1.0.0/define");
        if (ann == null) {
            ann = EcoreFactory.eINSTANCE.createEAnnotation();
            ann.setSource("http://www.eclipse.org/OCL/1.0.0/define");
            feature.getEAnnotations().add((Object)ann);
        }
        if (ann.getContents().isEmpty()) {
            ann.getContents().add((Object)astNode);
        } else {
            ann.getContents().set(0, (Object)astNode);
        }
        return astNode;
    }

    protected final Variable variableDeclarationCS(VariableCS variableDeclarationCS, Environment env, boolean addToEnvironment) throws SemanticException {
        String varName = this.unquote(variableDeclarationCS.getName());
        EClassifier type = null;
        if (variableDeclarationCS.getTypeCS() != null) {
            type = this.typeCS(variableDeclarationCS.getTypeCS(), env);
        }
        TypedElement expr = null;
        if (variableDeclarationCS.getInitExpression() != null) {
            expr = this.oclExpressionCS(variableDeclarationCS.getInitExpression(), env);
        }
        if (expr != null) {
            EClassifier exprType = expr.getType();
            while (exprType instanceof CollectionType) {
                exprType = ((CollectionType)exprType).getElementType();
            }
            if (exprType instanceof MessageType) {
                EClassifier varType = type;
                if (varType instanceof CollectionType) {
                    do {
                        CollectionType collType;
                        if ((varType = (collType = (CollectionType)varType).getElementType()) != Types.OCL_MESSAGE) continue;
                        collType.setElementType(exprType);
                        break;
                    } while (varType instanceof CollectionType);
                } else if (type == Types.OCL_MESSAGE) {
                    type = exprType;
                }
            }
        }
        Variable astNode = this.genVariableDeclaration("variableDeclarationCS", env, varName, type, (OCLExpression)expr, true, addToEnvironment, false);
        this.initStartEndPositions(astNode, variableDeclarationCS);
        if (variableDeclarationCS.getTypeCS() != null) {
            this.initTypePositions(astNode, variableDeclarationCS.getTypeCS());
        }
        return astNode;
    }

    protected final EList variableDeclarationListCS(EList variableDeclarationCS, Environment env, boolean addToEnvironment) throws SemanticException {
        BasicEList variableDeclarations = new BasicEList();
        Iterator i = variableDeclarationCS.iterator();
        while (i.hasNext()) {
            variableDeclarations.add((Object)this.variableDeclarationCS((VariableCS)i.next(), env, addToEnvironment));
        }
        return variableDeclarations;
    }

    protected final EClassifier typeCS(TypeCS typeCS, Environment env) throws SemanticException {
        EClassifier astNode = null;
        if (typeCS instanceof PrimitiveTypeCS) {
            astNode = this.primitiveTypeCS(((PrimitiveTypeCS)typeCS).getType());
        } else if (typeCS instanceof PathNameCS) {
            astNode = env.lookupPathName((List)((PathNameCS)typeCS).getSequenceOfNames());
        } else if (typeCS instanceof CollectionTypeCS || typeCS instanceof TupleTypeCS) {
            if (typeCS instanceof CollectionTypeCS) {
                astNode = this.collectionTypeCS((CollectionTypeCS)typeCS, env);
            } else if (typeCS instanceof TupleTypeCS) {
                astNode = this.tupleTypeCS((TupleTypeCS)typeCS, env);
            }
        }
        return astNode;
    }

    protected final StateExp stateExpCS(OCLExpression source, StateExpCS stateExpCS, Environment env) throws SemanticException {
        EClassifier sourceType = null;
        if (source != null) {
            sourceType = source.getType();
        }
        EObject state = null;
        EList statePath = stateExpCS.getSequenceOfNames();
        int lastName = statePath.size() - 1;
        if (lastName >= 0) {
            String stateName = (String)statePath.get(lastName);
            EList states = env.getStates(sourceType, statePath.subList(0, lastName));
            Iterator iter = states.iterator();
            while (state == null && iter.hasNext()) {
                EObject next = (EObject)iter.next();
                if (!stateName.equals(env.getStateName(next))) continue;
                state = next;
            }
            if (state == null) {
                this.ERROR("stateExpCS", OCLMessages.bind(OCLMessages.NoSuchState_ERROR_, statePath, sourceType == null ? null : sourceType.getName()));
            }
        }
        StateExp astNode = this.expressionsFactory.createStateExp();
        astNode.setReferredState(state);
        astNode.setType((EClassifier)Types.STATE);
        astNode.setName(this.makeName(statePath));
        this.initStartEndPositions(astNode, stateExpCS);
        return astNode;
    }

    protected final EClassifier collectionTypeCS(CollectionTypeCS collectionTypeCS, Environment env) throws SemanticException {
        CollectionKind kind = this.collectionTypeIdentifierCS(collectionTypeCS.getCollectionTypeIdentifier());
        EClassifier type = this.typeCS(collectionTypeCS.getTypeCS(), env);
        CollectionType astNode = this.getCollectionType(env, kind, type);
        this.initTypePositions(astNode, collectionTypeCS.getTypeCS());
        return astNode;
    }

    protected final CollectionKind collectionTypeIdentifierCS(CollectionTypeIdentifierEnum collectionTypeIdentifier) throws SemanticException {
        CollectionKind astNode = null;
        switch (collectionTypeIdentifier.getValue()) {
            case 1: {
                astNode = CollectionKind.SET_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "SET");
                break;
            }
            case 2: {
                astNode = CollectionKind.BAG_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "BAG");
                break;
            }
            case 3: {
                astNode = CollectionKind.SEQUENCE_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "SEQUENCE");
                break;
            }
            case 4: {
                astNode = CollectionKind.COLLECTION_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "COLLECTION");
                break;
            }
            case 5: {
                astNode = CollectionKind.ORDERED_SET_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "ORDERED_SET");
            }
        }
        return astNode;
    }

    protected final EClassifier tupleTypeCS(TupleTypeCS tupleTypeCS, Environment env) throws SemanticException {
        HashSet<String> names = new HashSet<String>();
        String nodeName = null;
        ArrayList<Variable> vdcls = new ArrayList<Variable>();
        EList variableDeclarations = this.variableDeclarationListCS(tupleTypeCS.getVariables(), env, false);
        Iterator i = variableDeclarations.iterator();
        while (i.hasNext()) {
            String message;
            Variable vdcl = (Variable)i.next();
            vdcls.add(vdcl);
            String name = vdcl.getName();
            this.TRACE("tupleTypeCS", " name = " + name);
            if (names.contains(name)) {
                message = OCLMessages.bind(OCLMessages.DuplicateNameInTuple_ERROR_, name);
                this.ERROR("tupleTypeCS", message);
                vdcl.setName(null);
            } else {
                names.add(name);
            }
            if (vdcl.getInitExpression() != null) {
                message = OCLMessages.bind(OCLMessages.InitExpNotAllowed_ERROR_, name);
                this.ERROR("tupleTypeCS", message);
            }
            if (vdcl.getType() == null) {
                message = OCLMessages.bind(OCLMessages.DeclarationType_ERROR_, name);
                this.ERROR("tupleTypeCS", message);
            }
            nodeName = nodeName == null ? "Tuple(" : String.valueOf(nodeName) + ", ";
            nodeName = String.valueOf(nodeName) + vdcl.getName() + ":" + vdcl.getType().getName();
        }
        TupleType astNode = this.getTupleType(env, vdcls);
        return astNode;
    }

    protected final OCLExpression oclExpressionCS(OCLExpressionCS oclExpressionCS, Environment env) throws SemanticException {
        OCLExpression astNode = null;
        if (oclExpressionCS instanceof IfExpCS) {
            astNode = this.ifExpCS((IfExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof CallExpCS) {
            astNode = this.propertyCallExpCS((CallExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof VariableExpCS) {
            astNode = this.variableExpCS((VariableExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof LiteralExpCS) {
            astNode = this.literalExpCS((LiteralExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof LetExpCS) {
            astNode = this.letExpCS((LetExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof MessageExpCS) {
            astNode = this.messageExpCS((MessageExpCS)oclExpressionCS, env);
        }
        if (astNode != null) {
            astNode.setType(TypeUtil.resolveType(env, astNode.getType()));
            this.initStartEndPositions(astNode, oclExpressionCS);
        }
        return astNode;
    }

    protected final OCLExpression variableExpCS(VariableExpCS variableExpCS, Environment env) throws SemanticException {
        OCLExpression astNode = this.simpleNameCS(variableExpCS.getSimpleNameCS(), env, null);
        EList qualifiers = this.qualifiersCS(variableExpCS.getArguments(), env, astNode);
        if (variableExpCS.getIsMarkedPreCS().isPre()) {
            if (astNode instanceof FeatureCallExp) {
                ((FeatureCallExp)astNode).setMarkedPre(true);
            } else {
                this.ERROR("variableExpCS", OCLMessages.IllegalAtPre_ERROR_);
            }
        }
        if (!qualifiers.isEmpty()) {
            if (astNode instanceof NavigationCallExp) {
                this.setQualifiers(env, "variableExpCS", (NavigationCallExp)astNode, qualifiers);
            } else if (astNode instanceof LoopExp && ((LoopExp)astNode).getBody() instanceof NavigationCallExp) {
                this.setQualifiers(env, "variableExpCS", (NavigationCallExp)((LoopExp)astNode).getBody(), qualifiers);
            } else {
                this.ERROR("variableExpCS", OCLMessages.bind(OCLMessages.IllegalQualifiers_ERROR_, this.computeInputString(variableExpCS)));
            }
        } else if (astNode instanceof AssociationClassCallExp) {
            this.checkNotReflexive(env, "variableExpCS", (AssociationClassCallExp)astNode);
        }
        return astNode;
    }

    protected final EList qualifiersCS(EList arguments, Environment env, OCLExpression navigation) throws SemanticException {
        if (arguments.isEmpty()) {
            return ECollections.EMPTY_ELIST;
        }
        BasicEList qualifiers = new BasicEList();
        if (navigation instanceof LoopExp) {
            navigation = ((LoopExp)navigation).getBody();
        }
        if (navigation instanceof AssociationClassCallExp) {
            AssociationClassCallExp acc = (AssociationClassCallExp)navigation;
            OCLExpression source = acc.getSource();
            OCLExpressionCS arg = (OCLExpressionCS)arguments.get(0);
            if (!(arg instanceof VariableExpCS)) {
                this.ERROR("qualifiersCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "VariableExpCS", arg.eClass().getName()));
            }
            SimpleNameCS qualifier = ((VariableExpCS)arg).getSimpleNameCS();
            String simpleName = qualifier.getValue();
            EStructuralFeature property = env.lookupProperty(source.getType(), simpleName);
            if (!(property instanceof EReference)) {
                String message = OCLMessages.bind(OCLMessages.UnrecognizedVar_ERROR_, simpleName);
                this.ERROR("qualifiersCS", message);
            }
            EReference reference = (EReference)property;
            this.TRACE("qualifierCS", "Reference: " + simpleName);
            PropertyCallExp ref = this.expressionsFactory.createPropertyCallExp();
            ref.setReferredProperty((EStructuralFeature)reference);
            ref.setType(TypeUtil.getOCLType((ETypedElement)reference));
            if (source == null) {
                VariableExp src = this.expressionsFactory.createVariableExp();
                Variable implicitSource = env.lookupImplicitSourceForProperty(simpleName);
                src.setType(implicitSource.getType());
                src.setReferredVariable(implicitSource);
                src.setName(implicitSource.getName());
            }
            this.initStartEndPositions(ref, qualifier);
            this.initPropertyPositions(ref, qualifier);
            qualifiers.add((Object)ref);
        } else {
            Iterator i = arguments.iterator();
            while (i.hasNext()) {
                qualifiers.add((Object)this.oclExpressionCS((OCLExpressionCS)i.next(), env));
            }
        }
        return qualifiers;
    }

    protected final IfExp ifExpCS(IfExpCS ifExpCS, Environment env) throws SemanticException {
        OCLExpression condition = this.oclExpressionCS(ifExpCS.getCondition(), env);
        OCLExpression thenExpression = this.oclExpressionCS(ifExpCS.getThenExpression(), env);
        OCLExpression elseExpression = this.oclExpressionCS(ifExpCS.getElseExpression(), env);
        this.TRACE("ifExpCS", " ");
        if (condition.getType() != Types.OCL_BOOLEAN && condition != Types.OCL_VOID) {
            this.ERROR("ifExpCS", OCLMessages.bind(OCLMessages.BooleanForIf_ERROR_, this.computeInputString(ifExpCS.getCondition())));
        }
        IfExp astNode = this.expressionsFactory.createIfExp();
        astNode.setCondition(condition);
        astNode.setThenExpression(thenExpression);
        astNode.setElseExpression(elseExpression);
        astNode.setType(TypeUtil.commonSuperType(thenExpression.getType(), elseExpression.getType()));
        this.initStartEndPositions(astNode, ifExpCS);
        return astNode;
    }

    protected final LetExp letExpCS(LetExpCS letExpCS, Environment env) throws SemanticException {
        return (LetExp)this.letExpCSRecursive(letExpCS, 0, env);
    }

    protected final OCLExpression letExpCSRecursive(LetExpCS letExpCS, int index, Environment env) throws SemanticException {
        OCLExpression astNode;
        if (index < letExpCS.getVariables().size()) {
            String message;
            Variable variableDeclaration = this.variableDeclarationCS((VariableCS)letExpCS.getVariables().get(index), env, true);
            String varName = variableDeclaration.getName();
            if (variableDeclaration.getType() == null) {
                message = OCLMessages.bind(OCLMessages.DeclarationType_ERROR_, varName);
                this.ERROR("letExpCS", message);
            }
            if (variableDeclaration.getInitExpression() == null) {
                message = OCLMessages.bind(OCLMessages.DeclarationNoInitExp_ERROR_, varName);
                this.ERROR("letExpCS", message);
            }
            OCLExpression letSubExp = this.letExpCSRecursive(letExpCS, ++index, env);
            LetExp letExp = this.expressionsFactory.createLetExp();
            letExp.setVariable(variableDeclaration);
            letExp.setIn(letSubExp);
            letExp.setType(letSubExp.getType());
            astNode = letExp;
            env.deleteElement(varName);
        } else {
            astNode = this.oclExpressionCS(letExpCS.getInExpression(), env);
        }
        return astNode;
    }

    protected final OCLExpression simpleNameCS(SimpleNameCS simpleNameCS, Environment env, OCLExpression source) throws SemanticException {
        String simpleName = null;
        OCLExpression astNode = null;
        EStructuralFeature property = null;
        EClassifier classifier = null;
        PropertyCallExp propertyCall = null;
        EClass assocClass = null;
        AssociationClassCallExp acref = null;
        Variable vdcl = null;
        switch (simpleNameCS.getType().getValue()) {
            case 1: 
            case 2: 
            case 11: {
                simpleName = this.unquote(simpleNameCS.getValue());
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (source != null) break;
                classifier = this.primitiveTypeCS(simpleNameCS.getType());
                simpleName = classifier.getName();
            }
        }
        EClassifier sourceElementType = null;
        if (source != null && (sourceElementType = source.getType()) instanceof CollectionType) {
            sourceElementType = ((CollectionType)sourceElementType).getElementType();
        }
        Vector<String> names = new Vector<String>();
        names.addElement(simpleName);
        if (classifier == null && source == null) {
            classifier = env.lookupPathName(names);
        }
        if (classifier != null) {
            TypeExp texp = this.expressionsFactory.createTypeExp();
            texp.setReferredType(classifier);
            texp.setType(TypeTypeImpl.createType(classifier));
            astNode = texp;
        } else if (source == null && (vdcl = env.lookup(simpleName)) != null) {
            this.TRACE("variableExpCS", "Variable Expression: " + simpleName);
            VariableExp vexp = this.expressionsFactory.createVariableExp();
            vexp.setReferredVariable(vdcl);
            vexp.setName(vdcl.getName());
            vexp.setType(vdcl.getType());
            astNode = vexp;
        } else {
            property = env.lookupProperty(sourceElementType, simpleName);
            if (property != null) {
                this.TRACE("variableExpCS", "Property: " + simpleName);
                propertyCall = this.expressionsFactory.createPropertyCallExp();
                propertyCall.setReferredProperty(property);
                propertyCall.setType(TypeUtil.resolveType(env, TypeUtil.getOCLType((ETypedElement)property)));
                if (source != null) {
                    propertyCall.setSource(source);
                } else {
                    VariableExp src = this.expressionsFactory.createVariableExp();
                    Variable implicitSource = env.lookupImplicitSourceForProperty(simpleName);
                    src.setType(implicitSource.getType());
                    src.setReferredVariable(implicitSource);
                    src.setName(implicitSource.getName());
                    propertyCall.setSource(src);
                }
                this.initPropertyPositions(propertyCall, simpleNameCS);
                astNode = propertyCall;
            } else {
                assocClass = env.lookupAssociationClassReference(sourceElementType, simpleName);
                if (assocClass != null) {
                    this.TRACE("variableExpCS", "Association class: " + simpleName);
                    acref = this.expressionsFactory.createAssociationClassCallExp();
                    acref.setReferredAssociationClass(assocClass);
                    acref.setType((EClassifier)assocClass);
                    if (source != null) {
                        acref.setSource(source);
                    } else {
                        VariableExp src = this.expressionsFactory.createVariableExp();
                        Variable implicitSource = env.lookupImplicitSourceForAssociationClass(simpleName);
                        src.setType(implicitSource.getType());
                        src.setReferredVariable(implicitSource);
                        src.setName(implicitSource.getName());
                        acref.setSource(src);
                    }
                    this.initPropertyPositions(acref, simpleNameCS);
                    astNode = acref;
                } else if (source != null && (vdcl = env.lookup(simpleName)) != null) {
                    String message = OCLMessages.bind(OCLMessages.VarInNavExp_ERROR_, simpleName);
                    this.ERROR("variableExpCS", message);
                } else {
                    String message = OCLMessages.bind(OCLMessages.UnrecognizedVar_ERROR_, simpleName);
                    this.ERROR("variableExpCS", message);
                }
            }
        }
        if (source != null && source.getType() instanceof CollectionType) {
            astNode = this.createImplicitCollect(source, (FeatureCallExp)astNode, env);
        }
        return astNode;
    }

    private IteratorExp createImplicitCollect(OCLExpression source, FeatureCallExp propertyCall, Environment env) throws SemanticException {
        EClassifier sourceElementType = ((CollectionType)source.getType()).getElementType();
        IteratorExp result = this.expressionsFactory.createIteratorExp();
        Variable itervar = this.genVariableDeclaration("modelPropertyCallCS", env, null, sourceElementType, null, false, true, false);
        EList iters = result.getIterator();
        iters.add((Object)itervar);
        result.setBody(propertyCall);
        result.setName("collect");
        VariableExp vexp = this.expressionsFactory.createVariableExp();
        vexp.setType(itervar.getType());
        vexp.setReferredVariable(itervar);
        vexp.setName(itervar.getName());
        propertyCall.setSource(vexp);
        if (!(propertyCall instanceof OperationCallExp)) {
            propertyCall.setStartPosition(propertyCall.getPropertyStartPosition());
            propertyCall.setEndPosition(propertyCall.getPropertyEndPosition());
        }
        result.setSource(source);
        EClassifier bodyType = propertyCall.getType();
        if (bodyType instanceof CollectionType) {
            bodyType = ((CollectionType)bodyType).getElementType();
        }
        if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
            result.setType((EClassifier)this.getCollectionType(env, CollectionKind.SEQUENCE_LITERAL, bodyType));
        } else {
            result.setType((EClassifier)this.getCollectionType(env, CollectionKind.BAG_LITERAL, bodyType));
        }
        env.deleteElement(itervar.getName());
        return result;
    }

    protected final EClassifier primitiveTypeCS(SimpleTypeEnum simpleType) throws SemanticException {
        PredefinedType astNode = null;
        switch (simpleType.getValue()) {
            case 3: {
                astNode = Types.OCL_INTEGER;
                break;
            }
            case 4: {
                astNode = Types.OCL_STRING;
                break;
            }
            case 5: {
                astNode = Types.OCL_REAL;
                break;
            }
            case 6: {
                astNode = Types.OCL_BOOLEAN;
                break;
            }
            case 7: {
                astNode = Types.OCL_ANY_TYPE;
                break;
            }
            case 8: {
                astNode = Types.OCL_VOID;
                break;
            }
            case 9: {
                astNode = Types.INVALID;
                break;
            }
            case 10: {
                astNode = Types.OCL_MESSAGE;
            }
        }
        return astNode;
    }

    protected final LiteralExp primitiveLiteralExpCS(PrimitiveLiteralExpCS primitiveLiteralExpCS, Environment env) throws SemanticException {
        PrimitiveLiteralExp astNode = null;
        if (primitiveLiteralExpCS instanceof IntegerLiteralExpCS) {
            astNode = this.integerLiteralExpCS((IntegerLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof RealLiteralExpCS) {
            astNode = this.realLiteralExpCS((RealLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof StringLiteralExpCS) {
            astNode = this.stringLiteralExpCS((StringLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof BooleanLiteralExpCS) {
            astNode = this.booleanLiteralExpCS((BooleanLiteralExpCS)primitiveLiteralExpCS, env);
        }
        return astNode;
    }

    protected final IntegerLiteralExp integerLiteralExpCS(IntegerLiteralExpCS integerLiteralExpCS, Environment env) throws SemanticException {
        IntegerLiteralExp astNode = this.expressionsFactory.createIntegerLiteralExp();
        astNode.setIntegerSymbol(integerLiteralExpCS.getIntegerSymbol());
        astNode.setType((EClassifier)Types.OCL_INTEGER);
        astNode.setName("Integer");
        this.TRACE("integerLiteralExpCS", "Integer: " + integerLiteralExpCS.getSymbol());
        return astNode;
    }

    protected final RealLiteralExp realLiteralExpCS(RealLiteralExpCS realLiteralExpCS, Environment env) throws SemanticException {
        RealLiteralExp astNode = this.expressionsFactory.createRealLiteralExp();
        astNode.setRealSymbol(realLiteralExpCS.getRealSymbol());
        astNode.setType((EClassifier)Types.OCL_REAL);
        astNode.setName("Real");
        this.TRACE("realLiteralExpCS", "Real: " + realLiteralExpCS.getSymbol());
        return astNode;
    }

    protected final StringLiteralExp stringLiteralExpCS(StringLiteralExpCS stringLiteralExpCS, Environment env) throws SemanticException {
        StringLiteralExp astNode = this.expressionsFactory.createStringLiteralExp();
        String stringLiteral = stringLiteralExpCS.getStringSymbol();
        if (stringLiteral.length() <= 2) {
            astNode.setStringSymbol("");
        } else {
            astNode.setStringSymbol(stringLiteral.substring(1, stringLiteral.length() - 1));
        }
        astNode.setType((EClassifier)Types.OCL_STRING);
        astNode.setName("String");
        this.TRACE("stringLiteralExpCS", "String: " + stringLiteralExpCS.getSymbol());
        return astNode;
    }

    protected final BooleanLiteralExp booleanLiteralExpCS(BooleanLiteralExpCS booleanLiteralExpCS, Environment env) throws SemanticException {
        BooleanLiteralExp astNode = this.expressionsFactory.createBooleanLiteralExp();
        astNode.setBooleanSymbol(booleanLiteralExpCS.getBooleanSymbol());
        astNode.setType((EClassifier)Types.OCL_BOOLEAN);
        astNode.setName("Boolean");
        this.TRACE("booleanLiteralExpCS", "Boolean: " + booleanLiteralExpCS.getSymbol());
        return astNode;
    }

    protected final NullLiteralExp nullLiteralExpCS(NullLiteralExpCS nullLiteralExpCS, Environment env) throws SemanticException {
        NullLiteralExp astNode = this.expressionsFactory.createNullLiteralExp();
        astNode.setType(Types.OCL_VOID);
        astNode.setName("OclVoid");
        this.TRACE("nullLiteralExpCS", "OclVoid: null");
        return astNode;
    }

    protected final InvalidLiteralExp invalidLiteralExpCS(InvalidLiteralExpCS nullLiteralExpCS, Environment env) throws SemanticException {
        InvalidLiteralExp astNode = this.expressionsFactory.createInvalidLiteralExp();
        astNode.setType(Types.INVALID);
        astNode.setName("Invalid");
        this.TRACE("invalidLiteralExpCS", "Invalid: OclInvalid");
        return astNode;
    }

    protected final OCLExpression literalExpCS(LiteralExpCS literalExpCS, Environment env) throws SemanticException {
        OCLExpression astNode = null;
        if (literalExpCS instanceof PrimitiveLiteralExpCS) {
            astNode = this.primitiveLiteralExpCS((PrimitiveLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof CollectionLiteralExpCS) {
            astNode = this.collectionLiteralExpCS((CollectionLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof TupleLiteralExpCS) {
            astNode = this.tupleLiteralExpCS((TupleLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof EnumLiteralExpCS) {
            astNode = this.enumLiteralExpCS((EnumLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof NullLiteralExpCS) {
            astNode = this.nullLiteralExpCS((NullLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof InvalidLiteralExpCS) {
            astNode = this.invalidLiteralExpCS((InvalidLiteralExpCS)literalExpCS, env);
        }
        return astNode;
    }

    protected final TupleLiteralExp tupleLiteralExpCS(TupleLiteralExpCS tupleLiteralExpCS, Environment env) throws SemanticException {
        HashSet<String> names = new HashSet<String>();
        String nodeName = null;
        TupleLiteralExp astNode = this.expressionsFactory.createTupleLiteralExp();
        EList tupleParts = astNode.getPart();
        this.TRACE("tupleLiteralExpCS", "Tuple");
        EList tupleLiteralParts = this.tupleLiteralPartListCS(tupleLiteralExpCS.getVariables(), env);
        Iterator i = tupleLiteralParts.iterator();
        while (i.hasNext()) {
            String message;
            TupleLiteralPart part = (TupleLiteralPart)i.next();
            tupleParts.add((Object)part);
            String name = part.getName();
            this.TRACE("tupleLiteralExpCS", " name = " + name);
            if (names.contains(name)) {
                message = OCLMessages.bind(OCLMessages.DuplicateNameInTuple_ERROR_, name);
                this.ERROR("tupleLiteralPartCS", message);
                part.setName(null);
            } else {
                names.add(name);
            }
            if (part.getValue() == null) {
                message = OCLMessages.bind(OCLMessages.MissingTypeInTupleLiteralPart_ERROR_, name, this.computeInputString(tupleLiteralExpCS));
                this.ERROR("tupleLiteralExpCS", message);
            }
            if (part.getType() == null) {
                part.setType(part.getValue().getType());
            }
            nodeName = nodeName == null ? "Tuple{" : String.valueOf(nodeName) + ", ";
            nodeName = String.valueOf(nodeName) + part.getName() + ":" + part.getType().getName();
        }
        TupleType tt = this.getTupleType(env, (List)tupleParts);
        astNode.setType((EClassifier)tt);
        Iterator iter = tupleParts.iterator();
        while (iter.hasNext()) {
            TupleLiteralPart part = (TupleLiteralPart)iter.next();
            part.setAttribute(tt.getEStructuralFeature(part.getName()));
        }
        return astNode;
    }

    private EList tupleLiteralPartListCS(EList variableDeclarations, Environment env) throws SemanticException {
        BasicEList result = new BasicEList();
        Iterator i = variableDeclarations.iterator();
        while (i.hasNext()) {
            result.add((Object)this.tupleLiteralPartCS((VariableCS)i.next(), env));
        }
        return result;
    }

    private TupleLiteralPart tupleLiteralPartCS(VariableCS variableDeclarationCS, Environment env) throws SemanticException {
        String varName = this.unquote(variableDeclarationCS.getName());
        EClassifier type = null;
        if (variableDeclarationCS.getTypeCS() != null) {
            type = this.typeCS(variableDeclarationCS.getTypeCS(), env);
        }
        OCLExpression expr = null;
        if (variableDeclarationCS.getInitExpression() != null) {
            expr = this.oclExpressionCS(variableDeclarationCS.getInitExpression(), env);
        }
        TupleLiteralPart astNode = this.expressionsFactory.createTupleLiteralPart();
        astNode.setName(varName);
        astNode.setType(type);
        astNode.setValue(expr);
        this.initStartEndPositions(astNode, variableDeclarationCS);
        if (variableDeclarationCS.getTypeCS() != null) {
            this.initTypePositions(astNode, variableDeclarationCS.getTypeCS());
        }
        return astNode;
    }

    protected final OCLExpression enumLiteralExpCS(EnumLiteralExpCS enumLiteralExpCS, Environment env) throws SemanticException {
        OCLExpression astNode;
        EList sequenceOfNames = enumLiteralExpCS.getPathNameCS().getSequenceOfNames();
        String lastToken = enumLiteralExpCS.getSimpleNameCS().getValue();
        EEnumLiteral literal = null;
        EClassifier enumType = env.lookupPathName((List)sequenceOfNames);
        if (enumType == null || !(enumType instanceof EEnum)) {
            TypeExp typeExp = this.expressionsFactory.createTypeExp();
            sequenceOfNames.add((Object)lastToken);
            EClassifier type = env.lookupPathName((List)sequenceOfNames);
            if (type == null) {
                String message = OCLMessages.bind(OCLMessages.UnrecognizedType_ERROR_, sequenceOfNames);
                this.ERROR("enumerationOrClassLiteralExpCS", message);
            } else {
                typeExp.setReferredType(type);
                typeExp.setType(TypeTypeImpl.createType(type));
            }
            astNode = typeExp;
        } else {
            astNode = this.expressionsFactory.createEnumLiteralExp();
            literal = ((EEnum)enumType).getEEnumLiteral(lastToken);
            if (literal == null) {
                String message = OCLMessages.bind(OCLMessages.UnrecognizedEnum_ERROR_, lastToken);
                this.ERROR("enumerationOrClassLiteralExpCS", message);
            }
            EnumLiteralExp litExp = astNode;
            litExp.setReferredEnumLiteral(literal);
            astNode = litExp;
            if (enumType == null || literal == null) {
                astNode.setType(Types.INVALID);
            } else {
                astNode.setType(enumType);
            }
        }
        String traceText = new String();
        Iterator i = sequenceOfNames.iterator();
        while (i.hasNext()) {
            traceText = String.valueOf(traceText) + (String)i.next() + "::";
        }
        traceText = String.valueOf(traceText) + lastToken;
        this.TRACE("enumerationOrClassLiteralExpCS", traceText);
        return astNode;
    }

    protected final CollectionLiteralExp collectionLiteralExpCS(CollectionLiteralExpCS collectionLiteralExpCS, Environment env) throws SemanticException {
        CollectionLiteralExp astNode = null;
        CollectionKind kind = null;
        CollectionLiteralPart collectionLiteralPartExp = null;
        EList collectionParts = null;
        EClassifier type = null;
        CollectionType resultType = null;
        kind = this.collectionTypeIdentifierCS(collectionLiteralExpCS.getCollectionType());
        astNode = this.expressionsFactory.createCollectionLiteralExp();
        astNode.setKind(kind);
        collectionParts = astNode.getPart();
        EList collectionLiteralPartsCS = collectionLiteralExpCS.getCollectionLiteralParts();
        if (!collectionLiteralPartsCS.isEmpty()) {
            Iterator i = collectionLiteralPartsCS.iterator();
            CollectionLiteralPartCS colPart = (CollectionLiteralPartCS)i.next();
            collectionLiteralPartExp = this.collectionLiteralPartCS(colPart, env);
            collectionParts.add((Object)collectionLiteralPartExp);
            type = collectionLiteralPartExp.getType();
            while (i.hasNext()) {
                collectionLiteralPartExp = this.collectionLiteralPartCS((CollectionLiteralPartCS)i.next(), env);
                EClassifier type1 = collectionLiteralPartExp.getType();
                type = TypeUtil.commonSuperType(type, type1);
                collectionParts.add((Object)collectionLiteralPartExp);
            }
        }
        if (collectionParts.isEmpty()) {
            resultType = this.getCollectionType(env, kind, AnyTypeImpl.UML_CLASSIFIER);
            resultType.setName(String.valueOf(resultType.getName()) + "()");
        } else {
            resultType = this.getCollectionType(env, kind, type);
        }
        astNode.setType((EClassifier)resultType);
        return astNode;
    }

    protected final CollectionLiteralPart collectionLiteralPartCS(CollectionLiteralPartCS collectionLiteralPartCS, Environment env) throws SemanticException {
        CollectionLiteralPart astNode = null;
        OCLExpression expr1 = null;
        OCLExpression expr2 = null;
        CollectionRange collRange = null;
        CollectionItem collItem = null;
        expr1 = this.oclExpressionCS(collectionLiteralPartCS.getExpressionCS(), env);
        if (collectionLiteralPartCS instanceof CollectionRangeCS) {
            CollectionRangeCS collectionRangeCS = (CollectionRangeCS)collectionLiteralPartCS;
            expr2 = this.oclExpressionCS(collectionRangeCS.getLastExpressionCS(), env);
            collRange = this.expressionsFactory.createCollectionRange();
            collRange.setFirst(expr1);
            collRange.setLast(expr2);
            collRange.setType(expr1.getType());
            if (expr1.getType() != expr2.getType()) {
                this.ERROR("collectionLiteralPartCS", OCLMessages.bind(OCLMessages.FirstLastTypeMismatch_ERROR_, this.computeInputString(collectionLiteralPartCS)));
            }
            astNode = collRange;
            this.TRACE("collectionLiteralPartCS", "collection range");
        } else {
            collItem = this.expressionsFactory.createCollectionItem();
            collItem.setType(expr1.getType());
            collItem.setItem(expr1);
            astNode = collItem;
            this.TRACE("collectionLiteralPartCS", "collection item");
        }
        return astNode;
    }

    protected final OCLExpression propertyCallExpCS(CallExpCS propertyCallExpCS, Environment env) throws SemanticException {
        OCLExpression astNode = null;
        if (propertyCallExpCS instanceof LoopExpCS) {
            astNode = this.loopExpCS((LoopExpCS)propertyCallExpCS, env);
        } else if (propertyCallExpCS instanceof FeatureCallExpCS) {
            astNode = this.modelPropertyCallExpCS((FeatureCallExpCS)propertyCallExpCS, env);
        }
        this.initStartEndPositions(astNode, propertyCallExpCS);
        return astNode;
    }

    protected final LoopExp loopExpCS(LoopExpCS loopExpCS, Environment env) throws SemanticException {
        LoopExp astNode = null;
        if (loopExpCS instanceof IteratorExpCS) {
            astNode = this.iteratorExpCS((IteratorExpCS)loopExpCS, env);
        } else if (loopExpCS instanceof IterateExpCS) {
            astNode = this.iterateExpCS((IterateExpCS)loopExpCS, env);
        }
        return astNode;
    }

    protected final OCLExpression getCollectionSourceExpression(OCLExpressionCS oclExpressionCS, Environment env) throws SemanticException {
        OCLExpression astNode = this.oclExpressionCS(oclExpressionCS, env);
        if (!(astNode.getType() instanceof CollectionType)) {
            CollectionLiteralExp astNode1 = this.expressionsFactory.createCollectionLiteralExp();
            astNode1.setKind(CollectionKind.SET_LITERAL);
            EList collectionParts = astNode1.getPart();
            CollectionItem collItem = this.expressionsFactory.createCollectionItem();
            collItem.setType(astNode.getType());
            collItem.setItem(astNode);
            collectionParts.add((Object)collItem);
            CollectionType type = this.getCollectionType(env, CollectionKind.SET_LITERAL, astNode.getType());
            astNode1.setType((EClassifier)type);
            astNode = astNode1;
        }
        return astNode;
    }

    protected final IteratorExp iteratorExpCS(IteratorExpCS iteratorExpCS, Environment env) throws SemanticException {
        IteratorExp astNode;
        OCLExpression source = this.getCollectionSourceExpression(iteratorExpCS.getSource(), env);
        String name = iteratorExpCS.getSimpleNameCS().getValue();
        Variable vdcl = null;
        Variable vdcl1 = null;
        OCLExpression expr = null;
        EList iterators = null;
        if (iteratorExpCS.getVariable1() != null) {
            EClassifier sourceType;
            vdcl = this.variableDeclarationCS(iteratorExpCS.getVariable1(), env, true);
            astNode = this.expressionsFactory.createIteratorExp();
            astNode.setName(name);
            iterators = astNode.getIterator();
            if (vdcl.getType() == null && (sourceType = source.getType()) instanceof CollectionType) {
                vdcl.setType(((CollectionType)sourceType).getElementType());
            }
            iterators.add((Object)vdcl);
            if (iteratorExpCS.getVariable2() != null) {
                vdcl1 = this.variableDeclarationCS(iteratorExpCS.getVariable2(), env, true);
                if (vdcl1.getType() == null && (sourceType = source.getType()) instanceof CollectionType) {
                    vdcl1.setType(((CollectionType)sourceType).getElementType());
                }
                iterators.add((Object)vdcl1);
            }
        } else {
            astNode = this.expressionsFactory.createIteratorExp();
            astNode.setName(name);
            iterators = astNode.getIterator();
            vdcl = this.genVariableDeclaration("iteratorExpCS", env, null, ((CollectionType)source.getType()).getElementType(), null, false, true, false);
            iterators.add((Object)vdcl);
        }
        expr = this.oclExpressionCS(iteratorExpCS.getBody(), env);
        this.TRACE("oclIteratorExpCS: ", name);
        if (name.equals("forAll") || name.equals("exists") || name.equals("one") || name.equals("isUnique")) {
            astNode.setType((EClassifier)Types.OCL_BOOLEAN);
        } else if (name.equals("select") || name.equals("reject")) {
            astNode.setType(source.getType());
        } else if (name.equals("collect")) {
            EClassifier elementType = expr.getType();
            while (elementType instanceof CollectionType) {
                elementType = ((CollectionType)elementType).getElementType();
            }
            if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
                astNode.setType((EClassifier)this.typesFactory.createSequenceType(elementType));
            } else {
                astNode.setType((EClassifier)this.typesFactory.createBagType(elementType));
            }
        } else if (name.equals("collectNested")) {
            if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
                astNode.setType((EClassifier)this.typesFactory.createSequenceType(expr.getType()));
            } else {
                astNode.setType((EClassifier)this.typesFactory.createBagType(expr.getType()));
            }
        } else if (name.equals("any")) {
            astNode.setType(((CollectionType)source.getType()).getElementType());
        } else if (name.equals("sortedBy")) {
            CollectionType osType;
            if (source.getType() instanceof SequenceType || source.getType() instanceof BagType) {
                osType = this.typesFactory.createSequenceType();
                osType.setElementType(((CollectionType)source.getType()).getElementType());
                astNode.setType((EClassifier)osType);
            } else {
                osType = this.typesFactory.createOrderedSetType();
                osType.setElementType(((CollectionType)source.getType()).getElementType());
                astNode.setType((EClassifier)osType);
            }
        } else if (name.equals("closure")) {
            EClassifier bodyType = expr.getType();
            if (bodyType instanceof CollectionType) {
                bodyType = ((CollectionType)bodyType).getElementType();
            }
            astNode.setType((EClassifier)this.typesFactory.createSetType(bodyType));
        }
        astNode.setBody(expr);
        astNode.setSource(source);
        env.deleteElement(vdcl.getName());
        if (vdcl1 != null) {
            env.deleteElement(vdcl1.getName());
        }
        return astNode;
    }

    protected final IterateExp iterateExpCS(IterateExpCS iterateExpCS, Environment env) throws SemanticException {
        String message;
        IterateExp astNode = null;
        OCLExpression source = this.getCollectionSourceExpression(iterateExpCS.getSource(), env);
        Variable vdcl = null;
        Variable vdcl1 = null;
        OCLExpression expr = null;
        vdcl = this.variableDeclarationCS(iterateExpCS.getVariable1(), env, true);
        if (iterateExpCS.getVariable2() != null) {
            vdcl1 = this.variableDeclarationCS(iterateExpCS.getVariable2(), env, true);
        }
        if (vdcl1 == null) {
            vdcl1 = vdcl;
            vdcl = null;
        }
        if (vdcl == null) {
            vdcl = this.genVariableDeclaration("iterateExpCS", env, null, ((CollectionType)source.getType()).getElementType(), null, false, true, false);
        }
        if (vdcl.getType() == null) {
            vdcl.setType(((CollectionType)source.getType()).getElementType());
        }
        expr = this.oclExpressionCS(iterateExpCS.getBody(), env);
        this.TRACE("iterateExpCS", "iterate");
        astNode = this.expressionsFactory.createIterateExp();
        astNode.setName("iterate");
        EList iterator = astNode.getIterator();
        iterator.add((Object)vdcl);
        astNode.setSource(source);
        astNode.setResult(vdcl1);
        astNode.setBody(expr);
        if (vdcl1.getType() == null) {
            message = OCLMessages.bind(OCLMessages.DeclarationType_ERROR_, vdcl1.getName());
            this.ERROR("iterateExpCS", message);
        }
        astNode.setType(vdcl1.getType());
        if (vdcl1.getInitExpression() == null) {
            message = OCLMessages.bind(OCLMessages.DeclarationNoInitExp_ERROR_, vdcl1.getName());
            this.ERROR("iterateExpCS", message);
        }
        if (vdcl.getInitExpression() != null) {
            message = OCLMessages.bind(OCLMessages.DeclarationInitExp_ERROR_, vdcl1.getName());
            this.ERROR("iterateExpCS", message);
        }
        env.deleteElement(vdcl.getName());
        env.deleteElement(vdcl1.getName());
        return astNode;
    }

    protected final OCLExpression modelPropertyCallExpCS(FeatureCallExpCS modelPropertyCallExpCS, Environment env) throws SemanticException {
        OCLExpression astNode = null;
        if (modelPropertyCallExpCS instanceof OperationCallExpCS) {
            astNode = this.operationCallExpCS((OperationCallExpCS)modelPropertyCallExpCS, env);
        } else {
            OCLExpression source = this.oclExpressionCS(modelPropertyCallExpCS.getSource(), env);
            astNode = this.simpleNameCS(modelPropertyCallExpCS.getSimpleNameCS(), env, source);
            EList qualifiers = this.qualifiersCS(modelPropertyCallExpCS.getArguments(), env, astNode);
            if (modelPropertyCallExpCS.getIsMarkedPreCS().isPre()) {
                if (astNode instanceof FeatureCallExp) {
                    ((FeatureCallExp)astNode).setMarkedPre(true);
                } else {
                    this.ERROR("modelPropertyCallExpCS", OCLMessages.IllegalAtPre_ERROR_);
                }
            }
            if (!qualifiers.isEmpty()) {
                if (astNode instanceof NavigationCallExp) {
                    this.setQualifiers(env, "modelPropertyCallExpCS", (NavigationCallExp)astNode, qualifiers);
                } else if (astNode instanceof LoopExp && ((LoopExp)astNode).getBody() instanceof NavigationCallExp) {
                    this.setQualifiers(env, "modelPropertyCallExpCS", (NavigationCallExp)((LoopExp)astNode).getBody(), qualifiers);
                } else {
                    this.ERROR("modelPropertyCallExpCS", OCLMessages.bind(OCLMessages.IllegalQualifiers_ERROR_, this.computeInputString(modelPropertyCallExpCS)));
                }
            } else if (astNode instanceof AssociationClassCallExp) {
                this.checkNotReflexive(env, "modelPropertyCallExpCS", (AssociationClassCallExp)astNode);
            }
        }
        return astNode;
    }

    protected final OCLExpression operationCallExpCS(OperationCallExpCS operationCallExpCS, Environment env) throws SemanticException {
        boolean isImplicitCollect;
        CallExp astNode = null;
        BasicEList args = new BasicEList();
        int operator = operationCallExpCS.getAccessor().getValue();
        OCLExpression source = operator == 3 ? this.getCollectionSourceExpression(operationCallExpCS.getSource(), env) : this.oclExpressionCS(operationCallExpCS.getSource(), env);
        String operationName = operationCallExpCS.getSimpleNameCS().getValue();
        if ("oclIsInState".equals(operationName)) {
            OCLExpressionCS arg;
            if (operationCallExpCS.getArguments().size() != 1) {
                this.ERROR("operationCallExpCS", OCLMessages.bind(OCLMessages.IsInStateSignature_ERROR_, this.computeInputString(operationCallExpCS)));
            }
            if (!((arg = (OCLExpressionCS)operationCallExpCS.getArguments().get(0)) instanceof StateExpCS)) {
                this.ERROR("operationCallExpCS", OCLMessages.bind(OCLMessages.IsInStateSignature_ERROR_, this.computeInputString(operationCallExpCS)));
            }
            args.add((Object)this.stateExpCS(source, (StateExpCS)arg, env));
        } else {
            Iterator i = operationCallExpCS.getArguments().iterator();
            while (i.hasNext()) {
                args.add((Object)this.oclExpressionCS((OCLExpressionCS)i.next(), env));
            }
        }
        if (source == null) {
            VariableExp vexp = this.expressionsFactory.createVariableExp();
            Variable implicitSource = env.lookupImplicitSourceForOperation(operationName, (EList)args);
            vexp.setType(implicitSource.getType());
            vexp.setReferredVariable(implicitSource);
            vexp.setName(implicitSource.getName());
            source = vexp;
        }
        EClassifier operationSourceType = source.getType();
        boolean bl = isImplicitCollect = operator == 2 && operationSourceType instanceof CollectionType;
        if (isImplicitCollect) {
            operationSourceType = ((CollectionType)operationSourceType).getElementType();
        }
        astNode = this.genOperationCallExp(env, "operationCallExpCS", operationName, source, operationSourceType, (EList)args);
        astNode.setMarkedPre(operationCallExpCS.getIsMarkedPreCS().isPre());
        this.initPropertyPositions(astNode, operationCallExpCS.getSimpleNameCS());
        if (isImplicitCollect) {
            astNode = this.createImplicitCollect(source, (FeatureCallExp)astNode, env);
        }
        return astNode;
    }

    protected final OCLExpression messageExpCS(MessageExpCS messageExpCS, Environment env) throws SemanticException {
        EOperation behavioralFeature;
        EList arguments;
        OCLExpression target = this.oclExpressionCS(messageExpCS.getTarget(), env);
        String name = messageExpCS.getSimpleNameCS().getValue();
        EList argsCS = messageExpCS.getArguments();
        if (argsCS.isEmpty()) {
            arguments = ECollections.EMPTY_ELIST;
        } else {
            arguments = new BasicEList();
            Iterator iter = argsCS.iterator();
            while (iter.hasNext()) {
                OCLExpression arg;
                OCLMessageArgCS argCS = (OCLMessageArgCS)iter.next();
                if (argCS.getExpression() == null) {
                    arg = this.expressionsFactory.createUnspecifiedValueExp();
                    this.initStartEndPositions(arg, argCS);
                    if (argCS.getTypeCS() == null) {
                        arg.setType(Types.OCL_VOID);
                    } else {
                        arg.setType(this.typeCS(argCS.getTypeCS(), env));
                        this.initTypePositions((UnspecifiedValueExp)arg, argCS.getTypeCS());
                    }
                } else {
                    arg = this.oclExpressionCS(argCS.getExpression(), env);
                }
                arguments.add((Object)arg);
            }
        }
        EOperation calledOperation = env.lookupOperation(target.getType(), name, arguments);
        EClass receivedSignal = env.lookupSignal(target.getType(), name, arguments);
        if (calledOperation == null && receivedSignal == null) {
            this.ERROR("messageExpCS", OCLMessages.bind(OCLMessages.UnrecognizedMessageType_ERROR_, name));
        } else if (calledOperation != null && receivedSignal != null) {
            this.ERROR("messageExpCS", OCLMessages.bind(OCLMessages.AmbiguousMessageType_ERROR_, name));
        }
        MessageExp result = this.expressionsFactory.createMessageExp();
        this.initStartEndPositions(result, messageExpCS);
        this.initPropertyPositions(result, messageExpCS.getSimpleNameCS());
        result.setTarget(target);
        result.getArgument().addAll((Collection)arguments);
        if (calledOperation != null) {
            CallOperationAction callAction = this.umlFactory.createCallOperationAction();
            callAction.setOperation(calledOperation);
            result.setCalledOperation(callAction);
            behavioralFeature = calledOperation;
        } else {
            SendSignalAction sendAction = this.umlFactory.createSendSignalAction();
            sendAction.setSignal(receivedSignal);
            result.setSentSignal(sendAction);
            behavioralFeature = receivedSignal;
        }
        if (messageExpCS.getKind() == MessageExpKind.HAS_SENT_LITERAL) {
            result.setType((EClassifier)Types.OCL_BOOLEAN);
        } else {
            result.setType((EClassifier)this.typesFactory.createSequenceType((EClassifier)this.typesFactory.createMessageType((ENamedElement)behavioralFeature)));
        }
        return result;
    }

    private CollectionType getCollectionType(Environment env, CollectionKind kind, EClassifier elementType) {
        return env instanceof PersistentEnvironment ? ((PersistentEnvironment)env).getTypeResolver().resolveCollectionType(kind, elementType) : this.typesFactory.createCollectionType(kind, elementType);
    }

    private TupleType getTupleType(Environment env, List parts) {
        return env instanceof PersistentEnvironment ? ((PersistentEnvironment)env).getTypeResolver().resolveTupleType(parts) : this.typesFactory.createTupleType(parts);
    }
}

