/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.parser;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.expressions.util.EvalEnvironment;
import org.eclipse.emf.ocl.internal.parser.LazyExtentMap;
import org.eclipse.emf.ocl.parser.EcoreEnvironment;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.parser.EvaluationEnvironment;
import org.eclipse.emf.ocl.types.impl.TypeUtil;

public abstract class AbstractEnvironmentFactory
implements EnvironmentFactory {
    private static final String SELF_NAME = "self";

    protected AbstractEnvironmentFactory() {
    }

    protected abstract Environment createEnvironment(EPackage var1);

    protected abstract EClassifier asEClassifier(Object var1);

    protected abstract EOperation asEOperation(Object var1);

    protected abstract EStructuralFeature asEStructuralFeature(Object var1);

    public Environment createClassifierContext(Object context) {
        return this.createClassifierContext(this.asEClassifier(context));
    }

    public Environment createPackageContext(List pathname) {
        EPackage defaultPackage = EcoreEnvironment.findPackage(pathname);
        if (defaultPackage != null) {
            return new EcoreEnvironment(defaultPackage);
        }
        return null;
    }

    public Environment createOperationContext(Object context, Object operation) {
        return this.createOperationContext(this.asEClassifier(context), this.asEOperation(operation));
    }

    public Environment createPropertyContext(Object context, Object property) {
        return this.createPropertyContext(this.asEClassifier(context), this.asEStructuralFeature(property));
    }

    public EvaluationEnvironment createEvaluationEnvironment() {
        return new EvalEnvironment();
    }

    private Environment createClassifierContext(EClassifier classifier) {
        Environment result = this.createEnvironment(classifier.getEPackage());
        classifier = TypeUtil.getOCLType(classifier);
        Variable self = AbstractEnvironmentFactory.createVariable(SELF_NAME, classifier);
        result.addElement(self.getName(), self, true);
        result.setSelfVariable(self);
        return result;
    }

    private Environment createOperationContext(EClassifier classifier, EOperation operation) {
        Environment classifierEnv = this.createClassifierContext(classifier);
        Environment result = this.createEnvironment(classifierEnv);
        Iterator iter = operation.getEParameters().iterator();
        while (iter.hasNext()) {
            EParameter next = (EParameter)iter.next();
            Variable var = AbstractEnvironmentFactory.createVariable(next.getName(), TypeUtil.getOCLType((ETypedElement)next));
            var.setRepresentedParameter(next);
            result.addElement(var.getName(), var, true);
        }
        if (result instanceof EcoreEnvironment) {
            ((EcoreEnvironment)result).setContextOperation(operation);
        }
        return result;
    }

    private Environment createPropertyContext(EClassifier classifier, EStructuralFeature property) {
        Environment classifierEnv = this.createClassifierContext(classifier);
        Environment result = this.createEnvironment(classifierEnv);
        if (result instanceof EcoreEnvironment) {
            ((EcoreEnvironment)result).setContextProperty(property);
        }
        return result;
    }

    public Map createExtentMap(Object object) {
        if (object instanceof EObject) {
            return new LazyExtentMap((EObject)object);
        }
        return Collections.EMPTY_MAP;
    }

    private static Variable createVariable(String name, EClassifier type) {
        Variable result = ExpressionsFactory.eINSTANCE.createVariable();
        result.setName(name);
        result.setType(type);
        return result;
    }
}

