/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.parser;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.internal.l10n.OCLMessages;
import org.eclipse.emf.ocl.internal.parser.OCLParser;
import org.eclipse.emf.ocl.parser.EcoreEnvironmentFactory;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.parser.EnvironmentResource;
import org.eclipse.emf.ocl.parser.PersistentEnvironment;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.parser.TypeResolver;
import org.eclipse.emf.ocl.parser.TypeResolverImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.uml.util.UMLTypeUtil;

public class EcoreEnvironment
implements PersistentEnvironment {
    private static int generatorInt = 0;
    private List namedElements = new ArrayList();
    private Variable selfVariable;
    private Environment parent;
    private EOperation contextOperation;
    private EStructuralFeature contextProperty;
    private EPackage defaultPackage;
    private EPackage.Registry registry;
    private EnvironmentFactory factory;
    private Resource resource;
    private TypeResolver typeResolver;

    public static EClassifier getOCLType(ETypedElement typedElement) {
        return TypeUtil.getOCLType(typedElement);
    }

    public static EClassifier getOCLType(EClassifier type) {
        return TypeUtil.getOCLType(type);
    }

    public static EClassifier getOCLCollectionType(EClassifier type, boolean isOrdered, boolean isUnique) {
        return TypeUtil.getOCLCollectionType(type, isOrdered, isUnique);
    }

    private synchronized String generateName() {
        return "temp" + ++generatorInt;
    }

    public EcoreEnvironment(EPackage pkg) {
        this(pkg, EPackage.Registry.INSTANCE);
    }

    public EcoreEnvironment(EPackage pkg, EPackage.Registry reg) {
        this.defaultPackage = pkg;
        this.registry = reg;
        this.resource = new EnvironmentResource();
    }

    public EcoreEnvironment(Environment parent) {
        if (parent instanceof EcoreEnvironment) {
            EcoreEnvironment eparent = (EcoreEnvironment)parent;
            this.defaultPackage = eparent.defaultPackage;
            this.registry = eparent.registry;
            this.resource = eparent.resource;
            this.typeResolver = eparent.getTypeResolver();
        } else {
            this.defaultPackage = parent.getContextClassifier().getEPackage();
            this.registry = EPackage.Registry.INSTANCE;
            this.resource = new EnvironmentResource();
        }
        this.parent = parent;
    }

    public EnvironmentFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        if (this.getParent() != null) {
            this.factory = this.getParent().getFactory();
            if (this.factory != null) {
                return this.factory;
            }
        }
        this.factory = this.registry == EPackage.Registry.INSTANCE ? EcoreEnvironmentFactory.ECORE_INSTANCE : new EcoreEnvironmentFactory(this.registry);
        return this.factory;
    }

    protected void setFactory(EnvironmentFactory factory) {
        this.factory = factory;
    }

    public void setParent(Environment env) {
        this.parent = env;
    }

    public Environment getParent() {
        return this.parent;
    }

    public EClassifier getContextClassifier() {
        return this.getSelfVariable().getType();
    }

    public EOperation getContextOperation() {
        if (this.contextOperation != null) {
            return this.contextOperation;
        }
        if (this.getParent() != null) {
            return this.getParent().getContextOperation();
        }
        return null;
    }

    public void setContextOperation(EOperation operation) {
        this.contextOperation = operation;
    }

    public EStructuralFeature getContextProperty() {
        if (this.contextProperty != null) {
            return this.contextProperty;
        }
        if (this.getParent() != null) {
            return this.getParent().getContextProperty();
        }
        return null;
    }

    public void setContextProperty(EStructuralFeature property) {
        this.contextProperty = property;
    }

    public TypeResolver getTypeResolver() {
        if (this.typeResolver == null) {
            this.typeResolver = this.createTypeResolver();
        }
        return this.typeResolver;
    }

    protected TypeResolver createTypeResolver() {
        return new TypeResolverImpl();
    }

    public boolean isEmpty() {
        return this.namedElements.size() == 0;
    }

    public Variable lookupLocal(String name) {
        int i = 0;
        while (i < this.namedElements.size()) {
            VariableEntry elem = (VariableEntry)this.namedElements.get(i);
            if (elem.name.equals(name)) {
                return elem.variable;
            }
            ++i;
        }
        return null;
    }

    public Variable lookup(String name) {
        Variable elem = this.lookupLocal(name);
        if (elem != null) {
            return elem;
        }
        if (this.parent != null) {
            return this.parent.lookup(name);
        }
        return null;
    }

    public EPackage lookupPackage(List path) {
        EPackage pkg = null;
        EPackage currPkg = this.defaultPackage;
        if (this.defaultPackage != null) {
            while (currPkg != null) {
                pkg = currPkg;
                int i = 0;
                while (i < path.size()) {
                    String name = (String)path.get(i);
                    EList subPackages = pkg.getESubpackages();
                    pkg = null;
                    int j = 0;
                    while (j < subPackages.size()) {
                        pkg = (EPackage)subPackages.get(j);
                        if (name.equals(pkg.getName())) break;
                        pkg = null;
                        ++j;
                    }
                    if (pkg == null) break;
                    ++i;
                }
                if (pkg != null) {
                    return pkg;
                }
                currPkg = currPkg.getESuperPackage();
            }
        }
        return EcoreEnvironment.findPackage(path, this.registry);
    }

    public EClassifier lookupPathName(List names) {
        EPackage pkg = null;
        EPackage currPkg = this.defaultPackage;
        if (names.size() > 1) {
            List newNames;
            if (this.defaultPackage != null) {
                while (currPkg != null) {
                    pkg = currPkg;
                    int i = 0;
                    while (i < names.size() - 1) {
                        String name = (String)names.get(i);
                        EList subPackages = pkg.getESubpackages();
                        pkg = null;
                        int j = 0;
                        while (j < subPackages.size()) {
                            pkg = (EPackage)subPackages.get(j);
                            if (name.equals(pkg.getName())) break;
                            pkg = null;
                            ++j;
                        }
                        if (pkg == null) break;
                        ++i;
                    }
                    if (pkg != null) {
                        return pkg.getEClassifier((String)names.get(names.size() - 1));
                    }
                    currPkg = currPkg.getESuperPackage();
                }
            }
            if ((pkg = EcoreEnvironment.findPackage(newNames = names.subList(0, names.size() - 1), this.registry)) == null) {
                return null;
            }
            return pkg.getEClassifier((String)names.get(names.size() - 1));
        }
        if (this.defaultPackage != null) {
            String name = (String)names.get(0);
            EClassifier result = null;
            while (currPkg != null) {
                result = currPkg.getEClassifier(name);
                if (result != null) {
                    return result;
                }
                currPkg = currPkg.getESuperPackage();
            }
        }
        return null;
    }

    public void setSelfVariable(Variable var) {
        this.selfVariable = var;
    }

    public Variable getSelfVariable() {
        Variable result = this.selfVariable;
        if (result == null && this.getParent() != null) {
            result = this.getParent().getSelfVariable();
        }
        return result;
    }

    public boolean addElement(String name, Variable elem, boolean exp) {
        if (name == null) {
            name = this.generateName();
            while (this.lookup(name) != null) {
                name = this.generateName();
            }
        } else if (this.lookup(name) != null) {
            return false;
        }
        elem.setName(name);
        VariableEntry newelem = new VariableEntry(name, elem, exp);
        this.namedElements.add(newelem);
        this.resource.getContents().add((Object)elem);
        return true;
    }

    public void deleteElement(String name) {
        Iterator iter = this.namedElements.iterator();
        while (iter.hasNext()) {
            VariableEntry elem = (VariableEntry)iter.next();
            if (!elem.name.equals(name)) continue;
            iter.remove();
            this.resource.getContents().remove((Object)elem.variable);
        }
    }

    public Collection getVariables() {
        ArrayList<Variable> result = new ArrayList<Variable>();
        int i = 0;
        while (i < this.namedElements.size()) {
            VariableEntry elem = (VariableEntry)this.namedElements.get(i);
            if (elem.isExplicit) {
                result.add(elem.variable);
            }
            ++i;
        }
        if (this.getParent() != null) {
            result.addAll(this.getParent().getVariables());
        }
        return result;
    }

    public EOperation lookupOperation(EClassifier owner, String name, EList args) {
        return TypeUtil.findOperationMatching(owner, name, args);
    }

    public EClass lookupSignal(EClassifier owner, String name, EList args) {
        return TypeUtil.findSignalMatching(owner, this.getSignals(owner), name, args);
    }

    public EList getSignals(EClassifier owner) {
        return ECollections.EMPTY_ELIST;
    }

    public EStructuralFeature lookupProperty(EClassifier owner, String name) {
        EClass ownerClass = null;
        if (owner != null && owner instanceof EClass) {
            ownerClass = (EClass)owner;
        }
        if (ownerClass == null) {
            Variable vdcl = this.lookupImplicitSourceForProperty(name);
            if (vdcl == null) {
                return null;
            }
            ownerClass = (EClass)vdcl.getType();
        }
        EList properties = TypeUtil.getProperties(ownerClass);
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            EStructuralFeature next = (EStructuralFeature)iter.next();
            if (!name.equals(next.getName())) continue;
            return next;
        }
        return null;
    }

    public EClass lookupAssociationClassReference(EClassifier parentClassifier, String name) {
        EClass owner = null;
        if (parentClassifier != null && parentClassifier instanceof EClass) {
            owner = (EClass)parentClassifier;
        } else if (parentClassifier != null) {
            owner = parentClassifier.eClass();
        }
        if (owner == null) {
            Variable vdcl = this.lookupImplicitSourceForAssociationClass(name);
            if (vdcl == null) {
                return null;
            }
            owner = (EClass)vdcl.getType();
        }
        EClass result = null;
        EList properties = owner.getEAllReferences();
        Iterator iter = properties.iterator();
        while (result == null && iter.hasNext()) {
            EReference next = (EReference)iter.next();
            EClass assocClass = this.getAssociationClass(next);
            if (assocClass == null || !name.equals(EcoreEnvironment.initialLower((ENamedElement)assocClass))) continue;
            result = assocClass;
        }
        return result;
    }

    public static String initialLower(ENamedElement elem) {
        StringBuffer result = new StringBuffer(elem.getName());
        if (result.length() > 0) {
            UTF16.setCharAt((StringBuffer)result, (int)0, (int)UCharacter.toLowerCase((int)UTF16.charAt((StringBuffer)result, (int)0)));
        }
        return result.toString();
    }

    public EList getStates(EClassifier owner, List pathPrefix) {
        if (owner == null) {
            Variable vdcl;
            int i = this.namedElements.size() - 1;
            while (i >= 0) {
                VariableEntry element = (VariableEntry)this.namedElements.get(i);
                vdcl = element.variable;
                if (vdcl.getType() instanceof EClass) {
                    return this.getStates(vdcl.getType(), pathPrefix);
                }
                --i;
            }
            vdcl = this.getSelfVariable();
            if (vdcl != null && vdcl.getType() instanceof EClass) {
                return this.getStates(vdcl.getType(), pathPrefix);
            }
        } else {
            BasicEList result = new BasicEList();
            this.collectStates(owner, pathPrefix, (List)result);
            if (owner instanceof EClass) {
                Iterator iter = ((EClass)owner).getEAllSuperTypes().iterator();
                while (iter.hasNext()) {
                    this.collectStates((EClassifier)((EClass)iter.next()), pathPrefix, (List)result);
                }
            }
            return result;
        }
        return ECollections.EMPTY_ELIST;
    }

    protected void collectStates(EClassifier owner, List pathPrefix, List states) {
    }

    public String getStateName(EObject state) {
        return null;
    }

    public Variable lookupImplicitSourceForProperty(String name) {
        EStructuralFeature property;
        Variable vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            EStructuralFeature property2;
            VariableEntry element = (VariableEntry)this.namedElements.get(i);
            vdcl = element.variable;
            if (vdcl.getType() instanceof EClass && (property2 = this.lookupProperty(vdcl.getType(), name)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && vdcl.getType() instanceof EClass && (property = this.lookupProperty(vdcl.getType(), name)) != null) {
            return vdcl;
        }
        return null;
    }

    public Variable lookupImplicitSourceForAssociationClass(String name) {
        EClass ac;
        Variable vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            EClass ac2;
            VariableEntry element = (VariableEntry)this.namedElements.get(i);
            vdcl = element.variable;
            if (vdcl.getType() instanceof EClass && (ac2 = this.lookupAssociationClassReference(vdcl.getType(), name)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && vdcl.getType() instanceof EClass && (ac = this.lookupAssociationClassReference(vdcl.getType(), name)) != null) {
            return vdcl;
        }
        return null;
    }

    public static EPackage findPackage(List packageNames) {
        return EcoreEnvironment.findPackage(packageNames, EPackage.Registry.INSTANCE);
    }

    public static EPackage findPackage(List packageNames, EPackage.Registry registry) {
        if (packageNames.isEmpty()) {
            return null;
        }
        String name = (String)packageNames.get(0);
        Iterator iter = registry.values().iterator();
        while (iter.hasNext()) {
            EPackage tentativeResult;
            EPackage ePackage;
            Object next = iter.next();
            if (!(next instanceof EPackage) || (ePackage = (EPackage)next).getESuperPackage() != null || !name.equals(ePackage.getName()) || (tentativeResult = EcoreEnvironment.findNestedPackage(packageNames.subList(1, packageNames.size()), ePackage)) == null) continue;
            return tentativeResult;
        }
        return EcoreEnvironment.findPackageByNSPrefix(packageNames, registry);
    }

    private static EPackage findNestedPackage(List packageNames, EPackage superpackage) {
        if (packageNames.isEmpty()) {
            return superpackage;
        }
        String name = (String)packageNames.get(0);
        Iterator iter = superpackage.getESubpackages().iterator();
        while (iter.hasNext()) {
            EPackage tentativeResult;
            EPackage next = (EPackage)iter.next();
            if (!name.equals(next.getName()) || (tentativeResult = EcoreEnvironment.findNestedPackage(packageNames.subList(1, packageNames.size()), next)) == null) continue;
            return tentativeResult;
        }
        return null;
    }

    private static EPackage findPackageByNSPrefix(List packageNames, EPackage.Registry registry) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator it = packageNames.iterator();
        while (it.hasNext()) {
            stringBuffer.append(it.next());
            if (!it.hasNext()) continue;
            stringBuffer.append(".");
        }
        String nsPrefix = stringBuffer.toString();
        Iterator iter = registry.values().iterator();
        while (iter.hasNext()) {
            EPackage ePackage;
            Object next = iter.next();
            if (!(next instanceof EPackage) || !nsPrefix.equals((ePackage = (EPackage)next).getNsPrefix())) continue;
            return ePackage;
        }
        return null;
    }

    public Variable lookupImplicitSourceForOperation(String name, EList params) throws SemanticException {
        EOperation eop;
        Variable vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            EOperation eop2;
            VariableEntry element = (VariableEntry)this.namedElements.get(i);
            vdcl = element.variable;
            if (vdcl.getType() instanceof EClass && (eop2 = TypeUtil.findOperationMatching(vdcl.getType(), name, params)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && vdcl.getType() instanceof EClass && (eop = TypeUtil.findOperationMatching(vdcl.getType(), name, params)) != null) {
            return vdcl;
        }
        String errMessage = String.valueOf(name) + "(";
        int i2 = 0;
        while (i2 < params.size()) {
            if (i2 > 0) {
                errMessage = String.valueOf(errMessage) + ", ";
            }
            errMessage = String.valueOf(errMessage) + ((OCLExpression)params.get(i2)).getType().getName();
            ++i2;
        }
        errMessage = String.valueOf(errMessage) + ")";
        String message = OCLMessages.bind(OCLMessages.IllegalSignature_ERROR_, errMessage);
        OCLParser.ERR(message);
        return null;
    }

    public String getDescription(ENamedElement namedElement) {
        if (namedElement instanceof ETypedElement) {
            return ((ETypedElement)namedElement).getEType().getName();
        }
        if (namedElement instanceof EEnumLiteral) {
            return ((EEnumLiteral)namedElement).getEEnum().getName();
        }
        if (namedElement == null) {
            return null;
        }
        return namedElement.eClass().getName();
    }

    public boolean isQuery(EOperation operation) {
        return UMLTypeUtil.isQuery(operation);
    }

    public boolean isAssociationClass(EClass eclass) {
        return UMLTypeUtil.isAssociationClass((EClassifier)eclass);
    }

    public EClass getAssociationClass(EReference reference) {
        return UMLTypeUtil.getAssociationClass(reference);
    }

    public EList getMemberEnds(EClass associationClass) {
        return UMLTypeUtil.getMemberEnds(associationClass);
    }

    public EList getQualifiers(EStructuralFeature property) {
        return UMLTypeUtil.getQualifiers(property);
    }

    private static final class VariableEntry {
        final String name;
        final Variable variable;
        final boolean isExplicit;

        VariableEntry(String name, Variable variable, boolean isExplicit) {
            this.name = name;
            this.variable = variable;
            this.isExplicit = isExplicit;
        }
    }
}

