/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.parser.TypeResolver;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.MessageType;
import org.eclipse.emf.ocl.types.TupleType;
import org.eclipse.emf.ocl.types.TypeType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.impl.TypeTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.TypesSwitch;
import org.eclipse.emf.ocl.uml.TypedElement;
import org.eclipse.emf.ocl.utilities.impl.TupleFactory;

public class TypeResolverImpl
implements TypeResolver {
    private final TypesSwitch resolveSwitch = new ResolveSwitch();
    private Resource resource;
    private EPackage collectionPackage;
    private EPackage tuplePackage;
    private EPackage typePackage;
    private EPackage messagePackage;
    private EPackage additionalFeaturesPackage;

    public TypeResolverImpl() {
    }

    public TypeResolverImpl(Resource resource) {
        this.resource = resource;
    }

    public EClassifier resolve(EClassifier type) {
        return type == null ? type : (EClassifier)this.resolveSwitch.doSwitch((EObject)type);
    }

    public Resource getResource() {
        if (this.resource == null) {
            this.resource = this.createResource();
        }
        return this.resource;
    }

    protected Resource createResource() {
        ResourceImpl result = new ResourceImpl(){

            public EObject getEObject(String uriFragment) {
                return super.getEObject(URI.decode((String)uriFragment));
            }
        };
        result.setURI(URI.createURI((String)"ocltypes:///"));
        return result;
    }

    public EPackage getCollectionPackage() {
        if (this.collectionPackage == null) {
            this.collectionPackage = this.createCollectionPackage();
        }
        return this.collectionPackage;
    }

    protected EPackage createCollectionPackage() {
        EncodingPackage result = new EncodingPackage();
        result.setName("collections");
        this.getResource().getContents().add((Object)result);
        return result;
    }

    public CollectionType resolveCollectionType(CollectionKind kind, EClassifier elementType) {
        CollectionType result = this.findCollectionType(kind, elementType);
        if (result == null) {
            result = this.createCollectionType(kind, elementType);
        }
        return result;
    }

    protected CollectionType createCollectionType(CollectionKind kind, EClassifier elementType) {
        CollectionType result = TypesFactory.eINSTANCE.createCollectionType(kind, elementType);
        this.getCollectionPackage().getEClassifiers().add((Object)result);
        return result;
    }

    protected CollectionType findCollectionType(CollectionKind kind, EClassifier elementType) {
        Iterator iter = this.getCollectionPackage().getEClassifiers().iterator();
        while (iter.hasNext()) {
            CollectionType type = (CollectionType)iter.next();
            if (type.getKind() != kind || TypeUtil.getRelationship(type.getElementType(), elementType) != 1) continue;
            return type;
        }
        return null;
    }

    public EPackage getTuplePackage() {
        if (this.tuplePackage == null) {
            this.tuplePackage = this.createTuplePackage();
        }
        return this.tuplePackage;
    }

    protected EPackage createTuplePackage() {
        EncodingPackage result = new EncodingPackage();
        result.setName("tuples");
        result.setEFactoryInstance((EFactory)new TupleFactory());
        this.getResource().getContents().add((Object)result);
        return result;
    }

    public TupleType resolveTupleType(List parts) {
        TupleType result = this.findTupleType(parts);
        if (result == null) {
            result = this.createTupleType(parts);
        }
        return result;
    }

    protected TupleType createTupleType(List parts) {
        TupleType result = TypesFactory.eINSTANCE.createTupleType(parts);
        this.getTuplePackage().getEClassifiers().add((Object)result);
        return result;
    }

    protected TupleType findTupleType(List parts) {
        Iterator iter = this.getTuplePackage().getEClassifiers().iterator();
        while (iter.hasNext()) {
            TupleType type = (TupleType)iter.next();
            if (type.getEStructuralFeatures().size() != parts.size()) continue;
            Iterator jter = parts.iterator();
            while (jter.hasNext()) {
                TypedElement part = (TypedElement)jter.next();
                EStructuralFeature property = type.getEStructuralFeature(part.getName());
                if (property == null || TypeUtil.getRelationship(property.getEType(), part.getType()) != 1) break;
            }
            return type;
        }
        return null;
    }

    public EPackage getTypePackage() {
        if (this.typePackage == null) {
            this.typePackage = this.createTypePackage();
        }
        return this.typePackage;
    }

    protected EPackage createTypePackage() {
        EncodingPackage result = new EncodingPackage();
        result.setName("types");
        this.getResource().getContents().add((Object)result);
        return result;
    }

    public TypeType resolveTypeType(EClassifier type) {
        TypeType result = this.findTypeType(type);
        if (result == null) {
            result = this.createTypeType(type);
        }
        return result;
    }

    protected TypeType createTypeType(EClassifier type) {
        TypeType result = TypesFactory.eINSTANCE.createTypeType(type);
        this.getTypePackage().getEClassifiers().add((Object)result);
        return result;
    }

    protected TypeType findTypeType(EClassifier type) {
        Iterator iter = this.getTypePackage().getEClassifiers().iterator();
        while (iter.hasNext()) {
            TypeTypeImpl typeType = (TypeTypeImpl)iter.next();
            if (TypeUtil.getRelationship(typeType.getReferredType(), type) != 1) continue;
            return typeType;
        }
        return null;
    }

    public EPackage getMessagePackage() {
        if (this.messagePackage == null) {
            this.messagePackage = this.createMessagePackage();
        }
        return this.messagePackage;
    }

    protected EPackage createMessagePackage() {
        EncodingPackage result = new EncodingPackage();
        result.setName("messages");
        this.getResource().getContents().add((Object)result);
        return result;
    }

    public MessageType resolveMessageType(EOperation operation) {
        MessageType result = this.findMessageType((ENamedElement)operation);
        if (result == null) {
            result = this.createMessageType((ENamedElement)operation);
        }
        return result;
    }

    public MessageType resolveMessageType(EClass signal) {
        MessageType result = this.findMessageType((ENamedElement)signal);
        if (result == null) {
            result = this.createMessageType((ENamedElement)signal);
        }
        return result;
    }

    protected MessageType createMessageType(ENamedElement element) {
        MessageType result = TypesFactory.eINSTANCE.createMessageType(element);
        this.getMessagePackage().getEClassifiers().add((Object)result);
        return result;
    }

    protected MessageType findMessageType(ENamedElement element) {
        Iterator iter = this.getMessagePackage().getEClassifiers().iterator();
        while (iter.hasNext()) {
            MessageType type = (MessageType)iter.next();
            if (type.getReferredOperation() != element && type.getReferredSignal() != element) continue;
            return type;
        }
        return null;
    }

    public EPackage getAdditionalFeaturesPackage() {
        if (this.additionalFeaturesPackage == null) {
            this.additionalFeaturesPackage = this.createAdditionalFeaturesPackage();
        }
        return this.additionalFeaturesPackage;
    }

    protected EPackage createAdditionalFeaturesPackage() {
        EncodingPackage result = new EncodingPackage();
        result.setName("additional");
        this.getResource().getContents().add((Object)result);
        return result;
    }

    public EOperation resolveAdditionalOperation(EClassifier owner, EOperation operation) {
        EOperation result;
        EClass shadow = this.findShadowClass(owner);
        if (shadow == null) {
            shadow = this.createShadowClass(owner);
        }
        if ((result = this.findMatchingOperation(shadow, operation)) == null) {
            result = operation;
            shadow.getEOperations().add((Object)result);
        }
        return result;
    }

    protected EOperation findMatchingOperation(EClass shadow, EOperation operation) {
        Iterator iter = shadow.getEOperations().iterator();
        while (iter.hasNext()) {
            EOperation next = (EOperation)iter.next();
            if (next != operation && (!next.getName().equals(operation.getName()) || !this.matchParameters(next, operation))) continue;
            return next;
        }
        return null;
    }

    private boolean matchParameters(EOperation a, EOperation b) {
        EList aparms = a.getEParameters();
        EList bparms = b.getEParameters();
        if (aparms.size() == bparms.size()) {
            int count = aparms.size();
            int i = 0;
            while (i < count) {
                EParameter aparm = (EParameter)aparms.get(i);
                EParameter bparm = (EParameter)bparms.get(i);
                if (!aparm.getName().equals(bparm.getName()) || TypeUtil.getRelationship(aparm.getEType(), bparm.getEType()) != 1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected EStructuralFeature findMatchingProperty(EClass shadow, EStructuralFeature property) {
        Iterator iter = shadow.getEStructuralFeatures().iterator();
        while (iter.hasNext()) {
            EStructuralFeature next = (EStructuralFeature)iter.next();
            if (next != property && !next.getName().equals(property.getName())) continue;
            return next;
        }
        return null;
    }

    public EStructuralFeature resolveAdditionalProperty(EClassifier owner, EStructuralFeature property) {
        EStructuralFeature result;
        EClass shadow = this.findShadowClass(owner);
        if (shadow == null) {
            shadow = this.createShadowClass(owner);
        }
        if ((result = this.findMatchingProperty(shadow, property)) == null) {
            result = property;
            shadow.getEStructuralFeatures().add((Object)result);
        }
        return result;
    }

    protected EClass createShadowClass(EClassifier type) {
        EClassImpl result = new EClassImpl(){

            public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
                String result = super.eURIFragmentSegment(eStructuralFeature, eObject);
                return URI.encodeFragment((String)result, (boolean)false);
            }
        };
        result.setName(String.valueOf(type.getName()) + "_Class");
        EAnnotation ann = EcoreFactory.eINSTANCE.createEAnnotation();
        ann.setSource("realOwner");
        ann.getReferences().add((Object)type);
        result.getEAnnotations().add((Object)ann);
        this.getAdditionalFeaturesPackage().getEClassifiers().add((Object)result);
        return result;
    }

    protected EClass findShadowClass(EClassifier type) {
        Iterator iter = this.getAdditionalFeaturesPackage().getEClassifiers().iterator();
        while (iter.hasNext()) {
            EClass next = (EClass)iter.next();
            EAnnotation ann = next.getEAnnotation("realOwner");
            if (ann == null || !ann.getReferences().contains((Object)type)) continue;
            return next;
        }
        return null;
    }

    private class ResolveSwitch
    extends TypesSwitch {
        private ResolveSwitch() {
        }

        public Object caseCollectionType(CollectionType object) {
            return TypeResolverImpl.this.resolveCollectionType(object.getKind(), TypeResolverImpl.this.resolve(object.getElementType()));
        }

        public Object caseTupleType(TupleType object) {
            return TypeResolverImpl.this.resolveTupleType(this.createTupleParts((Collection)object.getEStructuralFeatures()));
        }

        public Object caseTypeType(TypeType object) {
            return TypeResolverImpl.this.resolveTypeType(TypeResolverImpl.this.resolve(((TypeTypeImpl)object).getReferredType()));
        }

        public Object caseMessageType(MessageType object) {
            if (object.getReferredOperation() != null) {
                return TypeResolverImpl.this.resolveMessageType(object.getReferredOperation());
            }
            if (object.getReferredSignal() != null) {
                return TypeResolverImpl.this.resolveMessageType(object.getReferredSignal());
            }
            return null;
        }

        public Object defaultCase(EObject object) {
            return object;
        }

        private List createTupleParts(Collection features) {
            ArrayList<Variable> result = new ArrayList<Variable>();
            Iterator iter = features.iterator();
            while (iter.hasNext()) {
                EStructuralFeature next = (EStructuralFeature)iter.next();
                Variable v = ExpressionsFactory.eINSTANCE.createVariable();
                v.setName(next.getName());
                v.setType(TypeResolverImpl.this.resolve(next.getEType()));
                result.add(v);
            }
            return result;
        }
    }

    private static class EncodingPackage
    extends EPackageImpl {
        private EncodingPackage() {
        }

        public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
            String result = super.eURIFragmentSegment(eStructuralFeature, eObject);
            return URI.encodeFragment((String)result, (boolean)false);
        }
    }
}

