/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ocl.internal.l10n.OCLMessages;
import org.eclipse.emf.ocl.internal.parser.OCLParser;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.MessageType;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;

public class MessageTypeImpl
extends EClassImpl
implements MessageType {
    public static final String copyright = "";
    public static final MessageType INSTANCE = new MessageTypeImpl("OclMessage");
    protected EClass referredSignal = null;
    protected EOperation referredOperation = null;
    private static EList operations = null;

    protected static EList createOperations() {
        if (operations == null) {
            operations = new BasicEList();
            operations.add((Object)TypeUtil.createUnaryOperation((EClassifier)Types.OCL_BOOLEAN, "hasReturned"));
            operations.add((Object)TypeUtil.createUnaryOperation(AnyTypeImpl.OCL_T, "result"));
            operations.add((Object)TypeUtil.createUnaryOperation((EClassifier)Types.OCL_BOOLEAN, "isSignalSent"));
            operations.add((Object)TypeUtil.createUnaryOperation((EClassifier)Types.OCL_BOOLEAN, "isOperationCall"));
            operations.addAll((Collection)AnyTypeImpl.createAnyOperations());
        }
        return operations;
    }

    protected MessageTypeImpl() {
    }

    protected MessageTypeImpl(String name) {
        this();
        this.setName(name);
    }

    public String getName() {
        if (this.name == null) {
            EOperation elem = this.getReferredOperation() != null ? this.getReferredOperation() : this.getReferredSignal();
            this.name = elem == null ? "OclMessage(?)" : "OclMessage(" + elem.getName() + ')';
        }
        return super.getName();
    }

    protected static MessageType createMessageType(ENamedElement behavioralFeature) {
        EList typedElements;
        MessageTypeImpl result = new MessageTypeImpl();
        EList properties = result.getEStructuralFeatures();
        if (behavioralFeature instanceof EOperation) {
            EOperation operation = (EOperation)behavioralFeature;
            result.setReferredOperation(operation);
            typedElements = operation.getEParameters();
        } else if (behavioralFeature instanceof EClass) {
            EClass signal = (EClass)behavioralFeature;
            result.setReferredSignal(signal);
            typedElements = signal.getEAllStructuralFeatures();
        } else {
            typedElements = ECollections.EMPTY_ELIST;
        }
        Iterator iter = typedElements.iterator();
        while (iter.hasNext()) {
            ETypedElement next = (ETypedElement)iter.next();
            properties.add((Object)TypeUtil.createProperty(next));
        }
        return result;
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.MESSAGE_TYPE;
    }

    public EClass getReferredSignal() {
        if (this.referredSignal != null && this.referredSignal.eIsProxy()) {
            InternalEObject oldReferredSignal = (InternalEObject)this.referredSignal;
            this.referredSignal = (EClass)this.eResolveProxy(oldReferredSignal);
            if (this.referredSignal != oldReferredSignal && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 21, (Object)oldReferredSignal, (Object)this.referredSignal));
            }
        }
        return this.referredSignal;
    }

    public EClass basicGetReferredSignal() {
        return this.referredSignal;
    }

    public void setReferredSignal(EClass newReferredSignal) {
        EClass oldReferredSignal = this.referredSignal;
        this.referredSignal = newReferredSignal;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, (Object)oldReferredSignal, (Object)this.referredSignal));
        }
    }

    public EList getOperations() {
        if (operations == null) {
            return MessageTypeImpl.createOperations();
        }
        return operations;
    }

    public String getOperationNameFor(int opcode) {
        switch (opcode) {
            case 100: {
                return "hasReturned";
            }
            case 101: {
                return "result";
            }
            case 102: {
                return "isSignalSent";
            }
            case 103: {
                return "isOperationCall";
            }
        }
        return AnyTypeImpl.getOperationName(opcode);
    }

    public int getOperationCodeFor(String operName) {
        if ("hasReturned".equals(operName)) {
            return 100;
        }
        if ("result".equals(operName)) {
            return 101;
        }
        if ("isSignalSent".equals(operName)) {
            return 102;
        }
        if ("isOperationCall".equals(operName)) {
            return 103;
        }
        return AnyTypeImpl.getOperationCode(operName);
    }

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        switch (opcode) {
            case 100: 
            case 102: 
            case 103: {
                return Types.OCL_BOOLEAN;
            }
            case 101: {
                return this.getReferredOperation() == null ? Types.INVALID : this.getReferredOperation().getEType();
            }
        }
        return AnyTypeImpl.getResultType(ownerType, opcode, args);
    }

    public int getRelationshipTo(EClassifier type) {
        if (this == type) {
            return 1;
        }
        if (type instanceof MessageType) {
            MessageType other = (MessageType)type;
            if (this.getReferredOperation() != null && this.getReferredOperation() == other.getReferredOperation()) {
                return 1;
            }
            if (this.getReferredSignal() != null && this.getReferredSignal() == other.getReferredSignal()) {
                return 1;
            }
            if (this == Types.OCL_MESSAGE) {
                return 4;
            }
        }
        if (type == Types.OCL_MESSAGE) {
            return 2;
        }
        return 8;
    }

    public EClassifier getCommonSupertype(EClassifier type) throws SemanticException {
        if (this == type) {
            return this;
        }
        if (type instanceof MessageType) {
            return Types.OCL_MESSAGE;
        }
        String message = OCLMessages.bind(OCLMessages.TypeMismatch_ERROR_, this.getName(), TypeUtil.getName((ENamedElement)type));
        OCLParser.ERR(message);
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 20: {
                if (resolve) {
                    return this.getReferredOperation();
                }
                return this.basicGetReferredOperation();
            }
            case 21: {
                if (resolve) {
                    return this.getReferredSignal();
                }
                return this.basicGetReferredSignal();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 20: {
                this.setReferredOperation((EOperation)newValue);
                return;
            }
            case 21: {
                this.setReferredSignal((EClass)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 20: {
                this.setReferredOperation(null);
                return;
            }
            case 21: {
                this.setReferredSignal(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 20: {
                return this.referredOperation != null;
            }
            case 21: {
                return this.referredSignal != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public EOperation getReferredOperation() {
        if (this.referredOperation != null && this.referredOperation.eIsProxy()) {
            InternalEObject oldReferredOperation = (InternalEObject)this.referredOperation;
            this.referredOperation = (EOperation)this.eResolveProxy(oldReferredOperation);
            if (this.referredOperation != oldReferredOperation && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 20, (Object)oldReferredOperation, (Object)this.referredOperation));
            }
        }
        return this.referredOperation;
    }

    public EOperation basicGetReferredOperation() {
        return this.referredOperation;
    }

    public void setReferredOperation(EOperation newReferredOperation) {
        EOperation oldReferredOperation = this.referredOperation;
        this.referredOperation = newReferredOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldReferredOperation, (Object)this.referredOperation));
        }
    }
}

