/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.OrderedSetType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.SetTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;

public class OrderedSetTypeImpl
extends CollectionTypeImpl
implements OrderedSetType {
    public static final String copyright = "";
    private static EList operations;
    private static EList iterators;
    private SetTypeImpl supertype;
    static /* synthetic */ Class class$0;

    protected OrderedSetTypeImpl() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.LinkedHashSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setInstanceClass(clazz);
        this.setClassifierID(6);
        this.supertype = new SetTypeImpl();
    }

    protected OrderedSetTypeImpl(EClassifier elementType) {
        this.elementType = elementType;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.LinkedHashSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setInstanceClass(clazz);
        this.setClassifierID(6);
        this.supertype = new SetTypeImpl(elementType);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.elementType != null ? "OrderedSet(" + this.elementType.getName() + ')' : "OrderedSet(?)";
        }
        return super.getName();
    }

    public CollectionKind getKind() {
        return CollectionKind.ORDERED_SET_LITERAL;
    }

    public void setElementType(EClassifier newElementType) {
        super.setElementType(newElementType);
        this.supertype.setElementType(newElementType);
    }

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        EClassifier elemType = this.getElementType();
        switch (opcode) {
            case 60: 
            case 61: {
                return Types.OCL_BOOLEAN;
            }
            case 160: {
                return Types.OCL_INTEGER;
            }
            case 163: 
            case 165: {
                OCLExpression arg = (OCLExpression)args.get(0);
                EClassifier eArgType = arg.getType();
                OrderedSetType resultType = TypesFactory.eINSTANCE.createOrderedSetType();
                resultType.setElementType(TypeUtil.commonSuperType(elemType, eArgType));
                return resultType;
            }
            case 161: {
                OCLExpression arg = (OCLExpression)args.get(1);
                EClassifier eArgType = arg.getType();
                OrderedSetType resultType = TypesFactory.eINSTANCE.createOrderedSetType();
                resultType.setElementType(TypeUtil.commonSuperType(elemType, eArgType));
                return resultType;
            }
            case 166: {
                return this;
            }
            case 158: 
            case 159: 
            case 162: {
                return elemType;
            }
            case 152: {
                return TypesFactory.eINSTANCE.createSetType(elemType);
            }
            case 149: {
                return TypesFactory.eINSTANCE.createBagType(elemType);
            }
            case 151: {
                return TypesFactory.eINSTANCE.createSequenceType(elemType);
            }
        }
        return this.supertype.getResultTypeFor(ownerType, opcode, args);
    }

    protected static EList createOperations() {
        BasicEList result = new BasicEList();
        result.addAll((Collection)CollectionTypeImpl.createOperations());
        result.addAll((Collection)SetTypeImpl.createSetOperations());
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "=", (EClassifier)OCL_ORDERED_SET, "s"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "<>", (EClassifier)OCL_ORDERED_SET, "s"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_ORDERED_SET, "append", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createBinaryOperation(AnyTypeImpl.OCL_T, "at", (EClassifier)Types.OCL_INTEGER, "index"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_INTEGER, "indexOf", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createTernaryOperation((EClassifier)OCL_ORDERED_SET, "insertAt", (EClassifier)Types.OCL_INTEGER, "index", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_ORDERED_SET, "prepend", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createTernaryOperation((EClassifier)OCL_ORDERED_SET, "subOrderedSet", (EClassifier)Types.OCL_INTEGER, "lower", (EClassifier)Types.OCL_INTEGER, "upper"));
        result.add((Object)TypeUtil.createUnaryOperation(AnyTypeImpl.OCL_T, "first"));
        result.add((Object)TypeUtil.createUnaryOperation(AnyTypeImpl.OCL_T, "last"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_BAG, "asBag"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_SET, "asSet"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_SEQUENCE, "asSequence"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_ORDERED_SET, "asOrderedSet"));
        return result;
    }

    public EList getOperations() {
        if (operations == null) {
            operations = OrderedSetTypeImpl.createOperations();
        }
        return operations;
    }

    public EList getIterators() {
        if (iterators == null) {
            iterators = SetTypeImpl.createIterators();
        }
        return iterators;
    }

    protected EClass eStaticClass() {
        return TypesPackage.eINSTANCE.getOrderedSetType();
    }
}

