/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.ExpressionsPackage;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.SequenceType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;

public class SequenceTypeImpl
extends CollectionTypeImpl
implements SequenceType {
    public static final String copyright = "";
    private static EList operations;
    private static EList iterators;
    static /* synthetic */ Class class$0;

    protected SequenceTypeImpl() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setInstanceClass(clazz);
        this.setClassifierID(12);
    }

    protected SequenceTypeImpl(EClassifier elementType) {
        this.elementType = elementType;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setInstanceClass(clazz);
        this.setClassifierID(12);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.elementType != null ? "Sequence(" + this.elementType.getName() + ')' : "Sequence(?)";
        }
        return super.getName();
    }

    public CollectionKind getKind() {
        return CollectionKind.SEQUENCE_LITERAL;
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.SEQUENCE_TYPE;
    }

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        EClassifier elemType = this.getElementType();
        switch (opcode) {
            case 140: 
            case 160: {
                return Types.OCL_INTEGER;
            }
            case 60: 
            case 61: {
                return Types.OCL_BOOLEAN;
            }
            case 157: {
                OCLExpression arg = (OCLExpression)args.get(0);
                CollectionType argType = (CollectionType)arg.getType();
                EClassifier argElementType = argType.getElementType();
                SequenceType resultType = TypesFactory.eINSTANCE.createSequenceType();
                resultType.setElementType(TypeUtil.commonSuperType(elemType, argElementType));
                return resultType;
            }
            case 155: 
            case 163: 
            case 165: {
                OCLExpression arg = (OCLExpression)args.get(0);
                EClassifier eArgType = arg.getType();
                SequenceType resultType = TypesFactory.eINSTANCE.createSequenceType();
                resultType.setElementType(TypeUtil.commonSuperType(elemType, eArgType));
                return resultType;
            }
            case 161: {
                OCLExpression arg = (OCLExpression)args.get(1);
                EClassifier eArgType = arg.getType();
                SequenceType resultType = TypesFactory.eINSTANCE.createSequenceType();
                resultType.setElementType(TypeUtil.commonSuperType(elemType, eArgType));
                return resultType;
            }
            case 153: {
                return this;
            }
            case 154: {
                if (!(elemType instanceof CollectionType)) {
                    return this;
                }
                SequenceType resultType = TypesFactory.eINSTANCE.createSequenceType();
                resultType.setElementType(((CollectionType)elemType).getElementType());
                return resultType;
            }
            case 158: 
            case 159: 
            case 162: {
                return elemType;
            }
            case 149: {
                return TypesFactory.eINSTANCE.createBagType(elemType);
            }
            case 151: 
            case 164: {
                return this;
            }
            case 152: {
                return TypesFactory.eINSTANCE.createSetType(elemType);
            }
            case 150: {
                return TypesFactory.eINSTANCE.createOrderedSetType(elemType);
            }
            case 209: 
            case 210: {
                return this;
            }
            case 211: {
                return TypesFactory.eINSTANCE.createSequenceType(this.getElementType());
            }
            case 207: {
                return TypesFactory.eINSTANCE.createSequenceType(AnyTypeImpl.OCL_T2);
            }
        }
        return super.getResultTypeFor(ownerType, opcode, args);
    }

    protected static EList createOperations() {
        BasicEList result = new BasicEList();
        result.addAll((Collection)CollectionTypeImpl.createOperations());
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "=", (EClassifier)OCL_SEQUENCE, "s"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "<>", (EClassifier)OCL_SEQUENCE, "s"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_SEQUENCE, "union", (EClassifier)OCL_SEQUENCE, "s"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_SEQUENCE, "append", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_SEQUENCE, "prepend", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createTernaryOperation((EClassifier)OCL_SEQUENCE, "insertAt", (EClassifier)Types.OCL_INTEGER, "index", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createTernaryOperation((EClassifier)OCL_SEQUENCE, "subSequence", (EClassifier)Types.OCL_INTEGER, "lower", (EClassifier)Types.OCL_INTEGER, "upper"));
        result.add((Object)TypeUtil.createBinaryOperation(AnyTypeImpl.OCL_T, "at", (EClassifier)Types.OCL_INTEGER, "index"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_INTEGER, "indexOf", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_SEQUENCE, "including", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)OCL_SEQUENCE, "excluding", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createUnaryOperation(AnyTypeImpl.OCL_T, "first"));
        result.add((Object)TypeUtil.createUnaryOperation(AnyTypeImpl.OCL_T, "last"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)new SequenceTypeImpl(AnyTypeImpl.OCL_T2), "flatten"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_BAG, "asBag"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_SET, "asSet"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_SEQUENCE, "asSequence"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)OCL_ORDERED_SET, "asOrderedSet"));
        return result;
    }

    protected static EList createIterators() {
        BasicEList result = new BasicEList();
        result.addAll((Collection)CollectionTypeImpl.createIterators());
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)CollectionTypeImpl.OCL_SEQUENCE, "select", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)CollectionTypeImpl.OCL_SEQUENCE, "reject", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)CollectionTypeImpl.OCL_SEQUENCE, "sortedBy", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)TypesFactory.eINSTANCE.createSequenceType(AnyTypeImpl.OCL_T2), "collectNested", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        return result;
    }

    public EList getOperations() {
        if (operations == null) {
            operations = SequenceTypeImpl.createOperations();
        }
        return operations;
    }

    public EList getIterators() {
        if (iterators == null) {
            iterators = SequenceTypeImpl.createIterators();
        }
        return iterators;
    }
}

