/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.ExpressionsPackage;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.BagType;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.SetType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;

public class SetTypeImpl
extends CollectionTypeImpl
implements SetType {
    public static final String copyright = "";
    private static EList operations;
    private static EList iterators;
    static /* synthetic */ Class class$0;

    protected SetTypeImpl() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Set");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setInstanceClass(clazz);
        this.setClassifierID(13);
    }

    protected SetTypeImpl(EClassifier elementType) {
        this.elementType = elementType;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Set");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setInstanceClass(clazz);
        this.setClassifierID(13);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.elementType != null ? "Set(" + this.elementType.getName() + ')' : "Set(?)";
        }
        return super.getName();
    }

    public CollectionKind getKind() {
        return CollectionKind.SET_LITERAL;
    }

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        EClassifier elemType = this.getElementType();
        switch (opcode) {
            case 60: 
            case 61: {
                return Types.OCL_BOOLEAN;
            }
            case 157: {
                OCLExpression arg = (OCLExpression)args.get(0);
                CollectionType argType = (CollectionType)arg.getType();
                EClassifier argElementType = argType.getElementType();
                CollectionType resultType = argType instanceof BagType ? TypesFactory.eINSTANCE.createBagType() : TypesFactory.eINSTANCE.createSetType();
                resultType.setElementType(TypeUtil.commonSuperType(elemType, argElementType));
                return resultType;
            }
            case 2: 
            case 167: {
                OCLExpression arg = (OCLExpression)args.get(0);
                CollectionType argType = (CollectionType)arg.getType();
                EClassifier argElementType = argType.getElementType();
                SetType resultType = TypesFactory.eINSTANCE.createSetType();
                resultType.setElementType(TypeUtil.commonSuperType(elemType, argElementType));
                return resultType;
            }
            case 155: {
                OCLExpression arg = (OCLExpression)args.get(0);
                EClassifier eArgType = arg.getType();
                SetType resultType = TypesFactory.eINSTANCE.createSetType();
                resultType.setElementType(TypeUtil.commonSuperType(elemType, eArgType));
                return resultType;
            }
            case 156: {
                OCLExpression arg = (OCLExpression)args.get(0);
                CollectionType argType = (CollectionType)arg.getType();
                EClassifier argElementType = argType.getElementType();
                SetType resultType = TypesFactory.eINSTANCE.createSetType();
                resultType.setElementType(TypeUtil.commonSuperType(elemType, argElementType));
                return this;
            }
            case 153: {
                return this;
            }
            case 140: {
                return Types.OCL_INTEGER;
            }
            case 154: {
                if (!(elemType instanceof CollectionType)) {
                    return this;
                }
                SetType resultType = TypesFactory.eINSTANCE.createSetType();
                resultType.setElementType(((CollectionType)elemType).getElementType());
                return resultType;
            }
            case 149: {
                return TypesFactory.eINSTANCE.createBagType(elemType);
            }
            case 151: {
                return TypesFactory.eINSTANCE.createSequenceType(elemType);
            }
            case 152: {
                return this;
            }
            case 150: {
                return TypesFactory.eINSTANCE.createOrderedSetType(elemType);
            }
            case 209: 
            case 210: {
                return this;
            }
            case 211: {
                return TypesFactory.eINSTANCE.createOrderedSetType(this.getElementType());
            }
            case 207: {
                return TypesFactory.eINSTANCE.createBagType(AnyTypeImpl.OCL_T2);
            }
        }
        return super.getResultTypeFor(ownerType, opcode, args);
    }

    protected static EList createOperations() {
        BasicEList result = new BasicEList();
        result.addAll((Collection)CollectionTypeImpl.createOperations());
        result.addAll((Collection)SetTypeImpl.createSetOperations());
        return result;
    }

    static List createSetOperations() {
        ArrayList<EOperation> result = new ArrayList<EOperation>();
        result.add(TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "=", (EClassifier)OCL_SET, "set"));
        result.add(TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "<>", (EClassifier)OCL_SET, "set"));
        result.add(TypeUtil.createBinaryOperation((EClassifier)OCL_BAG, "union", (EClassifier)OCL_BAG, "bag"));
        result.add(TypeUtil.createBinaryOperation((EClassifier)OCL_SET, "union", (EClassifier)OCL_SET, "set"));
        result.add(TypeUtil.createBinaryOperation((EClassifier)OCL_SET, "-", (EClassifier)OCL_SET, "set"));
        result.add(TypeUtil.createBinaryOperation((EClassifier)OCL_SET, "intersection", (EClassifier)OCL_BAG, "bag"));
        result.add(TypeUtil.createBinaryOperation((EClassifier)OCL_SET, "intersection", (EClassifier)OCL_SET, "set"));
        result.add(TypeUtil.createBinaryOperation((EClassifier)OCL_SET, "including", AnyTypeImpl.OCL_T, "object"));
        result.add(TypeUtil.createBinaryOperation((EClassifier)OCL_SET, "excluding", AnyTypeImpl.OCL_T, "object"));
        result.add(TypeUtil.createBinaryOperation((EClassifier)OCL_SET, "symmetricDifference", (EClassifier)OCL_SET, "s"));
        result.add(TypeUtil.createUnaryOperation((EClassifier)new SetTypeImpl(AnyTypeImpl.OCL_T2), "flatten"));
        result.add(TypeUtil.createUnaryOperation((EClassifier)OCL_BAG, "asBag"));
        result.add(TypeUtil.createUnaryOperation((EClassifier)OCL_SET, "asSet"));
        result.add(TypeUtil.createUnaryOperation((EClassifier)OCL_SEQUENCE, "asSequence"));
        result.add(TypeUtil.createUnaryOperation((EClassifier)OCL_ORDERED_SET, "asOrderedSet"));
        return result;
    }

    protected static EList createIterators() {
        BasicEList result = new BasicEList();
        result.addAll((Collection)CollectionTypeImpl.createIterators());
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)CollectionTypeImpl.OCL_SET, "select", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)CollectionTypeImpl.OCL_SET, "reject", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)CollectionTypeImpl.OCL_ORDERED_SET, "sortedBy", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)TypesFactory.eINSTANCE.createBagType(AnyTypeImpl.OCL_T2), "collectNested", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        return result;
    }

    public EList getOperations() {
        if (operations == null) {
            operations = SetTypeImpl.createOperations();
        }
        return operations;
    }

    public EList getIterators() {
        if (iterators == null) {
            iterators = SetTypeImpl.createIterators();
        }
        return iterators;
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.SET_TYPE;
    }
}

