/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ocl.internal.l10n.OCLMessages;
import org.eclipse.emf.ocl.internal.parser.OCLParser;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.TupleType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.uml.TypedElement;

public class TupleTypeImpl
extends EClassImpl
implements TupleType {
    public static final String copyright = "";
    static EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
    static EcorePackage ecorePackage = EcorePackage.eINSTANCE;
    static TypesPackage typesPackage = TypesPackage.eINSTANCE;
    static TypesFactory typesFactory = TypesFactory.eINSTANCE;

    protected TupleTypeImpl() {
    }

    protected TupleTypeImpl(List tupleParts) {
        this.setClassifierID(14);
        Iterator iter = tupleParts.iterator();
        while (iter.hasNext()) {
            TypedElement next = (TypedElement)iter.next();
            if (next.getName() == null || next.getType() == null) continue;
            this.getEStructuralFeatures().add((Object)TypeUtil.createProperty(next));
        }
    }

    public String getName() {
        if (this.name == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("Tuple(");
            Iterator iter = this.getEStructuralFeatures().iterator();
            while (iter.hasNext()) {
                EStructuralFeature part = (EStructuralFeature)iter.next();
                buf.append(part.getName());
                buf.append(": ");
                buf.append(TypeUtil.getName((ENamedElement)part.getEType()));
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(')');
            this.name = buf.toString();
        }
        return super.getName();
    }

    public EClassifier getCommonSupertype(EClassifier type) throws SemanticException {
        if (!(type instanceof TupleType)) {
            String message = OCLMessages.bind(OCLMessages.TupleTypeMismatch_ERROR_, this.getName(), TypeUtil.getName((ENamedElement)type));
            OCLParser.ERR(message);
        }
        EList props1 = this.getEStructuralFeatures();
        EList props2 = ((TupleType)type).getEStructuralFeatures();
        if (props1.size() != props2.size()) {
            String message = OCLMessages.bind(OCLMessages.TupleFieldNumMismatch_ERROR_, this.getName(), TypeUtil.getName((ENamedElement)type));
            OCLParser.ERR(message);
        }
        TupleType result = TypesFactory.eINSTANCE.createTupleType();
        TupleTypeImpl resultTuple = (TupleTypeImpl)result;
        resultTuple.setName("TupleType");
        Iterator iter1 = props1.iterator();
        while (iter1.hasNext()) {
            EStructuralFeature prop1 = (EStructuralFeature)iter1.next();
            boolean found = false;
            Iterator iter2 = props2.iterator();
            while (iter2.hasNext()) {
                EStructuralFeature prop2 = (EStructuralFeature)iter2.next();
                if (!prop1.getName().equals(prop2.getName())) continue;
                EClassifier resultElementType = TypeUtil.commonSuperType(prop1.getEType(), prop2.getEType());
                found = true;
                EAttribute attr = ecoreFactory.createEAttribute();
                attr.setName(prop1.getName());
                attr.setEType(resultElementType);
                resultTuple.getEStructuralFeatures().add((Object)attr);
                break;
            }
            if (found) continue;
            String message = OCLMessages.bind(OCLMessages.TupleFieldNotFound_ERROR_, new Object[]{this.getName(), prop1.getName(), type.getName()});
            OCLParser.ERR(message);
        }
        return result;
    }

    public int getRelationshipTo(EClassifier type) {
        if (!(type instanceof TupleType)) {
            return 8;
        }
        EList myProperties = this.getEStructuralFeatures();
        EList otherProperties = ((TupleType)type).getEStructuralFeatures();
        if (myProperties.size() != otherProperties.size()) {
            return 8;
        }
        int result = 1;
        Iterator iter1 = myProperties.iterator();
        while (iter1.hasNext()) {
            EStructuralFeature prop1 = (EStructuralFeature)iter1.next();
            boolean found = false;
            Iterator iter2 = otherProperties.iterator();
            while (iter2.hasNext()) {
                EStructuralFeature prop2 = (EStructuralFeature)iter2.next();
                if (!prop1.getName().equals(prop2.getName())) continue;
                int propResult = TypeUtil.getRelationship(prop1.getEType(), prop2.getEType());
                if (result == 1) {
                    result = propResult;
                } else if (result != propResult) {
                    return 8;
                }
                found = true;
                break;
            }
            if (found) continue;
            return 8;
        }
        return result;
    }

    public EList getOperations() {
        return AnyTypeImpl.createAnyOperations();
    }

    public int getOperationCodeFor(String operName) {
        return AnyTypeImpl.getOperationCode(operName);
    }

    public String getOperationNameFor(int opcode) {
        return AnyTypeImpl.getOperationName(opcode);
    }

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        return AnyTypeImpl.getResultType(ownerType, opcode, args);
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.TUPLE_TYPE;
    }
}

