/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.impl.EClassifierImpl;
import org.eclipse.emf.ocl.internal.l10n.OCLMessages;
import org.eclipse.emf.ocl.internal.parser.OCLParser;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.TypeType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;

public class TypeTypeImpl
extends EClassifierImpl
implements TypeType {
    public static final String copyright = "";
    public static final TypeType INSTANCE = new TypeTypeImpl(AnyTypeImpl.OCL_T, "OclType");
    private EClassifier type;
    private static EList operations = null;

    protected static EList createOperations() {
        if (operations == null) {
            operations = new BasicEList();
            operations.add((Object)TypeUtil.createUnaryOperation((EClassifier)CollectionTypeImpl.OCL_SET, "allInstances"));
            operations.addAll((Collection)AnyTypeImpl.createAnyOperations());
        }
        return operations;
    }

    protected TypeTypeImpl() {
    }

    protected TypeTypeImpl(EClassifier type, String name) {
        this.type = type;
        this.setName(name);
    }

    protected TypeTypeImpl(EClassifier type) {
        this(type, type.getName());
    }

    public static TypeType createType(EClassifier type) {
        return new TypeTypeImpl(type);
    }

    public EClassifier getReferredType() {
        return this.type;
    }

    public int getOperationCodeFor(String operName) {
        if (operName.equals("allInstances")) {
            return 40;
        }
        return AnyTypeImpl.getOperationCode(operName);
    }

    public String getOperationNameFor(int opcode) {
        switch (opcode) {
            case 40: {
                return "allInstances";
            }
        }
        return AnyTypeImpl.getOperationName(opcode);
    }

    public EList getOperations() {
        if (operations == null) {
            return TypeTypeImpl.createOperations();
        }
        return operations;
    }

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        switch (opcode) {
            case 40: {
                return TypesFactory.eINSTANCE.createSetType(this.type);
            }
        }
        return AnyTypeImpl.getResultType(ownerType, opcode, args);
    }

    public int getRelationshipTo(EClassifier type) {
        if (this == type) {
            return 1;
        }
        if (type == Types.OCL_TYPE) {
            return 2;
        }
        if (this == Types.OCL_TYPE && type instanceof TypeType) {
            return 4;
        }
        return 8;
    }

    public EClassifier getCommonSupertype(EClassifier type) throws SemanticException {
        if (this == type) {
            return this;
        }
        if (type instanceof TypeType) {
            return Types.OCL_TYPE;
        }
        String message = OCLMessages.bind(OCLMessages.TypeMismatch_ERROR_, this.getName(), TypeUtil.getName((ENamedElement)type));
        OCLParser.ERR(message);
        return null;
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.TYPE_TYPE;
    }
}

