/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.utilities.impl;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.emf.ocl.internal.OCLPlugin;
import org.eclipse.emf.ocl.internal.l10n.OCLMessages;
import org.eclipse.emf.ocl.utilities.impl.Bag;

public final class Bag
extends AbstractCollection {
    public static Bag EMPTY_BAG = new Bag();
    private Map coll = new HashMap();
    private int size = 0;

    public Bag() {
    }

    public Bag(Collection c) {
        this();
        this.addAll(c);
    }

    public boolean remove(Object o) {
        MutableInteger count = (MutableInteger)this.coll.remove(o);
        if (count != null) {
            this.size -= count.i;
        }
        return count != null;
    }

    public boolean add(Object o) {
        MutableInteger count = (MutableInteger)this.coll.get(o);
        if (count == null) {
            this.coll.put(o, new MutableInteger(1));
        } else {
            ++count.i;
        }
        ++this.size;
        return true;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.coll.clear();
    }

    public boolean equals(Object o) {
        if (o instanceof Bag) {
            Bag b = (Bag)o;
            if (this.size() == b.size()) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    MutableInteger count = (MutableInteger)this.coll.get(obj);
                    MutableInteger otherCount = (MutableInteger)b.coll.get(obj);
                    if (otherCount != null && otherCount.i == count.i) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 37;
        result = 37 * result + this.coll.hashCode();
        result = 37 * result + this.size;
        return result;
    }

    public Iterator iterator() {
        class MyIterator
        implements Iterator {
            private Iterator it;
            private int offset;
            private Object curr;
            final /* synthetic */ Bag this$0;

            public MyIterator(Bag bag) {
                this.this$0 = bag;
                this.it = Bag.access$0(bag).keySet().iterator();
                this.offset = 0;
                this.curr = null;
            }

            public boolean hasNext() {
                if (this.it.hasNext()) {
                    return true;
                }
                MutableInteger count = (MutableInteger)Bag.access$0(this.this$0).get(this.curr);
                return this.curr != null && this.offset < count.i - 1;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                MutableInteger count = (MutableInteger)Bag.access$0(this.this$0).get(this.curr);
                if (count != null && this.offset < count.i - 1) {
                    ++this.offset;
                    return this.curr;
                }
                this.curr = this.it.next();
                this.offset = 0;
                return this.curr;
            }

            public void remove() {
                UnsupportedOperationException error = new UnsupportedOperationException(OCLMessages.RemoveUnsupported_ERROR_);
                OCLPlugin.throwing(this.getClass(), "remove", error);
                throw error;
            }
        }
        return new MyIterator(this);
    }

    public String toString() {
        return this.coll.toString();
    }

    static /* synthetic */ Map access$0(Bag bag) {
        return bag.coll;
    }

    private static class MutableInteger {
        public int i;

        public MutableInteger(int i) {
            this.i = i;
        }

        public String toString() {
            return Integer.toString(this.i);
        }
    }
}

