/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.ocl.conditions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ocl.query.Query;
import org.eclipse.emf.ocl.query.QueryFactory;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.IEStructuralFeatureValueGetter;
import org.eclipse.emf.query.handlers.PruneHandler;
import org.eclipse.emf.query.ocl.internal.OCLPlugin;

public abstract class OCLCondition
extends EObjectCondition {
    private final EClass contextEObjectType;
    private String oclExpressionString;
    private Query oclQuery;
    private IEStructuralFeatureValueGetter eStructuralFeatureValueGetter;
    private Map contextFreeOclQueriesMap;

    protected OCLCondition(String oclExpressionString, EClass contextEObjectType, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter) {
        this(oclExpressionString, contextEObjectType, eStructuralFeatureValueGetter, PruneHandler.NEVER);
    }

    protected OCLCondition(String oclExpressionString, EClass contextEObjectType, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter, PruneHandler pruneHandler) {
        super(pruneHandler);
        this.oclExpressionString = oclExpressionString;
        this.contextEObjectType = contextEObjectType;
        this.eStructuralFeatureValueGetter = eStructuralFeatureValueGetter;
        if (contextEObjectType != null) {
            this.oclQuery = QueryFactory.eINSTANCE.createQuery(oclExpressionString, (EClassifier)contextEObjectType);
        }
    }

    protected OCLCondition(Query oclQuery, EClass contextEObjectType, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter, PruneHandler pruneHandler) {
        super(pruneHandler);
        this.oclQuery = oclQuery;
        this.oclExpressionString = oclQuery.queryText();
        if (contextEObjectType == null) {
            throw new NullPointerException("null contextEObjectType");
        }
        this.contextEObjectType = contextEObjectType;
        this.eStructuralFeatureValueGetter = eStructuralFeatureValueGetter;
    }

    protected final Query getOclQuery() {
        return this.oclQuery;
    }

    public boolean isSatisfied(EObject eObject) {
        if (!this.isContextFree()) {
            return this.getContextEObjectType().isInstance((Object)eObject);
        }
        return this.getOclQueryRecord(eObject.eClass()).hasOclQuery();
    }

    public EClassifier getResultType(EObject eObject) {
        if (!this.isContextFree()) {
            return this.getOclQuery().resultType();
        }
        if (eObject != null) {
            Query query = this.getOclQueryRecord(eObject.eClass()).getCachedOclQuery();
            if (query != null) {
                return query.resultType();
            }
        } else if (!this.getOclQueryRecordMap().isEmpty()) {
            Iterator it = this.getOclQueryRecordMap().values().iterator();
            while (it.hasNext()) {
                Query query = ((OclQueryCacheEntry)it.next()).getCachedOclQuery();
                if (query == null) continue;
                return query.resultType();
            }
        }
        return null;
    }

    private Map getOclQueryRecordMap() {
        if (this.contextFreeOclQueriesMap == null) {
            this.contextFreeOclQueriesMap = new HashMap();
        }
        return this.contextFreeOclQueriesMap;
    }

    private OclQueryCacheEntry getOclQueryRecord(EClass contextEClass) {
        OclQueryCacheEntry oclQueryRecord = (OclQueryCacheEntry)this.getOclQueryRecordMap().get(contextEClass);
        if (oclQueryRecord == null) {
            Query query = null;
            try {
                query = QueryFactory.eINSTANCE.createQuery(this.oclExpressionString, (EClassifier)contextEClass);
            }
            catch (Exception ex) {
                OCLPlugin.catching(((Object)((Object)this)).getClass(), "getOclQueryRecord", ex);
                query = null;
            }
            oclQueryRecord = new OclQueryCacheEntry(contextEClass, query);
            this.getOclQueryRecordMap().put(oclQueryRecord.getContextEClass(), oclQueryRecord);
        }
        this.oclQuery = oclQueryRecord.getCachedOclQuery();
        return oclQueryRecord;
    }

    protected final boolean isContextFree() {
        return this.getContextEObjectType() == null;
    }

    public final IEStructuralFeatureValueGetter getEStructuralFeatureValueGetter() {
        return this.eStructuralFeatureValueGetter;
    }

    public final void setEStructuralFeatureValueGetter(IEStructuralFeatureValueGetter eStructuralFeatureValueGetter) {
        this.eStructuralFeatureValueGetter = eStructuralFeatureValueGetter;
    }

    public Object evaluate(EObject eObject) {
        if (!this.isContextFree() || eObject != null && this.getOclQueryRecord(eObject.eClass()).hasOclQuery()) {
            if (eObject == null) {
                return this.getOclQuery().evaluate();
            }
            return this.getOclQuery().evaluate((Object)this.getEStructuralFeatureValueGetter().resolve(eObject));
        }
        return null;
    }

    protected final EClass getContextEObjectType() {
        return this.contextEObjectType;
    }

    private static class OclQueryCacheEntry {
        private EClass contextEClass;
        private Query cachedOclQuery;

        OclQueryCacheEntry(EClass contextEClass, Query oclQuery) {
            this.contextEClass = contextEClass;
            this.cachedOclQuery = oclQuery;
        }

        Query getCachedOclQuery() {
            return this.cachedOclQuery;
        }

        EClass getContextEClass() {
            return this.contextEClass;
        }

        boolean hasOclQuery() {
            return this.getCachedOclQuery() != null;
        }
    }
}

