/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.conditions.numbers;

import org.eclipse.emf.query.conditions.Condition;
import org.eclipse.emf.query.conditions.numbers.NumberAdapter;

public abstract class NumberCondition
extends Condition {
    protected Number upperBound;
    protected Number lowerBound;
    protected NumberAdapter adapter;

    private NumberCondition(Number lowerBound, Number upperBound, NumberAdapter adapter) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.adapter = adapter;
    }

    public boolean isSatisfied(Byte byteNumber) {
        return this.isSatisfied((byte)byteNumber);
    }

    public boolean isSatisfied(byte byteValue) {
        return byteValue >= this.lowerBound.byteValue() && byteValue <= this.upperBound.byteValue();
    }

    public boolean isSatisfied(Double doubleNumber) {
        return this.isSatisfied((double)doubleNumber);
    }

    public boolean isSatisfied(double doubleValue) {
        return doubleValue >= this.lowerBound.doubleValue() && doubleValue <= this.upperBound.doubleValue();
    }

    public boolean isSatisfied(Float floatNumber) {
        return this.isSatisfied(floatNumber.floatValue());
    }

    public boolean isSatisfied(float floatValue) {
        return floatValue >= this.lowerBound.floatValue() && floatValue <= this.upperBound.floatValue();
    }

    public boolean isSatisfied(Integer intNumber) {
        return this.isSatisfied((int)intNumber);
    }

    public boolean isSatisfied(int intValue) {
        return intValue >= this.lowerBound.intValue() && intValue <= this.upperBound.intValue();
    }

    public boolean isSatisfied(Long longNumber) {
        return this.isSatisfied((long)longNumber);
    }

    public boolean isSatisfied(long longValue) {
        return longValue >= this.lowerBound.longValue() && longValue <= this.upperBound.longValue();
    }

    public boolean isSatisfied(Short shortNumber) {
        return this.isSatisfied((short)shortNumber);
    }

    public boolean isSatisfied(short shortValue) {
        return shortValue >= this.lowerBound.shortValue() && shortValue <= this.upperBound.shortValue();
    }

    /* synthetic */ NumberCondition(Number number, Number number2, NumberAdapter numberAdapter, NumberCondition numberCondition) {
        this(number, number2, numberAdapter);
    }

    public static class IntegerValue
    extends NumberCondition {
        public IntegerValue(Integer number) {
            this(number, NumberAdapter.IntegerAdapter.DEFAULT);
        }

        public IntegerValue(Integer number, NumberAdapter.IntegerAdapter adapter) {
            this(number, number, adapter);
        }

        public IntegerValue(Integer lowerBound, Integer upperBound) {
            this(lowerBound, upperBound, NumberAdapter.IntegerAdapter.DEFAULT);
        }

        public IntegerValue(Integer lowerBound, Integer upperBound, NumberAdapter.IntegerAdapter adapter) {
            super(lowerBound, upperBound, adapter, null);
        }

        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.IntegerAdapter)this.adapter).intValue(object));
        }
    }

    public static class ByteValue
    extends NumberCondition {
        public ByteValue(Byte number) {
            this(number, NumberAdapter.ByteAdapter.DEFAULT);
        }

        public ByteValue(Byte number, NumberAdapter.ByteAdapter adapter) {
            this(number, number, adapter);
        }

        public ByteValue(Byte lowerBound, Byte upperBound) {
            this(lowerBound, upperBound, NumberAdapter.ByteAdapter.DEFAULT);
        }

        public ByteValue(Byte lowerBound, Byte upperBound, NumberAdapter.ByteAdapter adapter) {
            super(lowerBound, upperBound, adapter, null);
        }

        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.ByteAdapter)this.adapter).byteValue(object));
        }
    }

    public static class DoubleValue
    extends NumberCondition {
        public DoubleValue(Double number) {
            this(number, NumberAdapter.DoubleAdapter.DEFAULT);
        }

        public DoubleValue(Double number, NumberAdapter.DoubleAdapter adapter) {
            this(number, number, adapter);
        }

        public DoubleValue(Double lowerBound, Double upperBound) {
            this(lowerBound, upperBound, NumberAdapter.DoubleAdapter.DEFAULT);
        }

        public DoubleValue(Double lowerBound, Double upperBound, NumberAdapter.DoubleAdapter adapter) {
            super(lowerBound, upperBound, adapter, null);
        }

        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.DoubleAdapter)this.adapter).doubleValue(object));
        }
    }

    public static class FloatValue
    extends NumberCondition {
        public FloatValue(Float number) {
            this(number, NumberAdapter.FloatAdapter.DEFAULT);
        }

        public FloatValue(Float number, NumberAdapter.FloatAdapter adapter) {
            this(number, number, adapter);
        }

        public FloatValue(Float lowerBound, Float upperBound) {
            this(lowerBound, upperBound, NumberAdapter.FloatAdapter.DEFAULT);
        }

        public FloatValue(Float lowerBound, Float upperBound, NumberAdapter.FloatAdapter adapter) {
            super(lowerBound, upperBound, adapter, null);
        }

        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.FloatAdapter)this.adapter).floatValue(object));
        }
    }

    public static class LongValue
    extends NumberCondition {
        public LongValue(Long number) {
            this(number, NumberAdapter.LongAdapter.DEFAULT);
        }

        public LongValue(Long number, NumberAdapter.LongAdapter adapter) {
            this(number, number, adapter);
        }

        public LongValue(Long lowerBound, Long upperBound) {
            this(lowerBound, upperBound, NumberAdapter.LongAdapter.DEFAULT);
        }

        public LongValue(Long lowerBound, Long upperBound, NumberAdapter.LongAdapter adapter) {
            super(lowerBound, upperBound, adapter, null);
        }

        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.LongAdapter)this.adapter).longValue(object));
        }
    }

    public static class ShortValue
    extends NumberCondition {
        public ShortValue(Short number) {
            this(number, NumberAdapter.ShortAdapter.DEFAULT);
        }

        public ShortValue(Short number, NumberAdapter.ShortAdapter adapter) {
            this(number, number, adapter);
        }

        public ShortValue(Short lowerBound, Short upperBound) {
            this(lowerBound, upperBound, NumberAdapter.ShortAdapter.DEFAULT);
        }

        public ShortValue(Short lowerBound, Short upperBound, NumberAdapter.ShortAdapter adapter) {
            super(lowerBound, upperBound, adapter, null);
        }

        public boolean isSatisfied(Object object) {
            return this.isSatisfied(((NumberAdapter.ShortAdapter)this.adapter).shortValue(object));
        }
    }
}

